/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JsonStringPropertyInsertHandler
implements InsertHandler<LookupElement> {
    private final String myNewValue;

    public JsonStringPropertyInsertHandler(@NotNull String newValue2) {
        if (newValue2 == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(0);
        }
        this.myNewValue = newValue2;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        TextRange toDelete;
        PsiElement element2;
        JsonStringLiteral literal;
        if (context2 == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(2);
        }
        if ((literal = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)(element2 = context2.getFile().findElementAt(context2.getStartOffset())), JsonStringLiteral.class, (boolean)false)) == null) {
            return;
        }
        JsonProperty property2 = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class);
        if (property2 == null) {
            return;
        }
        Object textToInsert = "";
        TextRange literalRange = literal.getTextRange();
        if (literal.getValue().equals(this.myNewValue)) {
            toDelete = new TextRange(literalRange.getEndOffset(), literalRange.getEndOffset());
        } else {
            toDelete = literalRange;
            textToInsert = StringUtil.wrapWithDoubleQuote((String)this.myNewValue);
        }
        int newCaretOffset = literalRange.getStartOffset() + 1 + this.myNewValue.length();
        boolean showAutoPopup = false;
        if (property2.getNameElement().equals(literal) && property2.getValue() == null) {
            textToInsert = (String)textToInsert + ":\"\"";
            newCaretOffset += 3;
            if (JsonStringPropertyInsertHandler.needCommaAfter(property2)) {
                textToInsert = (String)textToInsert + ",";
            }
            showAutoPopup = true;
        }
        context2.getDocument().replaceString(toDelete.getStartOffset(), toDelete.getEndOffset(), (CharSequence)textToInsert);
        context2.getEditor().getCaretModel().moveToOffset(newCaretOffset);
        JsonStringPropertyInsertHandler.reformat(context2, toDelete.getStartOffset(), toDelete.getStartOffset() + ((String)textToInsert).length());
        if (showAutoPopup) {
            AutoPopupController.getInstance(context2.getProject()).autoPopupMemberLookup(context2.getEditor(), null);
        }
    }

    private static boolean needCommaAfter(@NotNull JsonProperty property2) {
        if (property2 == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(3);
        }
        for (PsiElement element2 = property2.getNextSibling(); element2 != null; element2 = element2.getNextSibling()) {
            if (element2 instanceof JsonProperty) {
                return true;
            }
            if (element2.getNode().getElementType() != JsonElementTypes.COMMA) continue;
            return false;
        }
        return false;
    }

    private static void reformat(@NotNull InsertionContext context2, int startOffset, int endOffset) {
        if (context2 == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(context2.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context2.getProject());
        codeStyleManager.reformatText(context2.getFile(), startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/codeinsight/JsonStringPropertyInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "needCommaAfter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reformat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

