/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TokenSequence
implements TokenList {
    private static final Logger LOG = Logger.getInstance(TokenSequence.class);
    private final CharSequence myText;
    final int[] lexStarts;
    final IElementType[] lexTypes;
    final int lexemeCount;

    TokenSequence(int[] lexStarts, IElementType[] lexTypes, int lexemeCount, CharSequence text2) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        this.myText = text2;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    void assertMatches(@NotNull CharSequence text2, @NotNull Lexer lexer) {
        if (text2 == null) {
            TokenSequence.$$$reportNull$$$0(0);
        }
        if (lexer == null) {
            TokenSequence.$$$reportNull$$$0(1);
        }
        TokenSequence sequence = new Builder(text2, lexer).performLexing();
        assert (this.lexemeCount == sequence.lexemeCount);
        for (int j = 0; j <= this.lexemeCount; ++j) {
            if (sequence.lexStarts[j] != this.lexStarts[j] || sequence.lexTypes[j] != this.lexTypes[j]) assert (false);
        }
    }

    @NotNull
    public static TokenSequence performLexing(@NotNull CharSequence text2, @NotNull Lexer lexer) {
        TokenList existing;
        if (text2 == null) {
            TokenSequence.$$$reportNull$$$0(2);
        }
        if (lexer == null) {
            TokenSequence.$$$reportNull$$$0(3);
        }
        if (lexer instanceof TokenList.WrappingLexer && (existing = ((TokenList.WrappingLexer)lexer).getTokens()) instanceof TokenSequence && Comparing.equal((CharSequence)text2, (CharSequence)((TokenSequence)existing).myText)) {
            return new TokenSequence(((TokenSequence)existing).lexStarts, (IElementType[])((TokenSequence)existing).lexTypes.clone(), ((TokenSequence)existing).lexemeCount, text2);
        }
        TokenSequence tokenSequence = new Builder(text2, lexer).performLexing();
        if (tokenSequence == null) {
            TokenSequence.$$$reportNull$$$0(4);
        }
        return tokenSequence;
    }

    public int getTokenCount() {
        return this.lexemeCount;
    }

    @Nullable
    public IElementType getTokenType(int index2) {
        if (index2 < 0 || index2 >= this.getTokenCount()) {
            return null;
        }
        return this.lexTypes[index2];
    }

    public int getTokenStart(int index2) {
        return this.lexStarts[index2];
    }

    public int getTokenEnd(int index2) {
        return this.lexStarts[index2 + 1];
    }

    @NotNull
    public CharSequence getTokenizedText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            TokenSequence.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/TokenSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/TokenSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "performLexing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertMatches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performLexing";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        Builder(@NotNull CharSequence text2, @NotNull Lexer lexer) {
            if (text2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (lexer == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myText = text2;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        TokenSequence performLexing() {
            IElementType type;
            this.myLexer.start(this.myText);
            int i2 = 0;
            int offset = 0;
            while ((type = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i2 % 20 == 0) {
                    ProgressIndicatorProvider.checkCanceled();
                }
                if (i2 >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i2 * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset) {
                    this.reportDescendingOffsets(i2, offset, tokenStart);
                }
                this.myLexStarts[i2] = offset = tokenStart;
                this.myLexTypes[i2] = type;
                ++i2;
                this.myLexer.advance();
            }
            this.myLexStarts[i2] = this.myText.length();
            return new TokenSequence(this.myLexStarts, this.myLexTypes, i2, this.myText);
        }

        private void reportDescendingOffsets(int tokenIndex, int offset, int tokenStart) {
            @NonNls StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error((Object)sb);
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = ArrayUtil.realloc((int[])this.myLexStarts, (int)newSize);
            this.myLexTypes = (IElementType[])ArrayUtil.realloc((Object[])this.myLexTypes, (int)newSize, (ArrayFactory)IElementType.ARRAY_FACTORY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lexer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/impl/TokenSequence$Builder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

