/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.navigation.JBProtocolNavigateCommandBaseKt;
import com.intellij.navigation.JBProtocolRevisionResolver;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PsiNavigateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a&\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u001a,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a.\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00190\u00182\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\u001a;\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00100\u001cH\u0002\u001a$\u0010!\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0019H\u0002\u001a$\u0010#\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"COLUMN_GROUP", "", "FILE_PROTOCOL", "LINE_GROUP", "PATH_GROUP", "PATH_WITH_LOCATION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REVISION", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "absolutePath", "revision", "navigateByFqn", "", "parameters", "", "reference", "parsePosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "range", "parseSelections", "", "Lkotlin/Pair;", "runNavigateTask", "task", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lkotlin/ParameterName;", "name", "indicator", "setSelection", "selection", "setSelections", "intellij.platform.lang.impl"})
public final class JBProtocolNavigateCommandBaseKt {
    private static final String FILE_PROTOCOL = "file://";
    private static final String PATH_GROUP = "path";
    private static final String LINE_GROUP = "line";
    private static final String COLUMN_GROUP = "column";
    private static final String REVISION = "revision";
    private static final Pattern PATH_WITH_LOCATION = Pattern.compile("(?<path>[^:]*)(:(?<line>[\\d]+))?(:(?<column>[\\d]+))?");

    private static final VirtualFile findFile(Project project, String absolutePath, String revision) {
        VirtualFile virtualFile2;
        if (absolutePath == null) {
            return null;
        }
        if (revision != null && (virtualFile2 = JBProtocolRevisionResolver.processResolvers(project, absolutePath, revision)) != null) {
            return virtualFile2;
        }
        return VirtualFileManager.getInstance().findFileByUrl(FILE_PROTOCOL + absolutePath);
    }

    private static final void runNavigateTask(String reference2, Project project, Function1<? super ProgressIndicator, Unit> task2) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(task2, project, reference2, project, IdeBundle.message((String)"navigate.command.search.reference.progress.title", (Object[])new Object[]{reference2}), true){
            final /* synthetic */ Function1 $task;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $reference;

            public void run(@NotNull ProgressIndicator indicator2) {
                Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                this.$task.invoke((Object)indicator2);
            }

            public boolean shouldStartInBackground() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                return !application.isUnitTestMode();
            }

            public boolean isConditionalModal() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                return !application.isUnitTestMode();
            }
            {
                this.$task = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$reference = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    private static final void navigateByFqn(Project project, Map<String, String> parameters2, String reference2) {
        String string;
        block3: {
            block2: {
                string = parameters2.get("__fragment");
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = reference2 + '#' + it;
                if (string != null) break block3;
            }
            string = reference2;
        }
        String fqn = string;
        JBProtocolNavigateCommandBaseKt.runNavigateTask(reference2, project, (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(project, fqn, parameters2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $fqn;
            final /* synthetic */ Map $parameters;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DataContext dataContext = SimpleDataContext.getProjectContext(this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"SimpleDataContext.getProjectContext(project)");
                DataContext dataContext2 = dataContext;
                SymbolSearchEverywhereContributor symbolSearchEverywhereContributor = new SymbolSearchEverywhereContributor(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2));
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                if (progressIndicator == null) {
                    progressIndicator = new StatusBarProgress();
                }
                List list2 = symbolSearchEverywhereContributor.search(this.$fqn, progressIndicator);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"SymbolSearchEverywhereCo\u2026r ?: StatusBarProgress())");
                Iterable $this$filterIsInstance$iv = list2;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiElement)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(it2, this){
                        final /* synthetic */ PsiElement $it;
                        final /* synthetic */ navigateByFqn.1 this$0;
                        {
                            this.$it = psiElement;
                            this.this$0 = var2_2;
                        }

                        public final void run() {
                            PsiNavigateUtil.navigate((PsiElement)this.$it);
                            JBProtocolNavigateCommandBaseKt.access$setSelections(this.this$0.$parameters, this.this$0.$project);
                        }
                    });
                }
            }
            {
                this.$project = project;
                this.$fqn = string;
                this.$parameters = map2;
                super(1);
            }
        }));
    }

    private static final void setSelections(Map<String, String> parameters2, Project project) {
        Iterable $this$forEach$iv = JBProtocolNavigateCommandBaseKt.parseSelections(parameters2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair selection = (Pair)element$iv;
            boolean bl = false;
            JBProtocolNavigateCommandBaseKt.setSelection(project, (Pair<? extends LogicalPosition, ? extends LogicalPosition>)selection);
        }
    }

    private static final void setSelection(Project project, Pair<? extends LogicalPosition, ? extends LogicalPosition> selection) {
        block0: {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
            Editor editor = fileEditorManager.getSelectedTextEditor();
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getSelectionModel()) == null) break block0;
            editor2.setSelection(editor.logicalPositionToOffset((LogicalPosition)selection.getFirst()), editor.logicalPositionToOffset((LogicalPosition)selection.getSecond()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<LogicalPosition, LogicalPosition>> parseSelections(Map<String, String> parameters2) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, String> $this$filterKeys$iv = parameters2;
        boolean $i$f$filterKeys = false;
        Object result$iv = new LinkedHashMap();
        Map<String, String> map2 = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry<String, String> entry$iv : map2.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)it, (String)"selection", (boolean)false, (int)2, null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$mapNotNull$iv = ((Map)result$iv).values();
        boolean $i$f$mapNotNull = false;
        result$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            List split2 = StringsKt.split$default((CharSequence)it, (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null);
            if (split2.size() != 2) {
                pair = null;
            } else {
                LogicalPosition position1 = JBProtocolNavigateCommandBaseKt.parsePosition((String)split2.get(0));
                LogicalPosition position2 = JBProtocolNavigateCommandBaseKt.parsePosition((String)split2.get(1));
                pair = position1 != null && position2 != null ? new Pair((Object)position1, (Object)position1) : null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl5 = false;
            boolean bl6 = false;
            Pair it$iv$iv = pair2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final LogicalPosition parsePosition(String range2) {
        List position = StringsKt.split$default((CharSequence)range2, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        if (position.size() != 2) {
            return null;
        }
        try {
            return new LogicalPosition(Integer.parseInt((String)position.get(0)), Integer.parseInt((String)position.get(1)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final /* synthetic */ void access$navigateByFqn(Project project, Map parameters2, String reference2) {
        JBProtocolNavigateCommandBaseKt.navigateByFqn(project, parameters2, reference2);
    }

    public static final /* synthetic */ Pattern access$getPATH_WITH_LOCATION$p() {
        return PATH_WITH_LOCATION;
    }

    public static final /* synthetic */ void access$runNavigateTask(String reference2, Project project, Function1 task2) {
        JBProtocolNavigateCommandBaseKt.runNavigateTask(reference2, project, (Function1<? super ProgressIndicator, Unit>)task2);
    }

    public static final /* synthetic */ VirtualFile access$findFile(Project project, String absolutePath, String revision) {
        return JBProtocolNavigateCommandBaseKt.findFile(project, absolutePath, revision);
    }

    public static final /* synthetic */ void access$setSelections(Map parameters2, Project project) {
        JBProtocolNavigateCommandBaseKt.setSelections(parameters2, project);
    }
}

