/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.JBProtocolNavigateCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "areOriginsEqual", "", "originUrl", "", "projectOriginUrl", "extractCanonicalPath", "extractHostAndPath", "url", "intellij.platform.lang.impl"})
public final class OriginSupportKt {
    private static final Logger LOG;

    @VisibleForTesting
    public static final boolean areOriginsEqual(@Nullable String originUrl, @Nullable String projectOriginUrl) {
        block3: {
            block2: {
                CharSequence charSequence = originUrl;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block2;
                charSequence = projectOriginUrl;
                bl = false;
                bl2 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block3;
            }
            return false;
        }
        String canonicalOrigin = OriginSupportKt.extractCanonicalPath(originUrl);
        String canonicalProjectOrigin = OriginSupportKt.extractCanonicalPath(projectOriginUrl);
        return canonicalOrigin != null && Intrinsics.areEqual((Object)canonicalProjectOrigin, (Object)canonicalOrigin);
    }

    private static final String extractCanonicalPath(String originUrl) {
        CharSequence charSequence = originUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        try {
            String hostAndPath;
            String string = hostAndPath = OriginSupportKt.extractHostAndPath(originUrl);
            bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            return StringsKt.removeSuffix((String)string3, (CharSequence)".git");
        }
        catch (URISyntaxException e) {
            LOG.warn("Malformed origin url '" + originUrl + "' in navigate request", (Throwable)e);
            return null;
        }
    }

    private static final String extractHostAndPath(String url) {
        String path2;
        String urlWithScheme = URLUtil.containsScheme((String)url) ? url : "ssh://" + url;
        URI uri = new URI(urlWithScheme);
        String host = uri.getHost();
        String string = uri.getPath();
        if (string == null) {
            string = path2 = "";
        }
        if (host != null) {
            String hostPort = uri.getHost() + (uri.getPort() != -1 ? "" + ':' + uri.getPort() : "");
            return hostPort + path2;
        }
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"ssh") && uri.getAuthority() != null) {
            String string2 = uri.getAuthority();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.authority");
            List at = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"@"}, (boolean)false, (int)0, (int)6, null);
            String hostAndOrg = at.size() > 1 ? (String)at.get(1) : (String)at.get(0);
            List comma = StringsKt.split$default((CharSequence)hostAndOrg, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            String sshPath = comma.size() > 1 ? "/" + (String)comma.get(1) + path2 : path2;
            return (String)comma.get(0) + sshPath;
        }
        return "";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JBProtocolNavigateCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

