/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class UndoRedoStacksHolderBase<E> {
    protected static final Logger LOG = Logger.getInstance(UndoRedoStacksHolderBase.class);
    protected final Key<LinkedList<E>> STACK_IN_DOCUMENT_KEY = Key.create((String)"STACK_IN_DOCUMENT_KEY");
    protected final boolean myUndo;
    protected final Map<DocumentReference, LinkedList<E>> myDocumentStacks = CollectionFactory.createSmallMemoryFootprintMap();
    protected final Collection<Document> myDocumentsWithStacks = new WeakList();
    protected final Collection<VirtualFile> myNonlocalVirtualFilesWithStacks = new WeakList();

    UndoRedoStacksHolderBase(boolean isUndo) {
        this.myUndo = isUndo;
    }

    @NotNull
    LinkedList<E> getStack(@NotNull DocumentReference r) {
        if (r == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(0);
        }
        return r.getFile() != null ? this.doGetStackForFile(r) : this.doGetStackForDocument(r);
    }

    @NotNull
    private LinkedList<E> doGetStackForFile(@NotNull DocumentReference r) {
        VirtualFile file2;
        if (r == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(1);
        }
        LinkedList result2 = !(file2 = r.getFile()).isInLocalFileSystem() ? this.addWeaklyTrackedEmptyStack(file2, this.myNonlocalVirtualFilesWithStacks) : this.myDocumentStacks.computeIfAbsent(r, __ -> new LinkedList());
        LinkedList linkedList = result2;
        if (linkedList == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(2);
        }
        return linkedList;
    }

    @NotNull
    private LinkedList<E> doGetStackForDocument(@NotNull DocumentReference r) {
        if (r == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(3);
        }
        return this.addWeaklyTrackedEmptyStack(r.getDocument(), this.myDocumentsWithStacks);
    }

    @NotNull
    private <T extends UserDataHolder> LinkedList<E> addWeaklyTrackedEmptyStack(@NotNull T holder, @NotNull Collection<? super T> allHolders2) {
        LinkedList result2;
        if (holder == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(4);
        }
        if (allHolders2 == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(5);
        }
        if ((result2 = (LinkedList)holder.getUserData(this.STACK_IN_DOCUMENT_KEY)) == null) {
            result2 = new LinkedList();
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, result2);
            allHolders2.add(holder);
        }
        LinkedList linkedList = result2;
        if (linkedList == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    protected String getStacksDescription() {
        return this.myUndo ? "undo stacks" : "redo stacks";
    }

    protected void removeEmptyStacks() {
        this.myDocumentStacks.entrySet().removeIf(each -> ((LinkedList)each.getValue()).isEmpty());
        CollectionFactory.trimMap(this.myDocumentStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myDocumentsWithStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myNonlocalVirtualFilesWithStacks);
    }

    void clearDocumentReferences(@NotNull Document document) {
        if (document == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(7);
        }
        this.myDocumentsWithStacks.remove(document);
        DocumentReference referenceFile = DocumentReferenceManager.getInstance().create(document);
        DocumentReferenceByDocument referenceDoc = new DocumentReferenceByDocument(document);
        this.myDocumentStacks.remove(referenceFile);
        this.myDocumentStacks.remove(referenceDoc);
    }

    private <T extends UserDataHolder> void cleanWeaklyTrackedEmptyStacks(@NotNull Collection<T> stackHolders) {
        if (stackHolders == null) {
            UndoRedoStacksHolderBase.$$$reportNull$$$0(8);
        }
        HashSet<UserDataHolder> holdersToDrop = new HashSet<UserDataHolder>();
        for (UserDataHolder holder : stackHolders) {
            List stack = (List)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
            if (stack == null || !stack.isEmpty()) continue;
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            holdersToDrop.add(holder);
        }
        stackHolders.removeAll(holdersToDrop);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoRedoStacksHolderBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allHolders";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackHolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoRedoStacksHolderBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetStackForFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeaklyTrackedEmptyStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStack";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForFile";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForDocument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWeaklyTrackedEmptyStack";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cleanWeaklyTrackedEmptyStacks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

