/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class JoinLinesAction
extends TextComponentEditorAction {
    public JoinLinesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            Document doc = editor.getDocument();
            LogicalPosition caretPosition = caret.getLogicalPosition();
            int startLine = caretPosition.line;
            int endLine = startLine + 1;
            if (caret.hasSelection()) {
                startLine = doc.getLineNumber(caret.getSelectionStart());
                endLine = doc.getLineNumber(caret.getSelectionEnd());
                if (doc.getLineStartOffset(endLine) == caret.getSelectionEnd()) {
                    --endLine;
                }
            }
            int[] caretRestoreOffset = new int[]{-1};
            int lineCount = endLine - startLine;
            int line = startLine;
            DocumentUtil.executeInBulk(doc, lineCount > 1000, () -> {
                for (int i2 = 0; i2 < lineCount && line < doc.getLineCount() - 1; ++i2) {
                    int start2;
                    CharSequence text2 = doc.getCharsSequence();
                    int end = doc.getLineEndOffset(line) + doc.getLineSeparatorLength(line);
                    for (start2 = end - doc.getLineSeparatorLength(line); start2 > 0 && (text2.charAt(start2) == ' ' || text2.charAt(start2) == '\t'); --start2) {
                    }
                    if (caretRestoreOffset[0] == -1) {
                        caretRestoreOffset[0] = start2 + 1;
                    }
                    while (end < doc.getTextLength() && (text2.charAt(end) == ' ' || text2.charAt(end) == '\t')) {
                        ++end;
                    }
                    doc.replaceString(start2, end, (CharSequence)" ");
                }
            });
            if (caret.hasSelection()) {
                caret.moveToOffset(caret.getSelectionEnd());
            } else if (caretRestoreOffset[0] != -1) {
                caret.moveToOffset(caretRestoreOffset[0]);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                caret.removeSelection();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/JoinLinesAction$Handler";
            objectArray[2] = "executeWriteAction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

