/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import java.awt.Point;
import java.util.List;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BlockInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, BlockInlayImpl<?>>
implements IntSupplier {
    final boolean myShowAbove;
    final boolean myShowWhenFolded;
    final int myPriority;
    private int myHeightInPixels;
    private GutterIconRenderer myGutterIconRenderer;

    BlockInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, boolean showAbove2, boolean showWhenFolded, int priority, @NotNull R renderer2) {
        if (editor == null) {
            BlockInlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            BlockInlayImpl.$$$reportNull$$$0(1);
        }
        super(editor, offset, relatesToPrecedingText, renderer2);
        this.myShowAbove = showAbove2;
        this.myShowWhenFolded = showWhenFolded;
        this.myPriority = priority;
    }

    @Override
    MarkerTreeWithPartialSums<BlockInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myBlockElementsTree;
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels < 0) {
            throw PluginException.createByClass((String)("Non-negative width should be defined for a block element by " + this.myRenderer), null, this.myRenderer.getClass());
        }
        int oldHeightInPixels = this.myHeightInPixels;
        this.myHeightInPixels = this.myRenderer.calcHeightInPixels((Inlay)this);
        if (oldHeightInPixels != this.myHeightInPixels) {
            ((MarkerTreeWithPartialSums)this.getTree()).valueUpdated(this);
        }
        if (this.myHeightInPixels < 0) {
            throw PluginException.createByClass((String)("Non-negative height should be defined for a block element by " + this.myRenderer), null, this.myRenderer.getClass());
        }
        this.myGutterIconRenderer = this.myRenderer.calcGutterIconRenderer((Inlay)this);
    }

    @Override
    Point getPosition() {
        int y;
        int visualLine = this.myEditor.offsetToVisualLine(this.getOffset());
        int[] yRange = this.myEditor.visualLineToYRange(visualLine);
        List<Inlay<?>> allInlays = this.myEditor.getInlayModel().getBlockElementsForVisualLine(visualLine, this.myShowAbove);
        if (this.myShowAbove) {
            y = yRange[0];
            boolean found = false;
            for (Inlay<?> inlay : allInlays) {
                if (inlay == this) {
                    found = true;
                }
                if (!found) continue;
                y -= inlay.getHeightInPixels();
            }
        } else {
            y = yRange[1];
            for (Inlay<?> inlay : allInlays) {
                if (inlay == this) break;
                y += inlay.getHeightInPixels();
            }
        }
        return new Point(this.myEditor.getContentComponent().getInsets().left, y);
    }

    public int getHeightInPixels() {
        return this.myHeightInPixels;
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        Inlay.Placement placement = this.myShowAbove ? Inlay.Placement.ABOVE_LINE : Inlay.Placement.BELOW_LINE;
        if (placement == null) {
            BlockInlayImpl.$$$reportNull$$$0(2);
        }
        return placement;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getOffset());
        if (visualPosition == null) {
            BlockInlayImpl.$$$reportNull$$$0(3);
        }
        return visualPosition;
    }

    @Override
    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Override
    public int getAsInt() {
        return this.myHeightInPixels;
    }

    @Override
    public String toString() {
        return "[Block inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", height=" + this.myHeightInPixels + ", renderer=" + this.myRenderer + "]" + (this.isValid() ? "" : "(invalid)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/BlockInlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/BlockInlayImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

