/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.InspectionPopupLevelChangePolicy;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.editor.markup.LanguageHighlightLevel;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class InspectionPopupManager {
    private final ExtensionPointName<InspectionPopupLevelChangePolicy> EP_NAME;
    private static final int DELTA_X = 6;
    private static final int DELTA_Y = 6;
    private final Supplier<AnalyzerStatus> statusSupplier;
    private final Editor myEditor;
    private final AnAction compactViewAction;
    private final JPanel myContent;
    private final ComponentPopupBuilder myPopupBuilder;
    private final Map<String, JProgressBar> myProgressBarMap;
    private final AncestorListener myAncestorListener;
    private final JBPopupListener myPopupListener;
    private final PopupState<JBPopup> myPopupState;
    private final Alarm popupAlarm;
    private final List<DropDownLink<?>> levelLinks;
    private JBPopup myPopup;
    private boolean insidePopup;

    InspectionPopupManager(final @NotNull Supplier<AnalyzerStatus> statusSupplier, @NotNull Editor editor, @NotNull AnAction compactViewAction) {
        if (statusSupplier == null) {
            InspectionPopupManager.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            InspectionPopupManager.$$$reportNull$$$0(1);
        }
        if (compactViewAction == null) {
            InspectionPopupManager.$$$reportNull$$$0(2);
        }
        this.EP_NAME = ExtensionPointName.create((String)"com.intellij.inspectionPopupLevelChangePolicy");
        this.myContent = new JPanel(new GridBagLayout());
        this.myProgressBarMap = new HashMap<String, JProgressBar>();
        this.myPopupState = PopupState.forPopup();
        this.popupAlarm = new Alarm();
        this.levelLinks = new ArrayList();
        this.statusSupplier = statusSupplier;
        this.myEditor = editor;
        this.compactViewAction = compactViewAction;
        this.myContent.setOpaque(true);
        this.myContent.setBackground(UIUtil.getToolTipBackground());
        this.myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myContent, null).setCancelOnClickOutside(true).setCancelCallback(() -> this.getAnalyzerStatus() == null || this.getAnalyzerStatus().getController().canClosePopup());
        this.myAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                InspectionPopupManager.this.hidePopup();
            }
        };
        this.myPopupListener = new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (statusSupplier.get() != null) {
                    ((AnalyzerStatus)statusSupplier.get()).getController().onClosePopup();
                }
                InspectionPopupManager.this.myEditor.getComponent().removeAncestorListener(InspectionPopupManager.this.myAncestorListener);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/InspectionPopupManager$2", "onClosed"));
            }
        };
        this.myContent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                InspectionPopupManager.this.insidePopup = true;
            }

            @Override
            public void mouseExited(MouseEvent event) {
                Point point = event.getPoint();
                if (!InspectionPopupManager.this.myContent.getBounds().contains(point) || point.x == 0 || point.y == 0) {
                    InspectionPopupManager.this.insidePopup = false;
                    if (InspectionPopupManager.this.canClose()) {
                        InspectionPopupManager.this.hidePopup();
                    }
                }
            }
        });
    }

    private boolean canClose() {
        return !this.insidePopup && this.levelLinks.stream().allMatch(l -> l.getPopupState().isHidden());
    }

    void updateUI() {
        IJSwingUtilities.updateComponentTreeUI(this.myContent);
    }

    void scheduleShow(@NotNull InputEvent event) {
        if (event == null) {
            InspectionPopupManager.$$$reportNull$$$0(3);
        }
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> this.showPopup(event), Registry.intValue((String)"ide.tooltip.initialReshowDelay"));
    }

    void scheduleHide() {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> {
            if (this.canClose()) {
                this.hidePopup();
            }
        }, Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"));
    }

    void showPopup(@NotNull InputEvent event) {
        if (event == null) {
            InspectionPopupManager.$$$reportNull$$$0(4);
        }
        this.hidePopup();
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        this.updateContentPanel(this.getAnalyzerStatus().getController());
        this.myPopup = this.myPopupBuilder.createPopup();
        this.myPopup.addListener(this.myPopupListener);
        this.myPopupState.prepareToShow((Object)this.myPopup);
        this.myEditor.getComponent().addAncestorListener(this.myAncestorListener);
        JComponent owner = (JComponent)event.getComponent();
        Dimension size2 = this.myContent.getPreferredSize();
        size2.width = Math.max(size2.width, JBUIScale.scale((int)296));
        RelativePoint point = new RelativePoint((Component)owner, new Point(owner.getWidth() - owner.getInsets().right + JBUIScale.scale((int)6) - size2.width, owner.getHeight() + JBUIScale.scale((int)6)));
        this.myPopup.setSize(size2);
        this.myPopup.show(point);
    }

    void hidePopup() {
        if (this.myPopup != null && !this.myPopup.isDisposed()) {
            this.myPopup.cancel();
        }
        this.myPopup = null;
    }

    private AnalyzerStatus getAnalyzerStatus() {
        return this.statusSupplier.get();
    }

    private void updateContentPanel(@NotNull UIController controller) {
        List passes;
        Set presentableNames;
        if (controller == null) {
            InspectionPopupManager.$$$reportNull$$$0(5);
        }
        if (!(presentableNames = ContainerUtil.map2Set((Collection)(passes = this.getAnalyzerStatus().getPasses()), p -> p.getPresentableName())).isEmpty() && this.myProgressBarMap.keySet().equals(presentableNames)) {
            for (PassWrapper pass : passes) {
                this.myProgressBarMap.get(pass.getPresentableName()).setValue(pass.toPercent());
            }
            return;
        }
        this.myContent.removeAll();
        this.levelLinks.clear();
        GridBag gc = new GridBag().nextLine().next().anchor(21).weightx(1.0).fillCellHorizontally().insets(10, 10, 10, 0);
        boolean hasTitle = StringUtil.isNotEmpty((String)this.getAnalyzerStatus().getTitle());
        if (hasTitle) {
            this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)this.getAnalyzerStatus().getTitle())), gc);
        } else if (StringUtil.isNotEmpty((String)this.getAnalyzerStatus().getDetails())) {
            this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)this.getAnalyzerStatus().getDetails())), gc);
        } else if (this.getAnalyzerStatus().getExpandedStatus().size() > 0 && this.getAnalyzerStatus().getAnalyzingType() != AnalyzingType.EMPTY) {
            this.myContent.add((Component)this.createDetailsPanel(), gc);
        }
        Presentation presentation2 = new Presentation();
        presentation2.setIcon(AllIcons.Actions.More);
        presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
        List actions2 = controller.getActions();
        if (!actions2.isEmpty()) {
            ActionButton menuButton = new ActionButton((AnAction)new MenuAction(actions2, this.compactViewAction), presentation2, "EditorPopup", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Override
                protected DataContext getDataContext() {
                    return ((EditorEx)InspectionPopupManager.this.myEditor).getDataContext();
                }
            };
            this.myContent.add((Component)menuButton, gc.next().anchor(22).weightx(0.0).insets(10, 6, 10, 6));
        }
        this.myProgressBarMap.clear();
        NonOpaquePanel myProgressPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        GridBag progressGC = new GridBag();
        for (PassWrapper pass : passes) {
            myProgressPanel.add((Component)new JLabel(pass.getPresentableName() + ": "), progressGC.nextLine().next().anchor(21).weightx(0.0).insets(0, 10, 0, 6));
            JProgressBar pb = new JProgressBar(0, 100);
            pb.setValue(pass.toPercent());
            myProgressPanel.add((Component)pb, progressGC.next().anchor(21).weightx(1.0).fillCellHorizontally().insets(0, 0, 0, 6));
            this.myProgressBarMap.put(pass.getPresentableName(), pb);
        }
        this.myContent.add((Component)myProgressPanel, gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0));
        if (hasTitle) {
            int topIndent = !this.myProgressBarMap.isEmpty() ? 10 : 0;
            gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0).insets(topIndent, 10, 10, 6);
            if (StringUtil.isNotEmpty((String)this.getAnalyzerStatus().getDetails())) {
                this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)this.getAnalyzerStatus().getDetails())), gc);
            } else if (this.getAnalyzerStatus().getExpandedStatus().size() > 0 && this.getAnalyzerStatus().getAnalyzingType() != AnalyzingType.EMPTY) {
                this.myContent.add((Component)this.createDetailsPanel(), gc);
            } else if (!passes.isEmpty()) {
                myProgressPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            }
        }
        this.myContent.add((Component)this.createLowerPanel(controller), gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0));
    }

    void updateVisiblePopup() {
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.updateContentPanel(this.getAnalyzerStatus().getController());
            Dimension size2 = this.myContent.getPreferredSize();
            size2.width = Math.max(size2.width, JBUIScale.scale((int)296));
            this.myPopup.setSize(size2);
        }
    }

    @NotNull
    private JComponent createDetailsPanel() {
        @Nls StringBuilder text2 = new StringBuilder();
        for (int i2 = 0; i2 < this.getAnalyzerStatus().getExpandedStatus().size(); ++i2) {
            boolean last = i2 == this.getAnalyzerStatus().getExpandedStatus().size() - 1;
            StatusItem item = (StatusItem)this.getAnalyzerStatus().getExpandedStatus().get(i2);
            String detailsText = item.getDetailsText();
            text2.append(detailsText != null ? detailsText : item.getText());
            if (!last) {
                text2.append(", ");
                continue;
            }
            if (this.getAnalyzerStatus().getAnalyzingType() == AnalyzingType.COMPLETE) continue;
            text2.append(" ").append(EditorBundle.message((String)"iw.found.so.far.suffix", (Object[])new Object[0]));
        }
        return new JLabel(text2.toString());
    }

    @NotNull
    private JPanel createLowerPanel(@NotNull UIController controller) {
        if (controller == null) {
            InspectionPopupManager.$$$reportNull$$$0(6);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine();
        if (PowerSaveMode.isEnabled()) {
            panel2.add((Component)((Object)new TrackableLinkLabel(EditorBundle.message((String)"iw.disable.powersave", (Object[])new Object[0]), () -> {
                PowerSaveMode.setEnabled((boolean)false);
                this.hidePopup();
            })), gc.next().anchor(21));
        } else {
            InspectionPopupLevelChangePolicy extension2;
            List levels = controller.getHighlightLevels();
            String msg = null;
            Iterator iterator2 = this.EP_NAME.getExtensionList().iterator();
            while (iterator2.hasNext() && (msg = (extension2 = (InspectionPopupLevelChangePolicy)iterator2.next()).getUnavailabilityReason(this.myEditor)) == null) {
            }
            if (levels.size() == 1) {
                String prefix2 = EditorBundle.message((String)"iw.highlight.label", (Object[])new Object[0]) + " ";
                GridBag constrains = gc.next();
                if (msg == null) {
                    DropDownLink<InspectionsLevel> link2 = this.createDropDownLink((LanguageHighlightLevel)levels.get(0), controller, prefix2);
                    this.levelLinks.add(link2);
                    panel2.add((Component)link2, constrains);
                } else {
                    JLabel noAccessLabel = InspectionPopupManager.createNoChangeLabel((LanguageHighlightLevel)levels.get(0), prefix2, msg);
                    panel2.add((Component)noAccessLabel, constrains);
                }
            } else if (levels.size() > 1) {
                for (LanguageHighlightLevel level : levels) {
                    GridBag constrains;
                    String prefix3 = level.getLangID() + ": ";
                    GridBag gridBag = constrains = gc.next().anchor((int)21).gridx > 0 ? gc.insetLeft(8) : gc;
                    if (msg == null) {
                        DropDownLink<InspectionsLevel> link3 = this.createDropDownLink(level, controller, prefix3);
                        this.levelLinks.add(link3);
                        panel2.add((Component)link3, constrains);
                        continue;
                    }
                    JLabel noAccessLabel = InspectionPopupManager.createNoChangeLabel(level, prefix3, msg);
                    panel2.add((Component)noAccessLabel, constrains);
                }
            }
        }
        panel2.add(Box.createHorizontalGlue(), gc.next().fillCellHorizontally().weightx(1.0));
        controller.fillHectorPanels((Container)panel2, gc);
        panel2.setOpaque(true);
        panel2.setBackground(UIUtil.getToolTipActionBackground());
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            InspectionPopupManager.$$$reportNull$$$0(7);
        }
        return jPanel2;
    }

    @NotNull
    private DropDownLink<InspectionsLevel> createDropDownLink(@NotNull LanguageHighlightLevel level, @NotNull UIController controller, final @NotNull @Nls String prefix2) {
        if (level == null) {
            InspectionPopupManager.$$$reportNull$$$0(8);
        }
        if (controller == null) {
            InspectionPopupManager.$$$reportNull$$$0(9);
        }
        if (prefix2 == null) {
            InspectionPopupManager.$$$reportNull$$$0(10);
        }
        return new DropDownLink<InspectionsLevel>(level.getLevel(), controller.getAvailableLevels(), inspectionsLevel -> {
            controller.setHighLightLevel(level.copy(level.getLangID(), inspectionsLevel));
            this.myContent.revalidate();
            Dimension size2 = this.myContent.getPreferredSize();
            size2.width = Math.max(size2.width, JBUIScale.scale((int)296));
            this.myPopup.setSize(size2);
            FeatureUsageData data2 = new FeatureUsageData().addProject(this.myEditor.getProject()).addLanguage(level.getLangID()).addData("level", inspectionsLevel.name());
            FUCounterUsageLogger.getInstance().logEvent("inspection.widget", "highlight.level.changed", data2);
        }, true){

            @NotNull
            protected String itemToString(InspectionsLevel item) {
                String string = prefix2 + item.toString();
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/InspectionPopupManager$5", "itemToString"));
            }
        };
    }

    @NotNull
    private static JLabel createNoChangeLabel(@NotNull LanguageHighlightLevel level, @NotNull @Nls String prefix2, @NotNull @Nls String msg) {
        if (level == null) {
            InspectionPopupManager.$$$reportNull$$$0(11);
        }
        if (prefix2 == null) {
            InspectionPopupManager.$$$reportNull$$$0(12);
        }
        if (msg == null) {
            InspectionPopupManager.$$$reportNull$$$0(13);
        }
        JLabel label2 = new JLabel(prefix2 + level.getLevel());
        new HelpTooltip().setDescription(msg).installOn((JComponent)label2);
        JLabel jLabel = label2;
        if (jLabel == null) {
            InspectionPopupManager.$$$reportNull$$$0(14);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactViewAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InspectionPopupManager";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InspectionPopupManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLowerPanel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoChangeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleShow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateContentPanel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLowerPanel";
                break;
            }
            case 7: 
            case 14: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDropDownLink";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNoChangeLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TrackableLinkLabel
    extends LinkLabel<Object> {
        private InputEvent myEvent;

        private TrackableLinkLabel(@NotNull @NlsContexts.LinkLabel String text2, @NotNull Runnable action2) {
            if (text2 == null) {
                TrackableLinkLabel.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                TrackableLinkLabel.$$$reportNull$$$0(1);
            }
            super(text2, null);
            this.setListener((__, ___) -> {
                action2.run();
                ActionsCollector.getInstance().record(null, this.myEvent, ((Object)((Object)this)).getClass());
            }, null);
        }

        public void doClick(InputEvent e) {
            this.myEvent = e;
            super.doClick(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/InspectionPopupManager$TrackableLinkLabel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MenuAction
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        private MenuAction(@NotNull List<? extends AnAction> actions2, @NotNull AnAction compactViewAction) {
            if (actions2 == null) {
                MenuAction.$$$reportNull$$$0(0);
            }
            if (compactViewAction == null) {
                MenuAction.$$$reportNull$$$0(1);
            }
            this.setPopup(true);
            this.addAll(actions2);
            this.add(compactViewAction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compactViewAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/InspectionPopupManager$MenuAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

