/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenUntrustedProjectChoice;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autolink.UnlinkedProjectNotificationAware;
import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.importing.OpenProjectProvider;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.nio.file.Path;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b'\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H$J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\nH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/OpenProjectProvider;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "systemId$delegate", "Lkotlin/Lazy;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusOnOpenedSameProject", "projectDirectory", "Ljava/nio/file/Path;", "getProjectDirectory", "isProjectFile", "linkAndRefreshProject", "", "project", "Lcom/intellij/openapi/project/Project;", "linkToExistingProject", "projectFile", "projectFilePath", "", "openProject", "projectToClose", "forceOpenInNewFrame", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public abstract class AbstractOpenProjectProvider
implements OpenProjectProvider {
    @NotNull
    private final Lazy systemId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectSystemId>(this){
        final /* synthetic */ AbstractOpenProjectProvider this$0;

        @NotNull
        public final ProjectSystemId invoke() {
            AbstractOpenProjectProvider.Companion.getLOG().warn("Class " + this.this$0.getClass().getName() + " have to override AbstractOpenProjectProvider.systemId. " + "Resolving of systemId will be removed in future releases.");
            Object[] objectArray = StringUtils.splitByCharacterTypeCamelCase((String)this.this$0.getClass().getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"StringUtils.splitByChara\u2026ase(javaClass.simpleName)");
            String readableName = (String)ArraysKt.first((Object[])objectArray);
            ExternalSystemManager manager2 = (ExternalSystemManager)ExternalSystemManager.EP_NAME.findFirstSafe(new Predicate(readableName){
                final /* synthetic */ String $readableName;

                public final boolean test(ExternalSystemManager<?, ?, ?, ?, ?> it) {
                    Object[] objectArray = StringUtils.splitByCharacterTypeCamelCase((String)it.getClass().getSimpleName());
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"StringUtils.splitByChara\u2026(it.javaClass.simpleName)");
                    return StringUtils.equalsIgnoreCase((String)((String)ArraysKt.first((Object[])objectArray)), (String)this.$readableName);
                }
                {
                    this.$readableName = string;
                }
            });
            ExternalSystemManager externalSystemManager = manager2;
            if (externalSystemManager == null || (externalSystemManager = externalSystemManager.getSystemId()) == null) {
                String string = readableName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readableName");
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                externalSystemManager = new ProjectSystemId(string4);
            }
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemManager, (String)"manager?.systemId ?: Pro\u2026adableName.toUpperCase())");
            return externalSystemManager;
        }
        {
            this.this$0 = abstractOpenProjectProvider;
            super(0);
        }
    }));
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected ProjectSystemId getSystemId() {
        Lazy lazy = this.systemId$delegate;
        AbstractOpenProjectProvider abstractOpenProjectProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ProjectSystemId)lazy.getValue();
    }

    protected abstract boolean isProjectFile(@NotNull VirtualFile var1);

    protected abstract void linkAndRefreshProject(@NotNull Path var1, @NotNull Project var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canOpenProject(@NotNull VirtualFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (file2.isDirectory()) {
                void $this$any$iv;
                VirtualFile[] virtualFileArray = file2.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"file.children");
                VirtualFile[] virtualFileArray2 = virtualFileArray;
                AbstractOpenProjectProvider abstractOpenProjectProvider = this;
                boolean $i$f$any = false;
                void var5_5 = $this$any$iv;
                int n = ((void)var5_5).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void p1 = element$iv = var5_5[j];
                    boolean bl2 = false;
                    if (!abstractOpenProjectProvider.isProjectFile((VirtualFile)p1)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = this.isProjectFile(file2);
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public Project openProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        LOG.debug("Open project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        Path path2 = projectDirectory.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectDirectory.toNioPath()");
        if (this.focusOnOpenedSameProject(path2)) {
            return null;
        }
        Path path3 = projectDirectory.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"projectDirectory.toNioPath()");
        Path nioPath = path3;
        boolean isValidIdeaProject = ProjectUtil.isValidProjectPath(nioPath);
        OpenUntrustedProjectChoice openUntrustedProjectChoice = ExternalSystemUtil.confirmOpeningUntrustedProject(projectFile, this.getSystemId());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)openUntrustedProjectChoice), (String)"confirmOpeningUntrustedP\u2026ct(projectFile, systemId)");
        OpenUntrustedProjectChoice untrustedProjectChoice = openUntrustedProjectChoice;
        if (untrustedProjectChoice == OpenUntrustedProjectChoice.CANCEL) {
            return null;
        }
        Function1 function1 = null;
        Function1 function12 = (Function1)new Function1<Project, Boolean>(this, untrustedProjectChoice, isValidIdeaProject, nioPath){
            final /* synthetic */ AbstractOpenProjectProvider this$0;
            final /* synthetic */ OpenUntrustedProjectChoice $untrustedProjectChoice;
            final /* synthetic */ boolean $isValidIdeaProject;
            final /* synthetic */ Path $nioPath;

            public final boolean invoke(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                TrustedProjects.setTrusted(project, this.$untrustedProjectChoice == OpenUntrustedProjectChoice.IMPORT);
                if (this.$isValidIdeaProject) {
                    UnlinkedProjectNotificationAware.Companion.enableNotifications(project, this.this$0.getSystemId());
                } else {
                    project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)true);
                    project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(this, project){
                        final /* synthetic */ openProject.options.1 this$0;
                        final /* synthetic */ Project $project;

                        public final void run() {
                            this.this$0.this$0.linkAndRefreshProject(this.this$0.$nioPath, this.$project);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$project = project;
                        }
                    });
                    ProjectUtil.updateLastProjectLocation(this.$nioPath);
                }
                return true;
            }
            {
                this.this$0 = abstractOpenProjectProvider;
                this.$untrustedProjectChoice = openUntrustedProjectChoice;
                this.$isValidIdeaProject = bl;
                this.$nioPath = path2;
                super(1);
            }
        };
        Function1 function13 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        Object var20_19 = null;
        ProjectOpenedCallback projectOpenedCallback = null;
        boolean bl6 = false;
        String string2 = null;
        Project project = null;
        boolean bl7 = false;
        Project project2 = projectToClose;
        boolean bl8 = forceOpenInNewFrame;
        boolean bl9 = !isValidIdeaProject;
        OpenProjectTask options2 = new OpenProjectTask(bl8, project2, bl9, bl7, project, string2, bl6, projectOpenedCallback, var20_19, n2, n, bl5, bl4, bl3, string, bl2, bl, function13, function12, function1, 782328, null);
        return ProjectManagerEx.getInstanceEx().openProject(nioPath, options2);
    }

    @Override
    public void linkToExistingProject(@NotNull VirtualFile projectFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LOG.debug("Import project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        Path path2 = projectDirectory.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectDirectory.toNioPath()");
        this.linkAndRefreshProject(path2, project);
    }

    public final void linkToExistingProject(@NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        VirtualFile projectFile = localFileSystem2.refreshAndFindFileByPath(projectFilePath);
        if (projectFile == null) {
            String shortPath = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)projectFilePath), (boolean)false);
            throw (Throwable)new IllegalArgumentException(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])new Object[]{this.getSystemId().getReadableName(), shortPath}));
        }
        this.linkToExistingProject(projectFile, project);
    }

    private final boolean focusOnOpenedSameProject(Path projectDirectory) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        for (Project project : projectManager.getOpenProjects()) {
            if (!ProjectUtil.isSameProject(projectDirectory, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return true;
        }
        return false;
    }

    private final VirtualFile getProjectDirectory(VirtualFile file2) {
        VirtualFile virtualFile2;
        if (file2.isDirectory()) {
            virtualFile2 = file2;
        } else {
            VirtualFile virtualFile3 = file2.getParent();
            virtualFile2 = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"file.parent");
        }
        return virtualFile2;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractOpenProjectProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

