/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    private static final Logger LOG = Logger.getInstance(IdeModelsProviderImpl.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Map<ModuleData, Module> myIdeModulesCache;
    private final Map<Module, Map<String, List<ModuleOrderEntry>>> myIdeModuleToModuleDepsCache;

    public IdeModelsProviderImpl(@NotNull Project project) {
        if (project == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(0);
        }
        this.myIdeModulesCache = ContainerUtil.createWeakMap();
        this.myIdeModuleToModuleDepsCache = ContainerUtil.createWeakMap();
        this.myProject = project;
    }

    public Module @NotNull [] getModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    public Module @NotNull [] getModules(@NotNull ProjectData projectData2) {
        if (projectData2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(2);
        }
        List modules2 = ContainerUtil.filter((Object[])this.getModules(), module -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData2.getOwner(), (Module)module) && StringUtil.equals((CharSequence)projectData2.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)));
        Module[] moduleArray = modules2.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    public OrderEntry @NotNull [] getOrderEntries(@NotNull Module module) {
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(4);
        }
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        if (orderEntryArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(5);
        }
        return orderEntryArray;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module) {
        Module cachedIdeModule;
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(6);
        }
        if ((cachedIdeModule = this.myIdeModulesCache.get(module)) == null) {
            for (String candidate : this.suggestModuleNameCandidates(module)) {
                Module ideModule = this.findIdeModule(candidate);
                if (ideModule == null || !IdeModelsProviderImpl.isApplicableIdeModule(module, ideModule)) continue;
                this.myIdeModulesCache.put(module, ideModule);
                return ideModule;
            }
        } else {
            return cachedIdeModule;
        }
        return null;
    }

    protected Iterable<String> suggestModuleNameCandidates(@NotNull ModuleData module) {
        ExternalProjectSettings settings2;
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(7);
        }
        char delimiter = (settings2 = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)module.getOwner()).getLinkedProjectSettings(module.getLinkedExternalProjectPath())) != null && settings2.isUseQualifiedModuleNames() ? (char)'.' : '-';
        return new ModuleNameGenerator(module, delimiter).generate();
    }

    private static boolean isApplicableIdeModule(@NotNull ModuleData moduleData, @NotNull Module ideModule) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(8);
        }
        if (ideModule == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(9);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)ideModule).getContentRoots()) {
            if (!VfsUtilCore.pathEqualsTo((VirtualFile)root, (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)moduleData.getOwner(), (Module)ideModule) && FileUtil.pathsEqual((String)ExternalSystemApiUtil.getExternalProjectPath((Module)ideModule), (String)moduleData.getLinkedExternalProjectPath());
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        if (ideModuleName == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(10);
        }
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(ideModuleName);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(11);
        }
        for (String moduleName : this.suggestModuleNameCandidates(moduleData)) {
            UnloadedModuleDescription unloadedModuleDescription = ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(moduleName);
            if (unloadedModuleDescription == null) continue;
            return unloadedModuleDescription;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(12);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module) {
        Map namesToEntries;
        List candidates;
        if (dependency == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(13);
        }
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(14);
        }
        if ((candidates = (List)(namesToEntries = this.myIdeModuleToModuleDepsCache.computeIfAbsent(module, m -> Arrays.stream(this.getOrderEntries((Module)m)).filter(ModuleOrderEntry.class::isInstance).map(ModuleOrderEntry.class::cast).collect(Collectors.groupingBy(ModuleOrderEntry::getModuleName)))).get(dependency.getInternalName())) == null) {
            return null;
        }
        for (ModuleOrderEntry candidate : candidates) {
            if (!candidate.getScope().equals((Object)dependency.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData data2) {
        Module ownerIdeModule;
        if (data2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(15);
        }
        if ((ownerIdeModule = this.findIdeModule(data2.getOwnerModule())) == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (data2 instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)data2;
        } else if (data2 instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)data2;
        } else {
            return null;
        }
        for (OrderEntry entry2 : this.getOrderEntries(ownerIdeModule)) {
            String entryName;
            if (entry2 instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)entry2).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)entry2).getLibraryName())) {
                    Set paths2 = ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), PathUtil::getLocalPath);
                    Set entryPaths = ContainerUtil.map2Set((Object[])entry2.getUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s)));
                    if (!entryPaths.equals(paths2) || ((LibraryOrderEntry)entry2).getScope() != data2.getScope()) continue;
                    return entry2;
                }
            }
            String string = entryName = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!entryName.equals(entry2.getPresentableName()) || entry2 instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry2).getScope() != data2.getScope()) continue;
            return entry2;
        }
        return null;
    }

    @NotNull
    public Map<LibraryOrderEntry, LibraryDependencyData> findIdeModuleLibraryOrderEntries(@NotNull ModuleData moduleData, @NotNull List<LibraryDependencyData> libraryDependencyDataList) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(16);
        }
        if (libraryDependencyDataList == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(17);
        }
        if (libraryDependencyDataList.isEmpty()) {
            Map<LibraryOrderEntry, LibraryDependencyData> map2 = Collections.emptyMap();
            if (map2 == null) {
                IdeModelsProviderImpl.$$$reportNull$$$0(18);
            }
            return map2;
        }
        Module ownerIdeModule = this.findIdeModule(moduleData);
        if (ownerIdeModule == null) {
            Map<LibraryOrderEntry, LibraryDependencyData> map3 = Collections.emptyMap();
            if (map3 == null) {
                IdeModelsProviderImpl.$$$reportNull$$$0(19);
            }
            return map3;
        }
        HashMap<Set, LibraryDependencyData> libraryDependencyDataMap = new HashMap<Set, LibraryDependencyData>();
        for (LibraryDependencyData libraryDependencyData : libraryDependencyDataList) {
            if (libraryDependencyData.getLevel() == LibraryLevel.PROJECT) {
                LOG.warn("Library data \"" + libraryDependencyData.getInternalName() + "\" not a module level dependency");
                continue;
            }
            if (libraryDependencyData.getOwnerModule() != moduleData) {
                LOG.warn("Library data \"" + libraryDependencyData.getInternalName() + "\" not belong to the module: " + ownerIdeModule.getName());
                continue;
            }
            libraryDependencyDataMap.put(ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), PathUtil::getLocalPath), libraryDependencyData);
        }
        HashMap<LibraryOrderEntry, LibraryDependencyData> result2 = new HashMap<LibraryOrderEntry, LibraryDependencyData>();
        for (OrderEntry entry2 : this.getOrderEntries(ownerIdeModule)) {
            Set entryPaths;
            LibraryDependencyData libraryDependencyData;
            LibraryOrderEntry libraryOrderEntry;
            if (!(entry2 instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)entry2).isModuleLevel() || !StringUtil.isEmpty((String)libraryOrderEntry.getLibraryName()) || (libraryDependencyData = (LibraryDependencyData)libraryDependencyDataMap.get(entryPaths = ContainerUtil.map2Set((Object[])entry2.getUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s))))) == null || libraryOrderEntry.getScope() != libraryDependencyData.getScope()) continue;
            result2.put(libraryOrderEntry, libraryDependencyData);
        }
        HashMap<LibraryOrderEntry, LibraryDependencyData> hashMap = result2;
        if (hashMap == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    public VirtualFile @NotNull [] getContentRoots(Module module) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(21);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getSourceRoots(Module module) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(22);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getSourceRoots(Module module, boolean includingTests) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(23);
        }
        return virtualFileArray;
    }

    public Library @NotNull [] getAllLibraries() {
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
        if (libraryArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(24);
        }
        return libraryArray;
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(name);
    }

    public String @NotNull [] getLibraryUrls(@NotNull Library library2, @NotNull OrderRootType type) {
        if (library2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(25);
        }
        if (type == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(26);
        }
        String[] stringArray = library2.getUrls(type);
        if (stringArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(28);
        }
        List list2 = ModuleUtilCore.getAllDependentModules((Module)module);
        if (list2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(29);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyDataList";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdeModuleLibraryOrderEntries";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestModuleNameCandidates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableIdeModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleOrderEntry";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleLibraryOrderEntries";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleNameGenerator {
        private static final int MAX_FILE_DEPTH = 3;
        private static final int MAX_NUMBER_SEQ = 2;
        private final ModuleData myModule;
        private final char myDelimiter;

        ModuleNameGenerator(@NotNull ModuleData module, char delimiter) {
            if (module == null) {
                ModuleNameGenerator.$$$reportNull$$$0(0);
            }
            this.myModule = module;
            this.myDelimiter = delimiter;
        }

        Iterable<String> generate() {
            String prefix2 = this.myModule.getGroup();
            File modulePath = new File(this.myModule.getLinkedExternalProjectPath());
            if (modulePath.isFile()) {
                modulePath = modulePath.getParentFile();
            }
            final ArrayList names2 = prefix2 == null || StringUtil.startsWith((CharSequence)this.myModule.getInternalName(), (CharSequence)prefix2) ? ContainerUtil.newArrayList((Object[])new String[]{this.myModule.getInternalName()}) : ContainerUtil.newArrayList((Object[])new String[]{this.myModule.getInternalName(), prefix2 + this.myDelimiter + this.myModule.getInternalName()});
            String name = (String)names2.get(0);
            List pathParts = FileUtil.splitPath((String)FileUtil.toSystemDependentName((String)modulePath.getPath()));
            StringBuilder nameBuilder = new StringBuilder();
            String duplicateCandidate = name;
            int i2 = pathParts.size() - 1;
            for (int j = 0; i2 >= 0 && j < 3; --i2, ++j) {
                String part = (String)pathParts.get(i2);
                boolean isAlreadyIncluded = false;
                if (!duplicateCandidate.isEmpty()) {
                    if (duplicateCandidate.equals(part) || duplicateCandidate.endsWith(this.myDelimiter + part) || duplicateCandidate.endsWith("_" + part)) {
                        --j;
                        duplicateCandidate = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)duplicateCandidate, (String)part), (char)this.myDelimiter), (char)'_');
                        isAlreadyIncluded = true;
                    } else if (name.startsWith(part) || i2 > 1 && name.startsWith((String)pathParts.get(i2 - 1) + this.myDelimiter + part)) {
                        --j;
                        isAlreadyIncluded = true;
                    } else {
                        duplicateCandidate = "";
                    }
                }
                if (isAlreadyIncluded) continue;
                nameBuilder.insert(0, part + this.myDelimiter);
                names2.add(nameBuilder + name);
            }
            final String namePrefix = (String)ContainerUtil.getLastItem((List)names2);
            return new Iterable<String>(){

                @Override
                @NotNull
                public Iterator<String> iterator() {
                    Iterator iterator2 = ContainerUtil.concatIterators((Iterator[])new Iterator[]{names2.iterator(), new Iterator<String>(){
                        int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < 2;
                        }

                        @Override
                        public String next() {
                            ++this.current;
                            return namePrefix + "~" + this.current;
                        }
                    }});
                    if (iterator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return iterator2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl$ModuleNameGenerator$1", "iterator"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl$ModuleNameGenerator", "<init>"));
        }
    }
}

