/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemUiUtils;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemUiUtils$getKeyStrokes$;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u001a7\u0010\f\u001a\u00020\r*\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\"\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\u0002\u0010\u0013\u001a,\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u0011\u001a\u0012\u0010\u0014\u001a\u00020\n*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010\u0018\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0002\u001a\u0018\u0010\u001a\u001a\u00020\r*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c\u001a\u0018\u0010\u001d\u001a\u00020\r*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c\u001a\u0018\u0010\u001e\u001a\u00020\r*\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c\u00a8\u0006\u001f"}, d2={"getKeyStrokes", "", "Ljavax/swing/KeyStroke;", "actionIds", "", "", "([Ljava/lang/String;)Ljava/util/List;", "getModelPath", "path", "removeLastSlash", "", "getUiPath", "addKeyboardAction", "", "Ljavax/swing/JComponent;", "keyStrokes", "action", "Lkotlin/Function1;", "Ljava/awt/event/ActionEvent;", "(Ljavax/swing/JComponent;[Ljavax/swing/KeyStroke;Lkotlin/jvm/functions/Function1;)V", "isTextUnderMouse", "Ljavax/swing/text/JTextComponent;", "e", "Ljava/awt/event/MouseEvent;", "removeKeyStroke", "key", "whenFirstFocusGained", "listener", "Lkotlin/Function0;", "whenFocusGained", "whenTextModified", "intellij.platform.externalSystem.impl"})
@JvmName(name="ExternalSystemUiUtils")
public final class ExternalSystemUiUtils {
    public static final boolean isTextUnderMouse(@NotNull JTextComponent $this$isTextUnderMouse, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)$this$isTextUnderMouse, (String)"$this$isTextUnderMouse");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int position = $this$isTextUnderMouse.viewToModel2D(e.getPoint());
        int n = position;
        return 1 <= n && $this$isTextUnderMouse.getText().length() > n;
    }

    @NotNull
    public static final List<KeyStroke> getKeyStrokes(String ... actionIds) {
        KeymapManager keymapManager2;
        Intrinsics.checkNotNullParameter((Object)actionIds, (String)"actionIds");
        KeymapManager keymapManager3 = keymapManager2 = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager3, (String)"keymapManager");
        Keymap keymap2 = keymapManager3.getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap2, (String)"keymapManager.activeKeymap");
        Keymap activeKeymap = keymap2;
        Sequence $this$filterIsInstance$iv = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])actionIds), (Function1)((Function1)new Function1<String, Sequence<? extends Shortcut>>(activeKeymap){
            final /* synthetic */ Keymap $activeKeymap;

            @NotNull
            public final Sequence<Shortcut> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = this.$activeKeymap.getShortcuts(it);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"activeKeymap.getShortcuts(it)");
                return ArraysKt.asSequence((Object[])objectArray);
            }
            {
                this.$activeKeymap = keymap2;
                super(1);
            }
        }));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getKeyStrokes$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.flatMap((Sequence)sequence, (Function1)getKeyStrokes.2.INSTANCE)));
    }

    public static final void removeKeyStroke(@NotNull JComponent $this$removeKeyStroke, @NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)$this$removeKeyStroke, (String)"$this$removeKeyStroke");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        for (InputMap map2 = $this$removeKeyStroke.getInputMap(); map2 != null; map2 = map2.getParent()) {
            map2.remove(key);
        }
    }

    public static final void addKeyboardAction(@NotNull JComponent $this$addKeyboardAction, @NotNull KeyStroke[] keyStrokes, @NotNull Function1<? super ActionEvent, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeyboardAction, (String)"$this$addKeyboardAction");
        Intrinsics.checkNotNullParameter((Object)keyStrokes, (String)"keyStrokes");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        ExternalSystemUiUtils.addKeyboardAction($this$addKeyboardAction, ArraysKt.toList((Object[])keyStrokes), action2);
    }

    public static final void addKeyboardAction(@NotNull JComponent $this$addKeyboardAction, @NotNull List<? extends KeyStroke> keyStrokes, @NotNull Function1<? super ActionEvent, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeyboardAction, (String)"$this$addKeyboardAction");
        Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        for (KeyStroke keyStroke : keyStrokes) {
            Object object = action2;
            if (object != null) {
                Function1<? super ActionEvent, Unit> function1 = object;
                object = new ActionListener(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ void actionPerformed(ActionEvent p0) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)p0), (String)"invoke(...)");
                    }
                };
            }
            $this$addKeyboardAction.registerKeyboardAction((ActionListener)object, keyStroke, 0);
        }
    }

    @NotNull
    public static final String getUiPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        String string2 = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)((Object)StringsKt.trim((CharSequence)string)).toString()), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.getLocationRela\u2026Name(path.trim()), false)");
        return string2;
    }

    @NotNull
    public static final String getModelPath(@NotNull String path2, boolean removeLastSlash) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        String string2 = FileUtil.toCanonicalPath((String)FileUtil.expandUserHome((String)((Object)StringsKt.trim((CharSequence)string)).toString()), (char)File.separatorChar, (boolean)removeLastSlash);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.toCanonicalPath\u2026torChar, removeLastSlash)");
        return string2;
    }

    public static /* synthetic */ String getModelPath$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ExternalSystemUiUtils.getModelPath(string, bl);
    }

    public static final void whenTextModified(@NotNull JTextComponent $this$whenTextModified, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$whenTextModified, (String)"$this$whenTextModified");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$whenTextModified.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(listener2){
            final /* synthetic */ Function0 $listener;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public static final void whenFocusGained(@NotNull JComponent $this$whenFocusGained, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$whenFocusGained, (String)"$this$whenFocusGained");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$whenFocusGained.addFocusListener(new FocusAdapter(listener2){
            final /* synthetic */ Function0 $listener;

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public static final void whenFirstFocusGained(@NotNull JComponent $this$whenFirstFocusGained, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$whenFirstFocusGained, (String)"$this$whenFirstFocusGained");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$whenFirstFocusGained.addFocusListener(new FocusAdapter($this$whenFirstFocusGained, listener2){
            final /* synthetic */ JComponent $this_whenFirstFocusGained;
            final /* synthetic */ Function0 $listener;

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_whenFirstFocusGained.removeFocusListener(this);
                this.$listener.invoke();
            }
            {
                this.$this_whenFirstFocusGained = $receiver;
                this.$listener = $captured_local_variable$1;
            }
        });
    }
}

