/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends ExternalSystemNode {
    private final RunnerAndConfigurationSettings mySettings;

    public RunConfigurationNode(@NotNull ExternalProjectsView externalProjectsView, RunConfigurationsNode parent, @NotNull RunnerAndConfigurationSettings settings2) {
        if (externalProjectsView == null) {
            RunConfigurationNode.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            RunConfigurationNode.$$$reportNull$$$0(1);
        }
        super(externalProjectsView, parent);
        this.mySettings = settings2;
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            RunConfigurationNode.$$$reportNull$$$0(2);
        }
        super.update(presentation2);
        presentation2.setIcon(ProgramRunnerUtil.getConfigurationIcon(this.mySettings, false));
        ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)this.mySettings.getConfiguration();
        ExternalSystemTaskExecutionSettings taskExecutionSettings = runConfiguration.getSettings();
        String shortcutHint = StringUtil.nullize((String)this.getShortcutsManager().getDescription(taskExecutionSettings.getExternalProjectPath(), this.mySettings.getName()));
        String activatorHint = StringUtil.nullize((String)this.getTaskActivator().getDescription(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath(), ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(this.mySettings)));
        Object hint = shortcutHint == null ? activatorHint : (activatorHint == null ? shortcutHint : shortcutHint + ", " + activatorHint);
        this.setNameAndTooltip(this.getName(), StringUtil.join((Collection)taskExecutionSettings.getTaskNames(), (String)" "), (String)hint);
    }

    public RunnerAndConfigurationSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public String getName() {
        return this.mySettings.getName();
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.RunConfigurationMenu";
    }

    public void updateRunConfiguration() {
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        ExternalProjectsView projectsView = this.getExternalProjectsView();
        String place = projectsView instanceof Component ? ((Component)((Object)projectsView)).getName() : "unknown";
        ExternalSystemActionsCollector.trigger(this.myProject, projectsView.getSystemId(), ExternalSystemActionsCollector.ActionId.ExecuteExternalSystemRunConfigurationAction, place, false, null);
        ProgramRunnerUtil.executeConfiguration(this.mySettings, DefaultRunExecutor.getRunExecutorInstance());
        RunManager runManager = RunManager.getInstance((Project)this.mySettings.getConfiguration().getProject());
        runManager.addConfiguration(this.mySettings);
        runManager.setSelectedConfiguration(this.mySettings);
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return new Navigatable(){

            public void navigate(boolean requestFocus) {
                RunManager.getInstance((Project)RunConfigurationNode.this.myProject).setSelectedConfiguration(RunConfigurationNode.this.mySettings);
                EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(RunConfigurationNode.this.myProject);
                dialog2.show();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/view/RunConfigurationNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

