/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Order(value=30)
public final class RunConfigurationsNode
extends ExternalSystemNode<Void> {
    private final ModuleData myModuleData;

    public RunConfigurationsNode(@NotNull ExternalProjectsView externalProjectsView, ModuleNode parent) {
        if (externalProjectsView == null) {
            RunConfigurationsNode.$$$reportNull$$$0(0);
        }
        super(externalProjectsView, parent, null);
        this.myModuleData = (ModuleData)parent.getData();
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            RunConfigurationsNode.$$$reportNull$$$0(1);
        }
        super.update(presentation2);
        presentation2.setIcon(AllIcons.Nodes.ConfigFolder);
    }

    @Override
    public String getName() {
        return this.message("external.system.view.nodes.run_configurations.name", new Object[0]);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasChildren();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        ArrayList<RunConfigurationNode> runConfigurationNodes = new ArrayList<RunConfigurationNode>();
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(this.myModuleData.getOwner());
        if (configurationType == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                RunConfigurationsNode.$$$reportNull$$$0(2);
            }
            return list2;
        }
        HashSet settings2 = new HashSet(RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType));
        String directory = FileUtil.toCanonicalPath((String)this.myModuleData.getLinkedExternalProjectPath());
        for (RunnerAndConfigurationSettings cfg : settings2) {
            ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)cfg.getConfiguration();
            if (!directory.equals(FileUtil.toCanonicalPath((String)externalSystemRunConfiguration.getSettings().getExternalProjectPath()))) continue;
            runConfigurationNodes.add(new RunConfigurationNode(this.getExternalProjectsView(), this, cfg));
        }
        ArrayList<RunConfigurationNode> arrayList = runConfigurationNodes;
        if (arrayList == null) {
            RunConfigurationsNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void updateRunConfigurations() {
        this.cleanUpCache();
        this.getExternalProjectsView().updateUpTo(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/RunConfigurationsNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/RunConfigurationsNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

