/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.file.exclude.OverrideFileTypeManager;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class OverrideFileTypeAction
extends AnAction {
    OverrideFileTypeAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(0);
        }
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabled(file2 != null && !file2.isDirectory());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(1);
        }
        if ((file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) == null) {
            return;
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        Map duplicates = Arrays.stream(FileTypeManager.getInstance().getRegisteredFileTypes()).map(t -> t.getDisplayName()).collect(Collectors.groupingBy(Function.identity()));
        for (FileType type : ContainerUtil.sorted(Arrays.asList(FileTypeManager.getInstance().getRegisteredFileTypes()), (f1, f2) -> f1.getDisplayName().compareToIgnoreCase(f2.getDisplayName()))) {
            if (type instanceof InternalFileType || type instanceof DirectoryFileType || type instanceof UnknownFileType || type instanceof FakeFileType) continue;
            boolean hasDuplicate = duplicates.get(type.getDisplayName()).size() > 1;
            String dupHint = null;
            if (hasDuplicate) {
                PluginDescriptor descriptor2 = ((FileTypeManagerImpl)FileTypeManager.getInstance()).findPluginDescriptor(type);
                dupHint = descriptor2 == null ? null : " (" + (descriptor2.isBundled() ? ActionsBundle.message((String)"group.OverrideFileTypeAction.bundledPlugin", (Object[])new Object[0]) : ActionsBundle.message((String)"group.OverrideFileTypeAction.fromNamedPlugin", (Object[])new Object[]{descriptor2.getName()})) + ")";
            }
            @NlsActions.ActionText String displayText = type.getDisplayName() + StringUtil.notNullize(dupHint);
            group2.add((AnAction)new ChangeToThisFileTypeAction(displayText, file2, type));
        }
        JBPopupFactory.getInstance().createActionGroupPopup(ActionsBundle.message((String)"group.OverrideFileTypeAction.title", (Object[])new Object[0]), (ActionGroup)group2, e.getDataContext(), false, null, -1).showInBestPositionFor(e.getDataContext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/file/exclude/OverrideFileTypeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChangeToThisFileTypeAction
    extends AnAction {
        private final VirtualFile myFile;
        private final FileType myType;

        ChangeToThisFileTypeAction(@NotNull @NlsActions.ActionText String displayText, @NotNull VirtualFile file2, @NotNull FileType type) {
            if (displayText == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(1);
            }
            if (type == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(2);
            }
            super(displayText, ActionsBundle.message((String)"action.ChangeToThisFileTypeAction.description", (Object[])new Object[]{file2.getName(), type.getDescription()}), type.getIcon());
            this.myFile = file2;
            this.myType = type;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(3);
            }
            OverrideFileTypeManager.getInstance().addFile(this.myFile, this.myType);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(4);
            }
            boolean enabled = this.myFile.isValid() && !this.myFile.isDirectory();
            e.getPresentation().setEnabled(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/file/exclude/OverrideFileTypeAction$ChangeToThisFileTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

