/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileDrop;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.ex.PathField;
import com.intellij.openapi.fileChooser.ex.TextFieldAction;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDialogImpl
extends DialogWrapper
implements FileChooserDialog,
PathChooserDialog,
FileLookup {
    @NonNls
    public static final String FILE_CHOOSER_SHOW_PATH_PROPERTY = "FileChooser.ShowPath";
    private static final String RECENT_FILES_KEY = "file.chooser.recent.files";
    public static final @NotNull Supplier<@Nls String> DRAG_N_DROP_HINT = IdeBundle.messagePointer((String)"tooltip.drag.drop.file", (Object[])new Object[0]);
    private final FileChooserDescriptor myChooserDescriptor;
    protected FileSystemTreeImpl myFileSystemTree;
    private Project myProject;
    private VirtualFile[] myChosenFiles;
    private JPanel myNorthPanel;
    private TextFieldAction myTextFieldAction;
    protected FileTextFieldImpl myPathTextField;
    private ComboBox<String> myPath;
    private MergingUpdateQueue myUiUpdater;
    private boolean myTreeIsUpdating;
    private static final DataKey<PathField> PATH_FIELD = DataKey.create("PathField");
    private final Map<String, LocalFileSystem.WatchRequest> myRequests;

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project) {
        if (descriptor2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        this.myRequests = new HashMap<String, LocalFileSystem.WatchRequest>();
        this.myChooserDescriptor = descriptor2;
        this.myProject = project;
        this.setTitle(FileChooserDialogImpl.getChooserTitle(descriptor2));
    }

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor2, @NotNull Component parent) {
        if (descriptor2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(2);
        }
        this(descriptor2, parent, null);
    }

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor2, @NotNull Component parent, @Nullable Project project) {
        if (descriptor2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(4);
        }
        super(parent, true);
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        this.myRequests = new HashMap<String, LocalFileSystem.WatchRequest>();
        this.myChooserDescriptor = descriptor2;
        this.myProject = project;
        this.setTitle(FileChooserDialogImpl.getChooserTitle(descriptor2));
    }

    @NlsContexts.DialogTitle
    private static String getChooserTitle(FileChooserDescriptor descriptor2) {
        String title2 = descriptor2.getTitle();
        return title2 != null ? title2 : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    public VirtualFile @NotNull [] choose(@Nullable Project project, VirtualFile ... toSelect2) {
        if (toSelect2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(5);
        }
        this.init();
        if (this.myProject == null && project != null) {
            this.myProject = project;
        }
        if (toSelect2.length == 1) {
            this.restoreSelection(toSelect2[0]);
        } else if (toSelect2.length == 0) {
            this.restoreSelection(null);
        } else {
            this.selectInTree(toSelect2, true, true);
        }
        this.show();
        if (this.myChosenFiles == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(6);
        }
        return this.myChosenFiles;
    }

    public VirtualFile @NotNull [] choose(@Nullable VirtualFile toSelect2, @Nullable Project project) {
        if (toSelect2 == null) {
            VirtualFile[] virtualFileArray = this.choose(project, new VirtualFile[0]);
            if (virtualFileArray == null) {
                FileChooserDialogImpl.$$$reportNull$$$0(7);
            }
            return virtualFileArray;
        }
        VirtualFile[] virtualFileArray = this.choose(project, toSelect2);
        if (virtualFileArray == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    public void choose(@Nullable VirtualFile toSelect2, @NotNull Consumer<? super List<VirtualFile>> callback2) {
        if (callback2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(9);
        }
        this.init();
        this.restoreSelection(toSelect2);
        this.show();
        if (this.myChosenFiles.length > 0) {
            callback2.consume(Arrays.asList(this.myChosenFiles));
        } else if (callback2 instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback2).cancelled();
        }
    }

    protected void restoreSelection(@Nullable VirtualFile toSelect2) {
        VirtualFile lastOpenedFile = FileChooserUtil.getLastOpenedFile(this.myProject);
        VirtualFile file2 = FileChooserUtil.getFileToSelect(this.myChooserDescriptor, this.myProject, toSelect2, lastOpenedFile);
        if (file2 != null && file2.isValid()) {
            this.myPathTextField.setText(VfsUtil.getReadableUrl((VirtualFile)file2), true, () -> this.selectInTree(new VirtualFile[]{file2}, false, false));
        }
    }

    void storeSelection(@Nullable VirtualFile file2) {
        if (file2 != null) {
            Pair pair = file2.getFileSystem().getProtocol() == "jar" ? URLUtil.splitJarUrl((String)file2.getPath()) : null;
            FileChooserUtil.setLastOpenedFile(this.myProject, pair == null ? file2.toNioPath() : Paths.get((String)pair.getFirst(), new String[0]));
        }
        if (file2 != null && file2.getFileSystem() instanceof LocalFileSystem) {
            this.saveRecent(file2.getPath());
        }
    }

    private void saveRecent(String path2) {
        ArrayList<String> files2 = new ArrayList<String>(Arrays.asList(this.getRecentFiles()));
        files2.remove(path2);
        files2.add(0, path2);
        while (files2.size() > 30) {
            files2.remove(files2.size() - 1);
        }
        PropertiesComponent.getInstance().setValues(RECENT_FILES_KEY, ArrayUtilRt.toStringArray(files2));
    }

    private String @NotNull [] getRecentFiles() {
        String[] array2 = PropertiesComponent.getInstance().getValues(RECENT_FILES_KEY);
        if (array2 == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                FileChooserDialogImpl.$$$reportNull$$$0(10);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (array2.length > 0 && this.myPathTextField != null && this.myPathTextField.getField().getText().replace('\\', '/').equals(array2[0])) {
            String[] stringArray = Arrays.copyOfRange(array2, 1, array2.length);
            if (stringArray == null) {
                FileChooserDialogImpl.$$$reportNull$$$0(11);
            }
            return stringArray;
        }
        if (array2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(12);
        }
        return array2;
    }

    protected DefaultActionGroup createActionGroup() {
        this.registerTreeActionShortcut("FileChooser.Delete");
        this.registerTreeActionShortcut("FileChooser.Refresh");
        return (DefaultActionGroup)ActionManager.getInstance().getAction("FileChooserToolbar");
    }

    private void registerTreeActionShortcut(@NonNls String actionId) {
        JTree tree = this.myFileSystemTree.getTree();
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        action2.registerCustomShortcutSet(action2.getShortcutSet(), (JComponent)tree, this.myDisposable);
    }

    @Nullable
    protected final JComponent createTitlePane() {
        String description2 = this.myChooserDescriptor.getDescription();
        if (StringUtil.isEmptyOrSpaces((String)description2)) {
            return null;
        }
        JLabel label2 = new JLabel(description2);
        label2.setBorder(BorderFactory.createCompoundBorder((Border)new SideBorder(UIUtil.getPanelBackground().darker(), 8), (Border)JBUI.Borders.empty((int)0, (int)5, (int)10, (int)5)));
        return label2;
    }

    protected JComponent createCenterPanel() {
        MyPanel panel2 = new MyPanel();
        this.myUiUpdater = new MergingUpdateQueue("FileChooserUpdater", 200, false, (JComponent)panel2);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUiUpdater);
        new UiNotifyConnector((Component)panel2, (Activatable)this.myUiUpdater);
        panel2.setBorder((Border)JBUI.Borders.empty());
        this.createTree();
        DefaultActionGroup group2 = this.createActionGroup();
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("FileChooserDialog", (ActionGroup)group2, true);
        toolBar.setTargetComponent((JComponent)panel2);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolBar.getComponent(), "Center");
        this.myTextFieldAction = new TextFieldAction(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                FileChooserDialogImpl.this.toggleShowTextField();
            }
        };
        toolbarPanel.add((Component)((Object)this.myTextFieldAction), "East");
        JPanel extraToolbarPanel = this.createExtraToolbarPanel();
        if (extraToolbarPanel != null) {
            toolbarPanel.add((Component)extraToolbarPanel, "South");
        }
        this.myPath = new ComboBox((Object[])this.getRecentFiles());
        this.myPath.setEditable(true);
        this.myPath.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index2) -> {
            label2.setText(value2);
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(new File((String)value2));
            label2.setIcon(file2 == null ? EmptyIcon.ICON_16 : IconUtil.getIcon(file2, 2, null));
        }));
        this.myPathTextField = new FileTextFieldImpl.Vfs((JTextField)this.myPath.getEditor().getEditorComponent(), FileChooserFactoryImpl.getMacroMap(), this.getDisposable(), new LocalFsFinder.FileChooserFilter(this.myChooserDescriptor, this.myFileSystemTree)){

            @Override
            protected void onTextChanged(String newValue2) {
                FileChooserDialogImpl.this.myUiUpdater.cancelAllUpdates();
                FileChooserDialogImpl.this.updateTreeFromPath(newValue2);
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPathTextField);
        this.myNorthPanel = new JPanel(new BorderLayout());
        this.myNorthPanel.add((Component)toolbarPanel, "North");
        this.updateTextFieldShowing();
        panel2.add((Component)this.myNorthPanel, "North");
        this.registerMouseListener((ActionGroup)group2);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myFileSystemTree.getTree());
        panel2.add((Component)scrollPane, "Center");
        panel2.setPreferredSize((Dimension)JBUI.size((int)400));
        JLabel dndLabel = new JLabel(DRAG_N_DROP_HINT.get(), 0);
        dndLabel.setFont((Font)JBUI.Fonts.miniFont());
        dndLabel.setForeground(UIUtil.getLabelDisabledForeground());
        panel2.add((Component)dndLabel, "South");
        ApplicationManager.getApplication().getMessageBus().connect(this.getDisposable()).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    3.$$$reportNull$$$0(0);
                }
                SaveAndSyncHandler.getInstance().maybeRefresh(ModalityState.current());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$3", "applicationActivated"));
            }
        });
        return panel2;
    }

    @Nullable
    protected JPanel createExtraToolbarPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (FileChooserDialogImpl.isToShowTextField()) {
            return this.myPathTextField != null ? this.myPathTextField.getField() : null;
        }
        return this.myFileSystemTree != null ? this.myFileSystemTree.getTree() : null;
    }

    public final void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRequests.values());
        super.dispose();
    }

    private boolean isTextFieldActive() {
        return this.myPathTextField.getField().getRootPane() != null;
    }

    protected void doOKAction() {
        List<VirtualFile> selectedFiles;
        VirtualFile[] files2;
        if (!this.isOKActionEnabled()) {
            return;
        }
        if (this.isTextFieldActive()) {
            String text2 = this.myPathTextField.getTextFieldText();
            FileLookup.LookupFile file2 = this.myPathTextField.getFile();
            if (text2 == null || file2 == null || !file2.exists()) {
                this.setErrorText(IdeBundle.message((String)"dialog.message.specified.path.cannot.be.found", (Object[])new Object[0]), this.myPathTextField.getField());
                return;
            }
        }
        if ((files2 = VfsUtilCore.toVirtualFileArray(FileChooserUtil.getChosenFiles(this.myChooserDescriptor, selectedFiles = Arrays.asList(this.getSelectedFilesInt())))).length == 0) {
            this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
            this.close(1);
            return;
        }
        try {
            this.myChooserDescriptor.validateSelectedFiles(files2);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)this.getTitle());
            return;
        }
        this.myChosenFiles = files2;
        this.storeSelection(files2[files2.length - 1]);
        super.doOKAction();
    }

    public final void doCancelAction() {
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        super.doCancelAction();
    }

    protected JTree createTree() {
        Tree internalTree = this.createInternalTree();
        this.myFileSystemTree = new FileSystemTreeImpl(this.myProject, this.myChooserDescriptor, internalTree, null, null, null);
        internalTree.setRootVisible(this.myChooserDescriptor.isTreeRootVisible());
        internalTree.setShowsRootHandles(true);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myFileSystemTree);
        this.myFileSystemTree.addOkAction(this::doOKAction);
        JTree tree = this.myFileSystemTree.getTree();
        if (!Registry.is((String)"file.chooser.async.tree.model")) {
            tree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        }
        tree.getSelectionModel().addTreeSelectionListener(new FileTreeSelectionListener());
        tree.addTreeExpansionListener(new FileTreeExpansionListener());
        this.setOKActionEnabled(false);
        this.myFileSystemTree.addListener(selection -> {
            if (this.myTreeIsUpdating && this.myFileSystemTree.getTreeBuilder() == null) {
                this.myTreeIsUpdating = false;
            }
            this.updatePathFromTree(selection, false);
        }, this.myDisposable);
        new FileDrop(tree, new FileDrop.Target(){

            @Override
            public FileChooserDescriptor getDescriptor() {
                return FileChooserDialogImpl.this.myChooserDescriptor;
            }

            @Override
            public boolean isHiddenShown() {
                return FileChooserDialogImpl.this.myFileSystemTree.areHiddensShown();
            }

            @Override
            public void dropFiles(List<? extends VirtualFile> files2) {
                if (!FileChooserDialogImpl.this.myChooserDescriptor.isChooseMultiple() && !files2.isEmpty()) {
                    FileChooserDialogImpl.this.selectInTree(new VirtualFile[]{files2.get(0)}, true, true);
                } else {
                    FileChooserDialogImpl.this.selectInTree(VfsUtilCore.toVirtualFileArray(files2), true, true);
                }
            }
        });
        return tree;
    }

    @NotNull
    protected Tree createInternalTree() {
        return new Tree();
    }

    private void registerMouseListener(ActionGroup group2) {
        this.myFileSystemTree.registerMouseListener(group2);
    }

    private VirtualFile[] getSelectedFilesInt() {
        if (this.myTreeIsUpdating || !this.myUiUpdater.isEmpty()) {
            VirtualFile file2;
            FileLookup.LookupFile toFind;
            if (this.isTextFieldActive() && !StringUtil.isEmpty((String)this.myPathTextField.getTextFieldText()) && (toFind = this.myPathTextField.getFile()) instanceof LocalFsFinder.VfsFile && toFind.exists() && (file2 = ((LocalFsFinder.VfsFile)toFind).getFile()) != null) {
                return new VirtualFile[]{file2};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        return this.myFileSystemTree.getSelectedFiles();
    }

    private static boolean isToShowTextField() {
        return PropertiesComponent.getInstance().getBoolean(FILE_CHOOSER_SHOW_PATH_PROPERTY, true);
    }

    private static void setToShowTextField(boolean toShowTextField) {
        PropertiesComponent.getInstance().setValue(FILE_CHOOSER_SHOW_PATH_PROPERTY, Boolean.toString(toShowTextField));
    }

    public void toggleShowTextField() {
        FileChooserDialogImpl.setToShowTextField(!FileChooserDialogImpl.isToShowTextField());
        this.updateTextFieldShowing();
    }

    private void updateTextFieldShowing() {
        this.myTextFieldAction.update();
        this.myNorthPanel.remove((Component)this.myPath);
        if (FileChooserDialogImpl.isToShowTextField()) {
            ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
            if (this.myFileSystemTree.getSelectedFile() != null) {
                selection.add(this.myFileSystemTree.getSelectedFile());
            }
            this.updatePathFromTree(selection, true);
            this.myNorthPanel.add((Component)this.myPath, "Center");
        } else {
            this.setErrorText(null);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPathTextField.getField(), true));
        this.myNorthPanel.revalidate();
        this.myNorthPanel.repaint();
    }

    private void updatePathFromTree(List<? extends VirtualFile> selection, boolean now) {
        if (!FileChooserDialogImpl.isToShowTextField() || this.myTreeIsUpdating) {
            return;
        }
        String text2 = "";
        if (!selection.isEmpty()) {
            text2 = VfsUtil.getReadableUrl((VirtualFile)selection.get(0));
        } else {
            List roots = this.myChooserDescriptor.getRoots();
            if (!this.myFileSystemTree.getTree().isRootVisible() && roots.size() == 1) {
                text2 = VfsUtil.getReadableUrl((VirtualFile)((VirtualFile)roots.get(0)));
            }
        }
        if (this.myFileSystemTree.getTreeBuilder() == null) {
            if (text2.isEmpty()) {
                return;
            }
            String old = this.myPathTextField.getTextFieldText();
            if (old == null || old.equals(text2)) {
                return;
            }
            int index2 = old.length() - 1;
            if (index2 == text2.length() && File.separatorChar == old.charAt(index2) && old.startsWith(text2)) {
                return;
            }
        }
        this.myPathTextField.setText(text2, now, () -> {
            this.myPathTextField.getField().selectAll();
            this.setErrorText(null);
        });
    }

    private void updateTreeFromPath(final String text2) {
        if (!FileChooserDialogImpl.isToShowTextField()) {
            return;
        }
        if (this.myPathTextField.isPathUpdating()) {
            return;
        }
        if (text2 == null) {
            return;
        }
        this.myUiUpdater.queue(new Update("treeFromPath.1"){

            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    final LocalFsFinder.VfsFile toFind = (LocalFsFinder.VfsFile)FileChooserDialogImpl.this.myPathTextField.getFile();
                    if (toFind == null || !toFind.exists()) {
                        return;
                    }
                    FileChooserDialogImpl.this.myUiUpdater.queue(new Update("treeFromPath.2"){

                        public void run() {
                            FileChooserDialogImpl.this.selectInTree(toFind.getFile(), text2);
                        }
                    });
                });
            }
        });
    }

    private void selectInTree(VirtualFile vFile, String fromText2) {
        if (vFile != null && vFile.isValid()) {
            if (fromText2 == null || fromText2.equalsIgnoreCase(this.myPathTextField.getTextFieldText())) {
                this.selectInTree(new VirtualFile[]{vFile}, false, fromText2 == null);
            }
        } else {
            this.reportFileNotFound();
        }
    }

    private void selectInTree(VirtualFile[] array2, boolean requestFocus, boolean updatePathNeeded) {
        this.myTreeIsUpdating = true;
        List<VirtualFile> fileList = Arrays.asList(array2);
        if (!Arrays.asList(this.myFileSystemTree.getSelectedFiles()).containsAll(fileList)) {
            this.myFileSystemTree.select(array2, () -> {
                VirtualFile parent;
                if (!this.myFileSystemTree.areHiddensShown() && !Arrays.asList(this.myFileSystemTree.getSelectedFiles()).containsAll(fileList)) {
                    this.myFileSystemTree.showHiddens(true);
                    this.selectInTree(array2, requestFocus, updatePathNeeded);
                    return;
                }
                if (array2.length == 1 && !Arrays.asList(this.myFileSystemTree.getSelectedFiles()).containsAll(fileList) && (parent = array2[0].getParent()) != null && parent.isValid()) {
                    this.selectInTree(new VirtualFile[]{parent}, requestFocus, updatePathNeeded);
                    return;
                }
                this.reportFileNotFound();
                if (updatePathNeeded) {
                    this.updatePathFromTree(fileList, true);
                }
                if (requestFocus) {
                    SwingUtilities.invokeLater(() -> this.myFileSystemTree.getTree().requestFocus());
                }
            });
        } else {
            this.reportFileNotFound();
            if (updatePathNeeded) {
                this.updatePathFromTree(fileList, true);
            }
        }
    }

    private void reportFileNotFound() {
        this.myTreeIsUpdating = false;
        this.setErrorText(null);
    }

    protected String getDimensionServiceKey() {
        return "FileChooserDialogImpl";
    }

    protected String getHelpId() {
        return "select.path.dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected final class MyPanel
    extends JPanel
    implements DataProvider {
        final PasteProvider myPasteProvider;

        public MyPanel() {
            super(new BorderLayout(0, 0));
            this.myPasteProvider = new PasteProvider(){

                public void performPaste(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (FileChooserDialogImpl.this.myPathTextField != null) {
                        String path2 = this.calculatePath();
                        FileChooserDialogImpl.this.myPathTextField.setText(path2, true, null);
                        FileChooserDialogImpl.this.updateTreeFromPath(path2);
                    }
                }

                @Nullable
                private String calculatePath() {
                    List<File> fileList;
                    Transferable contents = CopyPasteManager.getInstance().getContents();
                    if (contents != null && (fileList = FileCopyPasteUtil.getFileList(contents)) != null && !fileList.isEmpty()) {
                        return fileList.get(0).getAbsolutePath();
                    }
                    return null;
                }

                public boolean isPastePossible(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return this.isPasteEnabled(dataContext);
                }

                public boolean isPasteEnabled(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return FileCopyPasteUtil.isFileListFlavorAvailable() && this.calculatePath() != null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "dataContext";
                    objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$MyPanel$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "performPaste";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isPastePossible";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isPasteEnabled";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @Override
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if (PATH_FIELD.is(dataId)) {
                return FileChooserDialogImpl.this::toggleShowTextField;
            }
            if (FileSystemTree.DATA_KEY.is(dataId)) {
                return FileChooserDialogImpl.this.myFileSystemTree;
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return this.myPasteProvider;
            }
            return FileChooserDialogImpl.this.myChooserDescriptor.getUserData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$MyPanel", "getData"));
        }
    }

    private final class FileTreeSelectionListener
    implements TreeSelectionListener {
        private FileTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths2 = e.getPaths();
            boolean enabled = true;
            for (TreePath treePath : paths2) {
                VirtualFile file2;
                if (!e.isAddedPath(treePath) || (file2 = FileSystemTreeImpl.getVirtualFile(treePath)) != null && FileChooserDialogImpl.this.myChooserDescriptor.isFileSelectable(file2)) continue;
                enabled = false;
            }
            FileChooserDialogImpl.this.setOKActionEnabled(enabled);
        }
    }

    private final class FileTreeExpansionListener
    implements TreeExpansionListener {
        private FileTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            LocalFileSystem.WatchRequest watchRequest;
            String rootPath;
            VirtualFile file2;
            DefaultMutableTreeNode node2;
            Object userObject;
            Object[] path2 = event.getPath().getPath();
            if (path2.length == 2 && path2[1] instanceof DefaultMutableTreeNode && (userObject = (node2 = (DefaultMutableTreeNode)path2[1]).getUserObject()) instanceof FileNodeDescriptor && (file2 = ((FileNodeDescriptor)((Object)userObject)).getElement().getFile()) != null && file2.isDirectory() && FileChooserDialogImpl.this.myRequests.get(rootPath = file2.getPath()) == null && (watchRequest = LocalFileSystem.getInstance().addRootToWatch(rootPath, true)) != null) {
                FileChooserDialogImpl.this.myRequests.put(rootPath, watchRequest);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

