/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReopenClosedTabAction
extends AnAction {
    public ReopenClosedTabAction() {
        super(ActionsBundle.messagePointer((String)"action.ReopenClosedTabAction.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        EditorWindow window;
        if (e == null) {
            ReopenClosedTabAction.$$$reportNull$$$0(0);
        }
        if ((window = ReopenClosedTabAction.getEditorWindow(e)) != null) {
            if (window.hasClosedTabs()) {
                window.restoreClosedTab();
            }
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        List<VirtualFile> list2 = EditorHistoryManager.getInstance(project).getFileList();
        if (!list2.isEmpty()) {
            FileEditorManager.getInstance((Project)project).openFile(list2.get(list2.size() - 1), true);
        }
    }

    @Nullable
    private static EditorWindow getEditorWindow(@NotNull AnActionEvent e) {
        EditorsSplitters splitters;
        Component component2;
        if (e == null) {
            ReopenClosedTabAction.$$$reportNull$$$0(1);
        }
        if ((component2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) != null && (splitters = (EditorsSplitters)((Object)ComponentUtil.getParentOfType(EditorsSplitters.class, (Component)component2))) != null) {
            return splitters.getCurrentWindow();
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        EditorWindow window;
        if (e == null) {
            ReopenClosedTabAction.$$$reportNull$$$0(2);
        }
        if ((window = ReopenClosedTabAction.getEditorWindow(e)) != null) {
            e.getPresentation().setEnabledAndVisible(window.hasClosedTabs());
            return;
        }
        Project project = e.getProject();
        if (project != null && !EditorHistoryManager.getInstance(project).getFileList().isEmpty()) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/ReopenClosedTabAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

