/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.highlighter.FileTypeRegistrar;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeEditor;
import com.intellij.lang.Commenter;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.WildcardFileNameMatcher;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractFileType
extends UserFileType<AbstractFileType>
implements ExternalizableFileType,
ExternalizableScheme,
CustomSyntaxTableFileType,
PlainTextLikeFileType {
    private static final String SEMICOLON = ";";
    @NotNull
    private SyntaxTable mySyntaxTable;
    private SyntaxTable myDefaultSyntaxTable;
    private Commenter myCommenter;
    @NonNls
    static final String ELEMENT_HIGHLIGHTING = "highlighting";
    @NonNls
    private static final String ELEMENT_OPTIONS = "options";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String VALUE_LINE_COMMENT = "LINE_COMMENT";
    @NonNls
    private static final String VALUE_COMMENT_START = "COMMENT_START";
    @NonNls
    private static final String VALUE_COMMENT_END = "COMMENT_END";
    @NonNls
    private static final String VALUE_HEX_PREFIX = "HEX_PREFIX";
    @NonNls
    private static final String VALUE_NUM_POSTFIXES = "NUM_POSTFIXES";
    @NonNls
    private static final String VALUE_HAS_BRACES = "HAS_BRACES";
    @NonNls
    private static final String VALUE_HAS_BRACKETS = "HAS_BRACKETS";
    @NonNls
    private static final String VALUE_HAS_PARENS = "HAS_PARENS";
    @NonNls
    private static final String VALUE_HAS_STRING_ESCAPES = "HAS_STRING_ESCAPES";
    @NonNls
    private static final String VALUE_LINE_COMMENT_AT_START = "LINE_COMMENT_AT_START";
    @NonNls
    private static final String ELEMENT_KEYWORDS = "keywords";
    @NonNls
    private static final String ATTRIBUTE_IGNORE_CASE = "ignore_case";
    @NonNls
    private static final String ELEMENT_KEYWORD = "keyword";
    @NonNls
    private static final String ELEMENT_KEYWORDS2 = "keywords2";
    @NonNls
    private static final String ELEMENT_KEYWORDS3 = "keywords3";
    @NonNls
    private static final String ELEMENT_KEYWORDS4 = "keywords4";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    static final String ATTRIBUTE_EXT = "ext";
    @NonNls
    static final String ATTRIBUTE_PATTERN = "pattern";
    @NonNls
    static final String ATTRIBUTE_TYPE = "type";

    public AbstractFileType(@NotNull SyntaxTable syntaxTable) {
        if (syntaxTable == null) {
            AbstractFileType.$$$reportNull$$$0(0);
        }
        this.mySyntaxTable = syntaxTable;
    }

    void initSupport() {
        for (FileTypeRegistrar registrar : (FileTypeRegistrar[])FileTypeRegistrar.EP_NAME.getExtensions()) {
            registrar.initFileType((FileType)this);
        }
    }

    @Override
    @NotNull
    public SyntaxTable getSyntaxTable() {
        SyntaxTable syntaxTable = this.mySyntaxTable;
        if (syntaxTable == null) {
            AbstractFileType.$$$reportNull$$$0(1);
        }
        return syntaxTable;
    }

    public Commenter getCommenter() {
        return this.myCommenter;
    }

    public void setSyntaxTable(@NotNull SyntaxTable syntaxTable) {
        if (syntaxTable == null) {
            AbstractFileType.$$$reportNull$$$0(2);
        }
        this.mySyntaxTable = syntaxTable;
    }

    public AbstractFileType clone() {
        return (AbstractFileType)super.clone();
    }

    public void copyFrom(@NotNull UserFileType<AbstractFileType> newType) {
        if (newType == null) {
            AbstractFileType.$$$reportNull$$$0(3);
        }
        super.copyFrom(newType);
        if (newType instanceof AbstractFileType) {
            this.mySyntaxTable = ((CustomSyntaxTableFileType)newType).getSyntaxTable();
        }
    }

    public boolean isBinary() {
        return false;
    }

    public void readExternal(@NotNull Element typeElement) throws InvalidDataException {
        Element element2;
        if (typeElement == null) {
            AbstractFileType.$$$reportNull$$$0(4);
        }
        if ((element2 = typeElement.getChild(ELEMENT_HIGHLIGHTING)) != null) {
            this.setSyntaxTable(AbstractFileType.readSyntaxTable(element2));
        }
    }

    @NotNull
    static SyntaxTable readSyntaxTable(@NotNull Element root) {
        if (root == null) {
            AbstractFileType.$$$reportNull$$$0(5);
        }
        SyntaxTable table = new SyntaxTable();
        for (Element element2 : root.getChildren()) {
            if (ELEMENT_OPTIONS.equals(element2.getName())) {
                for (Element e : element2.getChildren(ELEMENT_OPTION)) {
                    String name = e.getAttributeValue(ATTRIBUTE_NAME);
                    String value2 = e.getAttributeValue(ATTRIBUTE_VALUE);
                    if (VALUE_LINE_COMMENT.equals(name)) {
                        table.setLineComment(value2);
                        continue;
                    }
                    if (VALUE_COMMENT_START.equals(name)) {
                        table.setStartComment(value2);
                        continue;
                    }
                    if (VALUE_COMMENT_END.equals(name)) {
                        table.setEndComment(value2);
                        continue;
                    }
                    if (VALUE_HEX_PREFIX.equals(name)) {
                        table.setHexPrefix(value2);
                        continue;
                    }
                    if (VALUE_NUM_POSTFIXES.equals(name)) {
                        table.setNumPostfixChars(value2);
                        continue;
                    }
                    if (VALUE_LINE_COMMENT_AT_START.equals(name)) {
                        table.lineCommentOnlyAtStart = Boolean.parseBoolean(value2);
                        continue;
                    }
                    if (VALUE_HAS_BRACES.equals(name)) {
                        table.setHasBraces(Boolean.parseBoolean(value2));
                        continue;
                    }
                    if (VALUE_HAS_BRACKETS.equals(name)) {
                        table.setHasBrackets(Boolean.parseBoolean(value2));
                        continue;
                    }
                    if (VALUE_HAS_PARENS.equals(name)) {
                        table.setHasParens(Boolean.parseBoolean(value2));
                        continue;
                    }
                    if (!VALUE_HAS_STRING_ESCAPES.equals(name)) continue;
                    table.setHasStringEscapes(Boolean.parseBoolean(value2));
                }
                continue;
            }
            if (ELEMENT_KEYWORDS.equals(element2.getName())) {
                boolean ignoreCase = Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_IGNORE_CASE));
                table.setIgnoreCase(ignoreCase);
                AbstractFileType.loadKeywords(element2, table.getKeywords1());
                continue;
            }
            if (ELEMENT_KEYWORDS2.equals(element2.getName())) {
                AbstractFileType.loadKeywords(element2, table.getKeywords2());
                continue;
            }
            if (ELEMENT_KEYWORDS3.equals(element2.getName())) {
                AbstractFileType.loadKeywords(element2, table.getKeywords3());
                continue;
            }
            if (!ELEMENT_KEYWORDS4.equals(element2.getName())) continue;
            AbstractFileType.loadKeywords(element2, table.getKeywords4());
        }
        SyntaxTable syntaxTable = table;
        if (syntaxTable == null) {
            AbstractFileType.$$$reportNull$$$0(6);
        }
        return syntaxTable;
    }

    private static void loadKeywords(@NotNull Element element2, @NotNull Set<? super String> keywords) {
        String value2;
        if (element2 == null) {
            AbstractFileType.$$$reportNull$$$0(7);
        }
        if (keywords == null) {
            AbstractFileType.$$$reportNull$$$0(8);
        }
        if ((value2 = element2.getAttributeValue(ELEMENT_KEYWORDS)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value2, SEMICOLON);
            while (tokenizer.hasMoreElements()) {
                String keyword = tokenizer.nextToken().trim();
                if (keyword.isEmpty()) continue;
                keywords.add(keyword);
            }
        }
        for (Element e : element2.getChildren(ELEMENT_KEYWORD)) {
            keywords.add(e.getAttributeValue(ATTRIBUTE_NAME));
        }
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            AbstractFileType.$$$reportNull$$$0(9);
        }
        AbstractFileType.writeTable(element2, this.getSyntaxTable());
    }

    private static void writeTable(@NotNull Element element2, @NotNull SyntaxTable table) {
        String chars;
        String prefix2;
        String endComment;
        if (element2 == null) {
            AbstractFileType.$$$reportNull$$$0(10);
        }
        if (table == null) {
            AbstractFileType.$$$reportNull$$$0(11);
        }
        Element highlightingElement = new Element(ELEMENT_HIGHLIGHTING);
        Element optionsElement = new Element(ELEMENT_OPTIONS);
        Element lineComment = new Element(ELEMENT_OPTION);
        lineComment.setAttribute(ATTRIBUTE_NAME, VALUE_LINE_COMMENT);
        lineComment.setAttribute(ATTRIBUTE_VALUE, table.getLineComment());
        optionsElement.addContent(lineComment);
        String commentStart = table.getStartComment();
        if (commentStart != null) {
            Element commentStartElement = new Element(ELEMENT_OPTION);
            commentStartElement.setAttribute(ATTRIBUTE_NAME, VALUE_COMMENT_START);
            commentStartElement.setAttribute(ATTRIBUTE_VALUE, commentStart);
            optionsElement.addContent(commentStartElement);
        }
        if ((endComment = table.getEndComment()) != null) {
            Element commentEndElement = new Element(ELEMENT_OPTION);
            commentEndElement.setAttribute(ATTRIBUTE_NAME, VALUE_COMMENT_END);
            commentEndElement.setAttribute(ATTRIBUTE_VALUE, endComment);
            optionsElement.addContent(commentEndElement);
        }
        if ((prefix2 = table.getHexPrefix()) != null) {
            Element hexPrefix = new Element(ELEMENT_OPTION);
            hexPrefix.setAttribute(ATTRIBUTE_NAME, VALUE_HEX_PREFIX);
            hexPrefix.setAttribute(ATTRIBUTE_VALUE, prefix2);
            optionsElement.addContent(hexPrefix);
        }
        if ((chars = table.getNumPostfixChars()) != null) {
            Element numPostfixes = new Element(ELEMENT_OPTION);
            numPostfixes.setAttribute(ATTRIBUTE_NAME, VALUE_NUM_POSTFIXES);
            numPostfixes.setAttribute(ATTRIBUTE_VALUE, chars);
            optionsElement.addContent(numPostfixes);
        }
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_BRACES, table.isHasBraces());
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_BRACKETS, table.isHasBrackets());
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_PARENS, table.isHasParens());
        AbstractFileType.addElementOption(optionsElement, VALUE_HAS_STRING_ESCAPES, table.isHasStringEscapes());
        AbstractFileType.addElementOption(optionsElement, VALUE_LINE_COMMENT_AT_START, table.lineCommentOnlyAtStart);
        highlightingElement.addContent(optionsElement);
        AbstractFileType.writeKeywords(table.getKeywords1(), ELEMENT_KEYWORDS, highlightingElement).setAttribute(ATTRIBUTE_IGNORE_CASE, String.valueOf(table.isIgnoreCase()));
        AbstractFileType.writeKeywords(table.getKeywords2(), ELEMENT_KEYWORDS2, highlightingElement);
        AbstractFileType.writeKeywords(table.getKeywords3(), ELEMENT_KEYWORDS3, highlightingElement);
        AbstractFileType.writeKeywords(table.getKeywords4(), ELEMENT_KEYWORDS4, highlightingElement);
        element2.addContent(highlightingElement);
    }

    private static void addElementOption(@NotNull Element optionsElement, @NotNull String valueHasParens, boolean hasParens) {
        if (optionsElement == null) {
            AbstractFileType.$$$reportNull$$$0(12);
        }
        if (valueHasParens == null) {
            AbstractFileType.$$$reportNull$$$0(13);
        }
        if (!hasParens) {
            return;
        }
        Element supportParens = new Element(ELEMENT_OPTION);
        supportParens.setAttribute(ATTRIBUTE_NAME, valueHasParens);
        supportParens.setAttribute(ATTRIBUTE_VALUE, String.valueOf(true));
        optionsElement.addContent(supportParens);
    }

    private static Element writeKeywords(@NotNull Set<String> keywords, @NotNull String tagName, @NotNull Element highlightingElement) {
        if (keywords == null) {
            AbstractFileType.$$$reportNull$$$0(14);
        }
        if (tagName == null) {
            AbstractFileType.$$$reportNull$$$0(15);
        }
        if (highlightingElement == null) {
            AbstractFileType.$$$reportNull$$$0(16);
        }
        if (keywords.isEmpty() && !ELEMENT_KEYWORDS.equals(tagName)) {
            return null;
        }
        Element keywordsElement = new Element(tagName);
        Object[] strings = ArrayUtilRt.toStringArray(keywords);
        Arrays.sort(strings);
        StringBuilder keywordsAttribute = new StringBuilder();
        for (Object keyword : strings) {
            if (!((String)keyword).contains(SEMICOLON)) {
                if (keywordsAttribute.length() != 0) {
                    keywordsAttribute.append(SEMICOLON);
                }
                keywordsAttribute.append((String)keyword);
                continue;
            }
            Element e = new Element(ELEMENT_KEYWORD);
            e.setAttribute(ATTRIBUTE_NAME, (String)keyword);
            keywordsElement.addContent(e);
        }
        if (keywordsAttribute.length() != 0) {
            keywordsElement.setAttribute(ELEMENT_KEYWORDS, keywordsAttribute.toString());
        }
        highlightingElement.addContent(keywordsElement);
        return keywordsElement;
    }

    @Override
    public void markDefaultSettings() {
        this.myDefaultSyntaxTable = this.mySyntaxTable;
    }

    @Override
    public boolean isModified() {
        return !Comparing.equal((Object)this.myDefaultSyntaxTable, (Object)this.getSyntaxTable());
    }

    @NotNull
    static List<Pair<FileNameMatcher, String>> readAssociations(@NotNull Element element2) {
        List children2;
        if (element2 == null) {
            AbstractFileType.$$$reportNull$$$0(17);
        }
        if ((children2 = element2.getChildren(ELEMENT_MAPPING)).isEmpty()) {
            List<Pair<FileNameMatcher, String>> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractFileType.$$$reportNull$$$0(18);
            }
            return list2;
        }
        SmartList result2 = new SmartList();
        for (Element mapping2 : children2) {
            String ext = mapping2.getAttributeValue(ATTRIBUTE_EXT);
            String pattern = mapping2.getAttributeValue(ATTRIBUTE_PATTERN);
            ExtensionFileNameMatcher matcher = ext != null ? new ExtensionFileNameMatcher(ext) : FileTypeManager.parseFromString((String)pattern);
            result2.add(Pair.create((Object)matcher, (Object)mapping2.getAttributeValue(ATTRIBUTE_TYPE)));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            AbstractFileType.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    @Nullable
    static Element writeMapping(@NotNull String typeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName) {
        Element mapping2;
        if (typeName == null) {
            AbstractFileType.$$$reportNull$$$0(20);
        }
        if (matcher == null) {
            AbstractFileType.$$$reportNull$$$0(21);
        }
        if (!AbstractFileType.writePattern(matcher, mapping2 = new Element(ELEMENT_MAPPING))) {
            return null;
        }
        if (specifyTypeName) {
            mapping2.setAttribute(ATTRIBUTE_TYPE, typeName);
        }
        return mapping2;
    }

    static boolean writePattern(@NotNull FileNameMatcher matcher, @NotNull Element mapping2) {
        if (matcher == null) {
            AbstractFileType.$$$reportNull$$$0(22);
        }
        if (mapping2 == null) {
            AbstractFileType.$$$reportNull$$$0(23);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            mapping2.setAttribute(ATTRIBUTE_EXT, ((ExtensionFileNameMatcher)matcher).getExtension());
        } else if (matcher instanceof WildcardFileNameMatcher) {
            mapping2.setAttribute(ATTRIBUTE_PATTERN, ((WildcardFileNameMatcher)matcher).getPattern());
        } else if (matcher instanceof ExactFileNameMatcher) {
            mapping2.setAttribute(ATTRIBUTE_PATTERN, ((ExactFileNameMatcher)matcher).getFileName());
        } else {
            return false;
        }
        return true;
    }

    public SettingsEditor<AbstractFileType> getEditor() {
        return new CustomFileTypeEditor();
    }

    public void setCommenter(@NotNull Commenter commenter) {
        if (commenter == null) {
            AbstractFileType.$$$reportNull$$$0(24);
        }
        this.myCommenter = commenter;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj2) {
        return obj2 instanceof AbstractFileType && this.getName().equals(((AbstractFileType)obj2).getName()) && this.mySyntaxTable.equals(((AbstractFileType)obj2).mySyntaxTable);
    }

    public String toString() {
        return "AbstractFileType " + (String)(this.getName().isEmpty() ? "" : this.getName() + "; ") + this.mySyntaxTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxTable";
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/AbstractFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_KEYWORDS;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHasParens";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MAPPING;
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/AbstractFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readSyntaxTable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "readAssociations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSyntaxTable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSyntaxTable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadKeywords";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeTable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addElementOption";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeKeywords";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readAssociations";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeMapping";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writePattern";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setCommenter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

