/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.DefaultKeymapKt;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.MacOSDefaultKeymap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J+\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "", "()V", "defaultKeymapName", "", "getDefaultKeymapName", "()Ljava/lang/String;", "keymaps", "", "Lcom/intellij/openapi/keymap/Keymap;", "getKeymaps$intellij_platform_ide_impl", "()Ljava/util/List;", "nameToScheme", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "addKeymap", "", "keymap", "Lcom/intellij/openapi/keymap/impl/DefaultKeymapImpl;", "findScheme", "name", "findScheme$intellij_platform_ide_impl", "getKeymapPresentableName", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "loadKeymap", "keymapName", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "plugin", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "loadKeymap$intellij_platform_ide_impl", "removeKeymap", "removeKeymap$intellij_platform_ide_impl", "Companion", "intellij.platform.ide.impl"})
public class DefaultKeymap {
    @NotNull
    private final List<Keymap> keymaps = new ArrayList<E>();
    private final HashMap<String, Keymap> nameToScheme = new HashMap<K, V>();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Keymap> getKeymaps$intellij_platform_ide_impl() {
        return this.keymaps;
    }

    @NotNull
    public final DefaultKeymapImpl loadKeymap$intellij_platform_ide_impl(@NotNull String keymapName, @NotNull SchemeDataHolder<? super KeymapImpl> dataHolder, @NotNull PluginDescriptor plugin2) {
        Intrinsics.checkNotNullParameter((Object)keymapName, (String)"keymapName");
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        Intrinsics.checkNotNullParameter((Object)plugin2, (String)"plugin");
        DefaultKeymapImpl keymap2 = StringsKt.startsWith$default((String)keymapName, (String)"Mac OS X", (boolean)false, (int)2, null) ? (DefaultKeymapImpl)new MacOSDefaultKeymap(dataHolder, this, plugin2) : new DefaultKeymapImpl(dataHolder, this, plugin2);
        keymap2.setName(keymapName);
        this.addKeymap(keymap2);
        return keymap2;
    }

    private final void addKeymap(DefaultKeymapImpl keymap2) {
        this.keymaps.add(keymap2);
        ((Map)this.nameToScheme).put(keymap2.getName(), keymap2);
    }

    public final void removeKeymap$intellij_platform_ide_impl(@NotNull String keymapName) {
        Intrinsics.checkNotNullParameter((Object)keymapName, (String)"keymapName");
        Keymap removed = this.nameToScheme.remove(keymapName);
        Collection collection = this.keymaps;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(removed);
    }

    @Nullable
    public final Keymap findScheme$intellij_platform_ide_impl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.nameToScheme.get(name);
    }

    @NotNull
    public String getDefaultKeymapName() {
        return SystemInfoRt.isMac ? "Mac OS X 10.5+" : (SystemInfo.isGNOME ? "Default for GNOME" : (SystemInfo.isKDE ? "Default for KDE" : (SystemInfo.isXWindow ? "Default for XWin" : "$default")));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getKeymapPresentableName(@NotNull KeymapImpl keymap2) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        switch (string2 = keymap2.getName()) {
            case "Mac OS X 10.5+": {
                string = "macOS";
                break;
            }
            case "$default": {
                string = "Windows";
                break;
            }
            case "Default for GNOME": {
                string = "GNOME";
                break;
            }
            case "Default for KDE": {
                string = "KDE";
                break;
            }
            case "Default for XWin": {
                string = "XWin";
                break;
            }
            case "Mac OS X": {
                string = "IntelliJ IDEA Classic" + (SystemInfoRt.isMac ? "" : " (macOS)");
                break;
            }
            case "NetBeans 6.5": {
                string = "NetBeans";
                break;
            }
            default: {
                void name;
                String newName2 = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)name, (CharSequence)" (Mac OS X)"), (CharSequence)" OSX");
                string = StringsKt.removePrefix((String)(newName2 == name ? name : newName2 + " (macOS)"), (CharSequence)(DefaultKeymapKt.access$osName() + '/'));
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DefaultKeymap() {
        super();
        v0 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ApplicationManager.getApplication()");
        if (v0.isHeadlessEnvironment()) ** GOTO lbl-1000
        var2_1 = System.getProperty("keymap.current.os.only", "true");
        var3_2 = false;
        if (Boolean.parseBoolean(var2_1)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        filterKeymaps = v1;
        var3_2 = false;
        filteredBeans = new ArrayList<E>();
        var3_3 = new Ref.BooleanRef();
        var3_3.element = false;
        if (SystemInfoRt.isMac) {
            v2 = null;
        } else {
            var5_5 = false;
            v2 = new ArrayList<E>();
        }
        macosBeans = v2;
        BundledKeymapBean.EP_NAME.processWithPluginDescriptor(new BiConsumer((Ref.BooleanRef)macosParentKeymapFound, filteredBeans){
            final /* synthetic */ Ref.BooleanRef $macosParentKeymapFound;
            final /* synthetic */ List $filteredBeans;

            /*
             * Enabled aggressive block sorting
             */
            public final void accept(BundledKeymapBean bean, PluginDescriptor pluginDescriptor) {
                BundledKeymapBean bundledKeymapBean = bean;
                Intrinsics.checkNotNullExpressionValue((Object)bundledKeymapBean, (String)"bean");
                String keymapName = DefaultKeymapKt.getKeymapName(bundledKeymapBean);
                if (filterKeymaps) {
                    PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor2, (String)"pluginDescriptor");
                    if (pluginDescriptor2.isBundled() && Companion.isBundledKeymapHidden(keymapName)) {
                        return;
                    }
                }
                if (filterKeymaps && macosBeans != null) {
                    PluginDescriptor pluginDescriptor3 = pluginDescriptor;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor3, (String)"pluginDescriptor");
                    if (!pluginDescriptor3.isBundled() && DefaultKeymapKt.access$isKnownMacOSKeymap(keymapName)) {
                        this.$macosParentKeymapFound.element = this.$macosParentKeymapFound.element || Intrinsics.areEqual((Object)keymapName, (Object)"Mac OS X 10.5+");
                        macosBeans.add(new Pair((Object)bean, (Object)pluginDescriptor));
                        return;
                    }
                }
                this.$filteredBeans.add(new Pair((Object)bean, (Object)pluginDescriptor));
            }
            {
                this.$macosParentKeymapFound = booleanRef;
                this.$filteredBeans = list3;
            }
        });
        if (macosParentKeymapFound.element && macosBeans != null) {
            filteredBeans.addAll(macosBeans);
        }
        for (Pair var5_6 : filteredBeans) {
            var7_9 = (BundledKeymapBean)var5_6.component1();
            pluginDescriptor = (PluginDescriptor)var5_6.component2();
            $this$runAndLogException$iv = DefaultKeymapKt.access$getLOG$p();
            $i$f$runAndLogException = false;
            var11_13 = $this$runAndLogException$iv;
            var12_14 = false;
            try {
                var13_15 /* !! */  = Result.Companion;
                $this$runCatching$iv = var11_13;
                $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = false;
                $i$a$-runAndLogException-DefaultKeymap$2 = false;
                var14_16 = this.loadKeymap$intellij_platform_ide_impl(DefaultKeymapKt.getKeymapName((BundledKeymapBean)bean), (SchemeDataHolder<? super KeymapImpl>)new SchemeDataHolder<KeymapImpl>(this, (BundledKeymapBean)bean, pluginDescriptor){
                    final /* synthetic */ DefaultKeymap this$0;
                    final /* synthetic */ BundledKeymapBean $bean$inlined;
                    final /* synthetic */ PluginDescriptor $pluginDescriptor$inlined;
                    {
                        this.this$0 = defaultKeymap;
                        this.$bean$inlined = bundledKeymapBean;
                        this.$pluginDescriptor$inlined = pluginDescriptor;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public Element read() {
                        Element element2;
                        Closeable closeable = this.$pluginDescriptor$inlined.getPluginClassLoader().getResourceAsStream(DefaultKeymapKt.getEffectiveFile(this.$bean$inlined));
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl3 = false;
                            Element element3 = JDOMUtil.load((InputStream)it);
                            element2 = element3;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"pluginDescriptor.pluginC\u2026il.load(it)\n            }");
                        return element2;
                    }

                    public void updateDigest(@NotNull KeymapImpl scheme2) {
                        Intrinsics.checkNotNullParameter((Object)scheme2, (String)"scheme");
                        SchemeDataHolder.DefaultImpls.updateDigest(this, scheme2);
                    }

                    public void updateDigest(@Nullable Element data2) {
                        SchemeDataHolder.DefaultImpls.updateDigest(this, data2);
                    }
                }, pluginDescriptor);
                var15_18 = false;
                var13_15 /* !! */  = Result.constructor-impl((Object)var14_16);
            }
            catch (Throwable var14_17) {
                var15_19 = Result.Companion;
                var17_21 = false;
                var13_15 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var14_17));
            }
            LoggerKt.getOrLogException((Object)var13_15 /* !! */ , (Logger)$this$runAndLogException$iv);
        }
    }

    @JvmStatic
    @NotNull
    public static final DefaultKeymap getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "isBundledKeymapHidden", "", "keymapName", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DefaultKeymap getInstance() {
            boolean $i$f$service = false;
            Class<DefaultKeymap> serviceClass$iv = DefaultKeymap.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (DefaultKeymap)object;
        }

        public final boolean isBundledKeymapHidden(@Nullable String keymapName) {
            return (SystemInfoRt.isWindows || SystemInfoRt.isMac) && DefaultKeymapKt.access$isKnownLinuxKeymap(keymapName) || !SystemInfoRt.isMac && DefaultKeymapKt.access$isKnownMacOSKeymap(keymapName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

