/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ModuleWithDependenciesScope
extends GlobalSearchScope {
    public static final int COMPILE_ONLY = 1;
    public static final int LIBRARIES = 2;
    public static final int MODULES = 4;
    public static final int TESTS = 8;
    public static final int CONTENT = 32;
    private final Module myModule;
    @ScopeConstant
    private final int myOptions;
    private final ProjectFileIndexImpl myProjectFileIndex;
    private volatile Set<Module> myModules;
    private final Object2IntMap<VirtualFile> myRoots;
    private static final Key<Pair<Long, Object2IntMap<VirtualFile>>> BRANCH_ROOTS = Key.create((String)"BRANCH_ROOTS");

    ModuleWithDependenciesScope(@NotNull Module module, @ScopeConstant int options2) {
        if (module == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(0);
        }
        super(module.getProject());
        this.myModule = module;
        this.myOptions = options2;
        this.myProjectFileIndex = (ProjectFileIndexImpl)ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        this.myRoots = this.calcRoots(null);
    }

    private Object2IntMap<VirtualFile> calcRoots(@Nullable ModelBranch branch) {
        LinkedHashSet roots = new LinkedHashSet();
        if (this.hasOption(32)) {
            Set<Module> modules2 = this.calcModules();
            this.myModules = new HashSet<Module>(modules2);
            for (Module m : modules2) {
                for (ContentEntry entry3 : ModuleRootManager.getInstance((Module)m).getContentEntries()) {
                    ContainerUtil.addIfNotNull(roots, (Object)(branch == null ? entry3.getFile() : branch.findFileByUrl(entry3.getUrl())));
                }
            }
        } else {
            OrderRootsEnumerator en = this.getOrderEnumeratorForOptions().roots(entry2 -> {
                if (entry2 instanceof ModuleOrderEntry || entry2 instanceof ModuleSourceOrderEntry) {
                    return OrderRootType.SOURCES;
                }
                return OrderRootType.CLASSES;
            });
            if (branch == null) {
                Collections.addAll(roots, en.getRoots());
            } else {
                roots.addAll(ContainerUtil.mapNotNull((Object[])en.getUrls(), arg_0 -> ((ModelBranch)branch).findFileByUrl(arg_0)));
            }
        }
        int i2 = 1;
        Object2IntOpenHashMap map2 = new Object2IntOpenHashMap(roots.size());
        for (VirtualFile root : roots) {
            map2.put((Object)root, i2++);
        }
        return map2;
    }

    private OrderEnumerator getOrderEnumeratorForOptions() {
        OrderEnumerator en = ModuleRootManager.getInstance((Module)this.myModule).orderEntries();
        en.recursively();
        if (this.hasOption(1)) {
            en.exportedOnly().compileOnly();
        }
        if (!this.hasOption(2)) {
            en.withoutLibraries().withoutSdk();
        }
        if (!this.hasOption(4)) {
            en.withoutDepModules();
        }
        if (!this.hasOption(8)) {
            en.productionOnly();
        }
        return en;
    }

    @NotNull
    private Set<Module> calcModules() {
        LinkedHashSet<Module> modules2 = new LinkedHashSet<Module>();
        OrderEnumerator en = this.getOrderEnumeratorForOptions();
        en.forEach(each -> {
            if (each instanceof ModuleOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)modules2, (Object)((ModuleOrderEntry)each).getModule());
            } else if (each instanceof ModuleSourceOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)modules2, (Object)each.getOwnerModule());
            }
            return true;
        });
        LinkedHashSet<Module> linkedHashSet = modules2;
        if (linkedHashSet == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(2);
        }
        return module;
    }

    private boolean hasOption(@ScopeConstant int option2) {
        return BitUtil.isSet((int)this.myOptions, (int)option2);
    }

    @NotNull
    public String getDisplayName() {
        String string = this.hasOption(1) ? IndexingBundle.message((String)"search.scope.module", (Object[])new Object[]{this.myModule.getName()}) : IndexingBundle.message((String)"search.scope.module.runtime", (Object[])new Object[]{this.myModule.getName()});
        if (string == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Set<Module> allModules;
        if (aModule == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(4);
        }
        if ((allModules = this.myModules) == null) {
            this.myModules = allModules = new HashSet<Module>(this.calcModules());
        }
        return allModules.contains(aModule);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(5);
        }
        return this.isSearchInModuleContent(aModule) && (this.hasOption(8) || !testSources);
    }

    public boolean isSearchInLibraries() {
        return this.hasOption(2);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(6);
        }
        DirectoryInfo info2 = this.myProjectFileIndex.getInfoForFileOrDirectory(file2);
        Object2IntMap<VirtualFile> roots = this.getRoots(file2);
        if (this.hasOption(32)) {
            return roots.containsKey((Object)ProjectFileIndexImpl.getContentRootForFile(info2, file2, true));
        }
        if (ProjectFileIndexImpl.isFileInContent(file2, info2) && roots.containsKey((Object)ProjectFileIndexImpl.getSourceRootForFile(file2, info2))) {
            return true;
        }
        return roots.containsKey((Object)ProjectFileIndexImpl.getClassRootForFile(file2, info2));
    }

    private Object2IntMap<VirtualFile> getRoots(@NotNull VirtualFile file2) {
        ModelBranch branch;
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(7);
        }
        return (branch = ModelBranch.getFileBranch((VirtualFile)file2)) != null ? this.obtainBranchRoots(branch) : this.myRoots;
    }

    private Object2IntMap<VirtualFile> obtainBranchRoots(ModelBranch branch) {
        Pair pair = (Pair)branch.getUserData(BRANCH_ROOTS);
        long modCount = branch.getBranchedVfsStructureModificationCount();
        if (pair == null || (Long)pair.first != modCount) {
            pair = Pair.create((Object)modCount, this.calcRoots(branch));
        }
        return (Object2IntMap)pair.second;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        VirtualFile r1;
        if (file1 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(9);
        }
        if (Comparing.equal((Object)(r1 = this.getFileRoot(file1)), (Object)(r2 = this.getFileRoot(file2)))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        Object2IntMap<VirtualFile> roots = this.getRoots(file1);
        int i1 = roots.getInt((Object)r1);
        int i2 = roots.getInt((Object)r2);
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        DirectoryInfo info2;
        VirtualFile root;
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(10);
        }
        return (root = ProjectFileIndexImpl.getClassRootForFile(file2, info2 = this.myProjectFileIndex.getInfoForFileOrDirectory(file2))) != null ? root : ProjectFileIndexImpl.getSourceRootForFile(file2, info2);
    }

    @TestOnly
    public Collection<VirtualFile> getRoots() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>((Collection<VirtualFile>)this.myRoots.keySet());
        result2.sort(Comparator.comparingInt(arg_0 -> this.myRoots.getInt(arg_0)));
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ModuleWithDependenciesScope that = (ModuleWithDependenciesScope)((Object)o);
        return this.myOptions == that.myOptions && this.myModule.equals(that.myModule);
    }

    public int calcHashCode() {
        return 31 * this.myModule.hashCode() + this.myOptions;
    }

    public String toString() {
        return "Module-with-dependencies:" + this.myModule.getName() + " compile-only:" + this.hasOption(1) + " include-libraries:" + this.hasOption(2) + " include-other-modules:" + this.hasOption(4) + " include-tests:" + this.hasOption(8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface ScopeConstant {
    }
}

