/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.BundleBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableGroupEP;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.EpBasedConfigurableGroup;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    @NotNull
    public static List<Configurable> buildConfigurablesList(@NotNull List<? extends ConfigurableEP<Configurable>> extensions2, @Nullable ConfigurableFilter filter) {
        if (extensions2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(0);
        }
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        HashMap<String, ConfigurableWrapper> idToConfigurable = new HashMap<String, ConfigurableWrapper>();
        ArrayList<String> idsInEpOrder = new ArrayList<String>();
        for (ConfigurableEP<Configurable> configurableEP : extensions2) {
            Configurable configurable2 = ConfigurableWrapper.wrapConfigurable(configurableEP);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable2, filter)) continue;
            if (configurable2 instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
                idToConfigurable.put(wrapper2.getId(), wrapper2);
                idsInEpOrder.add(wrapper2.getId());
                continue;
            }
            if (configurable2 == null) continue;
            result2.add(configurable2);
        }
        HashSet visited = new HashSet();
        Map<String, List<String>> map2 = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id2 : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id2, idToConfigurable, visited, map2);
        }
        for (String id2 : idsInEpOrder) {
            ConfigurableWrapper wrapper3 = (ConfigurableWrapper)idToConfigurable.get(id2);
            String parentId = wrapper3.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result2.add((Configurable)wrapper3);
        }
        ArrayList<Configurable> arrayList = result2;
        if (arrayList == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static ConfigurableWrapper addChildrenRec(@NotNull String id2, @NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull Set<? super String> visited, @NotNull Map<String, List<String>> idTree) {
        if (id2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(2);
        }
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(4);
        }
        if (idTree == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(5);
        }
        ConfigurableWrapper wrapper2 = idToConfigurable.get(id2);
        if (visited.contains(id2)) {
            ConfigurableWrapper configurableWrapper = wrapper2;
            if (configurableWrapper == null) {
                ConfigurableExtensionPointUtil.$$$reportNull$$$0(6);
            }
            return configurableWrapper;
        }
        visited.add(id2);
        List<String> childIds = idTree.get(id2);
        if (childIds != null) {
            for (String childId : childIds) {
                ConfigurableWrapper childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper2 = wrapper2.addChild((Configurable)childWrapper);
            }
            idToConfigurable.put(id2, wrapper2);
        }
        ConfigurableWrapper configurableWrapper = wrapper2;
        if (configurableWrapper == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(7);
        }
        return configurableWrapper;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(8);
        }
        if (idsInEpOrder == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(9);
        }
        HashMap<String, List<String>> tree = new HashMap<String, List<String>>();
        for (String id2 : idsInEpOrder) {
            ConfigurableWrapper wrapper2 = idToConfigurable.get(id2);
            String parentId = wrapper2.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + wrapper2 + ")");
                continue;
            }
            tree.computeIfAbsent(parentId, k -> new ArrayList(5)).add(id2);
        }
        HashMap<String, List<String>> hashMap = tree;
        if (hashMap == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    public static ConfigurableGroup getConfigurableGroup(@Nullable Project project, boolean withIdeSettings) {
        Project targetProject = withIdeSettings ? project : ProjectUtil.currentOrDefaultProject((Project)project);
        return new EpBasedConfigurableGroup(targetProject, () -> ConfigurableExtensionPointUtil.getConfigurableGroup(ConfigurableExtensionPointUtil.getConfigurables(targetProject, withIdeSettings), targetProject));
    }

    @Nullable
    public static ConfigurableGroup getConfigurableGroup(@NotNull List<? extends Configurable> configurables, @Nullable Project project) {
        if (configurables == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(11);
        }
        Map<String, List<Configurable>> map2 = ConfigurableExtensionPointUtil.groupConfigurables(configurables);
        HashMap<String, Node<SortedConfigurableGroup>> tree = new HashMap<String, Node<SortedConfigurableGroup>>();
        for (Map.Entry<String, List<Configurable>> entry2 : map2.entrySet()) {
            ConfigurableExtensionPointUtil.addGroup(tree, project, entry2.getKey(), entry2.getValue(), null);
        }
        SortedConfigurableGroup root = ConfigurableExtensionPointUtil.getGroup(tree, "root");
        if (!tree.isEmpty()) {
            LOG.warn("ignore groups: " + tree.keySet());
        }
        if (root != null && root.myList != null && Registry.is((String)"ide.settings.replace.group.with.single.configurable")) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(root.myList);
        }
        return root;
    }

    private static void replaceGroupWithSingleConfigurable(List<Configurable> list2) {
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            SortedConfigurableGroup group2;
            Configurable configurable2 = list2.get(i2);
            if (!(configurable2 instanceof SortedConfigurableGroup) || (configurable2 = ConfigurableExtensionPointUtil.getConfigurableToReplace(group2.myList, (group2 = (SortedConfigurableGroup)configurable2).getWeight())) == null) continue;
            list2.set(i2, configurable2);
        }
    }

    private static Configurable getConfigurableToReplace(List<Configurable> list2, int weight2) {
        if (list2 != null) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(list2);
            if (1 == list2.size()) {
                Configurable configurable2 = list2.get(0);
                if (configurable2 instanceof SortedConfigurableGroup) {
                    SortedConfigurableGroup group2 = (SortedConfigurableGroup)configurable2;
                    group2.myWeight = weight2;
                    return group2;
                }
                if (configurable2 instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
                    wrapper2.myWeight = weight2;
                    return wrapper2;
                }
            }
        }
        return null;
    }

    private static SortedConfigurableGroup getGroup(Map<String, Node<SortedConfigurableGroup>> tree, String groupId2) {
        Node<SortedConfigurableGroup> node2 = tree.remove(groupId2);
        if (node2.myChildren != null) {
            Iterator<Object> iterator2 = node2.myChildren.iterator();
            while (iterator2.hasNext()) {
                String childId = (String)iterator2.next();
                ((SortedConfigurableGroup)node2.myValue).myList.add((Configurable)ConfigurableExtensionPointUtil.getGroup(tree, childId));
                iterator2.remove();
            }
        }
        return (SortedConfigurableGroup)node2.myValue;
    }

    private static void addGroup(@NotNull Map<String, Node<SortedConfigurableGroup>> tree, Project project, String groupId2, List<? extends Configurable> configurables, ResourceBundle alternative) {
        if (tree == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(12);
        }
        boolean root = "root".equals(groupId2);
        String id2 = "configurable.group." + groupId2;
        ResourceBundle bundle = ConfigurableExtensionPointUtil.getBundle(id2 + ".settings.display.name", configurables, alternative);
        if (bundle == null) {
            bundle = OptionsBundle.INSTANCE.getResourceBundle();
            if (!root) {
                LOG.warn("use other group instead of unexpected one: " + groupId2);
                groupId2 = "other";
                id2 = "configurable.group." + groupId2;
            }
        }
        ConfigurableGroupEP ep2 = root ? null : ConfigurableGroupEP.find(groupId2);
        Node<SortedConfigurableGroup> node2 = Node.get(tree, groupId2);
        if (node2.myValue == null) {
            if (ep2 != null) {
                String name = project == null || project.isDefault() || !"project".equals(groupId2) ? ep2.getDisplayName() : StringUtil.first((String)MessageFormat.format(ep2.getResourceValue("configurable.group.project.named.settings.display.name"), project.getName()), (int)30, (boolean)true);
                node2.myValue = new SortedConfigurableGroup(id2, name, ep2.getDescription(), ep2.helpTopic, ep2.weight);
            } else if (root) {
                node2.myValue = new SortedConfigurableGroup(id2, "ROOT GROUP", null, null, 0);
            } else {
                LOG.warn("Use <groupConfigurable> to specify custom configurable group: " + groupId2);
                int weight2 = ConfigurableExtensionPointUtil.getInt(bundle, id2 + ".settings.weight");
                String help = ConfigurableExtensionPointUtil.getString(bundle, id2 + ".settings.help.topic");
                String name = ConfigurableExtensionPointUtil.getName(bundle, id2 + ".settings.display.name");
                String desc = ConfigurableExtensionPointUtil.getString(bundle, id2 + ".settings.description");
                if (name != null && project != null) {
                    if (!project.isDefault() && !name.contains("{")) {
                        String named = ConfigurableExtensionPointUtil.getString(bundle, id2 + ".named.settings.display.name");
                        String string = name = named != null ? named : name;
                    }
                    if (name.contains("{")) {
                        name = StringUtil.first((String)MessageFormat.format(name, project.getName()), (int)30, (boolean)true);
                    }
                }
                node2.myValue = new SortedConfigurableGroup(id2, name, desc, help, weight2);
            }
        }
        if (configurables != null) {
            ((SortedConfigurableGroup)node2.myValue).myList.addAll(configurables);
        }
        if (!root && node2.myParent == null) {
            String parentId = ep2 != null ? ep2.parentId : ConfigurableExtensionPointUtil.getString(bundle, id2 + ".settings.parent");
            parentId = Node.cyclic(tree, parentId, "root", groupId2, node2);
            node2.myParent = Node.add(tree, parentId, groupId2);
            ConfigurableExtensionPointUtil.addGroup(tree, project, parentId, null, bundle);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Map<String, List<Configurable>> groupConfigurables(@NotNull List<? extends Configurable> configurables) {
        if (configurables == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(13);
        }
        HashMap<String, Node<ConfigurableWrapper>> tree = new HashMap<String, Node<ConfigurableWrapper>>();
        for (Configurable configurable2 : configurables) {
            void id2;
            if (!(configurable2 instanceof ConfigurableWrapper)) {
                Node.add(tree, "other", configurable2);
                continue;
            }
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
            try {
                String id22 = wrapper2.getId();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Cannot create configurable", e);
                continue;
            }
            Node node2 = Node.get(tree, id2);
            if (node2.myValue != null) {
                LOG.warn("ignore configurable with duplicated id: " + (String)id2);
                continue;
            }
            String parentId = wrapper2.getParentId();
            String groupId2 = wrapper2.getExtensionPoint().groupId;
            if (groupId2 != null) {
                if (parentId != null) {
                    LOG.warn("ignore deprecated groupId: " + groupId2 + " for id: " + (String)id2);
                } else {
                    parentId = groupId2;
                }
            }
            parentId = (String)Node.cyclic(tree, parentId, "other", id2, node2);
            node2.myParent = Node.add(tree, parentId, node2);
            node2.myValue = wrapper2;
        }
        HashMap<String, List<Configurable>> map2 = new HashMap<String, List<Configurable>>();
        for (String id3 : ArrayUtilRt.toStringArray(tree.keySet())) {
            List<Configurable> list2;
            Node node3 = (Node)tree.get(id3);
            if (node3 == null || (list2 = ConfigurableExtensionPointUtil.getConfigurables(tree, node3)) == null) continue;
            map2.put(id3, list2);
            tree.remove(id3);
        }
        HashMap<String, List<Configurable>> hashMap = map2;
        if (hashMap == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    private static List<Configurable> getConfigurables(Map<String, Node<ConfigurableWrapper>> tree, Node<ConfigurableWrapper> node2) {
        if (node2.myChildren == null) {
            if (node2.myValue == null) {
                return new ArrayList<Configurable>();
            }
            return null;
        }
        ArrayList<Configurable> list2 = new ArrayList<Configurable>(node2.myChildren.size());
        Iterator<Object> iterator2 = node2.myChildren.iterator();
        while (iterator2.hasNext()) {
            Object child2 = iterator2.next();
            if (child2 instanceof Configurable) {
                list2.add((Configurable)child2);
            } else {
                Node value2 = (Node)child2;
                if (ConfigurableExtensionPointUtil.getConfigurables(tree, value2) != null) {
                    throw new IllegalStateException("unexpected algorithm state");
                }
                list2.add((Configurable)value2.myValue);
                tree.remove(((ConfigurableWrapper)value2.myValue).getId());
            }
            iterator2.remove();
        }
        if (node2.myValue == null) {
            return list2;
        }
        for (Configurable configurable2 : list2) {
            node2.myValue = ((ConfigurableWrapper)node2.myValue).addChild(configurable2);
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project, boolean withIdeSettings) {
        Application application;
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        if (withIdeSettings && (application = ApplicationManager.getApplication()) != null) {
            for (ConfigurableEP extension2 : Configurable.APPLICATION_CONFIGURABLE.getExtensionList()) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension2, true), null);
            }
        }
        if (project != null && !project.isDisposed()) {
            for (ConfigurableEP extension3 : Configurable.PROJECT_CONFIGURABLE.getExtensions((AreaInstance)project)) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension3, true), project);
            }
        }
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addValid(@NotNull List<? super Configurable> list2, Configurable configurable2, Project project) {
        if (list2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(16);
        }
        if (ConfigurableExtensionPointUtil.isValid(configurable2, project)) {
            list2.add((Configurable)configurable2);
        }
    }

    private static boolean isValid(Configurable configurable2, Project project) {
        if (configurable2 == null) {
            return false;
        }
        return project == null || !project.isDefault() || !ConfigurableWrapper.isNonDefaultProject(configurable2);
    }

    @Nullable
    public static ResourceBundle getBundle(@NonNls @NotNull String resource, @Nullable Iterable<? extends Configurable> configurables, @Nullable ResourceBundle alternative) {
        ResourceBundle bundle;
        if (resource == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(17);
        }
        if (ConfigurableExtensionPointUtil.getString(bundle = OptionsBundle.INSTANCE.getResourceBundle(), resource) != null) {
            return bundle;
        }
        if (configurables != null) {
            for (Configurable configurable2 : configurables) {
                ConfigurableWrapper wrapper2;
                if (!(configurable2 instanceof ConfigurableWrapper) || ConfigurableExtensionPointUtil.getString(bundle = (wrapper2 = (ConfigurableWrapper)configurable2).getExtensionPoint().findBundle(), resource) == null) continue;
                return bundle;
            }
        }
        if (ConfigurableExtensionPointUtil.getString(alternative, resource) != null) {
            return alternative;
        }
        return null;
    }

    @Nls
    private static String getString(ResourceBundle bundle, @NonNls String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.getString(resource);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    @Nls
    private static String getName(ResourceBundle bundle, @NonNls String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return BundleBase.messageOrDefault((ResourceBundle)bundle, (String)resource, null, (Object[])new Object[0]);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static int getInt(ResourceBundle bundle, @NonNls String resource) {
        try {
            String value2 = ConfigurableExtensionPointUtil.getString(bundle, resource);
            return value2 == null ? 0 : Integer.parseInt(value2);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter) {
        return !ConfigurableExtensionPointUtil.isValid(each, null) || filter != null && !filter.isIncluded(each);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project, Class<? extends ConfigurableProvider> providerClass) {
        if (project == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(18);
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(Configurable.PROJECT_CONFIGURABLE.getIterable((AreaInstance)project), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(Configurable.APPLICATION_CONFIGURABLE.getIterable(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(@NotNull Iterable<? extends ConfigurableEP<Configurable>> extensions2, Class<? extends ConfigurableProvider> providerClass) {
        if (extensions2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(19);
        }
        for (ConfigurableEP<Configurable> configurableEP : extensions2) {
            Class aClass;
            if (configurableEP.providerClass == null || (aClass = configurableEP.findClassOrNull(configurableEP.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)configurableEP.createConfigurable();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsInEpOrder";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConfigurablesList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addChildrenRec";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIdTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "groupConfigurables";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildConfigurablesList";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenRec";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildIdTree";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableGroup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "groupConfigurables";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addValid";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createProjectConfigurableForProvider";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurableForProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node<V> {
        List<Object> myChildren;
        Node<V> myParent;
        V myValue;

        private Node() {
        }

        private static <I, V> Node<V> get(@NotNull Map<I, Node<V>> tree, @NotNull I id2) {
            Node<V> node2;
            if (tree == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(1);
            }
            if ((node2 = tree.get(id2)) == null) {
                node2 = new Node<V>();
                tree.put(id2, node2);
            }
            return node2;
        }

        private static <I, V> Node<V> add(@NotNull Map<I, Node<V>> tree, @NotNull I id2, Object child2) {
            if (tree == null) {
                Node.$$$reportNull$$$0(2);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(3);
            }
            Node<V> node2 = Node.get(tree, id2);
            if (node2.myChildren == null) {
                node2.myChildren = new SmartList();
            }
            node2.myChildren.add(child2);
            return node2;
        }

        private static <I, V> boolean cyclic(@NotNull Map<I, Node<V>> tree, @NotNull I id2, Node<V> parent) {
            if (tree == null) {
                Node.$$$reportNull$$$0(4);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            Node<V> node2 = tree.get(id2);
            while (node2 != null) {
                if (node2 == parent) {
                    return true;
                }
                node2 = node2.myParent;
            }
            return false;
        }

        private static <I, V> I cyclic(@NotNull Map<I, Node<V>> tree, @Nullable I id2, I idDefault, I idNode, Node<V> parent) {
            if (tree == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (id2 == null) {
                id2 = idDefault;
            }
            if (Node.cyclic(tree, id2, parent)) {
                LOG.warn("ignore cyclic dependency: " + id2 + " cannot contain " + idNode);
                id2 = idDefault;
            }
            return id2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil$Node";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cyclic";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

