/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.ExcludeFolderImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SourceFolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;

@ApiStatus.Internal
public final class ContentEntryImpl
extends RootModelComponentBase
implements ContentEntry,
ClonableContentEntry,
Comparable<ContentEntryImpl> {
    private static final Logger LOG = Logger.getInstance(ContentEntryImpl.class);
    @NotNull
    private final VirtualFilePointer myRoot;
    @NonNls
    public static final String ELEMENT_NAME = "content";
    private final Set<SourceFolder> mySourceFolders;
    private final Set<ExcludeFolder> myExcludeFolders;
    @NonNls
    public static final String URL_ATTRIBUTE = "url";
    private List<String> myExcludePatterns;

    ContentEntryImpl(@NotNull VirtualFile file2, @NotNull RootModelImpl m) {
        if (file2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(0);
        }
        if (m == null) {
            ContentEntryImpl.$$$reportNull$$$0(1);
        }
        super(m);
        this.mySourceFolders = new LinkedHashSet<SourceFolder>();
        this.myExcludeFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
        this.myRoot = VirtualFilePointerManager.getInstance().create(file2, (Disposable)this, m.getRootsChangedListener());
    }

    ContentEntryImpl(@NotNull String url, @NotNull RootModelImpl m) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(2);
        }
        if (m == null) {
            ContentEntryImpl.$$$reportNull$$$0(3);
        }
        super(m);
        this.mySourceFolders = new LinkedHashSet<SourceFolder>();
        this.myExcludeFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
        this.myRoot = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, m.getRootsChangedListener());
    }

    ContentEntryImpl(@NotNull Element e, @NotNull RootModelImpl m) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(4);
        }
        if (m == null) {
            ContentEntryImpl.$$$reportNull$$$0(5);
        }
        this(ContentEntryImpl.getUrlFrom(e), m);
        this.loadSourceFolders(e);
        this.loadExcludeFolders(e);
        this.loadExcludePatterns(e);
    }

    private void loadExcludePatterns(@NotNull Element e) {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(6);
        }
        for (Element element2 : e.getChildren("excludePattern")) {
            this.addExcludePattern(element2.getAttributeValue("pattern"));
        }
    }

    @NotNull
    private static String getUrlFrom(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(ELEMENT_NAME.equals(e.getName()));
        String url = e.getAttributeValue(URL_ATTRIBUTE);
        if (url == null) {
            throw new InvalidDataException();
        }
        String string = url;
        if (string == null) {
            ContentEntryImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void loadSourceFolders(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(9);
        }
        for (Element child2 : e.getChildren("sourceFolder")) {
            this.addSourceFolder(new SourceFolderImpl(child2, this));
        }
    }

    private void loadExcludeFolders(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(10);
        }
        for (Element child2 : e.getChildren("excludeFolder")) {
            ExcludeFolderImpl excludeFolder = new ExcludeFolderImpl(child2, this);
            this.addExcludeFolder((ExcludeFolder)excludeFolder);
        }
    }

    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @NotNull
    public String getUrl() {
        String string = this.myRoot.getUrl();
        if (string == null) {
            ContentEntryImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public SourceFolder @NotNull [] getSourceFolders() {
        SourceFolder[] sourceFolderArray = this.mySourceFolders.toArray(new SourceFolder[0]);
        if (sourceFolderArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(12);
        }
        return sourceFolderArray;
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            ContentEntryImpl.$$$reportNull$$$0(13);
        }
        List<SourceFolder> list2 = this.getSourceFolders(Collections.singleton(rootType));
        if (list2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ContentEntryImpl.$$$reportNull$$$0(15);
        }
        SmartList folders = new SmartList();
        for (SourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add((Object)folder);
        }
        SmartList smartList = folders;
        if (smartList == null) {
            ContentEntryImpl.$$$reportNull$$$0(16);
        }
        return smartList;
    }

    public VirtualFile @NotNull [] getSourceFolderFiles() {
        assert (!this.isDisposed());
        SourceFolder[] sourceFolders2 = this.getSourceFolders();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(sourceFolders2.length);
        for (SourceFolder sourceFolder : sourceFolders2) {
            VirtualFile file2 = sourceFolder.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(17);
        }
        return virtualFileArray;
    }

    public ExcludeFolder @NotNull [] getExcludeFolders() {
        ExcludeFolder[] excludeFolderArray = this.myExcludeFolders.toArray(new ExcludeFolder[0]);
        if (excludeFolderArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(18);
        }
        return excludeFolderArray;
    }

    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (ExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                excluded.add(pointer.getUrl());
            }
        }
        ArrayList<String> arrayList = excluded;
        if (arrayList == null) {
            ContentEntryImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public VirtualFile @NotNull [] getExcludeFolderFiles() {
        assert (!this.isDisposed());
        ArrayList result2 = new ArrayList();
        for (ExcludeFolder excludeFolder : this.getExcludeFolders()) {
            ContainerUtil.addIfNotNull(result2, (Object)excludeFolder.getFile());
        }
        for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : directoryIndexExcludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                ContainerUtil.addIfNotNull(result2, (Object)pointer.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(20);
        }
        return virtualFileArray;
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource) {
        if (file2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(21);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file2, isTestSource, "");
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(22);
        }
        return sourceFolder;
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource, @NotNull String packagePrefix) {
        if (file2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(23);
        }
        if (packagePrefix == null) {
            ContentEntryImpl.$$$reportNull$$$0(24);
        }
        JavaSourceRootType type = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        SourceFolder sourceFolder = this.addSourceFolder(file2, (JpsModuleSourceRootType)type);
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(25);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (file2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(26);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(27);
        }
        if (properties == null) {
            ContentEntryImpl.$$$reportNull$$$0(28);
        }
        this.assertCanAddFolder(file2);
        return this.addSourceFolder(new SourceFolderImpl(file2, JpsElementFactory.getInstance().createModuleSourceRoot(file2.getUrl(), type, properties), this));
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type) {
        if (file2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(29);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(30);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file2, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(31);
        }
        return sourceFolder;
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(32);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, (JpsModuleSourceRootType)(isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE));
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(33);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(34);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(35);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(36);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(37);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(38);
        }
        if (properties == null) {
            ContentEntryImpl.$$$reportNull$$$0(39);
        }
        this.assertFolderUnderMe(url);
        JpsModuleSourceRoot sourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url, type, properties);
        return this.addSourceFolder(new SourceFolderImpl(sourceRoot, this));
    }

    @NotNull
    private SourceFolder addSourceFolder(@NotNull SourceFolderImpl f) {
        if (f == null) {
            ContentEntryImpl.$$$reportNull$$$0(40);
        }
        this.mySourceFolders.add(f);
        Disposer.register((Disposable)this, (Disposable)f);
        SourceFolderImpl sourceFolderImpl = f;
        if (sourceFolderImpl == null) {
            ContentEntryImpl.$$$reportNull$$$0(41);
        }
        return sourceFolderImpl;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(42);
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(sourceFolder, this.mySourceFolders);
        this.doRemove(sourceFolder);
    }

    private void doRemove(SourceFolder sourceFolder) {
        this.mySourceFolders.remove(sourceFolder);
        Disposer.dispose((Disposable)((Disposable)sourceFolder));
    }

    public void clearSourceFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (SourceFolder folder : this.mySourceFolders) {
            Disposer.dispose((Disposable)((Disposable)folder));
        }
        this.mySourceFolders.clear();
    }

    @NotNull
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(43);
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(file2);
        return this.addExcludeFolder((ExcludeFolder)new ExcludeFolderImpl(file2, this));
    }

    @NotNull
    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(44);
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(url);
        return this.addExcludeFolder((ExcludeFolder)new ExcludeFolderImpl(url, this));
    }

    private void assertCanAddFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(45);
        }
        this.assertCanAddFolder(file2.getUrl());
    }

    private void assertCanAddFolder(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(46);
        }
        this.getRootModel().assertWritable();
        this.assertFolderUnderMe(url);
    }

    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(47);
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(excludeFolder, this.myExcludeFolders);
        this.myExcludeFolders.remove(excludeFolder);
        Disposer.dispose((Disposable)((Disposable)excludeFolder));
    }

    public boolean removeExcludeFolder(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(48);
        }
        for (ExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            Disposer.dispose((Disposable)((Disposable)folder));
            return true;
        }
        return false;
    }

    public void clearExcludeFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)((Disposable)excludeFolder));
        }
        this.myExcludeFolders.clear();
    }

    @NotNull
    public List<String> getExcludePatterns() {
        List<String> list2 = this.myExcludePatterns != null ? Collections.unmodifiableList(this.myExcludePatterns) : Collections.emptyList();
        if (list2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(49);
        }
        return list2;
    }

    public void addExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            ContentEntryImpl.$$$reportNull$$$0(50);
        }
        if (this.myExcludePatterns == null) {
            this.myExcludePatterns = new SmartList();
        }
        this.myExcludePatterns.add(pattern);
    }

    public void removeExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            ContentEntryImpl.$$$reportNull$$$0(51);
        }
        if (this.myExcludePatterns != null) {
            this.myExcludePatterns.remove(pattern);
            if (this.myExcludePatterns.isEmpty()) {
                this.myExcludePatterns = null;
            }
        }
    }

    public void setExcludePatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            ContentEntryImpl.$$$reportNull$$$0(52);
        }
        if (patterns.isEmpty()) {
            this.myExcludePatterns = null;
        } else {
            if (this.myExcludePatterns == null) {
                this.myExcludePatterns = new SmartList();
            } else {
                this.myExcludePatterns.clear();
            }
            this.myExcludePatterns.addAll(patterns);
        }
    }

    @NotNull
    private ExcludeFolder addExcludeFolder(@NotNull ExcludeFolder f) {
        if (f == null) {
            ContentEntryImpl.$$$reportNull$$$0(53);
        }
        Disposer.register((Disposable)this, (Disposable)((Disposable)f));
        this.myExcludeFolders.add(f);
        ExcludeFolder excludeFolder = f;
        if (excludeFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(54);
        }
        return excludeFolder;
    }

    private <T extends ContentFolder> void assertCanRemoveFrom(T f, @NotNull Set<T> ff) {
        if (ff == null) {
            ContentEntryImpl.$$$reportNull$$$0(55);
        }
        this.getRootModel().assertWritable();
        LOG.assertTrue(ff.contains(f));
    }

    private void assertFolderUnderMe(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(56);
        }
        String path2 = VfsUtilCore.urlToPath((String)url);
        String rootPath = VfsUtilCore.urlToPath((String)this.getUrl());
        if (!FileUtil.isAncestor((String)rootPath, (String)path2, (boolean)false)) {
            LOG.error("The file '" + path2 + "' is not under content entry root '" + rootPath + "'");
        }
    }

    public boolean isSynthetic() {
        return false;
    }

    @Override
    @NotNull
    public ContentEntry cloneEntry(@NotNull RootModelImpl rootModel) {
        ContentFolder folder;
        if (rootModel == null) {
            ContentEntryImpl.$$$reportNull$$$0(57);
        }
        assert (!this.isDisposed());
        ContentEntryImpl cloned = new ContentEntryImpl(this.myRoot.getUrl(), rootModel);
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)sourceFolder).cloneFolder(cloned);
            cloned.addSourceFolder((SourceFolderImpl)folder);
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)excludeFolder).cloneFolder(cloned);
            cloned.addExcludeFolder((ExcludeFolder)folder);
        }
        for (String pattern : this.getExcludePatterns()) {
            cloned.addExcludePattern(pattern);
        }
        ContentEntryImpl contentEntryImpl = cloned;
        if (contentEntryImpl == null) {
            ContentEntryImpl.$$$reportNull$$$0(58);
        }
        return contentEntryImpl;
    }

    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        if (element2 == null) {
            ContentEntryImpl.$$$reportNull$$$0(59);
        }
        assert (!this.isDisposed());
        LOG.assertTrue(ELEMENT_NAME.equals(element2.getName()));
        element2.setAttribute(URL_ATTRIBUTE, this.myRoot.getUrl());
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof SourceFolderImpl)) continue;
            JpsModuleRootModelSerializer.saveSourceRoot((Element)element2, (String)sourceFolder.getUrl(), (JpsTypedModuleSourceRoot)sourceFolder.getJpsElement().asTyped());
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ExcludeFolderImpl)) continue;
            Element subElement = new Element("excludeFolder");
            ((ExcludeFolderImpl)excludeFolder).writeExternal(subElement);
            element2.addContent(subElement);
        }
        for (String pattern : this.getExcludePatterns()) {
            element2.addContent(new Element("excludePattern").setAttribute("pattern", pattern));
        }
    }

    @Override
    public int compareTo(@NotNull ContentEntryImpl other) {
        int i2;
        if (other == null) {
            ContentEntryImpl.$$$reportNull$$$0(60);
        }
        if ((i2 = this.getUrl().compareTo(other.getUrl())) != 0) {
            return i2;
        }
        i2 = ArrayUtil.lexicographicCompare((Object[])this.getSourceFolders(), (Object[])other.getSourceFolders());
        if (i2 != 0) {
            return i2;
        }
        i2 = ArrayUtil.lexicographicCompare((Object[])this.getExcludeFolders(), (Object[])other.getExcludeFolders());
        if (i2 != 0) {
            return i2;
        }
        return ContainerUtil.compareLexicographically(this.getExcludePatterns(), other.getExcludePatterns());
    }

    public String toString() {
        return "ContentEntryImpl for '" + this.getUrl() + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 49: 
            case 54: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 49: 
            case 54: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 2: 
            case 32: 
            case 34: 
            case 37: 
            case 44: 
            case 46: 
            case 48: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTRIBUTE;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 49: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ContentEntryImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeFolder";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ff";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ContentEntryImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlFrom";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolders";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderUrls";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderFiles";
                break;
            }
            case 22: 
            case 25: 
            case 31: 
            case 33: 
            case 36: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceFolder";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludePatterns";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "addExcludeFolder";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadExcludePatterns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUrlFrom";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 49: 
            case 54: 
            case 58: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceFolders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadExcludeFolders";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolders";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFolder";
                break;
            }
            case 43: 
            case 44: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeFolder";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "assertCanAddFolder";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludeFolder";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addExcludePattern";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludePattern";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setExcludePatterns";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertCanRemoveFrom";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "assertFolderUnderMe";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 49: 
            case 54: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ContentFolderComparator
    implements Comparator<ContentFolder> {
        public static final ContentFolderComparator INSTANCE = new ContentFolderComparator();

        private ContentFolderComparator() {
        }

        @Override
        public int compare(@NotNull ContentFolder o1, @NotNull ContentFolder o2) {
            if (o1 == null) {
                ContentFolderComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                ContentFolderComparator.$$$reportNull$$$0(1);
            }
            return o1.getUrl().compareTo(o2.getUrl());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/impl/ContentEntryImpl$ContentFolderComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

