/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModulesOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectOrderEnumerator;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="ProjectRootManager")
public class ProjectRootManagerImpl
extends ProjectRootManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerImpl.class);
    private static final ProjectExtensionPointName<ProjectExtension> EP_NAME = new ProjectExtensionPointName("com.intellij.projectExtension");
    private static final String PROJECT_JDK_NAME_ATTR = "project-jdk-name";
    private static final String PROJECT_JDK_TYPE_ATTR = "project-jdk-type";
    private static final String ATTRIBUTE_VERSION = "version";
    protected final Project myProject;
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> myProjectJdkEventDispatcher;
    private String myProjectSdkName;
    private String myProjectSdkType;
    private final OrderRootsCache myRootsCache;
    protected boolean myStartupActivityPerformed;
    private boolean myStateLoaded;
    private final RootProvider.RootSetChangedListener myRootProviderChangeListener;
    protected final BatchSession<RootsChangeType> myRootsChanged;
    protected final BatchSession<Boolean> myFileTypesChanged;
    private final VirtualFilePointerListener myEmptyRootsValidityChangedListener;
    protected boolean isFiringEvent;
    private final Object myLibraryTableListenersLock;
    private final Map<LibraryTable, LibraryTableMultiListener> myLibraryTableMultiListeners;
    private final JdkTableMultiListener myJdkTableMultiListener;
    private final Map<RootProvider, Set<OrderEntry>> myRegisteredRootProviders;

    @ApiStatus.Internal
    public BatchSession<RootsChangeType> getRootsChanged() {
        return this.myRootsChanged;
    }

    public static ProjectRootManagerImpl getInstanceImpl(Project project) {
        return (ProjectRootManagerImpl)ProjectRootManagerImpl.getInstance((Project)project);
    }

    public ProjectRootManagerImpl(@NotNull Project project) {
        if (project == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProjectJdkEventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
        this.myRootProviderChangeListener = new RootProviderChangeListener();
        this.myRootsChanged = new BatchSession<RootsChangeType>(false){

            @Override
            protected boolean fireRootsChanged(@NotNull RootsChangeType cause) {
                if (cause == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectRootManagerImpl.this.fireRootsChanged(false, cause);
            }

            @Override
            @NotNull
            protected RootsChangeType accumulate(@NotNull RootsChangeType current2, @NotNull RootsChangeType cause) {
                if (current2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (cause == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (current2 == RootsChangeType.GENERIC || cause == RootsChangeType.GENERIC) {
                    RootsChangeType rootsChangeType = RootsChangeType.GENERIC;
                    if (rootsChangeType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return rootsChangeType;
                }
                if (current2 != cause) {
                    RootsChangeType rootsChangeType = RootsChangeType.GENERIC;
                    if (rootsChangeType == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return rootsChangeType;
                }
                RootsChangeType rootsChangeType = current2;
                if (rootsChangeType == null) {
                    1.$$$reportNull$$$0(5);
                }
                return rootsChangeType;
            }

            @Override
            @NotNull
            protected RootsChangeType getGenericChange() {
                RootsChangeType rootsChangeType = RootsChangeType.GENERIC;
                if (rootsChangeType == null) {
                    1.$$$reportNull$$$0(6);
                }
                return rootsChangeType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cause";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "current";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$1";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "accumulate";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGenericChange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fireRootsChanged";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "accumulate";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myFileTypesChanged = new BatchSession<Boolean>(true){

            @Override
            protected boolean fireRootsChanged(@NotNull Boolean aBoolean) {
                if (aBoolean == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ProjectRootManagerImpl.this.fireRootsChanged(true, null);
            }

            @Override
            @NotNull
            protected Boolean accumulate(@NotNull Boolean current2, @NotNull Boolean change) {
                if (current2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (change == null) {
                    2.$$$reportNull$$$0(2);
                }
                Boolean bl = current2 != false || change != false;
                if (bl == null) {
                    2.$$$reportNull$$$0(3);
                }
                return bl;
            }

            @Override
            @NotNull
            protected Boolean getGenericChange() {
                Boolean bl = Boolean.TRUE;
                if (bl == null) {
                    2.$$$reportNull$$$0(4);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aBoolean";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "current";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "accumulate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGenericChange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fireRootsChanged";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "accumulate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myEmptyRootsValidityChangedListener = new VirtualFilePointerListener(){};
        this.myLibraryTableListenersLock = new Object();
        this.myLibraryTableMultiListeners = new HashMap<LibraryTable, LibraryTableMultiListener>();
        this.myRegisteredRootProviders = new IdentityHashMap<RootProvider, Set<OrderEntry>>();
        this.myProject = project;
        this.myRootsCache = this.getOrderRootsCache(project);
        this.myJdkTableMultiListener = new JdkTableMultiListener(project);
    }

    @NotNull
    public ProjectFileIndex getFileIndex() {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        if (projectFileIndex == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(1);
        }
        return projectFileIndex;
    }

    @NotNull
    public List<String> getContentRootUrls() {
        Module[] modules2 = this.getModuleManager().getModules();
        ArrayList<String> result2 = new ArrayList<String>(modules2.length);
        for (Module module : modules2) {
            ContainerUtil.addAll(result2, (Object[])ModuleRootManager.getInstance((Module)module).getContentRootUrls());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public VirtualFile @NotNull [] getContentRoots() {
        Module[] modules2 = this.getModuleManager().getModules();
        ArrayList result2 = new ArrayList(modules2.length);
        for (Module module : modules2) {
            Object[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (modules2.length == 1) {
                if (contentRoots == null) {
                    ProjectRootManagerImpl.$$$reportNull$$$0(3);
                }
                return contentRoots;
            }
            ContainerUtil.addAll(result2, (Object[])contentRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getContentSourceRoots() {
        Module[] modules2 = this.getModuleManager().getModules();
        ArrayList result2 = new ArrayList(modules2.length);
        for (Module module : modules2) {
            ContainerUtil.addAll(result2, (Object[])ModuleRootManager.getInstance((Module)module).getSourceRoots());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    @NotNull
    public List<VirtualFile> getModuleSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(6);
        }
        Module[] modules2 = this.getModuleManager().getModules();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(modules2.length);
        for (Module module : modules2) {
            roots.addAll(ModuleRootManager.getInstance((Module)module).getSourceRoots(rootTypes));
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ProjectOrderEnumerator(this.myProject, this.myRootsCache);
    }

    @NotNull
    public OrderEnumerator orderEntries(@NotNull Collection<? extends Module> modules2) {
        if (modules2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(8);
        }
        return new ModulesOrderEnumerator(modules2);
    }

    public VirtualFile @NotNull [] getContentRootsFromAllModules() {
        Module[] modules2 = this.getModuleManager().getSortedModules();
        ArrayList result2 = new ArrayList(modules2.length + 1);
        for (Module module : modules2) {
            Collections.addAll(result2, ModuleRootManager.getInstance((Module)module).getContentRoots());
        }
        ContainerUtil.addIfNotNull(result2, (Object)this.myProject.getBaseDir());
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(9);
        }
        return virtualFileArray;
    }

    public Sdk getProjectSdk() {
        if (this.myProjectSdkName == null) {
            return null;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        if (this.myProjectSdkType == null) {
            return projectJdkTable.findJdk(this.myProjectSdkName);
        }
        return projectJdkTable.findJdk(this.myProjectSdkName, this.myProjectSdkType);
    }

    @Nullable
    public String getProjectSdkName() {
        return this.myProjectSdkName;
    }

    @Nullable
    public String getProjectSdkTypeName() {
        return this.myProjectSdkType;
    }

    public void setProjectSdk(@Nullable Sdk sdk2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (sdk2 == null) {
            this.myProjectSdkName = null;
            this.myProjectSdkType = null;
        } else {
            this.myProjectSdkName = sdk2.getName();
            this.myProjectSdkType = sdk2.getSdkType().getName();
        }
        this.projectJdkChanged();
    }

    protected void projectJdkChanged() {
        this.incModificationCount();
        this.mergeRootsChangesDuring(this.getActionToRunWhenProjectJdkChanges());
        Sdk sdk2 = this.getProjectSdk();
        for (ProjectExtension extension2 : EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            extension2.projectSdkChanged(sdk2);
        }
    }

    @NotNull
    protected Runnable getActionToRunWhenProjectJdkChanges() {
        Runnable runnable2 = () -> ((ProjectRootManagerEx.ProjectJdkListener)this.myProjectJdkEventDispatcher.getMulticaster()).projectJdkChanged();
        if (runnable2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(10);
        }
        return runnable2;
    }

    public void setProjectSdkName(@NotNull String name, @NotNull String sdkTypeName) {
        if (name == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(11);
        }
        if (sdkTypeName == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myProjectSdkName = name;
        this.myProjectSdkType = sdkTypeName;
        this.projectJdkChanged();
    }

    public void addProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener2) {
        if (listener2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(13);
        }
        this.myProjectJdkEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener2) {
        if (listener2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(14);
        }
        this.myProjectJdkEventDispatcher.removeListener((EventListener)listener2);
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(15);
        }
        for (ProjectExtension extension2 : EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            extension2.readExternal(element2);
        }
        this.myProjectSdkName = element2.getAttributeValue(PROJECT_JDK_NAME_ATTR);
        this.myProjectSdkType = element2.getAttributeValue(PROJECT_JDK_TYPE_ATTR);
        if (this.myStateLoaded) {
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                app.invokeLater(() -> app.runWriteAction(() -> this.projectJdkChanged()), app.getNoneModalityState());
            }
        } else {
            this.myStateLoaded = true;
        }
    }

    public void noStateLoaded() {
        this.myStateLoaded = true;
    }

    public Element getState() {
        Element element2 = new Element("state");
        element2.setAttribute(ATTRIBUTE_VERSION, "2");
        for (ProjectExtension extension2 : EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            extension2.writeExternal(element2);
        }
        if (this.myProjectSdkName != null) {
            element2.setAttribute(PROJECT_JDK_NAME_ATTR, this.myProjectSdkName);
        }
        if (this.myProjectSdkType != null) {
            element2.setAttribute(PROJECT_JDK_TYPE_ATTR, this.myProjectSdkType);
        }
        if (element2.getAttributes().size() == 1) {
            element2.removeAttribute(ATTRIBUTE_VERSION);
        }
        return element2;
    }

    public void mergeRootsChangesDuring(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        BatchSession<RootsChangeType> batchSession = this.myRootsChanged;
        batchSession.levelUp();
        try {
            runnable2.run();
        }
        finally {
            batchSession.levelDown();
        }
    }

    protected void clearScopesCaches() {
        this.clearScopesCachesForModules();
    }

    public void clearScopesCachesForModules() {
        Module[] modules2;
        this.myRootsCache.clearCache();
        for (Module module : modules2 = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootManagerEx.getInstanceEx(module).dropCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeRootsChange(@NotNull Runnable runnable2, boolean fileTypes, boolean fireEvents) {
        if (runnable2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(17);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        BatchSession<Object> session2 = fileTypes ? this.myFileTypesChanged : this.myRootsChanged;
        try {
            if (fireEvents) {
                session2.beforeRootsChanged();
            }
            runnable2.run();
        }
        finally {
            if (fireEvents) {
                session2.rootsChanged();
            }
        }
    }

    private void fireBeforeRootsChanged(boolean fileTypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        this.fireBeforeRootsChangeEvent(fileTypes);
    }

    @ApiStatus.Internal
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
    }

    private boolean fireRootsChanged(boolean fileTypes, @Nullable RootsChangeType cause) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        this.clearScopesCaches();
        this.incModificationCount();
        this.fireRootsChangedEvent(fileTypes, cause);
        return true;
    }

    @ApiStatus.Internal
    protected void fireRootsChangedEvent(boolean fileTypes, @Nullable RootsChangeType cause) {
    }

    @ApiStatus.Internal
    protected OrderRootsCache getOrderRootsCache(@NotNull Project project) {
        if (project == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(18);
        }
        return new OrderRootsCache((Disposable)project);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(19);
        }
        return project;
    }

    @NotNull
    public static String extractLocalPath(@NotNull String url) {
        String path2;
        int separatorIndex;
        if (url == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(20);
        }
        String string = (separatorIndex = (path2 = VfsUtilCore.urlToPath((String)url)).indexOf("!/")) > 0 ? path2.substring(0, separatorIndex) : path2;
        if (string == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private ModuleManager getModuleManager() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        if (moduleManager == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(22);
        }
        return moduleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribeToRootProvider(@NotNull OrderEntry owner, @NotNull RootProvider provider2) {
        if (owner == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(23);
        }
        if (provider2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(24);
        }
        Map<RootProvider, Set<OrderEntry>> map2 = this.myRegisteredRootProviders;
        synchronized (map2) {
            Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider2);
            if (owners == null) {
                owners = new HashSet<OrderEntry>();
                this.myRegisteredRootProviders.put(provider2, owners);
                provider2.addRootSetChangedListener(this.myRootProviderChangeListener);
            }
            owners.add(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribeFromRootProvider(@NotNull OrderEntry owner, @NotNull RootProvider provider2) {
        if (owner == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(25);
        }
        if (provider2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(26);
        }
        Map<RootProvider, Set<OrderEntry>> map2 = this.myRegisteredRootProviders;
        synchronized (map2) {
            Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider2);
            if (owners != null) {
                owners.remove(owner);
                if (owners.isEmpty()) {
                    provider2.removeRootSetChangedListener(this.myRootProviderChangeListener);
                    this.myRegisteredRootProviders.remove(provider2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerForTable(@NotNull LibraryTable.Listener libraryListener, @NotNull LibraryTable libraryTable) {
        if (libraryListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(27);
        }
        if (libraryTable == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(28);
        }
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener == null) {
                multiListener = new LibraryTableMultiListener();
                libraryTable.addListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.put(libraryTable, multiListener);
            }
            multiListener.addListener(libraryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListenerForTable(@NotNull LibraryTable.Listener libraryListener, @NotNull LibraryTable libraryTable) {
        if (libraryListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(29);
        }
        if (libraryTable == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(30);
        }
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            boolean last;
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener != null && (last = multiListener.removeListener(libraryListener))) {
                libraryTable.removeListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.remove(libraryTable);
            }
        }
    }

    void addJdkTableListener(@NotNull ProjectJdkTable.Listener jdkTableListener, @NotNull Disposable parent) {
        if (jdkTableListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(31);
        }
        if (parent == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(32);
        }
        this.myJdkTableMultiListener.addListener(jdkTableListener);
        Disposer.register((Disposable)parent, () -> this.myJdkTableMultiListener.removeListener(jdkTableListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertListenersAreDisposed() {
        Map<RootProvider, Set<OrderEntry>> map2 = this.myRegisteredRootProviders;
        synchronized (map2) {
            if (!this.myRegisteredRootProviders.isEmpty()) {
                StringBuilder details = new StringBuilder();
                int count = 0;
                for (Map.Entry<RootProvider, Set<OrderEntry>> entry2 : this.myRegisteredRootProviders.entrySet()) {
                    if (count++ >= 10) {
                        details.append(this.myRegisteredRootProviders.entrySet().size() - 10).append(" more providers.\n");
                        break;
                    }
                    details.append(" ").append(entry2.getKey()).append(" referenced by ").append(entry2.getValue().size()).append(" order entries:\n");
                    for (OrderEntry orderEntry : entry2.getValue()) {
                        details.append("   ").append(orderEntry);
                        if (orderEntry instanceof RootModelComponentBase) {
                            details.append(", isDisposed = ").append(((RootModelComponentBase)orderEntry).isDisposed());
                            details.append(", root model = ").append(((RootModelComponentBase)orderEntry).getRootModel());
                            details.append(", module.isDisposed = ").append(((RootModelComponentBase)orderEntry).getRootModel().getModule().isDisposed());
                        }
                        details.append("\n");
                    }
                }
                LOG.error("Listeners for " + this.myRegisteredRootProviders.size() + " root providers in " + this.myProject + " aren't disposed:" + details);
                for (RootProvider provider2 : this.myRegisteredRootProviders.keySet()) {
                    provider2.removeRootSetChangedListener(this.myRootProviderChangeListener);
                }
            }
        }
    }

    public void markRootsForRefresh() {
    }

    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myEmptyRootsValidityChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(33);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 21: 
            case 22: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 21: 
            case 22: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 21: 
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeName";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryListener";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkTableListener";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSourceRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSourceRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootsFromAllModules";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionToRunWhenProjectJdkChanges";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleManager";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsValidityChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 21: 
            case 22: 
            case 33: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSourceRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orderEntries";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProjectSdkName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addProjectJdkListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectJdkListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeRootsChangesDuring";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeRootsChange";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrderRootsCache";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToRootProvider";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unsubscribeFromRootProvider";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addListenerForTable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeListenerForTable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addJdkTableListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 21: 
            case 22: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RootProviderChangeListener
    implements RootProvider.RootSetChangedListener {
        private boolean myInsideRootsChange;

        private RootProviderChangeListener() {
        }

        public void rootSetChanged(@NotNull RootProvider wrapper2) {
            if (wrapper2 == null) {
                RootProviderChangeListener.$$$reportNull$$$0(0);
            }
            if (this.myInsideRootsChange) {
                return;
            }
            this.myInsideRootsChange = true;
            try {
                ProjectRootManagerImpl.this.makeRootsChange(EmptyRunnable.INSTANCE, false, true);
            }
            finally {
                this.myInsideRootsChange = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$RootProviderChangeListener", "rootSetChanged"));
        }
    }

    private final class JdkTableMultiListener
    extends ListenerContainer<ProjectJdkTable.Listener>
    implements ProjectJdkTable.Listener {
        private JdkTableMultiListener(Project project) {
            if (project == null) {
                JdkTableMultiListener.$$$reportNull$$$0(0);
            }
            super(new ProjectJdkTable.Listener[0]);
            project.getMessageBus().connect().subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)this);
        }

        public void jdkAdded(@NotNull Sdk jdk) {
            if (jdk == null) {
                JdkTableMultiListener.$$$reportNull$$$0(1);
            }
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (ProjectJdkTable.Listener listener2 : (ProjectJdkTable.Listener[])this.getListeners()) {
                    listener2.jdkAdded(jdk);
                }
            });
        }

        public void jdkRemoved(@NotNull Sdk jdk) {
            if (jdk == null) {
                JdkTableMultiListener.$$$reportNull$$$0(2);
            }
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (ProjectJdkTable.Listener listener2 : (ProjectJdkTable.Listener[])this.getListeners()) {
                    listener2.jdkRemoved(jdk);
                }
            });
        }

        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            if (jdk == null) {
                JdkTableMultiListener.$$$reportNull$$$0(3);
            }
            if (previousName == null) {
                JdkTableMultiListener.$$$reportNull$$$0(4);
            }
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (ProjectJdkTable.Listener listener2 : (ProjectJdkTable.Listener[])this.getListeners()) {
                    listener2.jdkNameChanged(jdk, previousName);
                }
            });
            String currentName = ProjectRootManagerImpl.this.getProjectSdkName();
            if (previousName.equals(currentName)) {
                ProjectRootManagerImpl.this.myProjectSdkName = jdk.getName();
                ProjectRootManagerImpl.this.myProjectSdkType = jdk.getSdkType().getName();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdk";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$JdkTableMultiListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkRemoved";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkNameChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class LibraryTableMultiListener
    extends ListenerContainer<LibraryTable.Listener>
    implements LibraryTable.Listener {
        private LibraryTableMultiListener() {
            super(new LibraryTable.Listener[0]);
        }

        public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(0);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.afterLibraryAdded(newLibrary);
                }
            });
        }

        public void afterLibraryRenamed(@NotNull Library library2, @Nullable String oldName) {
            if (library2 == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(1);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.afterLibraryRenamed(library2, oldName);
                }
            });
        }

        public void beforeLibraryRemoved(@NotNull Library library2) {
            if (library2 == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(2);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.beforeLibraryRemoved(library2);
                }
            });
        }

        public void afterLibraryRemoved(@NotNull Library library2) {
            if (library2 == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(3);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.afterLibraryRemoved(library2);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$LibraryTableMultiListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeLibraryRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ListenerContainer<T> {
        private final Set<T> myListeners;
        private final T @NotNull [] myEmptyArray;
        private T[] myListenersArray;

        private ListenerContainer(T @NotNull [] emptyArray) {
            if (emptyArray == null) {
                ListenerContainer.$$$reportNull$$$0(0);
            }
            this.myListeners = new LinkedHashSet<T>();
            this.myEmptyArray = emptyArray;
        }

        synchronized void addListener(@NotNull T listener2) {
            if (listener2 == null) {
                ListenerContainer.$$$reportNull$$$0(1);
            }
            this.myListeners.add(listener2);
            this.myListenersArray = null;
        }

        synchronized boolean removeListener(@NotNull T listener2) {
            if (listener2 == null) {
                ListenerContainer.$$$reportNull$$$0(2);
            }
            this.myListeners.remove(listener2);
            this.myListenersArray = null;
            return this.myListeners.isEmpty();
        }

        synchronized T @NotNull [] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(this.myEmptyArray);
            }
            if (this.myListenersArray == null) {
                ListenerContainer.$$$reportNull$$$0(3);
            }
            return this.myListenersArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyArray";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$ListenerContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$ListenerContainer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListeners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeListener";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static enum RootsChangeType {
        ROOTS_REMOVED,
        ROOTS_ADDED,
        GENERIC;

    }

    @ApiStatus.Internal
    public abstract class BatchSession<Change> {
        private final boolean myFileTypes;
        private int myBatchLevel;
        private int myPendingRootsChanged;
        private boolean myChanged;
        private Change myChanges;

        private BatchSession(boolean fileTypes) {
            this.myFileTypes = fileTypes;
        }

        void levelUp() {
            if (this.myBatchLevel == 0) {
                this.myChanged = false;
                this.myChanges = null;
            }
            ++this.myBatchLevel;
        }

        void levelDown() {
            --this.myBatchLevel;
            if (this.myChanged && this.myBatchLevel == 0) {
                try {
                    if (this.myChanges == null) {
                        this.myChanges = this.getGenericChange();
                    }
                    --this.myPendingRootsChanged;
                    WriteAction.run(() -> this.fireRootsChanged(this.myChanges));
                }
                finally {
                    if (this.myPendingRootsChanged == 0) {
                        this.myChanged = false;
                        this.myChanges = null;
                    }
                }
            }
        }

        public void beforeRootsChanged() {
            if (this.myBatchLevel == 0 || !this.myChanged) {
                ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.myFileTypes);
                ++this.myPendingRootsChanged;
                this.myChanged = true;
            }
        }

        public void rootsChanged(@NotNull Change change) {
            if (change == null) {
                BatchSession.$$$reportNull$$$0(0);
            }
            Change Change2 = this.myChanges = this.myChanges == null ? change : this.accumulate(this.myChanges, change);
            if (this.myBatchLevel == 0 && this.myChanged) {
                --this.myPendingRootsChanged;
                if (this.fireRootsChanged(this.myChanges) && this.myPendingRootsChanged == 0) {
                    this.myChanged = false;
                    this.myChanges = null;
                }
            }
        }

        public void rootsChanged() {
            this.rootsChanged(this.getGenericChange());
        }

        protected abstract boolean fireRootsChanged(@NotNull Change var1);

        @NotNull
        protected abstract Change accumulate(@NotNull Change var1, @NotNull Change var2);

        @NotNull
        protected abstract Change getGenericChange();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$BatchSession", "rootsChanged"));
        }
    }
}

