/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextAware;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public final class ShadowPainter
extends ScaleContextSupport {
    private final Icon myTop;
    private final Icon myTopRight;
    private final Icon myRight;
    private final Icon myBottomRight;
    private final Icon myBottom;
    private final Icon myBottomLeft;
    private final Icon myLeft;
    private final Icon myTopLeft;
    private Icon myCroppedTop = null;
    private Icon myCroppedRight = null;
    private Icon myCroppedBottom = null;
    private Icon myCroppedLeft = null;
    @Nullable
    private Color myBorderColor;

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft) {
        this.myTop = top;
        this.myTopRight = topRight;
        this.myRight = right;
        this.myBottomRight = bottomRight;
        this.myBottom = bottom;
        this.myBottomLeft = bottomLeft;
        this.myLeft = left;
        this.myTopLeft = topLeft;
        this.updateIcons(null);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(LafManagerListener.TOPIC, source -> this.updateIcons(null));
    }

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft, @Nullable Color borderColor) {
        this(top, topRight, right, bottomRight, bottom, bottomLeft, left, topLeft);
        this.myBorderColor = borderColor;
    }

    public void setBorderColor(@Nullable Color borderColor) {
        this.myBorderColor = borderColor;
    }

    public BufferedImage createShadow(JComponent c, int width, int height) {
        BufferedImage image = c.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
        Graphics2D g = image.createGraphics();
        this.paintShadow(c, g, 0, 0, width, height);
        g.dispose();
        return image;
    }

    private void updateIcons(ScaleContext ctx) {
        ShadowPainter.updateIcon(this.myTop, ctx, () -> {
            this.myCroppedTop = IconUtil.cropIcon(this.myTop, 1, Integer.MAX_VALUE);
        });
        ShadowPainter.updateIcon(this.myTopRight, ctx, null);
        ShadowPainter.updateIcon(this.myRight, ctx, () -> {
            this.myCroppedRight = IconUtil.cropIcon(this.myRight, Integer.MAX_VALUE, 1);
        });
        ShadowPainter.updateIcon(this.myBottomRight, ctx, null);
        ShadowPainter.updateIcon(this.myBottom, ctx, () -> {
            this.myCroppedBottom = IconUtil.cropIcon(this.myBottom, 1, Integer.MAX_VALUE);
        });
        ShadowPainter.updateIcon(this.myBottomLeft, ctx, null);
        ShadowPainter.updateIcon(this.myLeft, ctx, () -> {
            this.myCroppedLeft = IconUtil.cropIcon(this.myLeft, Integer.MAX_VALUE, 1);
        });
        ShadowPainter.updateIcon(this.myTopLeft, ctx, null);
    }

    private static void updateIcon(Icon icon2, ScaleContext ctx, Runnable r) {
        if (icon2 instanceof ScaleContextAware) {
            ((ScaleContextAware)icon2).updateScaleContext((UserScaleContext)ctx);
        }
        if (r != null) {
            r.run();
        }
    }

    public void paintShadow(Component c, Graphics2D g, int x, int y, int width, int height) {
        ScaleContext ctx = ScaleContext.create((Graphics2D)g);
        if (this.updateScaleContext((UserScaleContext)ctx)) {
            this.updateIcons(ctx);
        }
        int leftSize = this.myCroppedLeft.getIconWidth();
        int rightSize = this.myCroppedRight.getIconWidth();
        int bottomSize = this.myCroppedBottom.getIconHeight();
        int topSize = this.myCroppedTop.getIconHeight();
        int delta = this.myTopLeft.getIconHeight() + this.myBottomLeft.getIconHeight() - height;
        if (delta > 0) {
            Shape clip = g.getClip();
            int topHeight = this.myTopLeft.getIconHeight() - delta / 2;
            Area top = new Area(new Rectangle2D.Float(x, y, width, topHeight));
            if (clip != null) {
                top.intersect(new Area(clip));
            }
            g.setClip(top);
            this.myTopLeft.paintIcon(c, g, x, y);
            this.myTopRight.paintIcon(c, g, x + width - this.myTopRight.getIconWidth(), y);
            int bottomHeight = this.myBottomLeft.getIconHeight() - delta + delta / 2;
            Area bottom = new Area(new Rectangle2D.Float(x, y + topHeight, width, bottomHeight));
            if (clip != null) {
                bottom.intersect(new Area(clip));
            }
            g.setClip(bottom);
            this.myBottomLeft.paintIcon(c, g, x, y + height - this.myBottomLeft.getIconHeight());
            this.myBottomRight.paintIcon(c, g, x + width - this.myBottomRight.getIconWidth(), y + height - this.myBottomRight.getIconHeight());
            g.setClip(clip);
        } else {
            this.myTopLeft.paintIcon(c, g, x, y);
            this.myTopRight.paintIcon(c, g, x + width - this.myTopRight.getIconWidth(), y);
            this.myBottomLeft.paintIcon(c, g, x, y + height - this.myBottomLeft.getIconHeight());
            this.myBottomRight.paintIcon(c, g, x + width - this.myBottomRight.getIconWidth(), y + height - this.myBottomRight.getIconHeight());
        }
        ShadowPainter.fill(g, this.myCroppedTop, x, y, this.myTopLeft.getIconWidth(), width - this.myTopRight.getIconWidth(), true);
        ShadowPainter.fill(g, this.myCroppedBottom, x, y + height - bottomSize, this.myBottomLeft.getIconWidth(), width - this.myBottomRight.getIconWidth(), true);
        ShadowPainter.fill(g, this.myCroppedLeft, x, y, this.myTopLeft.getIconHeight(), height - this.myBottomLeft.getIconHeight(), false);
        ShadowPainter.fill(g, this.myCroppedRight, x + width - rightSize, y, this.myTopRight.getIconHeight(), height - this.myBottomRight.getIconHeight(), false);
        if (this.myBorderColor != null) {
            g.setColor(this.myBorderColor);
            g.drawRect(x + leftSize - 1, y + topSize - 1, width - leftSize - rightSize + 1, height - topSize - bottomSize + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fill(Graphics g, Icon pattern, int x, int y, int from2, int to, boolean horizontally) {
        double scale = JBUIScale.sysScale((Graphics2D)((Graphics2D)g));
        if (JreHiDpiUtil.isJreHiDPIEnabled() && Math.ceil(scale) > scale) {
            BufferedImage img = ImageUtil.toBufferedImage((Image)IconUtil.toImage(pattern));
            int patternSize = horizontally ? img.getWidth() : img.getHeight();
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.scale(1.0 / scale, 1.0 / scale);
                g2d.translate((double)x * scale, (double)y * scale);
                int at = (int)Math.floor((double)from2 * scale);
                while ((double)at < (double)to * scale) {
                    if (horizontally) {
                        g2d.drawImage((Image)img, at, 0, null);
                    } else {
                        g2d.drawImage((Image)img, 0, at, null);
                    }
                    at += patternSize;
                }
            }
            finally {
                g2d.dispose();
            }
        } else {
            for (int at = from2; at < to; ++at) {
                if (horizontally) {
                    pattern.paintIcon(null, g, x + at, y);
                    continue;
                }
                pattern.paintIcon(null, g, x, y + at);
            }
        }
    }
}

