/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateResult;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdateDialog
extends DialogWrapper {
    @NotNull
    private final Collection<PluginDownloader> myDownloaders;
    private final boolean myPlatformUpdate;
    private final MyPluginModel myPluginModel;
    private final PluginsGroupComponent myPluginsPanel;
    private final PluginsGroup myGroup;
    private final PluginDetailsPageComponent myDetailsPage;
    private final JLabel myTotalLabel;
    private final ActionLink myIgnoreAction;
    @Nullable
    private Runnable myFinishCallback;

    public PluginUpdateDialog(@Nullable Project project, @NotNull Collection<PluginDownloader> downloaders, @Nullable Collection<PluginNode> customRepositoryPlugins) {
        if (downloaders == null) {
            PluginUpdateDialog.$$$reportNull$$$0(0);
        }
        this(project, downloaders, customRepositoryPlugins, false);
        this.setTitle(IdeBundle.message((String)"dialog.title.plugin.updates", (Object[])new Object[0]));
    }

    PluginUpdateDialog(@Nullable Project project, @NotNull Collection<PluginDownloader> updatedPlugins) {
        if (updatedPlugins == null) {
            PluginUpdateDialog.$$$reportNull$$$0(1);
        }
        this(project, updatedPlugins, null, true);
        this.setTitle(IdeBundle.message((String)"updates.dialog.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
    }

    private PluginUpdateDialog(@Nullable Project project, @NotNull Collection<PluginDownloader> downloaders, final @Nullable Collection<PluginNode> customRepositoryPlugins, boolean platformUpdate) {
        if (downloaders == null) {
            PluginUpdateDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myGroup = new PluginsGroup("");
        this.myTotalLabel = new JLabel();
        this.myDownloaders = downloaders;
        this.myPlatformUpdate = platformUpdate;
        this.myIgnoreAction = new ActionLink(IdeBundle.message((String)"updates.ignore.updates.button", (Object[])new Object[]{downloaders.size()}), e -> {
            this.close(1);
            UpdateChecker.ignorePlugins(ContainerUtil.map(this.myGroup.ui.plugins, ListPluginComponent::getPluginDescriptor));
        });
        this.myPluginModel = new MyPluginModel(project){

            @Override
            public void runRestartButton(@NotNull Component component2) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginUpdateDialog.this.doOKAction();
            }

            @Override
            @NotNull
            protected Collection<PluginNode> getCustomRepoPlugins() {
                Collection<PluginNode> collection = customRepositoryPlugins != null ? customRepositoryPlugins : super.getCustomRepoPlugins();
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomRepoPlugins";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "runRestartButton";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myPluginModel.setTopController(Configurable.TopComponentController.EMPTY);
        this.myPluginModel.setPluginUpdatesService(new PluginUpdatesService(){

            @Override
            public void finishUpdate() {
            }
        });
        this.myDetailsPage = new PluginDetailsPageComponent(this.myPluginModel, (LinkListener<Object>)LinkListener.NULL, true);
        this.myDetailsPage.setOnlyUpdateMode();
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        this.myPluginsPanel = new PluginsGroupComponent(eventHandler){

            @Override
            @NotNull
            protected ListPluginComponent createListComponent(@NotNull IdeaPluginDescriptor descriptor2) {
                if (descriptor2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                ListPluginComponent component2 = new ListPluginComponent(PluginUpdateDialog.this.myPluginModel, descriptor2, (LinkListener<Object>)LinkListener.NULL, true);
                component2.setOnlyUpdateMode();
                component2.getChooseUpdateButton().addActionListener(e -> PluginUpdateDialog.this.updateButtons());
                ListPluginComponent listPluginComponent = component2;
                if (listPluginComponent == null) {
                    3.$$$reportNull$$$0(1);
                }
                return listPluginComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createListComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createListComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        PluginManagerConfigurable.registerCopyProvider(this.myPluginsPanel);
        this.myPluginsPanel.setSelectionListener(__ -> this.myDetailsPage.showPlugins(this.myPluginsPanel.getSelection()));
        for (PluginDownloader plugin2 : downloaders) {
            this.myGroup.descriptors.add(plugin2.getDescriptor());
        }
        this.myGroup.sortByName();
        this.myPluginsPanel.addGroup(this.myGroup);
        this.setOKButtonText(IdeBundle.message((String)"plugins.configurable.update.button", (Object[])new Object[0]));
        this.updateButtons();
        this.init();
        JRootPane rootPane = this.getPeer().getRootPane();
        if (rootPane != null) {
            rootPane.setPreferredSize((Dimension)new JBDimension(800, 600));
        }
    }

    private void updateButtons() {
        long total = 0L;
        int count = 0;
        for (ListPluginComponent plugin2 : this.myGroup.ui.plugins) {
            if (!plugin2.getChooseUpdateButton().isSelected()) continue;
            ++count;
            IdeaPluginDescriptor descriptor2 = plugin2.getPluginDescriptor();
            if (!(descriptor2 instanceof PluginNode)) continue;
            total += ((PluginNode)descriptor2).getIntegerSize();
        }
        this.myTotalLabel.setText(IdeBundle.message((String)"plugin.update.dialog.total.label", (Object[])new Object[]{StringUtilRt.formatFileSize((long)total).toUpperCase(Locale.ENGLISH)}));
        this.myTotalLabel.setVisible(total > 0L);
        this.getOKAction().setEnabled(count > 0);
    }

    public void setFinishCallback(@NotNull Runnable finishCallback) {
        if (finishCallback == null) {
            PluginUpdateDialog.$$$reportNull$$$0(3);
        }
        this.myFinishCallback = finishCallback;
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.myPlatformUpdate) {
            return;
        }
        ArrayList<PluginDownloader> toDownloads = new ArrayList<PluginDownloader>();
        int index2 = 0;
        for (PluginDownloader downloader : this.myDownloaders) {
            ListPluginComponent component2;
            if (!(component2 = this.myGroup.ui.plugins.get(index2++)).getChooseUpdateButton().isSelected()) continue;
            toDownloads.add(downloader);
        }
        PluginUpdateDialog.runUpdateAll(toDownloads, this.getContentPanel(), this.myFinishCallback);
    }

    public static void runUpdateAll(final @NotNull Collection<PluginDownloader> toDownloads, final @Nullable JComponent ownerComponent, final @Nullable Runnable finishCallback) {
        if (toDownloads == null) {
            PluginUpdateDialog.$$$reportNull$$$0(4);
        }
        String message2 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        new Task.Backgroundable(null, message2, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator2) {
                List<PluginDownloader> downloaders;
                if (indicator2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!(downloaders = PluginUpdateDialog.downloadPluginUpdates(toDownloads, indicator2)).isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PluginUpdateResult result2 = UpdateInstaller.installDownloadedPluginUpdates(downloaders, (Function1<? super PluginDownloader, Boolean>)((Function1)downloader -> !downloader.tryInstallWithoutRestart(ownerComponent)));
                        if (result2.getPluginsInstalled().size() > 0) {
                            if (!result2.getRestartRequired()) {
                                String message2;
                                if (result2.getPluginsInstalled().size() == 1) {
                                    IdeaPluginDescriptor plugin2 = result2.getPluginsInstalled().get(0);
                                    message2 = IdeBundle.message((String)"notification.content.updated.plugin.to.version", (Object[])new Object[]{plugin2.getName(), plugin2.getVersion()});
                                } else {
                                    String names2 = result2.getPluginsInstalled().stream().map(PluginDescriptor::getName).collect(Collectors.joining(", "));
                                    message2 = IdeBundle.message((String)"notification.content.updated.plugins", (Object[])new Object[]{names2});
                                }
                                UpdateChecker.getNotificationGroupForUpdateResults().createNotification(message2, NotificationType.INFORMATION).setDisplayId("plugins.updated.without.restart").notify(this.myProject);
                            } else if (WelcomeFrame.getInstance() == null) {
                                PluginManagerMain.notifyPluginsUpdated(null);
                            } else {
                                PluginManagerConfigurable.shutdownOrRestartApp();
                            }
                        }
                    });
                }
            }

            public void onFinished() {
                if (finishCallback != null) {
                    finishCallback.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$4", "run"));
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<PluginDownloader> downloadPluginUpdates(Collection<PluginDownloader> toDownloads, @NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(5);
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (PluginDownloader pluginDownloader : toDownloads) {
            pluginDownloader.setErrorsCollector(errors);
        }
        List<PluginDownloader> list2 = UpdateInstaller.downloadPluginUpdates(toDownloads, indicator2);
        Object object = list2;
        if (object == null) {
            PluginUpdateDialog.$$$reportNull$$$0(6);
        }
        return object;
        finally {
            for (PluginDownloader download : toDownloads) {
                download.setErrorsCollector(null);
            }
            if (!errors.isEmpty()) {
                String string = StringUtil.join(errors, (String)"\n\n");
                String title3 = IdeBundle.message((String)"title.plugin.installation", (Object[])new Object[0]);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)text2, (String)title2), ModalityState.any());
            }
        }
    }

    public void doCancelAction() {
        this.close(1);
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        Wrapper panel2 = new Wrapper((JComponent)this.myIgnoreAction);
        panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return panel2;
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "plugin.update.dialog";
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            PluginUpdateDialog.$$$reportNull$$$0(7);
        }
        return dialogStyle;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.45f){

            protected Divider createDivider() {
                Divider divider = super.createDivider();
                divider.setBackground(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR);
                return divider;
            }
        };
        this.myGroup.ui.panel.getParent().remove(this.myGroup.ui.panel);
        this.myGroup.ui.panel.setPreferredSize(new Dimension());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add(PluginManagerConfigurable.createScrollPane(this.myPluginsPanel, true));
        OpaquePanel titlePanel = new OpaquePanel((LayoutManager)new BorderLayout(), PluginManagerConfigurable.MAIN_BG_COLOR);
        titlePanel.setBorder((Border)JBUI.Borders.empty((int)13, (int)12));
        leftPanel.add((Component)titlePanel, "South");
        this.myTotalLabel.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
        titlePanel.add((Component)this.myTotalLabel);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent((JComponent)this.myDetailsPage);
        return splitter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedPlugins";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDownloads";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadPluginUpdates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFinishCallback";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runUpdateAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "downloadPluginUpdates";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

