/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.WhatsNewAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.PlatformUpdates;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoPanel;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateInfoDialog
extends AbstractUpdateDialog {
    @Nullable
    private final Project myProject;
    @NotNull
    private final PlatformUpdates.Loaded myLoadedResult;
    @Nullable
    private final Collection<PluginDownloader> myUpdatedPlugins;
    private final boolean myWriteProtected;
    private final @Nullable Pair<@NlsContexts.Label String, Boolean> myLicenseInfo;
    @Nullable
    private final File myTestPatch;
    @Nullable
    private final AbstractAction myWhatsNewAction;

    public UpdateInfoDialog(@Nullable Project project, @NotNull PlatformUpdates.Loaded loadedResult, boolean enableLink, @Nullable Collection<PluginDownloader> updatedPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
        if (loadedResult == null) {
            UpdateInfoDialog.$$$reportNull$$$0(0);
        }
        super(project, enableLink);
        this.myProject = project;
        this.myLoadedResult = loadedResult;
        this.myUpdatedPlugins = updatedPlugins;
        UpdateChain patches2 = this.myLoadedResult.getPatches();
        this.myWriteProtected = patches2 != null && !SystemInfo.isWindows && !Files.isWritable(Paths.get(PathManager.getHomePath(), new String[0]));
        this.myLicenseInfo = UpdateInfoDialog.getLicensingInfo(this.myLoadedResult);
        this.myTestPatch = null;
        this.myWhatsNewAction = null;
        this.init();
        if (!ContainerUtil.isEmpty(incompatiblePlugins)) {
            String names2 = incompatiblePlugins.stream().map(PluginDescriptor::getName).collect(Collectors.joining("<br/>"));
            this.setErrorText(IdeBundle.message((String)"updates.incompatible.plugins.found", (Object[])new Object[]{incompatiblePlugins.size(), names2}));
        }
        IdeUpdateUsageTriggerCollector.triggerUpdateDialog(patches2, ApplicationManager.getApplication().isRestartCapable());
    }

    UpdateInfoDialog(final @Nullable Project project, @NotNull PlatformUpdates.Loaded loadedResult, @Nullable File patchFile) {
        if (loadedResult == null) {
            UpdateInfoDialog.$$$reportNull$$$0(1);
        }
        super(true);
        this.myProject = project;
        this.myLoadedResult = loadedResult;
        this.myUpdatedPlugins = null;
        this.myWriteProtected = false;
        this.myLicenseInfo = UpdateInfoDialog.getLicensingInfo(this.myLoadedResult);
        this.myTestPatch = patchFile;
        this.myWhatsNewAction = project == null ? null : new AbstractAction("[T] What's New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildInfo newBuild = UpdateInfoDialog.this.myLoadedResult.getNewBuild();
                WhatsNewAction.openWhatsNewFile(project, newBuild.getBlogPost(), newBuild.getMessage());
                UpdateInfoDialog.this.close(0);
            }
        };
        this.init();
        this.setTitle("[TEST] " + this.getTitle());
    }

    private static @Nullable Pair<@NlsContexts.Label String, Boolean> getLicensingInfo(@NotNull PlatformUpdates.Loaded result2) {
        LicensingFacade la;
        if (result2 == null) {
            UpdateInfoDialog.$$$reportNull$$$0(2);
        }
        if ((la = LicensingFacade.getInstance()) == null) {
            return null;
        }
        UpdateChannel channel2 = result2.getUpdatedChannel();
        if (channel2.getLicensing() == UpdateChannel.Licensing.EAP) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.channel.bundled.key", (Object[])new Object[0]), (Object)Boolean.FALSE);
        }
        Date releaseDate = result2.getNewBuild().getReleaseDate();
        if (releaseDate == null) {
            return null;
        }
        if (!la.isApplicableForProduct(releaseDate)) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.paid.upgrade", (Object[])new Object[]{channel2.getEvalDays()}), (Object)Boolean.TRUE);
        }
        if (la.isPerpetualForProduct(releaseDate)) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.fallback.build", (Object[])new Object[0]), (Object)Boolean.FALSE);
        }
        Date expiration = la.getLicenseExpirationDate();
        if (expiration != null) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.interim.build", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)expiration)}), (Object)Boolean.FALSE);
        }
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel2 = UpdateInfoPanel.create(this.myLoadedResult.getNewBuild(), this.myLoadedResult.getPatches(), this.myTestPatch, this.myWriteProtected, this.myLicenseInfo != null ? (String)this.myLicenseInfo.first : null, this.myLicenseInfo != null && (Boolean)this.myLicenseInfo.second != false, this.myEnableLink, this.myLoadedResult.getUpdatedChannel());
        if (jPanel2 == null) {
            UpdateInfoDialog.$$$reportNull$$$0(3);
        }
        return jPanel2;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            UpdateInfoDialog.$$$reportNull$$$0(4);
        }
        return dialogStyle;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent component2 = super.createSouthPanel();
        component2.setBorder(JBUI.Borders.empty((int)8));
        JComponent jComponent = component2;
        if (jComponent == null) {
            UpdateInfoDialog.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = new Action[]{new AbstractAction(IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String build2 = UpdateInfoDialog.this.myLoadedResult.getNewBuild().getNumber().asStringWithoutProductCode();
                UpdateSettings.getInstance().getIgnoredBuildNumbers().add(build2);
                UpdateInfoDialog.this.doCancelAction();
            }
        }};
        if (actionArray == null) {
            UpdateInfoDialog.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions2 = new ArrayList<Action>();
        actions2.add(this.getCancelAction());
        AbstractAction updateButton = null;
        if (this.myLoadedResult.getPatches() != null || this.myTestPatch != null) {
            boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
            String name = canRestart ? IdeBundle.message((String)"updates.download.and.restart.button", (Object[])new Object[0]) : IdeBundle.message((String)"updates.apply.manually.button", (Object[])new Object[0]);
            updateButton = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateInfoDialog.this.close(0);
                    UpdateInfoDialog.this.downloadPatchAndRestart();
                }
            };
            updateButton.setEnabled(!this.myWriteProtected);
        } else {
            final String downloadUrl = this.myLoadedResult.getNewBuild().getDownloadUrl();
            if (downloadUrl != null) {
                updateButton = new AbstractAction(IdeBundle.message((String)"updates.download.button", (Object[])new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UpdateInfoDialog.this.close(0);
                        BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(downloadUrl));
                    }
                };
            }
        }
        if (updateButton != null) {
            updateButton.putValue("DefaultAction", Boolean.TRUE);
            actions2.add(updateButton);
        }
        if (this.myWhatsNewAction != null) {
            actions2.add(this.myWhatsNewAction);
        }
        Action[] actionArray = actions2.toArray(new Action[0]);
        if (actionArray == null) {
            UpdateInfoDialog.$$$reportNull$$$0(7);
        }
        return actionArray;
    }

    @Override
    @NotNull
    protected String getCancelButtonText() {
        String string = IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]);
        if (string == null) {
            UpdateInfoDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void downloadPatchAndRestart() {
        if (!ContainerUtil.isEmpty(this.myUpdatedPlugins) && !new PluginUpdateDialog(this.myProject, this.myUpdatedPlugins).showAndGet()) {
            return;
        }
        new Task.Backgroundable(null, IdeBundle.message((String)"update.preparing", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator2) {
                String[] command;
                if (indicator2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    if (UpdateInfoDialog.this.myTestPatch != null) {
                        command = UpdateInstaller.preparePatchCommand(List.of(UpdateInfoDialog.this.myTestPatch), indicator2);
                    } else {
                        List<File> files2 = UpdateInstaller.downloadPatchChain(UpdateInfoDialog.this.myLoadedResult.getPatches().getChain(), indicator2);
                        command = UpdateInstaller.preparePatchCommand(files2, indicator2);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logger.getInstance(UpdateInstaller.class).warn((Throwable)e);
                    String title2 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                    String downloadUrl = UpdateInfoPanel.downloadUrl(UpdateInfoDialog.this.myLoadedResult.getNewBuild(), UpdateInfoDialog.this.myLoadedResult.getUpdatedChannel());
                    String message2 = IdeBundle.message((String)"update.downloading.patch.error", (Object[])new Object[]{e.getMessage(), downloadUrl});
                    UpdateChecker.getNotificationGroup().createNotification(title2, message2, NotificationType.ERROR).setListener(NotificationListener.URL_OPENING_LISTENER).setDisplayId("ide.patch.download.failed").notify(null);
                    return;
                }
                if (!ContainerUtil.isEmpty(UpdateInfoDialog.this.myUpdatedPlugins)) {
                    UpdateInstaller.installPluginUpdates(UpdateInfoDialog.this.myUpdatedPlugins, indicator2);
                }
                if (ApplicationManager.getApplication().isRestartCapable()) {
                    if (indicator2.isShowing()) {
                        UpdateInfoDialog.restartLaterAndRunCommand(command);
                    } else {
                        String title3 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                        String message3 = IdeBundle.message((String)"update.ready.message", (Object[])new Object[0]);
                        UpdateChecker.getNotificationGroup().createNotification(title3, message3, NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter(){

                            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                                if (notification == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (e == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                UpdateInfoDialog.restartLaterAndRunCommand(command);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "notification";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "e";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog$5$1";
                                objectArray[2] = "hyperlinkActivated";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }).setDisplayId("ide.update.suggest.restart").notify(null);
                    }
                } else {
                    UpdateInfoDialog.showPatchInstructions(command);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog$5", "run"));
            }
        }.queue();
    }

    private static void restartLaterAndRunCommand(String[] command) {
        IdeUpdateUsageTriggerCollector.trigger("dialog.update.started");
        PropertiesComponent.getInstance().setValue("ide.self.update.started.for.build", ApplicationInfo.getInstance().getBuild().asString());
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        application.invokeLater(() -> application.restart(6, command));
    }

    private static void showPatchInstructions(String[] command) {
        String product = ApplicationNamesInfo.getInstance().getFullProductName().replace(' ', '-').toLowerCase(Locale.ENGLISH);
        String version2 = ApplicationInfo.getInstance().getFullVersion();
        File file2 = new File(SystemProperties.getUserHome(), product + "-" + version2 + "-patch." + (SystemInfo.isWindows ? "cmd" : "sh"));
        try {
            String cmdLine = String.join((CharSequence)" ", CommandLineUtil.toCommandLine(Arrays.asList(command)));
            String text2 = (SystemInfo.isWindows ? "@echo off\n\n" : "#!/bin/sh\n\n") + cmdLine;
            FileUtil.writeToFile((File)file2, (String)text2);
            FileUtil.setExecutable((File)file2);
        }
        catch (Exception e) {
            Logger.getInstance(UpdateInstaller.class).error((Throwable)e);
            return;
        }
        String title2 = IdeBundle.message((String)"updates.dialog.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String message2 = IdeBundle.message((String)"update.apply.manually.message", (Object[])new Object[]{file2});
        IdeUpdateUsageTriggerCollector.trigger("dialog.manual.patch.prepared");
        ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)message2, (String)title2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelButtonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLicensingInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

