/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import org.jetbrains.annotations.Nullable;

public class SelectInChangesViewTarget
implements SelectInTarget,
DumbAware {
    private final Project myProject;

    public SelectInChangesViewTarget(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return ChangesViewManager.getLocalChangesToolWindowName(this.myProject);
    }

    public boolean canSelect(SelectInContext context2) {
        VirtualFile file2 = context2.getVirtualFile();
        FileStatus fileStatus = ChangeListManager.getInstance((Project)this.myProject).getStatus(file2);
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length != 0 && !fileStatus.equals(FileStatus.NOT_CHANGED);
    }

    public void selectIn(SelectInContext context2, boolean requestFocus) {
        VirtualFile file2 = context2.getVirtualFile();
        Runnable runnable2 = () -> {
            ChangesViewContentManager.getInstance(this.myProject).selectContent("Local Changes");
            ChangesViewManager.getInstance(this.myProject).selectFile(file2);
        };
        if (requestFocus) {
            ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(this.myProject, "Local Changes");
            if (toolWindow != null) {
                toolWindow.activate(runnable2);
            }
        } else {
            runnable2.run();
        }
    }

    @Nullable
    public String getToolWindowId() {
        return ChangesViewContentManager.getToolWindowIdFor(this.myProject, "Local Changes");
    }

    public float getWeight() {
        return 9.0f;
    }
}

