/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsShelveUtils;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VcsShelveChangesSaver {
    private static final Logger LOG = Logger.getInstance(VcsShelveChangesSaver.class);
    private final Project project;
    @Nls
    private final String myStashMessage;
    private final ProgressIndicator myProgressIndicator;
    private final Map<String, ShelvedChangeList> myShelvedLists;

    public VcsShelveChangesSaver(@NotNull Project project, @NotNull ProgressIndicator indicator2, @NotNull @Nls String stashMessage) {
        if (project == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(0);
        }
        if (indicator2 == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(1);
        }
        if (stashMessage == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(2);
        }
        this.myShelvedLists = new HashMap<String, ShelvedChangeList>();
        this.project = project;
        this.myProgressIndicator = indicator2;
        this.myStashMessage = stashMessage;
    }

    @NotNull
    public List<ShelvedChangeList> getShelvedLists() {
        return new ArrayList<ShelvedChangeList>(this.myShelvedLists.values());
    }

    public void save(@NotNull Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(3);
        }
        LOG.info("save " + rootsToSave);
        String oldProgressTitle = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(VcsBundle.message((String)"vcs.shelving.changes", (Object[])new Object[0]));
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Collection allChanges = changeListManager.getAllChanges();
        HashSet<? extends VirtualFile> rootsSet = new HashSet<VirtualFile>(rootsToSave);
        if (changeListManager.areChangeListsEnabled()) {
            for (LocalChangeList list2 : changeListManager.getChangeLists()) {
                List<Change> changes = this.filterChangesByRoots(list2.getChanges(), rootsSet);
                if (changes.isEmpty()) continue;
                String name = ChangeListUtil.createSystemShelvedChangeListName(this.myStashMessage, list2.getName());
                ShelvedChangeList shelved = VcsShelveUtils.shelveChanges(this.project, changes, name, false, true);
                this.myShelvedLists.put(list2.getId(), shelved);
            }
        } else {
            List<Change> changes = this.filterChangesByRoots(allChanges, rootsSet);
            if (!changes.isEmpty()) {
                ShelvedChangeList shelved = VcsShelveUtils.shelveChanges(this.project, changes, this.myStashMessage, false, true);
                this.myShelvedLists.put(null, shelved);
            }
        }
        this.doRollback(rootsToSave, allChanges);
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    public void load() {
        LOG.info("load");
        String oldProgressTitle = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(VcsBundle.message((String)"vcs.unshelving.changes", (Object[])new Object[0]));
        for (Map.Entry<String, ShelvedChangeList> listEntry : this.myShelvedLists.entrySet()) {
            VcsShelveUtils.doSystemUnshelve(this.project, listEntry.getValue(), ChangeListManager.getInstance((Project)this.project).getChangeList(listEntry.getKey()), ShelveChangesManager.getInstance(this.project), VcsBundle.message((String)"vcs.unshelving.conflict.left", (Object[])new Object[0]), VcsBundle.message((String)"vcs.unshelving.conflict.right", (Object[])new Object[0]));
        }
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    protected void doRollback(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<Change> shelvedChanges) {
        if (rootsToSave == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(4);
        }
        if (shelvedChanges == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(5);
        }
        HashSet<? extends VirtualFile> rootsSet = new HashSet<VirtualFile>(rootsToSave);
        List<Change> changes4Rollback = this.filterChangesByRoots(ChangeListManager.getInstance((Project)this.project).getAllChanges(), rootsSet);
        new RollbackWorker(this.project, this.myStashMessage, true).doRollback(changes4Rollback, true);
    }

    @NotNull
    private List<Change> filterChangesByRoots(@NotNull Collection<Change> changes, @NotNull Set<? extends VirtualFile> rootsToSave) {
        if (changes == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(6);
        }
        if (rootsToSave == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(7);
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.project);
        List list2 = ContainerUtil.filter(changes, change -> rootsToSave.contains(vcsManager2.getVcsRootFor(ChangesUtil.getFilePath((Change)change))));
        if (list2 == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsShelveChangesSaver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsShelveChangesSaver";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChangesByRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRollback";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterChangesByRoots";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

