/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMissingFilesAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        List files2;
        if (e == null) {
            AbstractMissingFilesAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (files2 = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY)) != null && !files2.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractMissingFilesAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        List files2 = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (files2 == null) {
            return;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action2 = () -> {
            ArrayList allExceptions = new ArrayList();
            ChangesUtil.processFilePathsByVcs((Project)project, (Collection)files2, (vcs, items) -> {
                List<VcsException> exceptions = this.processFiles(vcs, files2);
                if (exceptions != null) {
                    allExceptions.addAll(exceptions);
                }
            });
            for (FilePath file2 : files2) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file2);
            }
            if (allExceptions.size() > 0) {
                AbstractVcsHelper.getInstance((Project)project).showErrors(allExceptions, VcsBundle.message((String)"changes.tab.title.vcs.errors", (Object[])new Object[0]));
            }
        };
        if (this.synchronously()) {
            action2.run();
        } else {
            progressManager.runProcessWithProgressSynchronously(action2, this.getName(), true, project);
        }
    }

    protected abstract boolean synchronously();

    @NlsContexts.ProgressTitle
    protected abstract String getName();

    protected abstract List<VcsException> processFiles(AbstractVcs var1, List<? extends FilePath> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/AbstractMissingFilesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

