/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.DirectoryChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J \u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\"\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/BaseChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getModel", "()Ljavax/swing/tree/DefaultTreeModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getParentNodeFor", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "subtreeRoot", "getParentNodeRecursive", "getPathNode", "Companion", "Factory", "intellij.platform.vcs.impl"})
public final class DirectoryChangesGroupingPolicy
extends BaseChangesGroupingPolicy {
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultTreeModel model;
    @JvmField
    @NotNull
    public static final Key<DirectoryChangesGroupingPolicy> DIRECTORY_POLICY;
    @NotNull
    private static final Key<ChangesBrowserNode<?>> GRAND_PARENT_CANDIDATE;
    @NotNull
    private static final Key<ChangesBrowserNode<?>> HIERARCHY_UPPER_BOUND;
    @NotNull
    private static final Key<ChangesBrowserNode<?>> CACHING_ROOT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ChangesBrowserNode<?> getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(subtreeRoot, (String)"subtreeRoot");
        DIRECTORY_POLICY.set((UserDataHolder)subtreeRoot, (Object)this);
        Object object = this.getNextPolicy();
        if (object == null || (object = object.getParentNodeFor(nodePath, subtreeRoot)) == null) {
            object = subtreeRoot;
        }
        Object grandParent = object;
        HIERARCHY_UPPER_BOUND.set((UserDataHolder)subtreeRoot, grandParent);
        CACHING_ROOT.set((UserDataHolder)subtreeRoot, BaseChangesGroupingPolicy.Companion.getCachingRoot((ChangesBrowserNode<?>)grandParent, subtreeRoot));
        return this.getParentNodeRecursive(nodePath, subtreeRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ChangesBrowserNode<?> getParentNodeRecursive(StaticFilePath nodePath, ChangesBrowserNode<?> subtreeRoot) {
        Sequence $this$forEach$iv = SequencesKt.generateSequence((Object)nodePath.getParent(), (Function1)getParentNodeRecursive.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StaticFilePath parentPath = (StaticFilePath)element$iv;
            boolean bl = false;
            ChangesBrowserNode<? extends Object> cachingRoot = Companion.getCachingRoot$intellij_platform_vcs_impl(subtreeRoot);
            Map map2 = (Map)TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot);
            StaticFilePath staticFilePath = parentPath;
            Intrinsics.checkNotNullExpressionValue((Object)staticFilePath, (String)"parentPath");
            ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)map2.get(staticFilePath.getKey());
            if (changesBrowserNode != null) {
                ChangesBrowserNode changesBrowserNode2 = changesBrowserNode;
                boolean bl2 = false;
                boolean bl3 = false;
                ChangesBrowserNode it = changesBrowserNode2;
                boolean bl4 = false;
                if (Intrinsics.areEqual((Object)((ChangesBrowserNode)HIERARCHY_UPPER_BOUND.get((UserDataHolder)subtreeRoot)), (Object)it)) {
                    GRAND_PARENT_CANDIDATE.set((UserDataHolder)subtreeRoot, (Object)it);
                    try {
                        ChangesBrowserNode changesBrowserNode3 = this.getPathNode(parentPath, subtreeRoot);
                        if (changesBrowserNode3 == null) {
                            changesBrowserNode3 = it;
                        }
                        ChangesBrowserNode changesBrowserNode4 = changesBrowserNode3;
                        return changesBrowserNode4;
                    }
                    finally {
                        GRAND_PARENT_CANDIDATE.set((UserDataHolder)subtreeRoot, null);
                    }
                }
                return it;
            }
            ChangesBrowserNode<?> changesBrowserNode5 = this.getPathNode(parentPath, subtreeRoot);
            if (changesBrowserNode5 == null) continue;
            ChangesBrowserNode<?> changesBrowserNode6 = changesBrowserNode5;
            boolean bl5 = false;
            boolean bl6 = false;
            ChangesBrowserNode<?> it = changesBrowserNode6;
            boolean bl7 = false;
            return it;
        }
        Object object = HIERARCHY_UPPER_BOUND.getRequired((UserDataHolder)subtreeRoot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HIERARCHY_UPPER_BOUND.getRequired(subtreeRoot)");
        return (ChangesBrowserNode)object;
    }

    private final ChangesBrowserNode<?> getPathNode(StaticFilePath nodePath, ChangesBrowserNode<?> subtreeRoot) {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)((Function)TreeModelBuilder.PATH_NODE_BUILDER.getRequired((UserDataHolder)subtreeRoot)).apply(nodePath);
        if (changesBrowserNode != null) {
            ChangesBrowserNode changesBrowserNode2 = changesBrowserNode;
            boolean bl = false;
            boolean bl2 = false;
            ChangesBrowserNode it = changesBrowserNode2;
            boolean bl3 = false;
            it.markAsHelperNode();
            ChangesBrowserNode<?> changesBrowserNode3 = (ChangesBrowserNode<?>)GRAND_PARENT_CANDIDATE.get((UserDataHolder)subtreeRoot);
            if (changesBrowserNode3 == null) {
                changesBrowserNode3 = this.getParentNodeRecursive(nodePath, subtreeRoot);
            }
            ChangesBrowserNode<?> grandParent = changesBrowserNode3;
            ChangesBrowserNode<? extends Object> cachingRoot = Companion.getCachingRoot$intellij_platform_vcs_impl(subtreeRoot);
            this.model.insertNodeInto(it, grandParent, grandParent.getChildCount());
            Object object = TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DIRECTORY_CACHE.getValue(cachingRoot)");
            ((Map)object).put(nodePath.getKey(), it);
            return it;
        }
        return null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DefaultTreeModel getModel() {
        return this.model;
    }

    public DirectoryChangesGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.project = project;
        this.model = model2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ChangesTree.DirectoryPolicy");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<DirectoryChan\u2026gesTree.DirectoryPolicy\")");
        DIRECTORY_POLICY = key;
        Key key2 = Key.create((String)"ChangesTree.GrandParentCandidate");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<ChangesBrowse\u2026ee.GrandParentCandidate\")");
        GRAND_PARENT_CANDIDATE = key2;
        Key key3 = Key.create((String)"ChangesTree.HierarchyUpperBound");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"Key.create<ChangesBrowse\u2026ree.HierarchyUpperBound\")");
        HIERARCHY_UPPER_BOUND = key3;
        Key key4 = Key.create((String)"ChangesTree.CachingRoot");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"Key.create<ChangesBrowse\u2026ChangesTree.CachingRoot\")");
        CACHING_ROOT = key4;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "()V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @Override
        @NotNull
        public DirectoryChangesGroupingPolicy createGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            return new DirectoryChangesGroupingPolicy(project, model2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00052\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\b\u0012R/\u0010\u0003\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR#\u0010\n\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b0\u0004\u00a2\u0006\u0002\b\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\f\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR/\u0010\u000e\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy$Companion;", "", "()V", "CACHING_ROOT", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCACHING_ROOT$intellij_platform_vcs_impl", "()Lcom/intellij/openapi/util/Key;", "DIRECTORY_POLICY", "Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "GRAND_PARENT_CANDIDATE", "getGRAND_PARENT_CANDIDATE$intellij_platform_vcs_impl", "HIERARCHY_UPPER_BOUND", "getHIERARCHY_UPPER_BOUND$intellij_platform_vcs_impl", "getCachingRoot", "subtreeRoot", "getCachingRoot$intellij_platform_vcs_impl", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @NotNull
        public final Key<ChangesBrowserNode<?>> getGRAND_PARENT_CANDIDATE$intellij_platform_vcs_impl() {
            return GRAND_PARENT_CANDIDATE;
        }

        @NotNull
        public final Key<ChangesBrowserNode<?>> getHIERARCHY_UPPER_BOUND$intellij_platform_vcs_impl() {
            return HIERARCHY_UPPER_BOUND;
        }

        @NotNull
        public final Key<ChangesBrowserNode<?>> getCACHING_ROOT$intellij_platform_vcs_impl() {
            return CACHING_ROOT;
        }

        @NotNull
        public final ChangesBrowserNode<? extends Object> getCachingRoot$intellij_platform_vcs_impl(@NotNull ChangesBrowserNode<?> subtreeRoot) {
            Intrinsics.checkNotNullParameter(subtreeRoot, (String)"subtreeRoot");
            ChangesBrowserNode<?> changesBrowserNode = (ChangesBrowserNode<?>)this.getCACHING_ROOT$intellij_platform_vcs_impl().get((UserDataHolder)subtreeRoot);
            if (changesBrowserNode == null) {
                changesBrowserNode = subtreeRoot;
            }
            return changesBrowserNode;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

