/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.Clock;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.text.DateFormatUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class UpdateInfo {
    private UpdatedFiles myUpdatedFiles;
    private String myDate;
    private ActionInfo myActionInfo;
    @NonNls
    private static final String DATE_ATTR = "date";
    @NonNls
    private static final String FILE_INFO_ELEMENTS = "UpdatedFiles";
    @NonNls
    private static final String ACTION_INFO_ATTRIBUTE_NAME = "ActionInfo";

    UpdateInfo(UpdatedFiles updatedFiles, ActionInfo actionInfo) {
        this.myActionInfo = actionInfo;
        this.myUpdatedFiles = updatedFiles;
        this.myDate = DateFormatUtil.formatPrettyDateTime((long)Clock.getTime());
    }

    UpdateInfo() {
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            UpdateInfo.$$$reportNull$$$0(0);
        }
        if (this.myUpdatedFiles == null) {
            return;
        }
        element2.setAttribute(DATE_ATTR, this.myDate);
        element2.setAttribute(ACTION_INFO_ATTRIBUTE_NAME, this.myActionInfo.getActionName());
        Element filesElement = new Element(FILE_INFO_ELEMENTS);
        this.myUpdatedFiles.writeExternal(filesElement);
        element2.addContent(filesElement);
    }

    public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            UpdateInfo.$$$reportNull$$$0(1);
        }
        this.myDate = element2.getAttributeValue(DATE_ATTR);
        Element fileInfoElement = element2.getChild(FILE_INFO_ELEMENTS);
        if (fileInfoElement == null) {
            return;
        }
        String actionInfoName = element2.getAttributeValue(ACTION_INFO_ATTRIBUTE_NAME);
        this.myActionInfo = UpdateInfo.getActionInfoByName(actionInfoName);
        if (this.myActionInfo == null) {
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        updatedFiles.readExternal(fileInfoElement);
        this.myUpdatedFiles = updatedFiles;
    }

    private static ActionInfo getActionInfoByName(String actionInfoName) {
        if (ActionInfo.UPDATE.getActionName().equals(actionInfoName)) {
            return ActionInfo.UPDATE;
        }
        if (ActionInfo.STATUS.getActionName().equals(actionInfoName)) {
            return ActionInfo.STATUS;
        }
        return null;
    }

    public UpdatedFiles getFileInformation() {
        return this.myUpdatedFiles;
    }

    public String getCaption() {
        return VcsBundle.message((String)"toolwindow.title.update.project", (Object[])new Object[]{this.myDate});
    }

    public boolean isEmpty() {
        return this.myUpdatedFiles == null || this.myUpdatedFiles.isEmpty();
    }

    public ActionInfo getActionInfo() {
        return this.myActionInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/openapi/vcs/update/UpdateInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

