/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.keyFMap.KeyFMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsData {
    private static final Logger LOG = Logger.getInstance(VfsData.class);
    private static final int SEGMENT_BITS = 9;
    private static final int SEGMENT_SIZE = 512;
    private static final int OFFSET_MASK = 511;
    private final Object myDeadMarker = ObjectUtils.sentinel((String)"dead file");
    private final ConcurrentIntObjectMap<Segment> mySegments = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private final ConcurrentBitSet myInvalidatedIds = ConcurrentBitSet.create();
    private IntSet myDyingIds = new IntOpenHashSet();
    private final IntObjectMap<VirtualDirectoryImpl> myChangedParents = ConcurrentCollectionFactory.createConcurrentIntObjectMap();

    public VfsData() {
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionFinished(@NotNull Object action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    VfsData.this.killInvalidatedFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/vfs/newvfs/impl/VfsData$1", "writeActionFinished"));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killInvalidatedFiles() {
        Object object = this.myDeadMarker;
        synchronized (object) {
            if (!this.myDyingIds.isEmpty()) {
                IntIterator iterator2 = this.myDyingIds.iterator();
                while (iterator2.hasNext()) {
                    int id2 = iterator2.nextInt();
                    Segment segment = Objects.requireNonNull(this.getSegment(id2, false));
                    segment.myObjectArray.set(VfsData.getOffset(id2), this.myDeadMarker);
                    this.myChangedParents.remove(id2);
                }
                this.myDyingIds = new IntOpenHashSet();
            }
        }
    }

    @Nullable
    VirtualFileSystemEntry getFileById(int id2, @NotNull VirtualDirectoryImpl parent, boolean putToMemoryCache) {
        PersistentFSImpl persistentFS;
        VirtualFileSystemEntry dir;
        if (parent == null) {
            VfsData.$$$reportNull$$$0(0);
        }
        if ((dir = (persistentFS = (PersistentFSImpl)PersistentFS.getInstance()).getCachedDir(id2)) != null) {
            return dir;
        }
        Segment segment = this.getSegment(id2, false);
        if (segment == null) {
            return null;
        }
        int offset = VfsData.getOffset(id2);
        Object o = segment.myObjectArray.get(offset);
        if (o == null) {
            return null;
        }
        if (o == this.myDeadMarker) {
            throw VfsData.reportDeadFileAccess(new VirtualFileImpl(id2, segment, parent));
        }
        int nameId = segment.getNameId(id2);
        if (nameId <= 0) {
            FSRecords.invalidateCaches();
            throw new AssertionError((Object)("nameId=" + nameId + "; data=" + o + "; parent=" + parent + "; parent.id=" + parent.getId() + "; db.parent=" + FSRecords.getParent(id2)));
        }
        if (o instanceof DirectoryData) {
            if (putToMemoryCache) {
                return persistentFS.getOrCacheDir(id2, new VirtualDirectoryImpl(id2, segment, (DirectoryData)o, parent, parent.getFileSystem()));
            }
            VirtualFileSystemEntry entry2 = persistentFS.getCachedDir(id2);
            if (entry2 != null) {
                return entry2;
            }
            return new VirtualDirectoryImpl(id2, segment, (DirectoryData)o, parent, parent.getFileSystem());
        }
        return new VirtualFileImpl(id2, segment, parent);
    }

    @NotNull
    private static InvalidVirtualFileAccessException reportDeadFileAccess(@NotNull VirtualFileSystemEntry file2) {
        if (file2 == null) {
            VfsData.$$$reportNull$$$0(1);
        }
        return new InvalidVirtualFileAccessException("Accessing dead virtual file: " + file2.getUrl());
    }

    private static int getOffset(int id2) {
        if (id2 <= 0) {
            throw new IllegalArgumentException("invalid argument id: " + id2);
        }
        return id2 & 0x1FF;
    }

    @Nullable
    @Contract(value="_,true->!null")
    public Segment getSegment(int id2, boolean create2) {
        int key = id2 >>> 9;
        Segment segment = (Segment)this.mySegments.get(key);
        if (segment != null || !create2) {
            return segment;
        }
        return (Segment)this.mySegments.cacheOrGet(key, (Object)new Segment(this, key));
    }

    public boolean hasLoadedFile(int id2) {
        Segment segment = this.getSegment(id2, false);
        return segment != null && segment.myObjectArray.get(VfsData.getOffset(id2)) != null;
    }

    static void initFile(int id2, @NotNull Segment segment, int nameId, @NotNull Object data2) throws FileAlreadyCreatedException {
        if (segment == null) {
            VfsData.$$$reportNull$$$0(2);
        }
        if (data2 == null) {
            VfsData.$$$reportNull$$$0(3);
        }
        int offset = VfsData.getOffset(id2);
        segment.setNameId(id2, nameId);
        Object existingData = segment.myObjectArray.get(offset);
        if (existingData != null) {
            String msg = FSRecords.diagnosticsForAlreadyCreatedFile(id2, nameId, existingData);
            throw new FileAlreadyCreatedException(msg);
        }
        segment.myObjectArray.set(offset, data2);
    }

    @NotNull
    CharSequence getNameByFileId(int id2) {
        CharSequence charSequence = FileNameCache.getVFileName(this.getNameId(id2));
        if (charSequence == null) {
            VfsData.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    int getNameId(int id2) {
        return Objects.requireNonNull(this.getSegment(id2, false)).getNameId(id2);
    }

    boolean isFileValid(int id2) {
        return !this.myInvalidatedIds.get(id2);
    }

    @Nullable
    VirtualDirectoryImpl getChangedParent(int id2) {
        return (VirtualDirectoryImpl)((Object)this.myChangedParents.get(id2));
    }

    private void changeParent(int id2, @NotNull VirtualDirectoryImpl parent) {
        if (parent == null) {
            VfsData.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myChangedParents.put(id2, (Object)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateFile(int id2) {
        this.myInvalidatedIds.set(id2);
        Object object = this.myDeadMarker;
        synchronized (object) {
            this.myDyingIds.add(id2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameByFileId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileById";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reportDeadFileAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initFile";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class DirectoryData {
        private static final AtomicFieldUpdater<DirectoryData, KeyFMap> MY_USER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(DirectoryData.class, KeyFMap.class);
        @NotNull
        volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
        volatile int @NotNull [] myChildrenIds = ArrayUtilRt.EMPTY_INT_ARRAY;
        volatile boolean myAllChildrenLoaded;
        private volatile Set<CharSequence> myAdoptedNames;

        DirectoryData() {
        }

        VirtualFileSystemEntry @NotNull [] getFileChildren(@NotNull VirtualDirectoryImpl parent, boolean putToMemoryCache) {
            if (parent == null) {
                DirectoryData.$$$reportNull$$$0(0);
            }
            int[] ids = this.myChildrenIds;
            VirtualFileSystemEntry[] children2 = new VirtualFileSystemEntry[ids.length];
            for (int i2 = 0; i2 < ids.length; ++i2) {
                int childId = ids[i2];
                VirtualFileSystemEntry child2 = parent.getVfsData().getFileById(childId, parent, putToMemoryCache);
                if (child2 == null) {
                    throw new AssertionError((Object)("No file for id " + childId + ", parentId = " + parent.myId));
                }
                children2[i2] = child2;
            }
            if (children2 == null) {
                DirectoryData.$$$reportNull$$$0(1);
            }
            return children2;
        }

        boolean allChildrenLoaded() {
            return this.myAllChildrenLoaded;
        }

        void setAllChildrenLoaded() {
            this.myAllChildrenLoaded = true;
        }

        boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
            if (oldMap == null) {
                DirectoryData.$$$reportNull$$$0(2);
            }
            if (newMap == null) {
                DirectoryData.$$$reportNull$$$0(3);
            }
            return MY_USER_MAP_UPDATER.compareAndSet((Object)this, (Object)oldMap, (Object)newMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted;
            if (name == null) {
                DirectoryData.$$$reportNull$$$0(4);
            }
            if ((adopted = this.myAdoptedNames) == null) {
                return false;
            }
            Set<CharSequence> set2 = adopted;
            synchronized (set2) {
                return adopted.contains(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted;
            if (name == null) {
                DirectoryData.$$$reportNull$$$0(5);
            }
            if ((adopted = this.myAdoptedNames) == null) {
                return;
            }
            Set<CharSequence> set2 = adopted;
            synchronized (set2) {
                boolean removed = adopted.remove(name);
                if (removed && adopted.isEmpty()) {
                    this.myAdoptedNames = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedName(@NotNull String name, boolean caseSensitive) {
            Set<CharSequence> adopted;
            if (name == null) {
                DirectoryData.$$$reportNull$$$0(6);
            }
            Set<CharSequence> set2 = adopted = this.getOrCreateAdoptedNames(caseSensitive);
            synchronized (set2) {
                adopted.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedNames(@NotNull Collection<? extends CharSequence> names2, boolean caseSensitive) {
            Set<CharSequence> adopted;
            if (names2 == null) {
                DirectoryData.$$$reportNull$$$0(7);
            }
            Set<CharSequence> set2 = adopted = this.getOrCreateAdoptedNames(caseSensitive);
            synchronized (set2) {
                adopted.addAll(names2);
            }
        }

        @NotNull
        private Set<CharSequence> getOrCreateAdoptedNames(boolean caseSensitive) {
            Set adopted = this.myAdoptedNames;
            if (adopted == null) {
                this.myAdoptedNames = adopted = CollectionFactory.createCharSequenceSet((boolean)caseSensitive);
            }
            Set set2 = adopted;
            if (set2 == null) {
                DirectoryData.$$$reportNull$$$0(8);
            }
            return set2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        List<String> getAdoptedNames() {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                List<String> list2 = Collections.emptyList();
                if (list2 != null) return list2;
                DirectoryData.$$$reportNull$$$0(9);
                return list2;
            }
            Set<CharSequence> set2 = adopted;
            // MONITORENTER : set2
            List list3 = ContainerUtil.map(adopted, (Function)Functions.TO_STRING());
            // MONITOREXIT : set2
            if (list3 != null) return list3;
            DirectoryData.$$$reportNull$$$0(10);
            return list3;
        }

        void clearAdoptedNames() {
            this.myAdoptedNames = null;
        }

        @NonNls
        public String toString() {
            return "DirectoryData{myUserMap=" + this.myUserMap + ", myChildrenIds=" + Arrays.toString(this.myChildrenIds) + ", myAdoptedNames=" + this.myAdoptedNames + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$DirectoryData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newMap";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$DirectoryData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileChildren";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateAdoptedNames";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdoptedNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileChildren";
                    break;
                }
                case 1: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "changeUserMap";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAdoptedName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAdoptedName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addAdoptedName";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addAdoptedNames";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class Segment {
        private final int myIndex;
        private final AtomicReferenceArray<Object> myObjectArray;
        private final AtomicIntegerArray myIntArray;
        @NotNull
        final VfsData vfsData;
        @Nullable
        Segment replacement;

        Segment(@NotNull VfsData vfsData, int index2) {
            if (vfsData == null) {
                Segment.$$$reportNull$$$0(0);
            }
            this(vfsData, index2, new AtomicReferenceArray<Object>(512), new AtomicIntegerArray(1024));
        }

        private Segment(@NotNull VfsData vfsData, int index2, @NotNull AtomicReferenceArray<Object> objectArray, @NotNull AtomicIntegerArray intArray) {
            if (vfsData == null) {
                Segment.$$$reportNull$$$0(1);
            }
            if (objectArray == null) {
                Segment.$$$reportNull$$$0(2);
            }
            if (intArray == null) {
                Segment.$$$reportNull$$$0(3);
            }
            this.myIndex = index2;
            this.myObjectArray = objectArray;
            this.myIntArray = intArray;
            this.vfsData = vfsData;
        }

        int getNameId(int fileId) {
            return this.myIntArray.get(VfsData.getOffset(fileId) * 2);
        }

        void setNameId(int fileId, int nameId) {
            if (fileId <= 0 || nameId <= 0) {
                throw new IllegalArgumentException("invalid arguments id: " + fileId + "; nameId: " + nameId);
            }
            this.myIntArray.set(VfsData.getOffset(fileId) * 2, nameId);
        }

        void setUserMap(int fileId, @NotNull KeyFMap map2) {
            if (map2 == null) {
                Segment.$$$reportNull$$$0(4);
            }
            this.myObjectArray.set(VfsData.getOffset(fileId), map2);
        }

        @NotNull
        KeyFMap getUserMap(@NotNull VirtualFileSystemEntry file2, int id2) {
            Object o;
            if (file2 == null) {
                Segment.$$$reportNull$$$0(5);
            }
            if (!((o = this.myObjectArray.get(VfsData.getOffset(id2))) instanceof KeyFMap)) {
                throw VfsData.reportDeadFileAccess(file2);
            }
            KeyFMap keyFMap = (KeyFMap)o;
            if (keyFMap == null) {
                Segment.$$$reportNull$$$0(6);
            }
            return keyFMap;
        }

        boolean changeUserMap(int fileId, KeyFMap oldMap, KeyFMap newMap) {
            return this.myObjectArray.compareAndSet(VfsData.getOffset(fileId), oldMap, newMap);
        }

        boolean getFlag(int id2, @VirtualFileSystemEntry.Flags int mask) {
            BitUtil.assertOneBitMask((int)mask);
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            return (this.myIntArray.get(VfsData.getOffset(id2) * 2 + 1) & mask) != 0;
        }

        void setFlag(int id2, @VirtualFileSystemEntry.Flags int mask, boolean value2) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flag " + Integer.toHexString(mask) + "=" + value2 + " for id=" + id2);
            }
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            int offset = VfsData.getOffset(id2) * 2 + 1;
            this.myIntArray.updateAndGet(offset, oldInt -> BitUtil.set((int)oldInt, (int)mask, (boolean)value2));
        }

        void setFlags(int id2, @VirtualFileSystemEntry.Flags int combinedMask, @VirtualFileSystemEntry.Flags int combinedValue) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flags " + Integer.toHexString(combinedMask) + "=" + combinedValue + " for id=" + id2);
            }
            assert ((combinedMask & 0xFFFFFF) == 0) : "Unexpected flag";
            assert ((~combinedMask & combinedValue) == 0) : "Value (" + Integer.toHexString(combinedValue) + ") set bits outside mask (" + Integer.toHexString(combinedMask) + ")";
            int offset = VfsData.getOffset(id2) * 2 + 1;
            this.myIntArray.updateAndGet(offset, oldInt -> oldInt & ~combinedMask | combinedValue);
        }

        long getModificationStamp(int id2) {
            return this.myIntArray.get(VfsData.getOffset(id2) * 2 + 1) & 0xFFFFFF;
        }

        void setModificationStamp(int id2, long stamp) {
            int offset = VfsData.getOffset(id2) * 2 + 1;
            this.myIntArray.updateAndGet(offset, oldInt -> oldInt & 0xFF000000 | (int)stamp & 0xFFFFFF);
        }

        void changeParent(int fileId, VirtualDirectoryImpl directory) {
            assert (this.replacement == null);
            this.replacement = new Segment(this.vfsData, this.myIndex, this.myObjectArray, this.myIntArray);
            boolean replaced = this.vfsData.mySegments.replace(this.myIndex, (Object)this, (Object)this.replacement);
            assert (replaced);
            this.vfsData.changeParent(fileId, directory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vfsData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectArray";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intArray";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$Segment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$Segment";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setUserMap";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserMap";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class FileAlreadyCreatedException
    extends RuntimeException {
        private FileAlreadyCreatedException(@NotNull String message2) {
            if (message2 == null) {
                FileAlreadyCreatedException.$$$reportNull$$$0(0);
            }
            super(message2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vfs/newvfs/impl/VfsData$FileAlreadyCreatedException", "<init>"));
        }
    }
}

