/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnector;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSContentAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSPaths;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSTreeAccessor;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class FSRecords {
    static final Logger LOG = Logger.getInstance(FSRecords.class);
    public static final boolean useContentHashes = SystemProperties.getBooleanProperty((String)"idea.share.contents", (boolean)true);
    static final boolean backgroundVfsFlush = SystemProperties.getBooleanProperty((String)"idea.background.vfs.flush", (boolean)true);
    static final boolean inlineAttributes = SystemProperties.getBooleanProperty((String)"idea.inline.vfs.attributes", (boolean)true);
    static final boolean bulkAttrReadSupport = SystemProperties.getBooleanProperty((String)"idea.bulk.attr.read", (boolean)false);
    static final boolean useCompressionUtil = SystemProperties.getBooleanProperty((String)"idea.use.lightweight.compression.for.vfs", (boolean)false);
    static final boolean useSmallAttrTable = SystemProperties.getBooleanProperty((String)"idea.use.small.attr.table.for.vfs", (boolean)true);
    static final boolean ourStoreRootsSeparately = SystemProperties.getBooleanProperty((String)"idea.store.roots.separately", (boolean)false);
    private static volatile PersistentFSConnection ourConnection;
    private static volatile PersistentFSContentAccessor ourContentAccessor;
    private static volatile PersistentFSAttributeAccessor ourAttributeAccessor;
    private static volatile PersistentFSTreeAccessor ourTreeAccessor;
    private static volatile PersistentFSRecordAccessor ourRecordAccessor;
    private static final int VERSION;
    private static final FileAttribute ourSymlinkTargetAttr;
    static final ReentrantReadWriteLock lock;
    private static final ReentrantReadWriteLock.ReadLock r;
    private static final ReentrantReadWriteLock.WriteLock w;

    private static int nextMask(int value2, int bits, int prevMask) {
        assert (value2 < 1 << bits && value2 >= 0) : value2;
        int mask = prevMask << bits | value2;
        if (mask < 0) {
            throw new IllegalStateException("Too many flags, int mask overflown");
        }
        return mask;
    }

    private static int nextMask(boolean value2, int prevMask) {
        return FSRecords.nextMask(value2 ? 1 : 0, 1, prevMask);
    }

    static int writeAttributesToRecord(int fileId, int parentId, @NotNull FileAttributes attributes2, @NotNull String name) {
        if (attributes2 == null) {
            FSRecords.$$$reportNull$$$0(0);
        }
        if (name == null) {
            FSRecords.$$$reportNull$$$0(1);
        }
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int nameId = FSRecords.setName(fileId, name);
            FSRecords.setTimestamp(fileId, attributes2.lastModified);
            FSRecords.setLength(fileId, attributes2.isDirectory() ? -1L : attributes2.length);
            FSRecords.setFlags(fileId, PersistentFSImpl.fileAttributesToFlags(attributes2));
            FSRecords.setParent(fileId, parentId);
            return nameId;
        });
    }

    @Contract(value="_->fail")
    static void requestVfsRebuild(@NotNull Throwable e) {
        if (e == null) {
            FSRecords.$$$reportNull$$$0(2);
        }
        FSRecords.handleError(e);
    }

    @NotNull
    public static String diagnosticsForAlreadyCreatedFile(int fileId, int nameId, @NotNull Object existingData) {
        if (existingData == null) {
            FSRecords.$$$reportNull$$$0(3);
        }
        FSRecords.invalidateCaches();
        int parentId = FSRecords.getParent(fileId);
        String msg = "File already created: fileId=" + fileId + "; nameId=" + nameId + "(" + FSRecords.getNameByNameId(nameId) + "); parentId=" + parentId + "; existingData=" + existingData;
        if (parentId > 0) {
            msg = msg + "; parent.name=" + FSRecords.getName(parentId);
            msg = msg + "; parent.children=" + FSRecords.list(parentId);
        }
        String string = msg;
        if (string == null) {
            FSRecords.$$$reportNull$$$0(4);
        }
        return string;
    }

    private FSRecords() {
    }

    @ApiStatus.Internal
    public static int getVersion() {
        return VERSION;
    }

    static void connect() {
        ourConnection = PersistentFSConnector.connect(FSRecords.getCachesDir(), FSRecords.getVersion(), useContentHashes);
        ourContentAccessor = new PersistentFSContentAccessor(useContentHashes, ourConnection);
        ourAttributeAccessor = new PersistentFSAttributeAccessor(bulkAttrReadSupport, inlineAttributes, ourConnection);
        ourTreeAccessor = new PersistentFSTreeAccessor(ourAttributeAccessor, ourStoreRootsSeparately, ourConnection);
        ourRecordAccessor = new PersistentFSRecordAccessor(ourContentAccessor, ourAttributeAccessor, ourConnection);
        try {
            ourTreeAccessor.ensureLoaded();
        }
        catch (IOException e) {
            FSRecords.handleError(e);
        }
    }

    private static String getCachesDir() {
        String dir = System.getProperty("caches_dir");
        return dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
    }

    public static long getCreationTimestamp() {
        return (Long)FSRecords.readAndHandleErrors(() -> ourConnection.getTimestamp());
    }

    public static int createRecord() {
        return (Integer)FSRecords.writeAndHandleErrors(() -> ourRecordAccessor.createRecord());
    }

    static void deleteRecordRecursively(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            FSRecords.markAsDeletedRecursively(id2);
        });
    }

    private static void markAsDeletedRecursively(int id2) throws IOException {
        for (int subRecord : FSRecords.listIds(id2)) {
            FSRecords.markAsDeletedRecursively(subRecord);
        }
        ourRecordAccessor.addToFreeRecordsList(id2);
    }

    @TestOnly
    static int @NotNull [] listRoots() {
        int[] nArray = (int[])FSRecords.readAndHandleErrors(() -> ourTreeAccessor.listRoots());
        if (nArray == null) {
            FSRecords.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    @TestOnly
    static void force() {
        FSRecords.writeAndHandleErrors(ourConnection::doForce);
    }

    @TestOnly
    static boolean isDirty() {
        return (Boolean)FSRecords.readAndHandleErrors(ourConnection::isDirty);
    }

    static @PersistentFS.Attributes int getFlags(int id2) {
        return (Integer)FSRecords.readAndHandleErrors(() -> ourConnection.getRecords().doGetFlags(id2));
    }

    static int findRootRecord(@NotNull String rootUrl) {
        if (rootUrl == null) {
            FSRecords.$$$reportNull$$$0(6);
        }
        return (Integer)FSRecords.writeAndHandleErrors(() -> ourTreeAccessor.findOrCreateRootRecord(rootUrl, () -> FSRecords.createRecord()));
    }

    static void deleteRootRecord(int fileId) {
        FSRecords.writeAndHandleErrors(() -> ourTreeAccessor.deleteRootRecord(fileId));
    }

    static int @NotNull [] listIds(int fileId) {
        int[] nArray = (int[])FSRecords.readAndHandleErrors(() -> ourTreeAccessor.listIds(fileId));
        if (nArray == null) {
            FSRecords.$$$reportNull$$$0(7);
        }
        return nArray;
    }

    static boolean mayHaveChildren(int fileId) {
        return (Boolean)FSRecords.readAndHandleErrors(() -> ourTreeAccessor.mayHaveChildren(fileId));
    }

    @NotNull
    static ListResult list(int parentId) {
        ListResult listResult = (ListResult)FSRecords.readAndHandleErrors(() -> ourTreeAccessor.doLoadChildren(parentId));
        if (listResult == null) {
            FSRecords.$$$reportNull$$$0(8);
        }
        return listResult;
    }

    @NotNull
    public static List<CharSequence> listNames(int parentId) {
        List list2 = ContainerUtil.map(FSRecords.list((int)parentId).children, c -> c.getName());
        if (list2 == null) {
            FSRecords.$$$reportNull$$$0(9);
        }
        return list2;
    }

    static boolean wereChildrenAccessed(int id2) {
        return (Boolean)FSRecords.readAndHandleErrors(() -> ourTreeAccessor.wereChildrenAccessed(id2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T readAndHandleErrors(@NotNull ThrowableComputable<T, ? extends Exception> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(10);
        }
        if (lock.getReadHoldCount() != 0) {
            try {
                return (T)action2.compute();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            r.lock();
            try {
                Object ex = action2.compute();
                return (T)ex;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            FSRecords.handleError(e);
            throw new RuntimeException(e);
        }
    }

    static <T> T writeAndHandleErrors(@NotNull ThrowableComputable<T, ?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(11);
        }
        w.lock();
        try {
            Object object = action2.compute();
            return (T)object;
        }
        catch (Throwable e) {
            FSRecords.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void writeAndHandleErrors(@NotNull ThrowableRunnable<?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(12);
        }
        w.lock();
        try {
            action2.run();
        }
        catch (Throwable e) {
            FSRecords.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    static <T extends Exception> void write(@NotNull ThrowableRunnable<T> action2) throws T {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(13);
        }
        w.lock();
        try {
            action2.run();
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static ListResult update(@NotNull VirtualFile parent, int parentId, @NotNull Function<? super ListResult, ? extends ListResult> childrenConvertor) {
        ListResult listResult;
        if (parent == null) {
            FSRecords.$$$reportNull$$$0(14);
        }
        if (childrenConvertor == null) {
            FSRecords.$$$reportNull$$$0(15);
        }
        assert (parentId > 0) : parentId;
        ListResult children2 = FSRecords.list(parentId);
        ListResult result2 = childrenConvertor.apply(children2);
        w.lock();
        try {
            ListResult toSave;
            if (result2.childrenWereChangedSinceLastList()) {
                children2 = FSRecords.list(parentId);
                toSave = childrenConvertor.apply(children2);
            } else {
                toSave = result2;
            }
            if (!toSave.equals(children2)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Update children for " + parent + " (id = " + parentId + "); old = " + children2 + ", new = " + toSave);
                }
                FSRecords.updateSymlinksForNewChildren(parent, children2, toSave);
                ourTreeAccessor.doSaveChildren(parentId, toSave);
            }
            ListResult listResult2 = toSave;
            listResult = listResult2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            FSRecords.handleError(e);
            ExceptionUtil.rethrow((Throwable)e);
            ListResult listResult3 = result2;
            ListResult listResult4 = listResult3;
            if (listResult4 == null) {
                FSRecords.$$$reportNull$$$0(17);
            }
            return listResult4;
        }
        finally {
            w.unlock();
        }
        if (listResult == null) {
            FSRecords.$$$reportNull$$$0(16);
        }
        return listResult;
    }

    private static void updateSymlinksForNewChildren(@NotNull VirtualFile parent, @NotNull ListResult oldChildren, @NotNull ListResult newChildren) {
        if (parent == null) {
            FSRecords.$$$reportNull$$$0(18);
        }
        if (oldChildren == null) {
            FSRecords.$$$reportNull$$$0(19);
        }
        if (newChildren == null) {
            FSRecords.$$$reportNull$$$0(20);
        }
        ContainerUtil.processSortedListsInOrder(oldChildren.children, newChildren.children, Comparator.comparingInt(ChildInfo::getId), (boolean)true, (childInfo, isOldInfo) -> {
            if (!isOldInfo.booleanValue()) {
                FSRecords.updateSymlinkInfoForNewChild(parent, childInfo);
            }
        });
    }

    private static void updateSymlinkInfoForNewChild(@NotNull VirtualFile parent, @NotNull ChildInfo info2) {
        int attributes2;
        if (parent == null) {
            FSRecords.$$$reportNull$$$0(21);
        }
        if (info2 == null) {
            FSRecords.$$$reportNull$$$0(22);
        }
        if ((attributes2 = info2.getFileAttributeFlags()) != -1 && PersistentFS.isSymLink(attributes2)) {
            int id2 = info2.getId();
            String symlinkTarget = info2.getSymlinkTarget();
            FSRecords.storeSymlinkTarget(id2, symlinkTarget);
            CharSequence name = info2.getName();
            VirtualFileSystem fs = parent.getFileSystem();
            if (fs instanceof LocalFileSystemImpl) {
                String linkPath = parent.getPath() + "/" + name;
                ((LocalFileSystemImpl)fs).symlinkUpdated(id2, parent, name, linkPath, symlinkTarget);
            }
        }
    }

    @Nullable
    static String readSymlinkTarget(int id2) {
        String result2 = (String)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(id2, ourSymlinkTargetAttr);){
                if (stream != null) {
                    String string = StringUtil.nullize((String)IOUtil.readUTF((DataInput)stream));
                    return string;
                }
            }
            return null;
        });
        return result2 != null ? FileUtil.toSystemIndependentName((String)result2) : null;
    }

    static void storeSymlinkTarget(int id2, @Nullable String symlinkTarget) {
        FSRecords.writeAndHandleErrors(() -> {
            ourConnection.markDirty();
            try (DataOutputStream stream = FSRecords.writeAttribute(id2, ourSymlinkTargetAttr);){
                IOUtil.writeUTF((DataOutput)stream, (String)StringUtil.notNullize((String)symlinkTarget));
            }
        });
    }

    static int getLocalModCount() {
        return ourConnection.getLocalModificationCount();
    }

    static int getPersistentModCount() {
        return (Integer)FSRecords.readAndHandleErrors(ourConnection::getPersistentModCount);
    }

    private static void incModCount(int id2) throws IOException {
        ourConnection.incModCount(id2);
    }

    public static int getParent(int id2) {
        return (Integer)FSRecords.readAndHandleErrors(() -> {
            int parentId = ourConnection.getRecords().getParent(id2);
            if (parentId == id2) {
                LOG.error("Cyclic parent child relations in the database. id = " + id2);
                return 0;
            }
            return parentId;
        });
    }

    @Nullable
    static VirtualFileSystemEntry findFileById(final int id2, final @NotNull ConcurrentIntObjectMap<VirtualFileSystemEntry> idToDirCache) {
        if (idToDirCache == null) {
            FSRecords.$$$reportNull$$$0(23);
        }
        class ParentFinder
        implements ThrowableComputable<Void, Exception> {
            @Nullable
            private IntList path;
            private VirtualFileSystemEntry foundParent;

            ParentFinder() {
            }

            public Void compute() throws Exception {
                int parentId;
                int currentId = id2;
                while ((parentId = ourConnection.getRecords().getParent(currentId)) != 0) {
                    if (parentId == currentId || this.path != null && this.path.size() % 128 == 0 && this.path.contains(parentId)) {
                        LOG.error("Cyclic parent child relations in the database. id = " + parentId);
                        break;
                    }
                    this.foundParent = (VirtualFileSystemEntry)((Object)idToDirCache.get(parentId));
                    if (this.foundParent != null) break;
                    currentId = parentId;
                    if (this.path == null) {
                        this.path = new IntArrayList();
                    }
                    this.path.add(currentId);
                }
                return null;
            }

            @Nullable
            private VirtualFileSystemEntry findDescendantByIdPath() {
                VirtualFileSystemEntry parent = this.foundParent;
                if (this.path != null) {
                    for (int i2 = this.path.size() - 1; i2 >= 0; --i2) {
                        parent = this.findChild(parent, this.path.getInt(i2));
                    }
                }
                return this.findChild(parent, id2);
            }

            @Nullable
            private VirtualFileSystemEntry findChild(VirtualFileSystemEntry parent, int childId) {
                VirtualFileSystemEntry old;
                if (!(parent instanceof VirtualDirectoryImpl)) {
                    return null;
                }
                VirtualFileSystemEntry child2 = ((VirtualDirectoryImpl)parent).doFindChildById(childId);
                if (child2 instanceof VirtualDirectoryImpl && (old = (VirtualFileSystemEntry)((Object)idToDirCache.putIfAbsent(childId, (Object)child2))) != null) {
                    child2 = old;
                }
                return child2;
            }
        }
        ParentFinder finder = new ParentFinder();
        FSRecords.readAndHandleErrors(finder);
        return finder.findDescendantByIdPath();
    }

    @ApiStatus.Internal
    @NotNull
    public static IntList getRemainFreeRecords() {
        IntList intList = (IntList)FSRecords.readAndHandleErrors(() -> new IntArrayList(ourConnection.getFreeRecords()));
        if (intList == null) {
            FSRecords.$$$reportNull$$$0(24);
        }
        return intList;
    }

    @ApiStatus.Internal
    @NotNull
    public static IntList getNewFreeRecords() {
        IntList intList = (IntList)FSRecords.readAndHandleErrors(() -> new IntArrayList(ourRecordAccessor.getNewFreeRecords()));
        if (intList == null) {
            FSRecords.$$$reportNull$$$0(25);
        }
        return intList;
    }

    static void setParent(int id2, int parentId) {
        if (id2 == parentId) {
            LOG.error("Cyclic parent/child relations");
            return;
        }
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            ourConnection.getRecords().setParent(id2, parentId);
        });
    }

    public static int getNameId(@NotNull String name) {
        if (name == null) {
            FSRecords.$$$reportNull$$$0(26);
        }
        return (Integer)FSRecords.readAndHandleErrors(() -> ourConnection.getNames().enumerate(name));
    }

    public static String getName(int id2) {
        return FSRecords.getNameSequence(id2).toString();
    }

    @NotNull
    static CharSequence getNameSequence(int id2) {
        CharSequence charSequence = (CharSequence)FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameSequence(id2));
        if (charSequence == null) {
            FSRecords.$$$reportNull$$$0(27);
        }
        return charSequence;
    }

    @NotNull
    private static CharSequence doGetNameSequence(int id2) throws IOException {
        int nameId = ourConnection.getRecords().getNameId(id2);
        CharSequence charSequence = nameId == 0 ? "" : FileNameCache.getVFileName(nameId, FSRecords::doGetNameByNameId);
        if (charSequence == null) {
            FSRecords.$$$reportNull$$$0(28);
        }
        return charSequence;
    }

    public static String getNameByNameId(int nameId) {
        return (String)FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameByNameId(nameId));
    }

    private static String doGetNameByNameId(int nameId) throws IOException {
        assert (nameId >= 0) : nameId;
        return nameId == 0 ? "" : ourConnection.getNames().valueOf(nameId);
    }

    static int setName(int fileId, @NotNull String name) {
        if (name == null) {
            FSRecords.$$$reportNull$$$0(29);
        }
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(fileId);
            int nameId = ourConnection.getNames().enumerate(name);
            ourConnection.getRecords().setNameId(fileId, nameId);
            return nameId;
        });
    }

    static void setFlags(int id2, @PersistentFS.Attributes int flags) {
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            ourConnection.getRecords().setFlags(id2, flags);
        });
    }

    static long getLength(int id2) {
        return (Long)FSRecords.readAndHandleErrors(() -> ourConnection.getRecords().getLength(id2));
    }

    static void setLength(int id2, long len) {
        FSRecords.writeAndHandleErrors(() -> {
            PersistentFSRecordsStorage records = ourConnection.getRecords();
            if (records.putLength(id2, len)) {
                FSRecords.incModCount(id2);
            }
        });
    }

    static long getTimestamp(int id2) {
        return (Long)FSRecords.readAndHandleErrors(() -> ourConnection.getRecords().getTimestamp(id2));
    }

    static void setTimestamp(int id2, long value2) {
        FSRecords.writeAndHandleErrors(() -> {
            PersistentFSRecordsStorage records = ourConnection.getRecords();
            if (records.putTimeStamp(id2, value2)) {
                FSRecords.incModCount(id2);
            }
        });
    }

    static int getModCount(int id2) {
        return (Integer)FSRecords.readAndHandleErrors(() -> ourConnection.getRecords().getModCount(id2));
    }

    @Nullable
    static DataInputStream readContent(int fileId) {
        ThrowableComputable computable = (ThrowableComputable)FSRecords.readAndHandleErrors(() -> ourContentAccessor.readContent(fileId));
        if (computable == null) {
            return null;
        }
        try {
            return (DataInputStream)computable.compute();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable e) {
            FSRecords.handleError(e);
            return null;
        }
    }

    @NotNull
    static DataInputStream readContentById(int contentId) {
        DataInputStream dataInputStream;
        try {
            dataInputStream = ourContentAccessor.readContentDirectly(contentId);
        }
        catch (Throwable e) {
            FSRecords.handleError(e);
            if (null == null) {
                FSRecords.$$$reportNull$$$0(31);
            }
            return null;
        }
        if (dataInputStream == null) {
            FSRecords.$$$reportNull$$$0(30);
        }
        return dataInputStream;
    }

    @Nullable
    public static DataInputStream readAttributeWithLock(int fileId, @NotNull FileAttribute att) {
        if (att == null) {
            FSRecords.$$$reportNull$$$0(32);
        }
        return (DataInputStream)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(fileId, att);){
                if (stream != null && att.isVersioned()) {
                    try {
                        int actualVersion = DataInputOutputUtil.readINT((DataInput)stream);
                        if (actualVersion != att.getVersion()) {
                            DataInputStream dataInputStream = null;
                            return dataInputStream;
                        }
                    }
                    catch (IOException e) {
                        DataInputStream dataInputStream = null;
                        return dataInputStream;
                    }
                }
                DataInputStream dataInputStream = stream;
                return dataInputStream;
            }
        });
    }

    @Nullable
    private static DataInputStream readAttribute(int fileId, @NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            FSRecords.$$$reportNull$$$0(33);
        }
        return ourAttributeAccessor.readAttribute(fileId, attribute);
    }

    static int acquireFileContent(int fileId) {
        return (Integer)FSRecords.writeAndHandleErrors(() -> ourContentAccessor.acquireContentRecord(fileId));
    }

    static void releaseContent(int contentId) {
        FSRecords.writeAndHandleErrors(() -> ourContentAccessor.releaseContentRecord(contentId));
    }

    static int getContentId(int fileId) {
        return (Integer)FSRecords.readAndHandleErrors(() -> ourConnection.getRecords().getContentRecordId(fileId));
    }

    @TestOnly
    static byte[] getContentHash(int fileId) {
        return (byte[])FSRecords.readAndHandleErrors(() -> ourContentAccessor.getContentHash(fileId));
    }

    @NotNull
    static DataOutputStream writeContent(final int fileId, boolean readOnly) {
        PersistentFSContentAccessor persistentFSContentAccessor = ourContentAccessor;
        Objects.requireNonNull(persistentFSContentAccessor);
        return new DataOutputStream((OutputStream)((Object)new PersistentFSContentAccessor.ContentOutputStream(persistentFSContentAccessor, fileId, readOnly))){

            public void close() {
                FSRecords.writeAndHandleErrors(() -> {
                    super.close();
                    if (((PersistentFSContentAccessor.ContentOutputStream)((Object)((Object)this.out))).isModified()) {
                        FSRecords.incModCount(fileId);
                    }
                });
            }
        };
    }

    static void writeContent(int fileId, @NotNull ByteArraySequence bytes, boolean readOnly) {
        if (bytes == null) {
            FSRecords.$$$reportNull$$$0(34);
        }
        FSRecords.writeAndHandleErrors(() -> {
            if (ourContentAccessor.writeContent(fileId, bytes, readOnly)) {
                FSRecords.incModCount(fileId);
            }
        });
    }

    static int storeUnlinkedContent(byte[] bytes) {
        return (Integer)FSRecords.writeAndHandleErrors(() -> ourContentAccessor.allocateContentRecordAndStore(bytes));
    }

    @NotNull
    public static DataOutputStream writeAttribute(int fileId, @NotNull FileAttribute att) {
        if (att == null) {
            FSRecords.$$$reportNull$$$0(35);
        }
        DataOutputStream dataOutputStream = ourAttributeAccessor.writeAttribute(fileId, att);
        return new DataOutputStream((OutputStream)dataOutputStream){

            public void close() {
                FSRecords.writeAndHandleErrors(() -> super.close());
            }
        };
    }

    @NotNull
    public static PersistentFSPaths getPersistentFSPaths() {
        return new PersistentFSPaths(FSRecords.getCachesDir());
    }

    static synchronized void dispose() {
        FSRecords.writeAndHandleErrors(() -> {
            try {
                ourConnection.doForce();
                ourConnection.closeFiles();
            }
            finally {
                ourConnection = null;
                ourContentAccessor = null;
                ourAttributeAccessor = null;
                ourTreeAccessor = null;
                ourRecordAccessor = null;
            }
        });
    }

    public static void invalidateCaches() {
        ourConnection.createBrokenMarkerFile(null);
    }

    static void checkSanity() {
        FSRecords.writeAndHandleErrors(() -> {
            ourRecordAccessor.checkSanity();
            return null;
        });
    }

    @Contract(value="_->fail")
    public static void handleError(Throwable e) throws RuntimeException, Error {
        if (ourConnection != null) {
            ourConnection.handleError(e);
        }
    }

    static {
        VERSION = FSRecords.nextMask(59, 8, FSRecords.nextMask(useContentHashes, FSRecords.nextMask(IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER, FSRecords.nextMask(bulkAttrReadSupport, FSRecords.nextMask(inlineAttributes, FSRecords.nextMask(ourStoreRootsSeparately, FSRecords.nextMask(useCompressionUtil, FSRecords.nextMask(useSmallAttrTable, FSRecords.nextMask(PersistentHashMapValueStorage.COMPRESSION_ENABLED, FSRecords.nextMask(FileSystemUtil.DO_NOT_RESOLVE_SYMLINKS, FSRecords.nextMask(ZipHandlerBase.USE_CRC_INSTEAD_OF_TIMESTAMP, 0)))))))))));
        ourSymlinkTargetAttr = new FileAttribute("FsRecords.SYMLINK_TARGET");
        lock = new ReentrantReadWriteLock();
        r = lock.readLock();
        w = lock.writeLock();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingData";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenConvertor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChildren";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChildren";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDirCache";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "diagnosticsForAlreadyCreatedFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listIds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "listNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainFreeRecords";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFreeRecords";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetNameSequence";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributesToRecord";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requestVfsRebuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "diagnosticsForAlreadyCreatedFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRootRecord";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readAndHandleErrors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeAndHandleErrors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlinksForNewChildren";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlinkInfoForNewChild";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFileById";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeWithLock";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

