/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.Utf8BomOptionProvider;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.CompoundVFileEvent;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.FsRoot;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.BatchingFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.io.storage.HeavyProcessLatch;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PersistentFSImpl
extends PersistentFS
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PersistentFS.class);
    private final Map<String, VirtualFileSystemEntry> myRoots;
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache = ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap();
    private final ReadWriteLock myInputLock = new ReentrantReadWriteLock();
    private final AtomicBoolean myShutDown = new AtomicBoolean(false);
    private final AtomicInteger myStructureModificationCount = new AtomicInteger();
    private BulkFileListener myPublisher;
    private final VfsData myVfsData = new VfsData();
    private static final int INNER_ARRAYS_THRESHOLD = 1024;
    private static final Hash.Strategy<VFileCreateEvent> CASE_INSENSITIVE_STRATEGY = new Hash.Strategy<VFileCreateEvent>(){

        public int hashCode(@Nullable VFileCreateEvent object) {
            return object == null ? 0 : Strings.stringHashCodeInsensitive((CharSequence)object.getChildName());
        }

        public boolean equals(VFileCreateEvent o1, VFileCreateEvent o2) {
            if (o1 == o2) {
                return true;
            }
            return o2 != null && o1.getChildName().equalsIgnoreCase(o2.getChildName());
        }
    };

    public PersistentFSImpl() {
        this.myRoots = SystemInfoRt.isFileSystemCaseSensitive ? new ConcurrentHashMap<String, VirtualFileSystemEntry>(10, 0.4f, JobSchedulerImpl.getCPUCoresCount()) : ConcurrentCollectionFactory.createConcurrentMap((int)10, (float)0.4f, (int)JobSchedulerImpl.getCPUCoresCount(), (HashingStrategy)HashingStrategy.caseInsensitive());
        ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        LowMemoryWatcher.register(this::clearIdCache, (Disposable)this);
        AsyncEventSupport.startListening();
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                PersistentFSImpl.this.clearIdCache();
                Iterator<Map.Entry<String, VirtualFileSystemEntry>> iterator2 = PersistentFSImpl.this.myRoots.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, VirtualFileSystemEntry> entry2 = iterator2.next();
                    VirtualFileSystemEntry root = entry2.getValue();
                    if (VirtualFileManager.getInstance().getFileSystem(root.getFileSystem().getProtocol()) != null) continue;
                    iterator2.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$1", "pluginUnloaded"));
            }
        });
        Activity activity = StartUpMeasurer.startActivity((String)"connect FSRecords", (ActivityCategory)ActivityCategory.DEFAULT);
        FSRecords.connect();
        activity.end();
    }

    @NotNull
    private BulkFileListener getPublisher() {
        BulkFileListener publisher = this.myPublisher;
        if (publisher == null) {
            this.myPublisher = publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
        }
        BulkFileListener bulkFileListener = publisher;
        if (bulkFileListener == null) {
            PersistentFSImpl.$$$reportNull$$$0(0);
        }
        return bulkFileListener;
    }

    public void dispose() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (this.myShutDown.compareAndSet(false, true)) {
            LOG.info("VFS dispose started");
            FSRecords.dispose();
            LOG.info("VFS dispose completed");
        }
    }

    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(1);
        }
        return PersistentFSImpl.areChildrenLoaded(PersistentFSImpl.getFileId(dir));
    }

    public long getCreationTimestamp() {
        return FSRecords.getCreationTimestamp();
    }

    @NotNull
    public VirtualFileSystemEntry getOrCacheDir(int id2, @NotNull VirtualDirectoryImpl newDir) {
        VirtualFileSystemEntry dir;
        if (newDir == null) {
            PersistentFSImpl.$$$reportNull$$$0(2);
        }
        if ((dir = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id2))) != null) {
            VirtualFileSystemEntry virtualFileSystemEntry = dir;
            if (virtualFileSystemEntry == null) {
                PersistentFSImpl.$$$reportNull$$$0(3);
            }
            return virtualFileSystemEntry;
        }
        VirtualFileSystemEntry virtualFileSystemEntry = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.cacheOrGet(id2, (Object)newDir));
        if (virtualFileSystemEntry == null) {
            PersistentFSImpl.$$$reportNull$$$0(4);
        }
        return virtualFileSystemEntry;
    }

    public VirtualFileSystemEntry getCachedDir(int id2) {
        return (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id2));
    }

    @NotNull
    private static NewVirtualFileSystem getDelegate(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(5);
        }
        NewVirtualFileSystem newVirtualFileSystem = (NewVirtualFileSystem)file2.getFileSystem();
        if (newVirtualFileSystem == null) {
            PersistentFSImpl.$$$reportNull$$$0(6);
        }
        return newVirtualFileSystem;
    }

    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(7);
        }
        return FSRecords.wereChildrenAccessed(PersistentFSImpl.getFileId(dir));
    }

    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(8);
        }
        List<? extends ChildInfo> children2 = this.listAll(file2);
        String[] stringArray = (String[])ContainerUtil.map2Array(children2, String.class, id2 -> id2.getName().toString());
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] listPersisted(@NotNull VirtualFile parent) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(10);
        }
        int[] childrenIds = FSRecords.listIds(PersistentFSImpl.getFileId(parent));
        String[] names2 = ArrayUtil.newStringArray((int)childrenIds.length);
        for (int i2 = 0; i2 < childrenIds.length; ++i2) {
            names2[i2] = FSRecords.getName(childrenIds[i2]);
        }
        if (names2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(11);
        }
        return names2;
    }

    @NotNull
    private static List<? extends ChildInfo> persistAllChildren(@NotNull VirtualFile file2, int id2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(12);
        }
        NewVirtualFileSystem fs = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(file2));
        HashMap justCreated = new HashMap();
        String[] delegateNames = VfsUtil.filterNames((String[])fs.list(file2));
        ListResult saved = FSRecords.update(file2, id2, current2 -> {
            List<? extends ChildInfo> currentChildren = current2.children;
            if (delegateNames.length == 0 && !currentChildren.isEmpty()) {
                return current2;
            }
            Set toAddNames = CollectionFactory.createFilePathSet((String[])delegateNames, (boolean)file2.isCaseSensitive());
            for (ChildInfo childInfo : currentChildren) {
                toAddNames.remove(childInfo.getName().toString());
            }
            ArrayList<ChildInfo> toAddChildren = new ArrayList<ChildInfo>(toAddNames.size());
            if (fs instanceof BatchingFileSystem) {
                Map<String, FileAttributes> map2 = ((BatchingFileSystem)fs).listWithAttributes(file2, toAddNames);
                for (Map.Entry<String, FileAttributes> entry2 : map2.entrySet()) {
                    String newName2 = entry2.getKey();
                    Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, file2, newName2, entry2.getValue(), null);
                    if (childData == null) continue;
                    ChildInfo newChild = justCreated.computeIfAbsent(newName2, name -> PersistentFSImpl.makeChildRecord(file2, id2, name, childData, fs, null));
                    toAddChildren.add(newChild);
                }
            } else {
                for (String newName3 : toAddNames) {
                    Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, file2, newName3, null, null);
                    if (childData == null) continue;
                    ChildInfo newChild = justCreated.computeIfAbsent(newName3, name -> PersistentFSImpl.makeChildRecord(file2, id2, name, childData, fs, null));
                    toAddChildren.add(newChild);
                }
            }
            toAddChildren.sort(ChildInfo.BY_ID);
            return current2.merge(toAddChildren, file2.isCaseSensitive());
        });
        PersistentFSImpl.setChildrenCached(id2);
        List<? extends ChildInfo> list2 = saved.children;
        if (list2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private static void setChildrenCached(int id2) {
        int flags = FSRecords.getFlags(id2);
        FSRecords.setFlags(id2, flags | 1);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public List<? extends ChildInfo> listAll(@NotNull VirtualFile file2) {
        int id2;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(14);
        }
        if (PersistentFSImpl.areChildrenLoaded(id2 = PersistentFSImpl.getFileId(file2))) {
            List<? extends ChildInfo> list2 = FSRecords.list((int)id2).children;
            if (list2 == null) {
                PersistentFSImpl.$$$reportNull$$$0(15);
            }
            return list2;
        }
        return PersistentFSImpl.persistAllChildren(file2, id2);
    }

    private static boolean areChildrenLoaded(int parentId) {
        return BitUtil.isSet((int)FSRecords.getFlags(parentId), (int)1);
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(16);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(17);
        }
        return FSRecords.readAttributeWithLock(PersistentFSImpl.getFileId(file2), att);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(18);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(19);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeAttribute(PersistentFSImpl.getFileId(file2), att);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(20);
        }
        return dataOutputStream;
    }

    @Nullable
    private static DataInputStream readContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(21);
        }
        return FSRecords.readContent(PersistentFSImpl.getFileId(file2));
    }

    @NotNull
    private static DataInputStream readContentById(int contentId) {
        DataInputStream dataInputStream = FSRecords.readContentById(contentId);
        if (dataInputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(22);
        }
        return dataInputStream;
    }

    @NotNull
    private static DataOutputStream writeContent(@NotNull VirtualFile file2, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(23);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeContent(PersistentFSImpl.getFileId(file2), readOnly);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(24);
        }
        return dataOutputStream;
    }

    private static void writeContent(@NotNull VirtualFile file2, @NotNull ByteArraySequence content2, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(25);
        }
        if (content2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(26);
        }
        FSRecords.writeContent(PersistentFSImpl.getFileId(file2), content2, readOnly);
    }

    @Override
    public int storeUnlinkedContent(byte @NotNull [] bytes) {
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(27);
        }
        return FSRecords.storeUnlinkedContent(bytes);
    }

    public int getModificationCount(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(28);
        }
        return FSRecords.getModCount(PersistentFSImpl.getFileId(file2));
    }

    public int getModificationCount() {
        return FSRecords.getLocalModCount();
    }

    public int getStructureModificationCount() {
        return this.myStructureModificationCount.get();
    }

    public void incStructuralModificationCount() {
        this.myStructureModificationCount.incrementAndGet();
    }

    public int getFilesystemModificationCount() {
        return FSRecords.getPersistentModCount();
    }

    private static int writeAttributesToRecord(int id2, @Nullable VirtualFile parentFile, int parentId, @NotNull CharSequence name, @NotNull NewVirtualFileSystem fs, @NotNull FileAttributes attributes2) {
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(29);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(30);
        }
        if (attributes2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(31);
        }
        assert (id2 > 0) : id2;
        assert (parentId >= 0) : parentId;
        if (name.length() != 0 ? PersistentFSImpl.namesEqual((VirtualFileSystem)fs, parentFile, name, FSRecords.getNameSequence(id2)) : PersistentFSImpl.areChildrenLoaded(id2)) {
            return -1;
        }
        return FSRecords.writeAttributesToRecord(id2, parentId, attributes2, name.toString());
    }

    @Override
    public @PersistentFS.Attributes int getFileAttributes(int id2) {
        assert (id2 > 0);
        return FSRecords.getFlags(id2);
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(32);
        }
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    private static boolean namesEqual(@NotNull VirtualFileSystem fs, @Nullable VirtualFile parentFile, @NotNull CharSequence n1, @NotNull CharSequence n2) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(33);
        }
        if (n1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(34);
        }
        if (n2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(35);
        }
        return Comparing.equal((CharSequence)n1, (CharSequence)n2, (boolean)(parentFile == null ? fs.isCaseSensitive() : parentFile.isCaseSensitive()));
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            PersistentFSImpl.$$$reportNull$$$0(36);
        }
        return fileOrDirectory.exists();
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(37);
        }
        return FSRecords.getTimestamp(PersistentFSImpl.getFileId(file2));
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long modStamp) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(38);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        FSRecords.setTimestamp(id2, modStamp);
        PersistentFSImpl.getDelegate(file2).setTimeStamp(file2, modStamp);
    }

    private static int getFileId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(39);
        }
        return ((VirtualFileWithId)file2).getId();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(40);
        }
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(41);
        }
        return FSRecords.readSymlinkTarget(PersistentFSImpl.getFileId(file2));
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(42);
        }
        return !BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)4);
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(43);
        }
        return BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)64);
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(44);
        }
        PersistentFSImpl.getDelegate(file2).setWritable(file2, writableFlag);
        boolean oldWritable = this.isWritable(file2);
        if (oldWritable != writableFlag) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file2, "writable", (Object)oldWritable, (Object)writableFlag, false));
        }
    }

    @Override
    @ApiStatus.Internal
    public ChildInfo findChildInfo(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(45);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(46);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(47);
        }
        int parentId = PersistentFSImpl.getFileId(parent);
        Ref result2 = new Ref();
        Function<ListResult, ListResult> convertor = children2 -> {
            String canonicalName;
            ChildInfo child2 = PersistentFSImpl.findExistingChildInfo(parent, childName, children2.children, fs);
            if (child2 != null) {
                result2.set((Object)child2);
                return children2;
            }
            Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, parent, childName, null, null);
            if (childData == null) {
                return children2;
            }
            if (parent.isCaseSensitive()) {
                canonicalName = childName;
            } else {
                canonicalName = fs.getCanonicallyCasedName((VirtualFile)new FakeVirtualFile(parent, childName));
                if (Strings.isEmptyOrSpaces((CharSequence)canonicalName)) {
                    return children2;
                }
                if (!childName.equals(canonicalName)) {
                    child2 = PersistentFSImpl.findExistingChildInfo(parent, canonicalName, children2.children, fs);
                    result2.set((Object)child2);
                }
            }
            if (child2 == null) {
                if (result2.isNull()) {
                    child2 = PersistentFSImpl.makeChildRecord(parent, parentId, canonicalName, childData, fs, null);
                    result2.set((Object)child2);
                } else {
                    child2 = (ChildInfo)result2.get();
                }
                return children2.insert(child2);
            }
            return children2;
        };
        FSRecords.update(parent, parentId, convertor);
        return (ChildInfo)result2.get();
    }

    private static ChildInfo findExistingChildInfo(@NotNull VirtualFile parent, @NotNull String childName, @NotNull List<? extends ChildInfo> children2, @NotNull NewVirtualFileSystem fs) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(48);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(49);
        }
        if (children2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(50);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(51);
        }
        if (children2.isEmpty()) {
            return null;
        }
        int nameId = FSRecords.getNameId(childName);
        for (ChildInfo childInfo : children2) {
            if (nameId != childInfo.getNameId()) continue;
            return childInfo;
        }
        if (!parent.isCaseSensitive()) {
            for (ChildInfo childInfo : children2) {
                if (!PersistentFSImpl.namesEqual((VirtualFileSystem)fs, parent, childName, FSRecords.getNameByNameId(childInfo.getNameId()))) continue;
                return childInfo;
            }
        }
        return null;
    }

    public long getLength(@NotNull VirtualFile file2) {
        long length;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(52);
        }
        return (length = PersistentFSImpl.getLengthIfUpToDate(file2)) == -1L ? PersistentFSImpl.reloadLengthFromDelegate(file2, (FileSystemInterface)PersistentFSImpl.getDelegate(file2)) : length;
    }

    @Override
    public long getLastRecordedLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(53);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        return FSRecords.getLength(id2);
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(54);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(55);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(56);
        }
        PersistentFSImpl.getDelegate(file2).copyFile(requestor, file2, parent, name);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file2, parent, name));
        VirtualFile child2 = parent.findChild(name);
        if (child2 == null) {
            throw new IOException("Cannot create child");
        }
        VirtualFile virtualFile2 = child2;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(57);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        VirtualFile child2;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(58);
        }
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(59);
        }
        PersistentFSImpl.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, dir, true, null, null, false, ChildInfo.EMPTY_ARRAY));
        VFilePropertyChangeEvent caseSensitivityEvent = VfsImplUtil.generateCaseSensitivityChangedEventForUnknownCase(parent, dir);
        if (caseSensitivityEvent != null) {
            this.processEvent((VFileEvent)caseSensitivityEvent);
        }
        if ((child2 = parent.findChild(dir)) == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        VirtualFile virtualFile2 = child2;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(60);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        VirtualFile child2;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(61);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(62);
        }
        PersistentFSImpl.getDelegate(parent).createChildFile(requestor, parent, name);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, name, false, null, null, false, null));
        VFilePropertyChangeEvent caseSensitivityEvent = VfsImplUtil.generateCaseSensitivityChangedEventForUnknownCase(parent, name);
        if (caseSensitivityEvent != null) {
            this.processEvent((VFileEvent)caseSensitivityEvent);
        }
        if ((child2 = parent.findChild(name)) == null) {
            throw new IOException("Cannot create child file '" + name + "' at " + parent.getPath());
        }
        if (child2.getCharset().equals(StandardCharsets.UTF_8) && !(child2.getFileType() instanceof InternalFileType) && PersistentFSImpl.isUtf8BomRequired(child2)) {
            child2.setBOM(CharsetToolkit.UTF8_BOM);
        }
        VirtualFile virtualFile2 = child2;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(63);
        }
        return virtualFile2;
    }

    private static boolean isUtf8BomRequired(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(64);
        }
        for (Utf8BomOptionProvider encodingProvider : Utf8BomOptionProvider.EP_NAME.getIterable()) {
            if (!encodingProvider.shouldAddBOMForNewUtf8File(file2)) continue;
            return true;
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
        EncodingManager encodingManager = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        return encodingManager.shouldAddBOMForNewUtf8File();
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(65);
        }
        NewVirtualFileSystem delegate2 = PersistentFSImpl.getDelegate(file2);
        delegate2.deleteFile(requestor, file2);
        if (!delegate2.exists(file2)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file2, false));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(66);
        }
        if (newName2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(67);
        }
        PersistentFSImpl.getDelegate(file2).renameFile(requestor, file2, newName2);
        String oldName = file2.getName();
        if (!newName2.equals(oldName)) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file2, "name", (Object)oldName, (Object)newName2, false));
        }
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(68);
        }
        byte[] byArray = this.contentsToByteArray(file2, true);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(69);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2, boolean cacheContent) throws IOException {
        byte[] byArray;
        boolean reloadFromDelegate;
        boolean outdated;
        long length;
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(70);
        }
        DataInputStream contentStream = null;
        this.myInputLock.readLock().lock();
        try {
            fileId = PersistentFSImpl.getFileId(file2);
            length = PersistentFSImpl.getLengthIfUpToDate(file2);
            outdated = length == -1L || PersistentFSImpl.mustReloadContent(file2);
            reloadFromDelegate = outdated || (contentStream = PersistentFSImpl.readContent(file2)) == null;
        }
        finally {
            this.myInputLock.readLock().unlock();
        }
        if (reloadFromDelegate) {
            byte[] content2;
            NewVirtualFileSystem delegate2 = PersistentFSImpl.getDelegate(file2);
            if (outdated) {
                PersistentFSImpl.setLength(fileId, delegate2.getLength(file2));
                content2 = delegate2.contentsToByteArray(file2);
            } else {
                content2 = delegate2.contentsToByteArray(file2);
                PersistentFSImpl.setLength(fileId, content2.length);
            }
            Application application = ApplicationManager.getApplication();
            if ((!delegate2.isReadOnly() || cacheContent && !application.isInternal() && !application.isUnitTestMode()) && PersistentFSImpl.shouldCache(content2.length)) {
                this.myInputLock.writeLock().lock();
                try {
                    PersistentFSImpl.writeContent(file2, ByteArraySequence.create((byte[])content2), delegate2.isReadOnly());
                    PersistentFSImpl.setFlag(file2, 8, false);
                }
                finally {
                    this.myInputLock.writeLock().unlock();
                }
            }
            if (content2 == null) {
                PersistentFSImpl.$$$reportNull$$$0(71);
            }
            return content2;
        }
        try {
            assert (length >= 0L) : file2;
            byArray = contentStream.readNBytes((int)length);
        }
        catch (IOException e) {
            FSRecords.handleError(e);
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                PersistentFSImpl.$$$reportNull$$$0(73);
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(72);
        }
        return byArray;
    }

    @Override
    public byte @NotNull [] contentsToByteArray(int contentId) throws IOException {
        byte[] byArray = PersistentFSImpl.readContentById(contentId).readAllBytes();
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(74);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        InputStream contentStream;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(75);
        }
        boolean useReplicator = false;
        long len = 0L;
        boolean readOnly = false;
        this.myInputLock.readLock().lock();
        try {
            boolean mustReloadLength;
            long storedLength = PersistentFSImpl.getLengthIfUpToDate(file2);
            boolean bl = mustReloadLength = storedLength == -1L;
            if (mustReloadLength || PersistentFSImpl.mustReloadContent(file2) || FileUtilRt.isTooLarge((long)file2.getLength()) || (contentStream = PersistentFSImpl.readContent(file2)) == null) {
                NewVirtualFileSystem delegate2 = PersistentFSImpl.getDelegate(file2);
                len = mustReloadLength ? PersistentFSImpl.reloadLengthFromDelegate(file2, (FileSystemInterface)delegate2) : storedLength;
                contentStream = delegate2.getInputStream(file2);
                if (PersistentFSImpl.shouldCache(len)) {
                    useReplicator = true;
                    readOnly = delegate2.isReadOnly();
                }
            }
        }
        finally {
            this.myInputLock.readLock().unlock();
        }
        if (useReplicator) {
            contentStream = this.createReplicatorAndStoreContent(file2, contentStream, len, readOnly);
        }
        InputStream inputStream2 = contentStream;
        if (inputStream2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(76);
        }
        return inputStream2;
    }

    private static boolean shouldCache(long len) {
        return len <= PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD && !HeavyProcessLatch.INSTANCE.isRunning();
    }

    private static boolean mustReloadContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(77);
        }
        return BitUtil.isSet((int)FSRecords.getFlags(PersistentFSImpl.getFileId(file2)), (int)8);
    }

    private static long reloadLengthFromDelegate(@NotNull VirtualFile file2, @NotNull FileSystemInterface delegate2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(78);
        }
        if (delegate2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(79);
        }
        long len = delegate2.getLength(file2);
        int fileId = PersistentFSImpl.getFileId(file2);
        PersistentFSImpl.setLength(fileId, len);
        return len;
    }

    private static void setLength(int fileId, long len) {
        FSRecords.setLength(fileId, len);
        PersistentFSImpl.setFlag(fileId, 128, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private InputStream createReplicatorAndStoreContent(final @NotNull VirtualFile file2, @NotNull InputStream nativeStream, final long fileLength, boolean bl) {
        void readOnly;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(80);
        }
        if (nativeStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(81);
        }
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file2, (boolean)readOnly, bytes, bytes.length);
            InputStream inputStream2 = nativeStream;
            if (inputStream2 == null) {
                PersistentFSImpl.$$$reportNull$$$0(82);
            }
            return inputStream2;
        }
        BufferExposingByteArrayOutputStream cache2 = new BufferExposingByteArrayOutputStream((int)fileLength);
        return new ReplicatorInputStream(nativeStream, cache2, (boolean)readOnly, cache2){
            boolean isClosed;
            final /* synthetic */ boolean val$readOnly;
            final /* synthetic */ BufferExposingByteArrayOutputStream val$cache;
            {
                this.val$readOnly = bl;
                this.val$cache = bufferExposingByteArrayOutputStream;
                super(arg0, arg1);
            }

            public void close() throws IOException {
                if (!this.isClosed) {
                    try {
                        boolean isEndOfFileReached;
                        try {
                            isEndOfFileReached = this.available() < 0 || this.read() == -1;
                        }
                        catch (IOException ignored) {
                            isEndOfFileReached = false;
                        }
                        super.close();
                        if (isEndOfFileReached) {
                            PersistentFSImpl.this.storeContentToStorage(fileLength, file2, this.val$readOnly, this.val$cache.getInternalBuffer(), this.val$cache.size());
                        }
                    }
                    finally {
                        this.isClosed = true;
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file2, boolean readOnly, byte @NotNull [] bytes, int n) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(83);
        }
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(84);
        }
        this.myInputLock.writeLock().lock();
        try {
            void bytesLength;
            if ((long)bytesLength == fileLength) {
                PersistentFSImpl.writeContent(file2, new ByteArraySequence(bytes, 0, (int)bytesLength), readOnly);
                PersistentFSImpl.setFlag(file2, 8, false);
                PersistentFSImpl.setFlag(file2, 128, false);
            } else {
                PersistentFSImpl.doCleanPersistedContent(PersistentFSImpl.getFileId(file2));
            }
        }
        finally {
            this.myInputLock.writeLock().unlock();
        }
    }

    @TestOnly
    public static byte @Nullable [] getContentHashIfStored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(85);
        }
        return FSRecords.getContentHash(PersistentFSImpl.getFileId(file2));
    }

    private static long getLengthIfUpToDate(@NotNull VirtualFile file2) {
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(86);
        }
        return BitUtil.isSet((int)FSRecords.getFlags(fileId = PersistentFSImpl.getFileId(file2)), (int)128) ? -1L : FSRecords.getLength(fileId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, final Object requestor, final long modStamp, long l) {
        void timeStamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(87);
        }
        return new ByteArrayOutputStream((long)timeStamp){
            private boolean closed;
            final /* synthetic */ long val$timeStamp;
            {
                this.val$timeStamp = l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                super.close();
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                long oldLength = PersistentFSImpl.this.getLastRecordedLength(file2);
                VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file2, file2.getModificationStamp(), modStamp, file2.getTimeStamp(), -1L, oldLength, (long)this.count, false);
                List<VFileContentChangeEvent> events = Collections.singletonList(event);
                PersistentFSImpl.fireBeforeEvents(PersistentFSImpl.this.getPublisher(), events);
                NewVirtualFileSystem delegate2 = PersistentFSImpl.getDelegate(file2);
                try (DataOutputStream persistenceStream = PersistentFSImpl.writeContent(file2, delegate2.isReadOnly());){
                    ((OutputStream)persistenceStream).write(this.buf, 0, this.count);
                }
                catch (Throwable throwable) {
                    try {
                        try (OutputStream ioFileStream = delegate2.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);){
                            ioFileStream.write(this.buf, 0, this.count);
                        }
                        this.closed = true;
                    }
                    catch (Throwable throwable2) {
                        this.closed = true;
                        FileAttributes attributes2 = delegate2.getAttributes(file2);
                        long newTimestamp = attributes2 != null ? attributes2.lastModified : 0L;
                        long newLength = attributes2 != null ? attributes2.length : 0L;
                        PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), newLength, newTimestamp);
                        PersistentFSImpl.fireAfterEvents(PersistentFSImpl.this.getPublisher(), events);
                        throw throwable2;
                    }
                    FileAttributes attributes3 = delegate2.getAttributes(file2);
                    long newTimestamp = attributes3 != null ? attributes3.lastModified : 0L;
                    long newLength = attributes3 != null ? attributes3.length : 0L;
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), newLength, newTimestamp);
                    PersistentFSImpl.fireAfterEvents(PersistentFSImpl.this.getPublisher(), events);
                    throw throwable;
                }
                try {
                    try (OutputStream ioFileStream = delegate2.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);){
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    this.closed = true;
                }
                catch (Throwable throwable) {
                    this.closed = true;
                    FileAttributes attributes4 = delegate2.getAttributes(file2);
                    long newTimestamp = attributes4 != null ? attributes4.lastModified : 0L;
                    long newLength = attributes4 != null ? attributes4.length : 0L;
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), newLength, newTimestamp);
                    PersistentFSImpl.fireAfterEvents(PersistentFSImpl.this.getPublisher(), events);
                    throw throwable;
                }
                FileAttributes attributes5 = delegate2.getAttributes(file2);
                long newTimestamp = attributes5 != null ? attributes5.lastModified : 0L;
                long newLength = attributes5 != null ? attributes5.length : 0L;
                PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), newLength, newTimestamp);
                PersistentFSImpl.fireAfterEvents(PersistentFSImpl.this.getPublisher(), events);
            }
        };
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(88);
        }
        return FSRecords.acquireFileContent(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void releaseContent(int contentId) {
        FSRecords.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(89);
        }
        return FSRecords.getContentId(PersistentFSImpl.getFileId(file2));
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(90);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(91);
        }
        PersistentFSImpl.getDelegate(file2).moveFile(requestor, file2, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file2, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(92);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!event.isValid()) {
            return;
        }
        ArrayList<VFileEvent> outValidatedEvents = new ArrayList<VFileEvent>();
        outValidatedEvents.add(event);
        ArrayList<Runnable> outApplyActions = new ArrayList<Runnable>();
        List<VFileEvent> jarDeleteEvents = VfsImplUtil.getJarInvalidationEvents(event, outApplyActions);
        BulkFileListener publisher = this.getPublisher();
        if (jarDeleteEvents.isEmpty() && outApplyActions.isEmpty()) {
            PersistentFSImpl.fireBeforeEvents(publisher, outValidatedEvents);
            this.applyEvent(event);
            PersistentFSImpl.fireAfterEvents(publisher, outValidatedEvents);
        } else {
            outApplyActions.add(() -> this.applyEvent(event));
            for (VFileEvent jarDeleteEvent : jarDeleteEvents) {
                outApplyActions.add(() -> this.applyEvent(jarDeleteEvent));
                outValidatedEvents.add(jarDeleteEvent);
            }
            PersistentFSImpl.applyMultipleEvents(publisher, outApplyActions, outValidatedEvents, false);
        }
    }

    private static int groupByPath(List<? extends CompoundVFileEvent> events, int startIndex, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved, @NotNull Set<? super VirtualFile> deleted, @NotNull Map<VirtualDirectoryImpl, Object> toCreate, @NotNull Set<? super VFileEvent> eventsToRemove) {
        int i2;
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(93);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(94);
        }
        if (deleted == null) {
            PersistentFSImpl.$$$reportNull$$$0(95);
        }
        if (toCreate == null) {
            PersistentFSImpl.$$$reportNull$$$0(96);
        }
        if (eventsToRemove == null) {
            PersistentFSImpl.$$$reportNull$$$0(97);
        }
        for (i2 = startIndex; i2 < events.size(); ++i2) {
            String path2;
            VFileEvent event = events.get(i2).getFileEvent();
            String path3 = event.getPath();
            if (event instanceof VFileDeleteEvent && PersistentFSImpl.removeNestedDelete(((VFileDeleteEvent)event).getFile(), deleted)) {
                eventsToRemove.add((VFileEvent)event);
                continue;
            }
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                VirtualDirectoryImpl parent = (VirtualDirectoryImpl)createEvent.getParent();
                LinkedHashSet<VFileCreateEvent> createEvents = toCreate.get((Object)parent);
                if (createEvents == null) {
                    toCreate.put(parent, createEvent);
                } else {
                    Collection children2;
                    if (createEvents instanceof VFileCreateEvent) {
                        VFileCreateEvent prevEvent = (VFileCreateEvent)createEvents;
                        LinkedHashSet<VFileCreateEvent> children3 = parent.isCaseSensitive() ? new LinkedHashSet<VFileCreateEvent>() : new ObjectLinkedOpenCustomHashSet(CASE_INSENSITIVE_STRATEGY);
                        children3.add(prevEvent);
                        toCreate.put(parent, children3);
                        createEvents = children3;
                    }
                    if (!(children2 = (Collection)createEvents).add(createEvent)) {
                        eventsToRemove.add((VFileEvent)createEvent);
                        continue;
                    }
                }
            }
            if (PersistentFSImpl.eventConflictsWithPrevious(event, path3, filesInvolved, middleDirsInvolved) || (path2 = PersistentFSImpl.getAlternativePath(event)) != null && !(!SystemInfoRt.isFileSystemCaseSensitive ? path2.equalsIgnoreCase(path3) : path2.equals(path3)) && PersistentFSImpl.eventConflictsWithPrevious(event, path2, filesInvolved, middleDirsInvolved)) break;
        }
        return i2;
    }

    private static String getAlternativePath(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(98);
        }
        if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name")) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            VirtualFile parent = pce.getFile().getParent();
            String newName2 = (String)pce.getNewValue();
            return parent == null ? newName2 : parent.getPath() + "/" + newName2;
        }
        if (event instanceof VFileCopyEvent) {
            return ((VFileCopyEvent)event).getFile().getPath();
        }
        if (event instanceof VFileMoveEvent) {
            VFileMoveEvent vme = (VFileMoveEvent)event;
            String newName3 = vme.getFile().getName();
            return vme.getNewParent().getPath() + "/" + newName3;
        }
        return null;
    }

    private static boolean removeNestedDelete(@NotNull VirtualFile file2, @NotNull Set<? super VirtualFile> deleted) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(99);
        }
        if (deleted == null) {
            PersistentFSImpl.$$$reportNull$$$0(100);
        }
        if (!deleted.add((VirtualFile)file2)) {
            return true;
        }
        while ((file2 = file2.getParent()) != null) {
            if (!deleted.contains(file2)) continue;
            return true;
        }
        return false;
    }

    private static boolean eventConflictsWithPrevious(@NotNull VFileEvent event, @NotNull String path2, @NotNull MostlySingularMultiMap<String, VFileEvent> files2, @NotNull Set<? super String> middleDirs) {
        int liPrev;
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(101);
        }
        if (path2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(102);
        }
        if (files2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(103);
        }
        if (middleDirs == null) {
            PersistentFSImpl.$$$reportNull$$$0(104);
        }
        boolean canReconcileEvents = true;
        for (VFileEvent prev2 : files2.get((Object)path2)) {
            if (PersistentFSImpl.isContentChangeLikeHarmlessEvent(event) && PersistentFSImpl.isContentChangeLikeHarmlessEvent(prev2)) continue;
            canReconcileEvents = false;
            break;
        }
        if (!canReconcileEvents) {
            return true;
        }
        if (middleDirs.contains(path2)) {
            return true;
        }
        files2.add((Object)path2, (Object)event);
        int li = path2.length();
        while ((liPrev = path2.lastIndexOf(47, li - 1)) != -1) {
            String parentDir = path2.substring(0, liPrev);
            if (files2.containsKey((Object)parentDir)) {
                return true;
            }
            if (!middleDirs.add(parentDir)) break;
            li = liPrev;
        }
        return false;
    }

    private static boolean isContentChangeLikeHarmlessEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(105);
        }
        if (event instanceof VFileContentChangeEvent) {
            return true;
        }
        if (event instanceof VFilePropertyChangeEvent) {
            String prop = ((VFilePropertyChangeEvent)event).getPropertyName();
            return prop.equals("writable") || prop.equals("encoding") || prop.equals("CHILDREN_CASE_SENSITIVITY");
        }
        return false;
    }

    private int groupAndValidate(@NotNull List<? extends CompoundVFileEvent> events, int startIndex, @NotNull List<? super Runnable> outApplyActions, @NotNull List<? super VFileEvent> outValidatedEvents, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved, @NotNull Map<VirtualDirectoryImpl, Object> toCreate, @NotNull Set<VFileEvent> toIgnore, @NotNull Set<? super VirtualFile> toDelete, boolean excludeAsyncListeners) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(106);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(107);
        }
        if (outValidatedEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(108);
        }
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(109);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(110);
        }
        if (toCreate == null) {
            PersistentFSImpl.$$$reportNull$$$0(111);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(112);
        }
        if (toDelete == null) {
            PersistentFSImpl.$$$reportNull$$$0(113);
        }
        int endIndex = PersistentFSImpl.groupByPath(events, startIndex, filesInvolved, middleDirsInvolved, toDelete, toCreate, toIgnore);
        assert (endIndex > startIndex) : events.get(startIndex) + "; files: " + filesInvolved + "; middleDirs: " + middleDirsInvolved;
        this.groupCreations(outValidatedEvents, outApplyActions, toCreate);
        this.groupDeletions(events, startIndex, endIndex, outValidatedEvents, outApplyActions, toIgnore);
        this.groupOthers(events, startIndex, endIndex, outValidatedEvents, outApplyActions);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            CompoundVFileEvent event = events.get(i2);
            outApplyActions.addAll(event.getApplyActions());
            if (excludeAsyncListeners && !event.areInducedEventsCalculated()) {
                LOG.error("Nested file events must be processed by async file listeners! Event: " + event);
            }
            for (VFileEvent jarDeleteEvent : event.getInducedEvents()) {
                outApplyActions.add(() -> this.applyEvent(jarDeleteEvent));
                outValidatedEvents.add((VFileEvent)jarDeleteEvent);
            }
        }
        return endIndex;
    }

    private void groupCreations(@NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyActions, @NotNull Map<VirtualDirectoryImpl, Object> created) {
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(114);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(115);
        }
        if (created == null) {
            PersistentFSImpl.$$$reportNull$$$0(116);
        }
        if (!created.isEmpty()) {
            boolean hasValidEvents = false;
            for (Map.Entry<VirtualDirectoryImpl, Object> entry2 : created.entrySet()) {
                VirtualDirectoryImpl directory = entry2.getKey();
                Object value2 = entry2.getValue();
                Set<Object> createEvents = value2 instanceof VFileCreateEvent ? new HashSet<VFileCreateEvent>(Collections.singletonList((VFileCreateEvent)value2)) : (Set)value2;
                directory.validateChildrenToCreate(createEvents);
                hasValidEvents |= !createEvents.isEmpty();
                outValidated.addAll(createEvents);
                entry2.setValue(createEvents);
            }
            if (hasValidEvents) {
                Map<VirtualDirectoryImpl, Object> finalGrouped = created;
                outApplyActions.add(() -> {
                    this.applyCreations(finalGrouped);
                    this.incStructuralModificationCount();
                });
            }
        }
    }

    private void groupDeletions(@NotNull List<? extends CompoundVFileEvent> events, int start2, int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyActions, @NotNull Set<? extends VFileEvent> toIgnore) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(117);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(118);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(119);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(120);
        }
        MultiMap grouped = null;
        boolean hasValidEvents = false;
        for (int i2 = start2; i2 < end; ++i2) {
            VFileEvent event = events.get(i2).getFileEvent();
            if (!(event instanceof VFileDeleteEvent) || toIgnore.contains(event) || !event.isValid()) continue;
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)de.getFile().getParent();
            if (grouped == null) {
                grouped = new MultiMap(end - start2);
            }
            grouped.putValue((Object)parent, (Object)de);
            outValidated.add((VFileEvent)event);
            hasValidEvents = true;
        }
        if (hasValidEvents) {
            MultiMap finalGrouped = grouped;
            outApplyActions.add(() -> {
                this.clearIdCache();
                this.applyDeletions((MultiMap<VirtualDirectoryImpl, VFileDeleteEvent>)finalGrouped);
                this.incStructuralModificationCount();
            });
        }
    }

    private void groupOthers(@NotNull List<? extends CompoundVFileEvent> events, int start2, int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyActions) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(121);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(122);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(123);
        }
        for (int i2 = start2; i2 < end; ++i2) {
            VFileEvent event = events.get(i2).getFileEvent();
            if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || !event.isValid()) continue;
            outValidated.add((VFileEvent)event);
            outApplyActions.add(() -> this.applyEvent(event));
        }
    }

    @Override
    public void processEvents(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(124);
        }
        this.processEventsImpl(ContainerUtil.map(events, e -> new CompoundVFileEvent((VFileEvent)e)), false);
    }

    @ApiStatus.Internal
    public void processEventsImpl(@NotNull List<? extends CompoundVFileEvent> events, boolean excludeAsyncListeners) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(125);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        int startIndex = 0;
        int cappedInitialSize = Math.min(events.size(), 1024);
        ArrayList applyActions = new ArrayList(cappedInitialSize);
        MostlySingularMultiMap files2 = new MostlySingularMultiMap(CollectionFactory.createFilePathMap((int)cappedInitialSize));
        Set middleDirs = CollectionFactory.createFilePathSet((int)cappedInitialSize);
        ArrayList validated = new ArrayList(cappedInitialSize);
        BulkFileListener publisher = this.getPublisher();
        LinkedHashMap<VirtualDirectoryImpl, Object> toCreate = new LinkedHashMap<VirtualDirectoryImpl, Object>();
        ReferenceOpenHashSet toIgnore = new ReferenceOpenHashSet();
        Set toDelete = CollectionFactory.createSmallMemoryFootprintSet();
        while (startIndex != events.size()) {
            PingProgress.interactWithEdtProgress();
            applyActions.clear();
            files2.clear();
            middleDirs.clear();
            validated.clear();
            toCreate.clear();
            toIgnore.clear();
            toDelete.clear();
            startIndex = this.groupAndValidate(events, startIndex, applyActions, validated, (MostlySingularMultiMap<String, VFileEvent>)files2, middleDirs, toCreate, (Set<VFileEvent>)toIgnore, toDelete, excludeAsyncListeners);
            if (validated.isEmpty()) continue;
            PersistentFSImpl.applyMultipleEvents(publisher, applyActions, validated, excludeAsyncListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyMultipleEvents(@NotNull BulkFileListener publisher, @NotNull List<? extends Runnable> applyActions, @NotNull List<? extends VFileEvent> applyEvents, boolean excludeAsyncListeners) {
        if (publisher == null) {
            PersistentFSImpl.$$$reportNull$$$0(126);
        }
        if (applyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(127);
        }
        if (applyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(128);
        }
        PingProgress.interactWithEdtProgress();
        ImmutableList toSend = ContainerUtil.immutableList((Object[])applyEvents.toArray(new VFileEvent[0]));
        try {
            if (excludeAsyncListeners) {
                AsyncEventSupport.markAsynchronouslyProcessedEvents((List<? extends VFileEvent>)toSend);
            }
            PersistentFSImpl.fireBeforeEvents(publisher, (List<? extends VFileEvent>)toSend);
            PingProgress.interactWithEdtProgress();
            applyActions.forEach(Runnable::run);
            PingProgress.interactWithEdtProgress();
            PersistentFSImpl.fireAfterEvents(publisher, (List<? extends VFileEvent>)toSend);
        }
        finally {
            if (excludeAsyncListeners) {
                AsyncEventSupport.unmarkAsynchronouslyProcessedEvents((List<? extends VFileEvent>)toSend);
            }
        }
    }

    private static void fireBeforeEvents(@NotNull BulkFileListener publisher, @NotNull List<? extends VFileEvent> toSend) {
        if (publisher == null) {
            PersistentFSImpl.$$$reportNull$$$0(129);
        }
        if (toSend == null) {
            PersistentFSImpl.$$$reportNull$$$0(130);
        }
        publisher.before(toSend);
        ((BulkFileListener)VirtualFilePointerManager.getInstance()).before(toSend);
    }

    private static void fireAfterEvents(@NotNull BulkFileListener publisher, @NotNull List<? extends VFileEvent> toSend) {
        if (publisher == null) {
            PersistentFSImpl.$$$reportNull$$$0(131);
        }
        if (toSend == null) {
            PersistentFSImpl.$$$reportNull$$$0(132);
        }
        CachedFileType.clearCache();
        ((BulkFileListener)VirtualFilePointerManager.getInstance()).after(toSend);
        publisher.after(toSend);
    }

    private void applyDeletions(@NotNull MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> deletions) {
        if (deletions == null) {
            PersistentFSImpl.$$$reportNull$$$0(133);
        }
        for (Map.Entry entry2 : deletions.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry2.getKey());
            Collection deleteEvents = (Collection)entry2.getValue();
            if (parent == null || !parent.isValid()) {
                deleteEvents.forEach(this::applyEvent);
                return;
            }
            int parentId = PersistentFSImpl.getFileId((VirtualFile)parent);
            ArrayList<CharSequence> childrenNamesDeleted = new ArrayList<CharSequence>(deleteEvents.size());
            IntOpenHashSet childrenIdsDeleted = new IntOpenHashSet(deleteEvents.size());
            ArrayList<ChildInfoImpl> deleted = new ArrayList<ChildInfoImpl>(deleteEvents.size());
            for (VFileDeleteEvent event : deleteEvents) {
                VirtualFile file2 = event.getFile();
                int id2 = PersistentFSImpl.getFileId(file2);
                childrenNamesDeleted.add(file2.getNameSequence());
                childrenIdsDeleted.add(id2);
                FSRecords.deleteRecordRecursively(id2);
                PersistentFSImpl.invalidateSubtree(file2, "Bulk file deletions", event);
                deleted.add(new ChildInfoImpl(id2, -238, null, null, null));
            }
            deleted.sort(ChildInfo.BY_ID);
            FSRecords.update((VirtualFile)parent, parentId, oldChildren -> oldChildren.subtract(deleted));
            parent.removeChildren((IntSet)childrenIdsDeleted, childrenNamesDeleted);
        }
    }

    private void applyCreations(@NotNull Map<VirtualDirectoryImpl, Set<VFileCreateEvent>> creations) {
        if (creations == null) {
            PersistentFSImpl.$$$reportNull$$$0(134);
        }
        for (Map.Entry<VirtualDirectoryImpl, Set<VFileCreateEvent>> entry2 : creations.entrySet()) {
            VirtualDirectoryImpl parent = entry2.getKey();
            Collection createEvents = entry2.getValue();
            this.applyCreateEventsInDirectory(parent, createEvents);
        }
    }

    private void applyCreateEventsInDirectory(@NotNull VirtualDirectoryImpl parent, @NotNull Collection<? extends VFileCreateEvent> createEvents) {
        int parentId;
        NewVirtualFile vf;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(135);
        }
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(136);
        }
        if (!((vf = this.findFileById(parentId = PersistentFSImpl.getFileId((VirtualFile)parent))) instanceof VirtualDirectoryImpl)) {
            return;
        }
        parent = (VirtualDirectoryImpl)vf;
        NewVirtualFileSystem delegate2 = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate((VirtualFile)parent));
        ArrayList<ChildInfo> childrenAdded = new ArrayList<ChildInfo>(createEvents.size());
        for (VFileCreateEvent vFileCreateEvent : createEvents) {
            vFileCreateEvent.resetCache();
            String name = vFileCreateEvent.getChildName();
            Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate2, vFileCreateEvent.getParent(), name, vFileCreateEvent.getAttributes(), vFileCreateEvent.getSymlinkTarget());
            if (childData == null) continue;
            ChildInfo child2 = PersistentFSImpl.makeChildRecord((VirtualFile)parent, parentId, name, childData, delegate2, vFileCreateEvent.getChildren());
            childrenAdded.add(child2);
        }
        childrenAdded.sort(ChildInfo.BY_ID);
        boolean caseSensitive = parent.isCaseSensitive();
        FSRecords.update((VirtualFile)parent, parentId, oldChildren -> oldChildren.merge(childrenAdded, caseSensitive));
        parent.createAndAddChildren(childrenAdded, false, (PairConsumer<? super VirtualFile, ? super ChildInfo>)((PairConsumer)(__, ___) -> {}));
        PersistentFSImpl.saveScannedChildrenRecursively(createEvents, delegate2, parent.isCaseSensitive());
    }

    private static void saveScannedChildrenRecursively(@NotNull Collection<? extends VFileCreateEvent> createEvents, @NotNull NewVirtualFileSystem delegate2, boolean isCaseSensitive) {
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(137);
        }
        if (delegate2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(138);
        }
        for (VFileCreateEvent vFileCreateEvent : createEvents) {
            VirtualFile createdDir;
            ChildInfo[] children2 = vFileCreateEvent.getChildren();
            if (children2 == null || !vFileCreateEvent.isDirectory() || !((createdDir = vFileCreateEvent.getFile()) instanceof VirtualDirectoryImpl)) continue;
            ArrayDeque<Pair> queue2 = new ArrayDeque<Pair>();
            queue2.add(new Pair((Object)((VirtualDirectoryImpl)createdDir), (Object)children2));
            while (!queue2.isEmpty()) {
                Pair queued = (Pair)queue2.remove();
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)((Object)queued.first);
                List<ChildInfo> scannedChildren = Arrays.asList((ChildInfo[])queued.second);
                int directoryId = directory.getId();
                ArrayList<ChildInfo> added2 = new ArrayList<ChildInfo>(scannedChildren.size());
                for (ChildInfo childInfo2 : scannedChildren) {
                    CharSequence childName = childInfo2.getName();
                    Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate2, (VirtualFile)directory, childName.toString(), childInfo2.getFileAttributes(), childInfo2.getSymlinkTarget());
                    if (childData == null) continue;
                    ChildInfo newChild = PersistentFSImpl.makeChildRecord((VirtualFile)directory, directoryId, childName, childData, delegate2, childInfo2.getChildren());
                    added2.add(newChild);
                }
                added2.sort(ChildInfo.BY_ID);
                FSRecords.update((VirtualFile)directory, directoryId, oldChildren -> oldChildren.merge(added2, isCaseSensitive));
                PersistentFSImpl.setChildrenCached(directoryId);
                directory.createAndAddChildren(added2, true, (PairConsumer<? super VirtualFile, ? super ChildInfo>)((PairConsumer)(childCreated, childInfo) -> {
                    if (childCreated instanceof VirtualDirectoryImpl && childInfo.getChildren() != null) {
                        queue2.add(new Pair((Object)((VirtualDirectoryImpl)((Object)((Object)childCreated))), (Object)childInfo.getChildren()));
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String path2, @NotNull NewVirtualFileSystem fs) {
        boolean mark;
        FsRoot newRoot;
        FileAttributes parentAttributes;
        String parentPath;
        String rootPath;
        CharSequence rootName;
        if (path2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(139);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(140);
        }
        if (path2.isEmpty()) {
            LOG.error("Invalid root, fs=" + fs);
            return null;
        }
        String rootUrl = UriUtil.trimTrailingSlashes(VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)path2));
        VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
        if (root != null) {
            return root;
        }
        if (fs instanceof ArchiveFileSystem) {
            ArchiveFileSystem afs = (ArchiveFileSystem)fs;
            VirtualFile localFile = afs.findLocalByRootPath(path2);
            if (localFile == null) {
                return null;
            }
            rootName = localFile.getNameSequence();
            rootPath = afs.getRootPathByLocal(localFile);
            rootUrl = UriUtil.trimTrailingSlashes(VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)rootPath));
        } else {
            rootPath = path2;
            rootName = rootPath;
        }
        FileAttributes attributes2 = PersistentFSImpl.loadAttributes(fs, rootPath);
        if (attributes2 == null || !attributes2.isDirectory()) {
            return null;
        }
        attributes2 = attributes2.withCaseSensitivity(fs.isCaseSensitive() ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE);
        String string = parentPath = fs instanceof LocalFileSystem ? PathUtil.getParentPath((String)rootPath) : "";
        if (!parentPath.isEmpty() && (parentAttributes = PersistentFSImpl.loadAttributes(fs, parentPath)) != null) {
            throw new IllegalArgumentException("Must pass FS root path, but got: '" + path2 + "', which has a parent '" + parentPath + "'. Use NewVirtualFileSystem.extractRootPath() for obtaining root path");
        }
        int rootId = FSRecords.findRootRecord(rootUrl);
        int rootNameId = FileNameCache.storeName(rootName.toString());
        Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
        synchronized (map2) {
            root = this.myRoots.get(rootUrl);
            if (root != null) {
                return root;
            }
            try {
                String pathBeforeSlash = StringUtil.trimTrailing((String)rootPath, (char)'/');
                newRoot = new FsRoot(rootId, rootNameId, this.myVfsData, fs, pathBeforeSlash, attributes2, path2);
            }
            catch (VfsData.FileAlreadyCreatedException e) {
                for (Map.Entry<String, VirtualFileSystemEntry> entry2 : this.myRoots.entrySet()) {
                    VirtualFileSystemEntry existingRoot = entry2.getValue();
                    if (existingRoot.getId() != rootId) continue;
                    String message2 = "Duplicate FS roots: " + rootUrl + " / " + entry2.getKey() + " id=" + rootId + " valid=" + existingRoot.isValid();
                    throw new RuntimeException(message2, e);
                }
                throw new RuntimeException("No root duplication, rootName='" + rootName + "'; rootNameId=" + rootNameId + "; rootId=" + rootId + "; path='" + path2 + "'; fs=" + fs + "; rootUrl='" + rootUrl + "'", e);
            }
            this.incStructuralModificationCount();
            mark = PersistentFSImpl.writeAttributesToRecord(rootId, null, 0, rootName, fs, attributes2) != -1;
            this.myRoots.put(rootUrl, newRoot);
            this.myIdToDirCache.put(rootId, (Object)newRoot);
        }
        if (!mark && attributes2.lastModified != FSRecords.getTimestamp(rootId)) {
            ((VirtualFileSystemEntry)newRoot).markDirtyRecursively();
        }
        LOG.assertTrue(rootId == newRoot.getId(), (Object)("root=" + newRoot + " expected=" + rootId + " actual=" + newRoot.getId()));
        return newRoot;
    }

    @Nullable
    private static FileAttributes loadAttributes(@NotNull NewVirtualFileSystem fs, final @NotNull String path2) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(141);
        }
        if (path2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(142);
        }
        StubVirtualFile file2 = new StubVirtualFile((VirtualFileSystem)fs){

            @NotNull
            public String getPath() {
                String string = path2;
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public VirtualFile getParent() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$4", "getPath"));
            }
        };
        return fs.getAttributes((VirtualFile)file2);
    }

    @Override
    public void clearIdCache() {
        this.myIdToDirCache.entrySet().removeIf(e -> ((VirtualFileSystemEntry)((Object)((Object)e.getValue()))).getParent() != null);
    }

    @Nullable
    public NewVirtualFile findFileById(int id2) {
        VirtualFileSystemEntry cached = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id2));
        return cached != null ? cached : FSRecords.findFileById(id2, this.myIdToDirCache);
    }

    @Override
    public NewVirtualFile findFileByIdIfCached(int id2) {
        return this.myVfsData.hasLoadedFile(id2) ? this.findFileById(id2) : null;
    }

    public VirtualFile @NotNull [] getRoots() {
        Collection<VirtualFileSystemEntry> roots = this.myRoots.values();
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(143);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getRoots(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(144);
        }
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (newVirtualFile.getFileSystem() != fs) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(145);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getLocalRoots() {
        SmartList roots = new SmartList();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (!newVirtualFile.isInLocalFileSystem() || newVirtualFile.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(146);
        }
        return virtualFileArray;
    }

    private void applyEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(147);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying " + event);
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent ce = (VFileCreateEvent)event;
                this.executeCreateChild(ce.getParent(), ce.getChildName(), ce.getAttributes(), ce.getSymlinkTarget(), ce.isEmptyDirectory());
            } else if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent);
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                VirtualFile file2 = contentUpdateEvent.getFile();
                long length = contentUpdateEvent.getNewLength();
                long timestamp = contentUpdateEvent.getNewTimestamp();
                if (!contentUpdateEvent.isLengthAndTimestampDiffProvided()) {
                    NewVirtualFileSystem delegate2 = PersistentFSImpl.getDelegate(file2);
                    FileAttributes attributes2 = delegate2.getAttributes(file2);
                    length = attributes2 != null ? attributes2.length : 0L;
                    timestamp = attributes2 != null ? attributes2.lastModified : 0L;
                }
                PersistentFSImpl.executeTouch(file2, contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp(), length, timestamp);
            } else if (event instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)event;
                this.executeCreateChild(ce.getNewParent(), ce.getNewChildName(), null, null, ce.getFile().getChildren().length == 0);
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
            } else if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                VirtualFile file3 = propertyChangeEvent.getFile();
                Object newValue2 = propertyChangeEvent.getNewValue();
                switch (propertyChangeEvent.getPropertyName()) {
                    case "name": {
                        PersistentFSImpl.executeRename(file3, (String)newValue2);
                        break;
                    }
                    case "writable": {
                        PersistentFSImpl.executeSetWritable(file3, (Boolean)newValue2);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("File " + file3 + " writable=" + file3.isWritable() + " id=" + PersistentFSImpl.getFileId(file3));
                        break;
                    }
                    case "HIDDEN": {
                        PersistentFSImpl.executeSetHidden(file3, (Boolean)newValue2);
                        break;
                    }
                    case "symlink": {
                        PersistentFSImpl.executeSetTarget(file3, (String)newValue2);
                        break;
                    }
                    case "CHILDREN_CASE_SENSITIVITY": {
                        PersistentFSImpl.executeChangeCaseSensitivity(file3, (FileAttributes.CaseSensitivity)newValue2);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void executeChangeCaseSensitivity(@NotNull VirtualFile file2, @NotNull FileAttributes.CaseSensitivity newCaseSensitivity) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(148);
        }
        if (newCaseSensitivity == null) {
            PersistentFSImpl.$$$reportNull$$$0(149);
        }
        VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file2;
        PersistentFSImpl.setFlag((VirtualFile)directory, 256, newCaseSensitivity == FileAttributes.CaseSensitivity.SENSITIVE);
        PersistentFSImpl.setFlag((VirtualFile)directory, 512, true);
        directory.setCaseSensitivityFlag(newCaseSensitivity);
    }

    public String toString() {
        return "PersistentFS";
    }

    private void executeCreateChild(@NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes2, @Nullable String symlinkTarget, boolean isEmptyDirectory) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(150);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(151);
        }
        NewVirtualFileSystem delegate2 = PersistentFSImpl.getDelegate(parent);
        int parentId = PersistentFSImpl.getFileId(parent);
        Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate2, parent, name, attributes2, symlinkTarget);
        if (childData == null) {
            return;
        }
        ChildInfo childInfo = PersistentFSImpl.makeChildRecord(parent, parentId, name, childData, delegate2, null);
        FSRecords.update(parent, parentId, children2 -> {
            ChildInfo duplicate = PersistentFSImpl.findExistingChildInfo(parent, name, children2.children, delegate2);
            if (duplicate != null) {
                return children2;
            }
            return children2.insert(childInfo);
        });
        int childId = childInfo.getId();
        assert (parent instanceof VirtualDirectoryImpl) : parent;
        VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
        VirtualFileSystemEntry child2 = dir.createChild(name, childId, dir.getFileSystem(), PersistentFSImpl.fileAttributesToFlags((FileAttributes)childData.first), isEmptyDirectory);
        if (isEmptyDirectory) {
            PersistentFSImpl.setChildrenCached(childId);
        }
        dir.addChild(child2);
        this.incStructuralModificationCount();
    }

    @NotNull
    private static ChildInfo makeChildRecord(@NotNull VirtualFile parentFile, int parentId, @NotNull CharSequence name, @NotNull @NotNull Pair<@NotNull FileAttributes, String> childData, @NotNull NewVirtualFileSystem fs, ChildInfo @Nullable [] children2) {
        if (parentFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(152);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(153);
        }
        if (childData == null) {
            PersistentFSImpl.$$$reportNull$$$0(154);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(155);
        }
        int childId = FSRecords.createRecord();
        FileAttributes attributes2 = (FileAttributes)childData.first;
        int nameId = PersistentFSImpl.writeAttributesToRecord(childId, parentFile, parentId, name, fs, attributes2);
        assert (childId > 0) : childId;
        return new ChildInfoImpl(childId, nameId, attributes2, children2, (String)childData.second);
    }

    private static @Nullable Pair<@NotNull FileAttributes, String> getChildData(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes2, @Nullable String symlinkTarget) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(156);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(157);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(158);
        }
        if (attributes2 == null) {
            FakeVirtualFile virtualFile2 = new FakeVirtualFile(parent, name);
            attributes2 = fs.getAttributes((VirtualFile)virtualFile2);
            symlinkTarget = attributes2 != null && attributes2.isSymLink() ? fs.resolveSymLink((VirtualFile)virtualFile2) : null;
        }
        return attributes2 == null ? null : new Pair((Object)attributes2, (Object)symlinkTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VFileDeleteEvent event) {
        int parentId;
        VirtualFile file2;
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(159);
        }
        if (!(file2 = event.getFile()).exists()) {
            LOG.error("Deleting a file which does not exist: " + ((VirtualFileWithId)file2).getId() + " " + file2.getPath());
            return;
        }
        this.clearIdCache();
        int id2 = PersistentFSImpl.getFileId(file2);
        VirtualFile parent = file2.getParent();
        int n = parentId = parent == null ? 0 : PersistentFSImpl.getFileId(parent);
        if (parentId == 0) {
            String rootUrl = UriUtil.trimTrailingSlashes(file2.getUrl());
            Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
            synchronized (map2) {
                this.myRoots.remove(rootUrl);
                this.myIdToDirCache.remove(id2);
                FSRecords.deleteRootRecord(id2);
            }
        } else {
            PersistentFSImpl.removeIdFromChildren(parent, parentId, id2);
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file2.getParent();
            assert (directory != null) : file2;
            directory.removeChild(file2);
        }
        FSRecords.deleteRecordRecursively(id2);
        PersistentFSImpl.invalidateSubtree(file2, "File deleted", event);
        this.incStructuralModificationCount();
    }

    private static void invalidateSubtree(@NotNull VirtualFile file2, @NotNull Object source, @NotNull Object reason) {
        VirtualFileSystem fs;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(160);
        }
        if (source == null) {
            PersistentFSImpl.$$$reportNull$$$0(161);
        }
        if (reason == null) {
            PersistentFSImpl.$$$reportNull$$$0(162);
        }
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file2;
        if (file2.is(VFileProperty.SYMLINK) && (fs = file2.getFileSystem()) instanceof LocalFileSystemImpl) {
            ((LocalFileSystemImpl)fs).symlinkRemoved(impl.getId());
        }
        impl.invalidate(source, reason);
        for (VirtualFile child2 : impl.getCachedChildren()) {
            PersistentFSImpl.invalidateSubtree(child2, source, reason);
        }
    }

    private static void removeIdFromChildren(@NotNull VirtualFile parent, int parentId, int childId) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(163);
        }
        ChildInfoImpl toRemove2 = new ChildInfoImpl(childId, -238, null, null, null);
        FSRecords.update(parent, parentId, list2 -> list2.remove(toRemove2));
    }

    private static void executeRename(@NotNull VirtualFile file2, @NotNull String newName2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(164);
        }
        if (newName2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(165);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        FSRecords.setName(id2, newName2);
        ((VirtualFileSystemEntry)file2).setNewName(newName2);
    }

    private static void executeSetWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(166);
        }
        PersistentFSImpl.setFlag(file2, 4, !writableFlag);
        ((VirtualFileSystemEntry)file2).setWritableFlag(writableFlag);
    }

    private static void executeSetHidden(@NotNull VirtualFile file2, boolean hiddenFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(167);
        }
        PersistentFSImpl.setFlag(file2, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file2).setHiddenFlag(hiddenFlag);
    }

    private static void executeSetTarget(@NotNull VirtualFile file2, @Nullable String target2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(168);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        FSRecords.storeSymlinkTarget(id2, target2);
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof LocalFileSystemImpl) {
            ((LocalFileSystemImpl)fs).symlinkUpdated(id2, file2.getParent(), file2.getNameSequence(), file2.getPath(), target2);
        }
    }

    private static void setFlag(@NotNull VirtualFile file2, @PersistentFS.Attributes int mask, boolean value2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(169);
        }
        PersistentFSImpl.setFlag(PersistentFSImpl.getFileId(file2), mask, value2);
    }

    private static void setFlag(int id2, @PersistentFS.Attributes int mask, boolean value2) {
        int flags;
        int oldFlags = FSRecords.getFlags(id2);
        int n = flags = value2 ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            FSRecords.setFlags(id2, flags);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void executeTouch(@NotNull VirtualFile file2, boolean reloadContentFromDelegate, long newModificationStamp, long newLength, long l) {
        void newTimestamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(170);
        }
        if (reloadContentFromDelegate) {
            PersistentFSImpl.setFlag(file2, 8, true);
        }
        int fileId = PersistentFSImpl.getFileId(file2);
        PersistentFSImpl.setLength(fileId, newLength);
        FSRecords.setTimestamp(fileId, (long)newTimestamp);
        ((VirtualFileSystemEntry)file2).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(171);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(172);
        }
        this.clearIdCache();
        int fileId = PersistentFSImpl.getFileId(file2);
        int newParentId = PersistentFSImpl.getFileId(newParent);
        VirtualFile oldParent = file2.getParent();
        int oldParentId = PersistentFSImpl.getFileId(oldParent);
        VirtualFileSystemEntry virtualFileSystemEntry = (VirtualFileSystemEntry)file2;
        NewVirtualFileSystem fileSystem = virtualFileSystemEntry.getFileSystem();
        PersistentFSImpl.removeIdFromChildren(oldParent, oldParentId, fileId);
        FSRecords.setParent(fileId, newParentId);
        ChildInfoImpl newChild = new ChildInfoImpl(fileId, virtualFileSystemEntry.getNameId(), null, null, null);
        FSRecords.update(newParent, newParentId, children2 -> {
            ChildInfo duplicate = PersistentFSImpl.findExistingChildInfo(file2, file2.getName(), children2.children, fileSystem);
            if (duplicate != null) {
                return children2;
            }
            return children2.insert(newChild);
        });
        virtualFileSystemEntry.setParent(newParent);
    }

    @Override
    public String getName(int id2) {
        assert (id2 > 0);
        return FSRecords.getName(id2);
    }

    @TestOnly
    public static void cleanPersistedContent(int id2) {
        PersistentFSImpl.doCleanPersistedContent(id2);
    }

    @TestOnly
    public void cleanPersistedContents() {
        int[] roots;
        for (int root : roots = FSRecords.listRoots()) {
            this.markForContentReloadRecursively(root);
        }
    }

    private void markForContentReloadRecursively(int id2) {
        if (PersistentFSImpl.isDirectory(this.getFileAttributes(id2))) {
            for (int child2 : FSRecords.listIds(id2)) {
                this.markForContentReloadRecursively(child2);
            }
        } else {
            PersistentFSImpl.doCleanPersistedContent(id2);
        }
    }

    private static void doCleanPersistedContent(int id2) {
        PersistentFSImpl.setFlag(id2, 8, true);
        PersistentFSImpl.setFlag(id2, 128, true);
    }

    @Override
    public boolean mayHaveChildren(int id2) {
        return FSRecords.mayHaveChildren(id2);
    }

    @TestOnly
    @NotNull
    ConcurrentIntObjectMap<VirtualFileSystemEntry> getIdToDirCache() {
        ConcurrentIntObjectMap<VirtualFileSystemEntry> concurrentIntObjectMap = this.myIdToDirCache;
        if (concurrentIntObjectMap == null) {
            PersistentFSImpl.$$$reportNull$$$0(173);
        }
        return concurrentIntObjectMap;
    }

    static @PersistentFS.Attributes int fileAttributesToFlags(@NotNull FileAttributes attributes2) {
        FileAttributes.CaseSensitivity sensitivity;
        if (attributes2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(174);
        }
        boolean isCaseSensitive = (sensitivity = attributes2.areChildrenCaseSensitive()) == FileAttributes.CaseSensitivity.SENSITIVE;
        return PersistentFSImpl.fileAttributesToFlags(attributes2.isDirectory(), attributes2.isWritable(), attributes2.isSymLink(), attributes2.isSpecial(), attributes2.isHidden(), sensitivity != FileAttributes.CaseSensitivity.UNKNOWN, isCaseSensitive);
    }

    public static @PersistentFS.Attributes int fileAttributesToFlags(boolean isDirectory, boolean isWritable, boolean isSymLink, boolean isSpecial, boolean isHidden, boolean isChildrenCaseSensitivityCached, boolean areChildrenCaseSensitive) {
        return (isDirectory ? 2 : 0) | (isWritable ? 0 : 4) | (isSymLink ? 16 : 0) | (isSpecial ? 32 : 0) | (isHidden ? 64 : 0) | (isChildrenCaseSensitivityCached ? 512 : 0) | (areChildrenCaseSensitive ? 256 : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 1: 
            case 7: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDir";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 52: 
            case 53: 
            case 54: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 99: 
            case 148: 
            case 160: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 45: 
            case 48: 
            case 55: 
            case 58: 
            case 61: 
            case 135: 
            case 150: 
            case 157: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 27: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 29: 
            case 56: 
            case 62: 
            case 151: 
            case 153: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: 
            case 33: 
            case 47: 
            case 51: 
            case 140: 
            case 141: 
            case 144: 
            case 155: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 31: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 67: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 79: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeStream";
                break;
            }
            case 91: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 92: 
            case 98: 
            case 101: 
            case 105: 
            case 147: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 93: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInvolved";
                break;
            }
            case 94: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirsInvolved";
                break;
            }
            case 95: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 96: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCreate";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsToRemove";
                break;
            }
            case 102: 
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirs";
                break;
            }
            case 106: 
            case 117: 
            case 121: 
            case 124: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 107: 
            case 115: 
            case 119: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outApplyActions";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidatedEvents";
                break;
            }
            case 112: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 114: 
            case 118: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidated";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 126: 
            case 129: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisher";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyActions";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyEvents";
                break;
            }
            case 130: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSend";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletions";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creations";
                break;
            }
            case 136: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createEvents";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCaseSensitivity";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childData";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCacheDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "listPersisted";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "persistAllChildren";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listAll";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "writeContent";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplicatorAndStoreContent";
                break;
            }
            case 143: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRoots";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdToDirCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenLoaded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCacheDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wereChildrenAccessed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "listPersisted";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "persistAllChildren";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "listAll";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "storeUnlinkedContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributesToRecord";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findChildInfo";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findExistingChildInfo";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLastRecordedLength";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isUtf8BomRequired";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 68: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "mustReloadContent";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "reloadLengthFromDelegate";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "createReplicatorAndStoreContent";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "storeContentToStorage";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getContentHashIfStored";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getLengthIfUpToDate";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "acquireContent";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentContentId";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "groupByPath";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativePath";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedDelete";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "eventConflictsWithPrevious";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isContentChangeLikeHarmlessEvent";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "groupAndValidate";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "groupCreations";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "groupDeletions";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "groupOthers";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "processEvents";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "processEventsImpl";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "applyMultipleEvents";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeEvents";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterEvents";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "applyDeletions";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "applyCreations";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "applyCreateEventsInDirectory";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "saveScannedChildrenRecursively";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "loadAttributes";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "applyEvent";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "executeChangeCaseSensitivity";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "executeCreateChild";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "makeChildRecord";
                break;
            }
            case 156: 
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "getChildData";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "executeDelete";
                break;
            }
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSubtree";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "removeIdFromChildren";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "executeRename";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "executeSetWritable";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "executeSetHidden";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "executeSetTarget";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "executeTouch";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "executeMove";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "fileAttributesToFlags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

