/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingPanel
extends EditorBasedStatusBarPopup {
    public EncodingPanel(@NotNull Project project) {
        if (project == null) {
            EncodingPanel.$$$reportNull$$$0(0);
        }
        super(project, false);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isDirectory()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                EncodingPanel.$$$reportNull$$$0(1);
            }
            return widgetState;
        }
        Pair<Charset, String> check2 = EncodingUtil.getCharsetAndTheReasonTooltip(file2);
        String failReason = (String)Pair.getSecond(check2);
        Charset charset = (Charset)ObjectUtils.notNull((Object)((Charset)Pair.getFirst(check2)), (Object)file2.getCharset());
        String charsetName = (String)ObjectUtils.notNull((Object)charset.displayName(), (Object)IdeBundle.message((String)"encoding.not.available", (Object[])new Object[0]));
        String toolTipText = IdeBundle.message((String)"status.bar.text.file.encoding", (Object[])new Object[]{charsetName}) + (String)(failReason == null ? "" : " (" + failReason + ")");
        return new EditorBasedStatusBarPopup.WidgetState(toolTipText, charsetName, failReason == null);
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context2) {
        ChangeFileEncodingAction action2 = new ChangeFileEncodingAction();
        action2.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"action.presentation.EncodingPanel.text", (Object[])new Object[0]));
        return action2.createPopup(context2, (ActionGroup)ActionManager.getInstance().getAction("EncodingPanelActions"));
    }

    @Override
    protected void registerCustomListeners() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(EncodingManagerListener.ENCODING_MANAGER_CHANGES, (document, propertyName, oldValue, newValue2) -> {
            if (propertyName.equals("cachedEncoding")) {
                this.updateForDocument(document);
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("encoding".equals(event.getPropertyName())) {
                    EncodingPanel.this.updateForFile(event.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/EncodingPanel$1", "propertyChanged"));
            }
        }));
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            EncodingPanel.$$$reportNull$$$0(2);
        }
        return new EncodingPanel(project);
    }

    @NotNull
    public String ID() {
        return "Encoding";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

