/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PowerSaveMode;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.ui.panel.ProgressPanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.status.PresentationModeProgressPanel;
import com.intellij.openapi.wm.impl.status.ProcessBalloon;
import com.intellij.openapi.wm.impl.status.ProcessPopup;
import com.intellij.openapi.wm.impl.status.ProgressButton;
import com.intellij.openapi.wm.impl.status.StatusPanel;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InfoAndProgressPanel
extends JPanel
implements CustomStatusBarWidget {
    private final ProcessPopup myPopup;
    private final ProcessBalloon myBalloon = new ProcessBalloon(3);
    private final StatusPanel myInfoPanel = new StatusPanel();
    private final JPanel myRefreshAndInfoPanel = new JPanel();
    private final InlineProgressPanel myInlinePanel = new InlineProgressPanel();
    private final NotNullLazyValue<AsyncProcessIcon> myProgressIcon = NotNullLazyValue.lazy(() -> {
        AsyncProcessIcon icon2 = new AsyncProcessIcon("Background process");
        icon2.setOpaque(false);
        icon2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InfoAndProgressPanel.this.handle(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                InfoAndProgressPanel.this.handle(e);
            }
        });
        icon2.setCursor(Cursor.getPredefinedCursor(12));
        icon2.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        icon2.setToolTipText(ActionsBundle.message((String)"action.ShowProcessWindow.double.click", (Object[])new Object[0]));
        return icon2;
    });
    private final List<ProgressIndicatorEx> myOriginals = new ArrayList<ProgressIndicatorEx>();
    private final List<TaskInfo> myInfos = new ArrayList<TaskInfo>();
    private final Map<InlineProgressIndicator, ProgressIndicatorEx> myInlineToOriginal = new HashMap<InlineProgressIndicator, ProgressIndicatorEx>();
    private final Map<ProgressIndicatorEx, Set<MyInlineProgressIndicator>> myOriginalToInlines = new HashMap<ProgressIndicatorEx, Set<MyInlineProgressIndicator>>();
    private final MergingUpdateQueue myUpdateQueue;
    private final Alarm myQueryAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private boolean myShouldClosePopupAndOnProcessFinish;
    private final JLabel myRefreshIcon = new JLabel((Icon)new AnimatedIcon.FS());
    private String myCurrentRequestor;
    private boolean myDisposed;
    private WeakReference<Balloon> myLastShownBalloon;
    private final Set<InlineProgressIndicator> myDirtyIndicators = new ReferenceOpenHashSet();
    private final Update myUpdateIndicators = new Update("UpdateIndicators", false, 1){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<InlineProgressIndicator> indicators;
            Set<InlineProgressIndicator> set2 = InfoAndProgressPanel.this.myDirtyIndicators;
            synchronized (set2) {
                indicators = new ArrayList<InlineProgressIndicator>(InfoAndProgressPanel.this.myDirtyIndicators);
                InfoAndProgressPanel.this.myDirtyIndicators.clear();
            }
            for (InlineProgressIndicator indicator2 : indicators) {
                indicator2.updateAndRepaint();
            }
        }
    };

    InfoAndProgressPanel() {
        this.setOpaque(false);
        this.setBorder((Border)JBUI.Borders.empty());
        this.myRefreshIcon.setVisible(false);
        this.myRefreshAndInfoPanel.setLayout(new BorderLayout());
        this.myRefreshAndInfoPanel.setOpaque(false);
        this.myRefreshAndInfoPanel.add((Component)this.myRefreshIcon, "West");
        this.myRefreshAndInfoPanel.add((Component)this.myInfoPanel, "Center");
        this.myUpdateQueue = new MergingUpdateQueue("Progress indicator", 50, true, MergingUpdateQueue.ANY_COMPONENT);
        this.myPopup = new ProcessPopup(this);
        this.setRefreshVisible(false);
        this.setLayout((LayoutManager)((Object)new InlineLayout()));
        this.add(this.myRefreshAndInfoPanel);
        this.add((Component)((Object)this.myInlinePanel));
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
        this.runOnProgressRelatedChange(this::updateProgressIcon, (Disposable)this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnProgressRelatedChange(final @NotNull Runnable runnable2, @NotNull Disposable parentDisposable, boolean powerSaveMode) {
        if (runnable2 == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(1);
        }
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (!this.myDisposed) {
                MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
                if (powerSaveMode) {
                    connection.subscribe(PowerSaveMode.TOPIC, () -> UIUtil.invokeLaterIfNeeded((Runnable)runnable2));
                }
                connection.subscribe(ProgressSuspender.TOPIC, (Object)new ProgressSuspender.SuspenderListener(){

                    @Override
                    public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender) {
                        if (suspender == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
                    }

                    @Override
                    public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
                        if (suspender == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "suspender";
                        objectArray2[1] = "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$3";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "suspendableProgressAppeared";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "suspendedStatusChanged";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
    }

    private void handle(@NotNull MouseEvent e) {
        if (e == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(2);
        }
        if (UIUtil.isActionClick((MouseEvent)e, (int)501)) {
            this.triggerPopupShowing();
        }
    }

    @NotNull
    public String ID() {
        return "InfoAndProgress";
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    public void install(@NotNull StatusBar statusBar2) {
        if (statusBar2 == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.setRefreshVisible(false);
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            this.restoreEmptyStatus();
            for (InlineProgressIndicator indicator2 : this.myInlineToOriginal.keySet()) {
                Disposer.dispose((Disposable)indicator2);
            }
            this.myInlineToOriginal.clear();
            this.myOriginalToInlines.clear();
            this.myDisposed = true;
        }
        GuiUtils.removePotentiallyLeakingReferences((Container)this.myRefreshIcon);
        this.myInfos.clear();
    }

    public JComponent getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    List<Pair<TaskInfo, ProgressIndicator>> getBackgroundProcesses() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        // MONITORENTER : list2
        if (this.myOriginals.isEmpty()) {
            List<Pair<TaskInfo, ProgressIndicator>> list3 = Collections.emptyList();
            // MONITOREXIT : list2
            if (list3 != null) return list3;
            InfoAndProgressPanel.$$$reportNull$$$0(4);
            return list3;
        }
        ArrayList<Pair> result2 = new ArrayList<Pair>(this.myOriginals.size());
        int i2 = 0;
        while (true) {
            if (i2 >= this.myOriginals.size()) {
                List<Pair<TaskInfo, ProgressIndicator>> list4 = Collections.unmodifiableList(result2);
                // MONITOREXIT : list2
                if (list4 != null) return list4;
                InfoAndProgressPanel.$$$reportNull$$$0(5);
                return list4;
            }
            result2.add(Pair.create((Object)this.myInfos.get(i2), (Object)this.myOriginals.get(i2)));
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProgress(@NotNull ProgressIndicatorEx original, @NotNull TaskInfo info2) {
        if (original == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(6);
        }
        if (info2 == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            this.myOriginals.add(original);
            this.myInfos.add(info2);
            MyInlineProgressIndicator expanded = this.createInlineDelegate(info2, original, false);
            MyInlineProgressIndicator compact = this.createInlineDelegate(info2, original, true);
            this.myPopup.addIndicator(expanded);
            this.myBalloon.addIndicator(this.getRootPane(), compact);
            this.updateProgressIcon();
            if (this.myOriginals.size() == 1) {
                this.myInlinePanel.updateState(compact);
            } else {
                this.myInlinePanel.updateState();
            }
            if (this.myInfos.size() > 1 && Registry.is((String)"ide.windowSystem.autoShowProcessPopup")) {
                this.openProcessPopup(false);
            }
            if (original.isFinished(info2)) {
                this.removeProgress(expanded);
                this.removeProgress(compact);
                return;
            }
            this.runQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProgressIndicators() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            return !this.myOriginals.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgress(@NotNull MyInlineProgressIndicator progress2) {
        if (progress2 == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(8);
        }
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            ProgressIndicatorEx original;
            boolean last;
            if (!this.myInlineToOriginal.containsKey(progress2)) {
                return;
            }
            boolean bl = last = this.myOriginals.size() == 1;
            if (!progress2.isCompact()) {
                this.myPopup.removeIndicator(progress2);
            }
            if (this.myOriginals.contains(original = this.removeFromMaps(progress2))) {
                Disposer.dispose((Disposable)progress2);
                if (progress2.isCompact()) {
                    this.myBalloon.removeIndicator(this.getRootPane(), progress2);
                }
                return;
            }
            if (last) {
                this.myInlinePanel.updateState(null);
                if (this.myShouldClosePopupAndOnProcessFinish) {
                    this.hideProcessPopup();
                }
            } else {
                this.myInlinePanel.updateState(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            }
            this.runQuery();
        }
        Disposer.dispose((Disposable)progress2);
        if (progress2.isCompact()) {
            this.myBalloon.removeIndicator(this.getRootPane(), progress2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressIndicatorEx removeFromMaps(@NotNull MyInlineProgressIndicator progress2) {
        if (progress2 == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(9);
        }
        ProgressIndicatorEx original = this.myInlineToOriginal.get(progress2);
        this.myInlineToOriginal.remove(progress2);
        Set<InlineProgressIndicator> set2 = this.myDirtyIndicators;
        synchronized (set2) {
            this.myDirtyIndicators.remove(progress2);
        }
        Set<MyInlineProgressIndicator> set3 = this.myOriginalToInlines.get(original);
        if (set3 != null) {
            set3.remove(progress2);
            if (set3.isEmpty()) {
                set3 = null;
                this.myOriginalToInlines.remove(original);
            }
        }
        if (set3 == null) {
            int originalIndex = this.myOriginals.indexOf(original);
            this.myOriginals.remove(originalIndex);
            this.myInfos.remove(originalIndex);
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProcessPopup(boolean requestFocus) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (this.myPopup.isShowing()) {
                return;
            }
            this.myPopup.show(requestFocus);
            this.myShouldClosePopupAndOnProcessFinish = this.hasProgressIndicators();
            this.myInlinePanel.updateState(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideProcessPopup() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (!this.myPopup.isShowing()) {
                return;
            }
            this.myPopup.hide();
            this.myInlinePanel.updateState(false);
        }
    }

    public @NotNull Pair<@NlsContexts.StatusBarText String, String> setText(@Nullable @NlsContexts.StatusBarText String text2, @Nullable String requestor) {
        if (StringUtil.isEmpty((String)text2) && !Objects.equals(requestor, this.myCurrentRequestor) && !"Internal log requestor".equals(requestor)) {
            return new Pair((Object)this.myInfoPanel.getText(), (Object)this.myCurrentRequestor);
        }
        boolean logMode = this.myInfoPanel.updateText("Internal log requestor".equals(requestor) ? "" : text2);
        this.myCurrentRequestor = logMode ? "Internal log requestor" : requestor;
        return new Pair((Object)text2, (Object)requestor);
    }

    void setRefreshVisible(boolean visible) {
        UIUtil.invokeLaterIfNeeded(() -> this.myRefreshIcon.setVisible(visible));
    }

    void setRefreshToolTipText(@NlsContexts.Tooltip String tooltip2) {
        this.myRefreshIcon.setToolTipText(tooltip2);
    }

    public BalloonHandler notifyByBalloon(@NotNull MessageType type, @NotNull @NlsContexts.PopupContent String htmlBody, @Nullable Icon icon2, @Nullable HyperlinkListener listener2) {
        if (type == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(10);
        }
        if (htmlBody == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(11);
        }
        Balloon balloon2 = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlBody.replace("\n", "<br>"), icon2 != null ? icon2 : type.getDefaultIcon(), type.getPopupBackground(), listener2).createBalloon();
        SwingUtilities.invokeLater(() -> {
            Balloon oldBalloon = (Balloon)SoftReference.dereference(this.myLastShownBalloon);
            if (oldBalloon != null) {
                balloon2.setAnimationEnabled(false);
                oldBalloon.setAnimationEnabled(false);
                oldBalloon.hide();
            }
            this.myLastShownBalloon = new WeakReference<Balloon>(balloon2);
            InfoAndProgressPanel comp = this;
            if (comp.isShowing()) {
                int offset = ((Component)comp).getHeight() / 2;
                Point point = new Point(((Component)comp).getWidth() - offset, ((Component)comp).getHeight() - offset);
                balloon2.show(new RelativePoint((Component)comp, point), Balloon.Position.above);
            } else {
                JRootPane rootPane = SwingUtilities.getRootPane(comp);
                if (rootPane != null && rootPane.isShowing()) {
                    Container contentPane = rootPane.getContentPane();
                    Rectangle bounds2 = contentPane.getBounds();
                    Point target2 = StartupUiUtil.getCenterPoint((Rectangle)bounds2, (Dimension)JBUI.size((int)1, (int)1));
                    target2.y = bounds2.height - 3;
                    balloon2.show(new RelativePoint((Component)contentPane, target2), Balloon.Position.above);
                }
            }
        });
        return () -> SwingUtilities.invokeLater(() -> ((Balloon)balloon2).hide());
    }

    @NotNull
    private MyInlineProgressIndicator createInlineDelegate(@NotNull TaskInfo info2, @NotNull ProgressIndicatorEx original, boolean compact) {
        Set inlines;
        if (info2 == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(12);
        }
        if (original == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(13);
        }
        if (!(inlines = this.myOriginalToInlines.computeIfAbsent(original, __ -> new HashSet())).isEmpty()) {
            for (MyInlineProgressIndicator eachInline : inlines) {
                if (eachInline.isCompact() != compact) continue;
                MyInlineProgressIndicator myInlineProgressIndicator = eachInline;
                if (myInlineProgressIndicator == null) {
                    InfoAndProgressPanel.$$$reportNull$$$0(14);
                }
                return myInlineProgressIndicator;
            }
        }
        MyInlineProgressIndicator inline = compact ? new MyInlineProgressIndicator(this, info2, original) : new ProgressPanelProgressIndicator(info2, original);
        this.myInlineToOriginal.put(inline, original);
        inlines.add(inline);
        if (compact) {
            inline.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }
            });
        }
        MyInlineProgressIndicator myInlineProgressIndicator = inline;
        if (myInlineProgressIndicator == null) {
            InfoAndProgressPanel.$$$reportNull$$$0(15);
        }
        return myInlineProgressIndicator;
    }

    private void triggerPopupShowing() {
        if (this.myPopup.isShowing()) {
            this.hideProcessPopup();
        } else {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("bg.progress.window.show.from.status.bar");
            this.openProcessPopup(true);
        }
    }

    private void updateProgressIcon() {
        AsyncProcessIcon progressIcon;
        AsyncProcessIcon asyncProcessIcon = progressIcon = this.myProgressIcon.isComputed() ? (AsyncProcessIcon)this.myProgressIcon.getValue() : null;
        if (progressIcon == null) {
            return;
        }
        if (this.myOriginals.isEmpty() || PowerSaveMode.isEnabled() || this.myOriginals.stream().map(ProgressSuspender::getSuspender).allMatch(s -> s != null && s.isSuspended())) {
            progressIcon.suspend();
        } else {
            progressIcon.resume();
        }
    }

    private void restoreEmptyStatus() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myRefreshAndInfoPanel, "Center");
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
    }

    boolean isProcessWindowOpen() {
        return this.myPopup.isShowing();
    }

    void setProcessWindowOpen(boolean open2) {
        if (open2) {
            this.openProcessPopup(true);
        } else {
            this.hideProcessPopup();
        }
    }

    private void runQuery() {
        if (this.getRootPane() == null) {
            return;
        }
        Set<InlineProgressIndicator> indicators = this.getCurrentInlineIndicators();
        if (indicators.isEmpty()) {
            return;
        }
        for (InlineProgressIndicator each : indicators) {
            each.updateProgress();
        }
        this.myQueryAlarm.cancelAllRequests();
        this.myQueryAlarm.addRequest(this::runQuery, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Set<InlineProgressIndicator> getCurrentInlineIndicators() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        // MONITORENTER : list2
        Set<InlineProgressIndicator> set2 = this.myInlineToOriginal.keySet();
        // MONITOREXIT : list2
        if (set2 != null) return set2;
        InfoAndProgressPanel.$$$reportNull$$$0(16);
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundProcesses";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineDelegate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentInlineIndicators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runOnProgressRelatedChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeProgress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFromMaps";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyByBalloon";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInlineDelegate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InlineLayout
    extends AbstractLayoutManager {
        private InlineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result2 = new Dimension();
            int count = parent.getComponentCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Dimension size2 = parent.getComponent(i2).getPreferredSize();
                result2.width += size2.width;
                result2.height = Math.max(result2.height, size2.height);
            }
            return result2;
        }

        public void layoutContainer(Container parent) {
            if (parent.getComponentCount() != 2) {
                return;
            }
            Component infoPanel = parent.getComponent(0);
            Component progressPanel = parent.getComponent(1);
            Dimension size2 = parent.getSize();
            int progressWidth = progressPanel.getPreferredSize().width;
            if (progressWidth > size2.width) {
                infoPanel.setBounds(0, 0, 0, 0);
                progressPanel.setBounds(0, 0, size2.width, size2.height);
            } else {
                infoPanel.setBounds(0, 0, size2.width - progressWidth, size2.height);
                progressPanel.setBounds(size2.width - progressWidth, 0, progressWidth, size2.height);
            }
        }
    }

    private final class InlineProgressPanel
    extends NonOpaquePanel {
        private MyInlineProgressIndicator myIndicator;
        private AsyncProcessIcon myProcessIconComponent;
        private final ActionLink myMultiProcessLink = new ActionLink("", e -> InfoAndProgressPanel.this.triggerPopupShowing()){

            public void updateUI() {
                super.updateUI();
                this.setFont((Font)(SystemInfo.isMac ? JBUI.Fonts.label((float)11.0f) : JBFont.label()));
            }
        };

        InlineProgressPanel() {
            this.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    JComponent component2;
                    Dimension result2 = new Dimension();
                    if (InlineProgressPanel.this.myIndicator != null && (component2 = InlineProgressPanel.this.myIndicator.getComponent()).isVisible()) {
                        Dimension size2 = component2.getPreferredSize();
                        result2.width += size2.width;
                        result2.height = Math.max(result2.height, size2.height);
                    }
                    if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                        Dimension size3 = InlineProgressPanel.this.myMultiProcessLink.getPreferredSize();
                        result2.width = result2.width + ((result2.width > 0 ? InlineProgressPanel.this.getGap() : 0) + size3.width);
                        result2.height = Math.max(result2.height, size3.height);
                    }
                    if (InlineProgressPanel.this.myProcessIconComponent != null) {
                        result2.height = Math.max(result2.height, InlineProgressPanel.this.myProcessIconComponent.getPreferredSize().height);
                    }
                    JBInsets.addTo((Dimension)result2, (Insets)parent.getInsets());
                    return result2;
                }

                public void layoutContainer(Container parent) {
                    if (InlineProgressPanel.this.myIndicator == null) {
                        InlineProgressPanel.this.hideProcessIcon();
                        return;
                    }
                    Insets insets = parent.getInsets();
                    int x = insets.left;
                    int centerY = (parent.getHeight() + insets.top - insets.bottom) / 2;
                    int width = parent.getWidth() - insets.left - insets.right;
                    int rightX = parent.getWidth() - insets.right;
                    int gap = InlineProgressPanel.this.getGap();
                    JComponent indicator2 = InlineProgressPanel.this.myIndicator.getComponent();
                    if (indicator2.isVisible()) {
                        int progressWidth2x;
                        int preferredWidth = this.preferredLayoutSize((Container)parent).width - insets.left - insets.right;
                        Dimension indicatorSize = null;
                        if (preferredWidth > width && width > (progressWidth2x = InlineProgressPanel.this.myIndicator.myProgress.getPreferredSize().width * 2) && InlineProgressPanel.this.myIndicator.myText.getPreferredSize().width > progressWidth2x) {
                            preferredWidth = width;
                            indicatorSize = new Dimension(width, indicator2.getPreferredSize().height);
                            if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                indicatorSize.width -= InlineProgressPanel.this.myMultiProcessLink.getPreferredSize().width + gap;
                            }
                        }
                        if (preferredWidth > width) {
                            indicator2.setBounds(0, 0, 0, 0);
                            InlineProgressPanel.this.addProcessIcon();
                            Dimension iconSize = InlineProgressPanel.this.myProcessIconComponent.getPreferredSize();
                            preferredWidth = iconSize.width;
                            if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                preferredWidth += gap + InlineProgressPanel.this.myMultiProcessLink.getPreferredSize().width;
                            }
                            if (preferredWidth > width) {
                                if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                    InlineProgressPanel.this.myMultiProcessLink.setBounds(0, 0, 0, 0);
                                }
                                InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myProcessIconComponent, 0, centerY, iconSize, false);
                            } else {
                                boolean minisWidth = true;
                                if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                    rightX = InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myMultiProcessLink, rightX, centerY, null, true) - gap;
                                } else if (width < 60) {
                                    rightX = 0;
                                    minisWidth = false;
                                }
                                InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myProcessIconComponent, rightX, centerY, iconSize, minisWidth);
                            }
                            InlineProgressPanel.this.myProcessIconComponent.setVisible(true);
                        } else {
                            InlineProgressPanel.this.hideProcessIcon();
                            if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                rightX = InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myMultiProcessLink, rightX, centerY, null, true) - gap;
                            }
                            InlineProgressPanel.this.setBounds(indicator2, rightX, centerY, indicatorSize, true);
                        }
                    } else {
                        Dimension linkSize = InlineProgressPanel.this.myMultiProcessLink.getPreferredSize();
                        int preferredWidth = linkSize.width;
                        if (preferredWidth > width) {
                            InlineProgressPanel.this.myMultiProcessLink.setBounds(0, 0, 0, 0);
                            InlineProgressPanel.this.addProcessIcon();
                            InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myProcessIconComponent, x, centerY, null, false);
                            InlineProgressPanel.this.myProcessIconComponent.setVisible(true);
                        } else {
                            InlineProgressPanel.this.hideProcessIcon();
                            InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myMultiProcessLink, rightX, centerY, linkSize, true);
                        }
                    }
                }
            });
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)0, (int)4));
            this.add((Component)this.myMultiProcessLink);
            this.myMultiProcessLink.setVisible(false);
        }

        private int getGap() {
            return JBUI.scale((int)10);
        }

        private int setBounds(@NotNull JComponent component2, int x, int centerY, @Nullable Dimension size2, boolean minusWidth) {
            if (component2 == null) {
                InlineProgressPanel.$$$reportNull$$$0(0);
            }
            if (size2 == null) {
                size2 = component2.getPreferredSize();
            }
            if (minusWidth) {
                x -= size2.width;
            }
            component2.setBounds(x, centerY - size2.height / 2, size2.width, size2.height);
            return x;
        }

        private void addProcessIcon() {
            if (this.myProcessIconComponent == null) {
                this.myProcessIconComponent = (AsyncProcessIcon)InfoAndProgressPanel.this.myProgressIcon.getValue();
                this.add((Component)this.myProcessIconComponent);
            }
        }

        private void hideProcessIcon() {
            if (this.myProcessIconComponent != null) {
                this.myProcessIconComponent.setVisible(false);
            }
        }

        void updateState(@Nullable MyInlineProgressIndicator indicator2) {
            if (this.getRootPane() == null) {
                return;
            }
            if (this.myIndicator != null) {
                this.remove(this.myIndicator.getComponent());
            }
            this.myIndicator = indicator2;
            if (indicator2 == null) {
                this.myMultiProcessLink.setVisible(false);
                this.doLayout();
                this.revalidate();
                this.repaint();
            } else {
                this.add(indicator2.getComponent());
                this.updateState();
            }
        }

        void updateState() {
            this.updateState(InfoAndProgressPanel.this.myPopup.isShowing());
        }

        void updateState(boolean showPopup) {
            if (this.myIndicator == null) {
                return;
            }
            int size2 = InfoAndProgressPanel.this.myOriginals.size();
            this.myIndicator.getComponent().setVisible(!showPopup);
            this.myMultiProcessLink.setVisible(showPopup || size2 > 1);
            if (showPopup) {
                this.myMultiProcessLink.setText(IdeBundle.message((String)"link.hide.processes", (Object[])new Object[]{size2}));
            } else if (size2 > 1) {
                this.myMultiProcessLink.setText(IdeBundle.message((String)"link.show.all.processes", (Object[])new Object[]{size2}));
            }
            this.doLayout();
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$InlineProgressPanel", "setBounds"));
        }
    }

    class MyInlineProgressIndicator
    extends InlineProgressIndicator {
        private ProgressIndicatorEx myOriginal;
        PresentationModeProgressPanel myPresentationModeProgressPanel;
        Balloon myPresentationModeBalloon;
        boolean myPresentationModeShowBalloon;
        final /* synthetic */ InfoAndProgressPanel this$0;

        MyInlineProgressIndicator(@NotNull InfoAndProgressPanel this$0, @NotNull TaskInfo task2, ProgressIndicatorEx original) {
            if (task2 == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(0);
            }
            if (original == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(1);
            }
            this(this$0, true, task2, original);
        }

        MyInlineProgressIndicator(final InfoAndProgressPanel this$0, @NotNull boolean compact, @NotNull TaskInfo task2, ProgressIndicatorEx original) {
            if (task2 == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(2);
            }
            if (original == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(3);
            }
            this.this$0 = this$0;
            super(compact, task2);
            this.myOriginal = original;
            original.addStateDelegate(this);
            this.addStateDelegate(new AbstractProgressIndicatorExBase(){

                @Override
                public void cancel() {
                    super.cancel();
                    MyInlineProgressIndicator.this.updateProgress();
                }
            });
            this$0.runOnProgressRelatedChange(this::queueProgressUpdate, this, this.canCheckPowerSaveMode());
        }

        @Override
        protected void createCompactTextAndProgress(@NotNull JPanel component2) {
            if (component2 == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(4);
            }
            this.myText.setTextAlignment(1.0f);
            this.myText.recomputeSize();
            UIUtil.setCursor((Component)((Object)this.myText), (Cursor)Cursor.getPredefinedCursor(12));
            UIUtil.setCursor((Component)this.myProgress, (Cursor)Cursor.getPredefinedCursor(12));
            super.createCompactTextAndProgress(component2);
            ((JComponent)this.myProgress.getParent()).setBorder((Border)JBUI.Borders.empty((int)0, (int)8, (int)0, (int)4));
        }

        protected boolean canCheckPowerSaveMode() {
            return true;
        }

        @Override
        public String getText() {
            String text2 = StringUtil.notNullize((String)super.getText());
            ProgressSuspender suspender = this.getSuspender();
            return suspender != null && suspender.isSuspended() ? suspender.getSuspendedText() : text2;
        }

        @Override
        @NotNull
        protected JBIterable<ProgressButton> createEastButtons() {
            JBIterable jBIterable = JBIterable.of((Object)this.createSuspendButton()).append(super.createEastButtons());
            if (jBIterable == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        protected void updateCancelButton(@NotNull InplaceButton suspend, @NotNull InplaceButton cancel) {
            if (suspend == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(6);
            }
            if (cancel == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(7);
            }
            boolean painting = this.getInfo().isCancellable() && !this.isStopping();
            cancel.setPainting(painting);
            cancel.setVisible(painting || !suspend.isVisible());
        }

        @NotNull
        JBIterable<ProgressButton> createPresentationButtons() {
            ProgressButton suspend = this.createSuspendButton();
            ProgressButton cancel = this.createCancelButton();
            JBIterable jBIterable = JBIterable.of((Object)suspend).append((Object)new ProgressButton(cancel.button, () -> this.updateCancelButton(suspend.button, cancel.button)));
            if (jBIterable == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        @NotNull
        private ProgressButton createSuspendButton() {
            InplaceButton suspendButton = new InplaceButton("", AllIcons.Actions.Pause, e -> this.createSuspendRunnable().run()).setFillBg(false);
            return new ProgressButton(suspendButton, this.createSuspendUpdateRunnable(suspendButton));
        }

        @NotNull
        protected Runnable createSuspendRunnable() {
            Runnable runnable2 = () -> {
                ProgressSuspender suspender = this.getSuspender();
                if (suspender == null) {
                    return;
                }
                if (suspender.isSuspended()) {
                    suspender.resumeProcess();
                } else {
                    suspender.suspendProcess(null);
                }
                (suspender.isSuspended() ? UIEventLogger.ProgressPaused : UIEventLogger.ProgressResumed).log();
            };
            if (runnable2 == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(9);
            }
            return runnable2;
        }

        @NotNull
        protected Runnable createSuspendUpdateRunnable(@NotNull InplaceButton suspendButton) {
            if (suspendButton == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(10);
            }
            suspendButton.setVisible(false);
            Runnable runnable2 = () -> {
                ProgressSuspender suspender = this.getSuspender();
                suspendButton.setVisible(suspender != null);
                if (suspender != null) {
                    String toolTipText;
                    String string = toolTipText = suspender.isSuspended() ? IdeBundle.message((String)"comment.text.resume", (Object[])new Object[0]) : IdeBundle.message((String)"comment.text.pause", (Object[])new Object[0]);
                    if (!toolTipText.equals(suspendButton.getToolTipText())) {
                        this.this$0.updateProgressIcon();
                        if (suspender.isSuspended()) {
                            this.showResumeIcons(suspendButton);
                        } else {
                            this.showPauseIcons(suspendButton);
                        }
                        suspendButton.setToolTipText(toolTipText);
                    }
                }
            };
            if (runnable2 == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(11);
            }
            return runnable2;
        }

        private void showPauseIcons(InplaceButton button4) {
            this.setIcons(button4, AllIcons.Process.ProgressPauseSmall, AllIcons.Process.ProgressPause, AllIcons.Process.ProgressPauseSmallHover, AllIcons.Process.ProgressPauseHover);
        }

        private void showResumeIcons(InplaceButton button4) {
            this.setIcons(button4, AllIcons.Process.ProgressResumeSmall, AllIcons.Process.ProgressResume, AllIcons.Process.ProgressResumeSmallHover, AllIcons.Process.ProgressResumeHover);
        }

        private void setIcons(InplaceButton button4, Icon compactRegular, Icon regular, Icon compactHovered, Icon hovered2) {
            button4.setIcons(this.isCompact() ? compactRegular : regular, null, this.isCompact() ? compactHovered : hovered2);
            button4.revalidate();
            button4.repaint();
        }

        @Nullable
        protected ProgressSuspender getSuspender() {
            ProgressIndicatorEx original = this.myOriginal;
            return original == null ? null : ProgressSuspender.getSuspender(original);
        }

        @Override
        public void stop() {
            super.stop();
            this.updateProgress();
        }

        @Override
        protected boolean isFinished() {
            TaskInfo info2 = this.getInfo();
            return info2 == null || this.isFinished(info2);
        }

        @Override
        public void finish(@NotNull TaskInfo task2) {
            if (task2 == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(12);
            }
            super.finish(task2);
            this.queueRunningUpdate(() -> this.this$0.removeProgress(this));
        }

        @Override
        public void dispose() {
            super.dispose();
            this.myOriginal = null;
        }

        @Override
        protected void cancelRequest() {
            this.myOriginal.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void queueProgressUpdate() {
            Set<InlineProgressIndicator> set2 = this.this$0.myDirtyIndicators;
            synchronized (set2) {
                this.this$0.myDirtyIndicators.add(this);
            }
            this.this$0.myUpdateQueue.queue(this.this$0.myUpdateIndicators);
        }

        @Override
        protected void queueRunningUpdate(final @NotNull Runnable update2) {
            if (update2 == null) {
                MyInlineProgressIndicator.$$$reportNull$$$0(13);
            }
            this.this$0.myUpdateQueue.queue(new Update(new Object(), false, 0){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(update2);
                }
            });
        }

        @Override
        public void updateProgressNow() {
            this.myProgress.setVisible(!PowerSaveMode.isEnabled() || !this.isPaintingIndeterminate());
            super.updateProgressNow();
            if (this.myPresentationModeProgressPanel != null) {
                this.myPresentationModeProgressPanel.update();
            }
        }

        public boolean showInPresentationMode() {
            return !this.this$0.isProcessWindowOpen();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$MyInlineProgressIndicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspend";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancel";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendButton";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "update";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$MyInlineProgressIndicator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEastButtons";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPresentationButtons";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSuspendRunnable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSuspendUpdateRunnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createCompactTextAndProgress";
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 11: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateCancelButton";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuspendUpdateRunnable";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "finish";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "queueRunningUpdate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ProgressPanelProgressIndicator
    extends MyInlineProgressIndicator {
        private final ProgressPanel myProgressPanel;
        private final InplaceButton myCancelButton;
        private final InplaceButton mySuspendButton;
        private final Runnable mySuspendUpdateRunnable;

        ProgressPanelProgressIndicator(@NotNull TaskInfo task2, ProgressIndicatorEx original) {
            if (task2 == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(0);
            }
            if (original == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(1);
            }
            super(InfoAndProgressPanel.this, false, task2, original);
            this.myProgressPanel = Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)this.myProgress));
            UIUtil.putClientProperty((JComponent)this.myComponent, ProcessPopup.KEY, (Object)this.myProgressPanel);
            this.myCancelButton = Objects.requireNonNull(this.myProgressPanel.getCancelButton());
            this.myCancelButton.setPainting(task2.isCancellable());
            this.mySuspendButton = Objects.requireNonNull(this.myProgressPanel.getSuspendButton());
            this.mySuspendUpdateRunnable = this.createSuspendUpdateRunnable(this.mySuspendButton);
            this.setProcessNameValue(task2.getTitle());
        }

        @Override
        @NotNull
        protected Runnable createSuspendUpdateRunnable(@NotNull InplaceButton suspendButton) {
            if (suspendButton == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(2);
            }
            suspendButton.setVisible(false);
            Runnable runnable2 = () -> {
                ProgressSuspender suspender = this.getSuspender();
                suspendButton.setVisible(suspender != null);
                if (suspender != null && this.myProgressPanel.getState() == ProgressPanel.State.PAUSED != suspender.isSuspended()) {
                    this.myProgressPanel.setState(suspender.isSuspended() ? ProgressPanel.State.PAUSED : ProgressPanel.State.PLAYING);
                    InfoAndProgressPanel.this.updateProgressIcon();
                }
            };
            if (runnable2 == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(3);
            }
            return runnable2;
        }

        @Override
        protected boolean canCheckPowerSaveMode() {
            return false;
        }

        @Override
        @NotNull
        protected JPanel createComponent() {
            ProgressPanelBuilder builder2 = new ProgressPanelBuilder(this.myProgress).withTopSeparator();
            builder2.withText2();
            builder2.withCancel(this::cancelRequest);
            Runnable suspendRunnable = this.createSuspendRunnable();
            builder2.withPause(suspendRunnable).withResume(suspendRunnable);
            JPanel jPanel2 = builder2.createPanel();
            if (jPanel2 == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(4);
            }
            return jPanel2;
        }

        @Override
        @Nullable
        protected String getTextValue() {
            return this.myProgressPanel.getCommentText();
        }

        @Override
        protected void setTextValue(@NotNull String text2) {
            if (text2 == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(5);
            }
            this.myProgressPanel.setCommentText(text2);
        }

        @Override
        protected void setTextEnabled(boolean value2) {
            this.myProgressPanel.setCommentEnabled(value2);
        }

        @Override
        protected void setText2Value(@NotNull String text2) {
            if (text2 == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(6);
            }
            this.myProgressPanel.setText2(text2);
        }

        @Override
        protected void setText2Enabled(boolean value2) {
            this.myProgressPanel.setText2Enabled(value2);
        }

        @Override
        protected void setProcessNameValue(@NotNull String text2) {
            if (text2 == null) {
                ProgressPanelProgressIndicator.$$$reportNull$$$0(7);
            }
            this.myProgressPanel.setLabelText(text2);
        }

        @Override
        public void updateProgressNow() {
            super.updateProgressNow();
            this.mySuspendUpdateRunnable.run();
            this.updateCancelButton(this.mySuspendButton, this.myCancelButton);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendButton";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$ProgressPanelProgressIndicator";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$ProgressPanelProgressIndicator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSuspendUpdateRunnable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuspendUpdateRunnable";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setTextValue";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setText2Value";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setProcessNameValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

