/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.ui.IconManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DependencyValidationManager", storages={@Storage(value="scopes", stateSplitter=ScopesStateSplitter.class)})
public final class DependencyValidationManagerImpl
extends DependencyValidationManager {
    private static final Icon ourSharedScopeIcon = IconLoader.createLazy(() -> IconManager.getInstance().createLayered(new Icon[]{AllIcons.Ide.LocalScope, AllIcons.Nodes.Shared}));
    private State myState;
    private final NamedScopeManager myNamedScopeManager;
    private boolean mySkipImportStatements;
    private boolean mySkipImportStatementsWasSpecified;
    @NonNls
    private static final String DENY_RULE_KEY = "deny_rule";
    @NonNls
    private static final String FROM_SCOPE_KEY = "from_scope";
    @NonNls
    private static final String TO_SCOPE_KEY = "to_scope";
    @NonNls
    private static final String IS_DENY_KEY = "is_deny";
    @NonNls
    private static final String UNNAMED_SCOPE = "unnamed_scope";
    @NonNls
    private static final String VALUE = "value";
    private final List<Pair<NamedScope, NamedScopesHolder>> myScopePairs;

    public DependencyValidationManagerImpl(@NotNull Project project) {
        if (project == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myState = new State();
        this.myScopePairs = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myNamedScopeManager = NamedScopeManager.getInstance((Project)project);
        this.myNamedScopeManager.addScopeListener(() -> this.reloadScopes(), (Disposable)project);
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        List<NamedScope> list2 = CustomScopesAggregator.getAllCustomScopes(this.myProject);
        if (list2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public NamedScope getPredefinedScope(@NotNull String name) {
        if (name == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(2);
        }
        for (CustomScopesProvider scopesProvider : CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            NamedScope scope2 = scopesProvider instanceof CustomScopesProviderEx ? ((CustomScopesProviderEx)scopesProvider).getCustomScope(name) : CustomScopesProviderEx.findPredefinedScope((String)name, (List)scopesProvider.getFilteredScopes());
            if (scope2 == null) continue;
            return scope2;
        }
        return null;
    }

    public boolean hasRules() {
        return !this.myState.rules.isEmpty();
    }

    @Nullable
    public DependencyRule getViolatorDependencyRule(@NotNull PsiFile from2, @NotNull PsiFile to) {
        if (from2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(3);
        }
        if (to == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(4);
        }
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from2, to)) continue;
            return dependencyRule;
        }
        return null;
    }

    public DependencyRule @NotNull [] getViolatorDependencyRules(@NotNull PsiFile from2, @NotNull PsiFile to) {
        if (from2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(5);
        }
        if (to == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(6);
        }
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from2, to)) continue;
            result2.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result2.toArray(new DependencyRule[0]);
        if (dependencyRuleArray == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(7);
        }
        return dependencyRuleArray;
    }

    public DependencyRule @NotNull [] getApplicableRules(@NotNull PsiFile file2) {
        if (file2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(8);
        }
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isApplicable(file2)) continue;
            result2.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result2.toArray(new DependencyRule[0]);
        if (dependencyRuleArray == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(9);
        }
        return dependencyRuleArray;
    }

    public boolean skipImportStatements() {
        return this.mySkipImportStatements;
    }

    public void setSkipImportStatements(boolean skip) {
        this.mySkipImportStatements = skip;
    }

    @NotNull
    public Map<String, PackageSet> getUnnamedScopes() {
        Map<String, PackageSet> map2 = this.myState.unnamedScopes;
        if (map2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(10);
        }
        return map2;
    }

    public DependencyRule @NotNull [] getAllRules() {
        List<DependencyRule> rules = this.myState.rules;
        DependencyRule[] dependencyRuleArray = rules.toArray(new DependencyRule[0]);
        if (dependencyRuleArray == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(11);
        }
        return dependencyRuleArray;
    }

    public void removeAllRules() {
        this.myState.rules.clear();
    }

    private void addRule(@NotNull DependencyRule rule, @NotNull State state) {
        if (rule == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(13);
        }
        this.appendUnnamedScope(rule.getFromScope(), state);
        this.appendUnnamedScope(rule.getToScope(), state);
        state.rules.add(rule);
    }

    public void addRule(@NotNull DependencyRule rule) {
        if (rule == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(14);
        }
        this.addRule(rule, this.myState);
    }

    private void appendUnnamedScope(@NotNull NamedScope fromScope, @NotNull State state) {
        PackageSet packageSet;
        if (fromScope == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(16);
        }
        if (this.getScope(fromScope.getScopeId()) == null && (packageSet = fromScope.getValue()) != null && !state.unnamedScopes.containsKey(packageSet.getText())) {
            state.unnamedScopes.put(packageSet.getText(), packageSet);
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = AnalysisBundle.message((String)"shared.scopes.node.text", (Object[])new Object[0]);
        if (string == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    public Icon getIcon() {
        return ourSharedScopeIcon;
    }

    public void loadState(@NotNull Element element2) {
        Element option2;
        if (element2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(18);
        }
        if ((option2 = element2.getChild("option")) != null && "SKIP_IMPORT_STATEMENTS".equals(option2.getAttributeValue("name"))) {
            this.mySkipImportStatementsWasSpecified = !this.myProject.isDefault();
            this.mySkipImportStatements = Boolean.parseBoolean(option2.getAttributeValue(VALUE));
        }
        super.loadState(element2);
        NamedScope[] scopes = this.getEditableScopes();
        Arrays.sort(scopes, (s1, s2) -> {
            String name2;
            String name1 = s1.getScopeId();
            if (Objects.equals(name1, name2 = s2.getScopeId())) {
                return 0;
            }
            List order = this.myNamedScopeManager.myOrderState.myOrder;
            int i1 = order.indexOf(name1);
            int i2 = order.indexOf(name2);
            return i1 - i2;
        });
        super.setScopes(scopes);
        State state = new State();
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        for (Element unnamedScope : element2.getChildren(UNNAMED_SCOPE)) {
            try {
                String packageSet = unnamedScope.getAttributeValue(VALUE);
                state.unnamedScopes.put(packageSet, packageSetFactory.compile(packageSet));
            }
            catch (ParsingException parsingException) {}
        }
        this.readRules(element2, state);
        this.myState = state;
    }

    private void readRules(@NotNull Element element2, State state) {
        if (element2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(19);
        }
        for (Element rule1 : element2.getChildren(DENY_RULE_KEY)) {
            DependencyRule rule = this.readRule(rule1);
            if (rule == null) continue;
            this.addRule(rule, state);
        }
    }

    @NotNull
    public Element getState() {
        Element element2 = super.getState();
        if (this.mySkipImportStatements || this.mySkipImportStatementsWasSpecified) {
            element2.addContent(new Element("option").setAttribute("name", "SKIP_IMPORT_STATEMENTS").setAttribute(VALUE, Boolean.toString(this.mySkipImportStatements)));
        }
        State state = this.myState;
        if (!state.unnamedScopes.isEmpty()) {
            Object[] unnamedScopes = ArrayUtilRt.toStringArray(state.unnamedScopes.keySet());
            Arrays.sort(unnamedScopes);
            for (Object unnamedScope : unnamedScopes) {
                element2.addContent(new Element(UNNAMED_SCOPE).setAttribute(VALUE, (String)unnamedScope));
            }
        }
        DependencyValidationManagerImpl.writeRules(element2, state);
        Element element3 = element2;
        if (element3 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(20);
        }
        return element3;
    }

    private static void writeRules(@NotNull Element element2, @NotNull State state) {
        if (element2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(21);
        }
        if (state == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(22);
        }
        for (DependencyRule rule : state.rules) {
            Element ruleElement = DependencyValidationManagerImpl.writeRule(rule);
            if (ruleElement == null) continue;
            element2.addContent(ruleElement);
        }
    }

    @Nullable
    public NamedScope getScope(@Nullable String scopeId) {
        return this.getScope(scopeId, this.myState);
    }

    private NamedScope getScope(@Nullable String name, @NotNull State state) {
        PackageSet packageSet;
        NamedScope scope2;
        if (state == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(23);
        }
        if ((scope2 = super.getScope(name)) == null && (packageSet = state.unnamedScopes.get(name)) != null) {
            return new NamedScope.UnnamedScope(packageSet);
        }
        if (scope2 == null && Comparing.strEqual((String)name, (String)"Project")) {
            return super.getScope("All");
        }
        return scope2;
    }

    @Nullable
    private static Element writeRule(DependencyRule rule) {
        NamedScope fromScope = rule.getFromScope();
        NamedScope toScope = rule.getToScope();
        if (fromScope == null || toScope == null) {
            return null;
        }
        Element ruleElement = new Element(DENY_RULE_KEY);
        ruleElement.setAttribute(FROM_SCOPE_KEY, fromScope.getScopeId());
        ruleElement.setAttribute(TO_SCOPE_KEY, toScope.getScopeId());
        ruleElement.setAttribute(IS_DENY_KEY, Boolean.valueOf(rule.isDenyRule()).toString());
        return ruleElement;
    }

    @Nullable
    private DependencyRule readRule(@NotNull Element ruleElement) {
        if (ruleElement == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(24);
        }
        String fromScope = ruleElement.getAttributeValue(FROM_SCOPE_KEY);
        String toScope = ruleElement.getAttributeValue(TO_SCOPE_KEY);
        String denyRule = ruleElement.getAttributeValue(IS_DENY_KEY);
        if (fromScope == null || toScope == null || denyRule == null) {
            return null;
        }
        NamedScope fromNamedScope = this.getScope(fromScope);
        NamedScope toNamedScope = this.getScope(toScope);
        if (fromNamedScope == null || toNamedScope == null) {
            return null;
        }
        return new DependencyRule(fromNamedScope, toNamedScope, Boolean.valueOf(denyRule).booleanValue());
    }

    private void reloadScopes() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            ArrayList scopeList = new ArrayList();
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this);
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this.myNamedScopeManager);
            this.myScopePairs.clear();
            this.myScopePairs.addAll(scopeList);
            Element element2 = new Element("rules_2_reload");
            DependencyValidationManagerImpl.writeRules(element2, this.myState);
            State state = new State();
            this.readRules(element2, state);
            this.myState = state;
        });
    }

    private static void addScopesToList(@NotNull List<? super Pair<NamedScope, NamedScopesHolder>> scopeList, @NotNull NamedScopesHolder holder) {
        if (scopeList == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(25);
        }
        if (holder == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(26);
        }
        for (NamedScope scope2 : holder.getScopes()) {
            scopeList.add((Pair<NamedScope, NamedScopesHolder>)Pair.create((Object)scope2, (Object)holder));
        }
    }

    @NotNull
    public List<Pair<NamedScope, NamedScopesHolder>> getScopeBasedHighlightingCachedScopes() {
        List<Pair<NamedScope, NamedScopesHolder>> list2 = this.myScopePairs;
        if (list2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(27);
        }
        return list2;
    }

    public void fireScopeListeners() {
        super.fireScopeListeners();
        this.reloadScopes();
    }

    public void setScopes(NamedScope @NotNull [] scopes) {
        if (scopes == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(28);
        }
        super.setScopes(scopes);
        List order = this.myNamedScopeManager.myOrderState.myOrder;
        order.clear();
        for (NamedScope scope2 : scopes) {
            order.add(scope2.getScopeId());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/DependencyValidationManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 13: 
            case 16: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromScope";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeList";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/DependencyValidationManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedScopes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getViolatorDependencyRules";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableRules";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnnamedScopes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRules";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeBasedHighlightingCachedScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getViolatorDependencyRule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getViolatorDependencyRules";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableRules";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendUnnamedScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readRules";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeRules";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readRule";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addScopesToList";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setScopes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ScopesStateSplitter
    extends MainConfigurationStateSplitter {
        ScopesStateSplitter() {
        }

        @NotNull
        protected String getSubStateFileName(@NotNull Element element2) {
            if (element2 == null) {
                ScopesStateSplitter.$$$reportNull$$$0(0);
            }
            String string = element2.getAttributeValue("name");
            if (string == null) {
                ScopesStateSplitter.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        protected String getComponentStateFileName() {
            return "scope_settings";
        }

        @NotNull
        protected String getSubStateTagName() {
            return "scope";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubStateFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubStateFileName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class State {
        private final List<DependencyRule> rules = new ArrayList<DependencyRule>();
        private final Map<String, PackageSet> unnamedScopes = new HashMap<String, PackageSet>();

        private State() {
        }
    }
}

