/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.profile.codeInspection.ui.table.ScopesOrderTable;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopesOrderDialog
extends DialogWrapper {
    private final ScopesOrderTable myOptionsTable;
    private final InspectionProfileImpl myInspectionProfile;
    @NotNull
    private final Project myProject;
    private final JPanel myPanel;

    ScopesOrderDialog(@NotNull Component parent, @NotNull InspectionProfileImpl inspectionProfile, final @NotNull Project project) {
        if (parent == null) {
            ScopesOrderDialog.$$$reportNull$$$0(0);
        }
        if (inspectionProfile == null) {
            ScopesOrderDialog.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ScopesOrderDialog.$$$reportNull$$$0(2);
        }
        super(parent, true);
        this.myInspectionProfile = inspectionProfile;
        this.myOptionsTable = new ScopesOrderTable();
        this.myProject = project;
        this.reloadScopeList();
        JPanel listPanel = ToolbarDecorator.createDecorator((JTable)((Object)this.myOptionsTable)).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ScopesOrderDialog.this.myOptionsTable.moveDown();
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ScopesOrderDialog.this.myOptionsTable.moveUp();
            }
        }).addExtraAction(new AnActionButton(CodeInsightBundle.messagePointer((String)"action.AnActionButton.text.edit.scopes", (Object[])new Object[0]), AllIcons.Actions.Edit){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new ScopeChooserConfigurable(project));
                ScopesOrderDialog.this.reloadScopeList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/ScopesOrderDialog$1", "actionPerformed"));
            }
        }).disableRemoveAction().disableAddAction().createPanel();
        JLabel descr = ComponentPanelBuilder.createCommentComponent((String)AnalysisBundle.message((String)"inspections.settings.scopes.order.help.label", (Object[])new Object[0]), (boolean)true, (int)110);
        descr.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)listPanel, "Center");
        this.myPanel.add((Component)descr, "South");
        this.init();
        this.setTitle(AnalysisBundle.message((String)"inspections.settings.scopes.order.title", (Object[])new Object[0]));
    }

    private void reloadScopeList() {
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            for (NamedScope scope2 : holder.getScopes()) {
                if (scope2 instanceof NonProjectFilesScope) continue;
                scopes.add(scope2);
            }
        }
        scopes.remove(CustomScopesProviderEx.getAllScope());
        scopes.sort(Comparator.comparing(namedScope -> namedScope.getScopeId(), new ScopeOrderComparator(this.myInspectionProfile)));
        this.myOptionsTable.updateItems(scopes);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        int size2 = this.myOptionsTable.getModel().getRowCount();
        ArrayList<String> newScopeOrder = new ArrayList<String>();
        for (int i2 = 0; i2 < size2; ++i2) {
            NamedScope namedScope = this.myOptionsTable.getScopeAt(i2);
            assert (namedScope != null);
            newScopeOrder.add(namedScope.getScopeId());
        }
        if (!newScopeOrder.equals(this.myInspectionProfile.getScopesOrder())) {
            this.myInspectionProfile.setScopesOrder(newScopeOrder);
        }
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionProfile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/profile/codeInspection/ui/ScopesOrderDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

