/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.FileBasedProfilerProcess;
import com.intellij.profiler.ProfilerProcessBase;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfileHistoryConfiguration;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH$J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0016\u0010\u001c\u001a\u00020\u0017*\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0004R\"\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/FileBasedProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/ProfilerProcessBase;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "dumpFileWhenTargetProcessFinished", "Ljava/io/File;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerTargetProcess;Ljava/io/File;)V", "couldNotDownloadDumpFromTargetException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getCouldNotDownloadDumpFromTargetException", "()Ljava/lang/Exception;", "setCouldNotDownloadDumpFromTargetException", "(Ljava/lang/Exception;)V", "getDumpFileWhenTargetProcessFinished", "()Ljava/io/File;", "onTargetProcessTerminated", "", "prepareDumpBeforeReading", "readPreparedDump", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readPreparedDumpAndReportStatistics", "asProfilerState", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "writer", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "intellij.profiler.common"})
public abstract class FileBasedProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends ProfilerProcessBase<TargetProcess> {
    @Nullable
    private Exception couldNotDownloadDumpFromTargetException;
    @NotNull
    private final File dumpFileWhenTargetProcessFinished;

    @Nullable
    protected final Exception getCouldNotDownloadDumpFromTargetException() {
        return this.couldNotDownloadDumpFromTargetException;
    }

    protected final void setCouldNotDownloadDumpFromTargetException(@Nullable Exception exception) {
        this.couldNotDownloadDumpFromTargetException = exception;
    }

    @Override
    protected void onTargetProcessTerminated() {
        if (this.getState() != Attached.INSTANCE) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ FileBasedProfilerProcess this$0;

            public final void run() {
                if (this.this$0.getState() != Attached.INSTANCE) {
                    return;
                }
                this.this$0.prepareDumpBeforeReading();
                Exception exception = this.this$0.getCouldNotDownloadDumpFromTargetException();
                if (exception != null) {
                    Exception exception2 = exception;
                    boolean bl = false;
                    boolean bl2 = false;
                    Exception e = exception2;
                    boolean bl3 = false;
                    String string = e.getMessage();
                    boolean bl4 = false;
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.this$0.changeStateAndNotifyAsync(new ProfilerError(string2));
                    return;
                }
                this.this$0.changeStateAndNotifyAsync(ReadingData.INSTANCE);
                this.this$0.runUnderDumpReadIndicator((Function1<ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(this){
                    final /* synthetic */ onTargetProcessTerminated.1 this$0;

                    public final void invoke(@NotNull ProgressIndicator it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.this$0.changeStateAndNotifyAsync(this.this$0.this$0.readPreparedDumpAndReportStatistics(this.this$0.this$0.getDumpFileWhenTargetProcessFinished(), it));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = fileBasedProfilerProcess;
            }
        });
    }

    protected void prepareDumpBeforeReading() {
    }

    @NotNull
    protected final ProfilerState readPreparedDumpAndReportStatistics(@NotNull File dump, @NotNull ProgressIndicator indicator2) throws ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        long startTime = System.currentTimeMillis();
        ProfilerState result2 = this.readPreparedDump(dump, indicator2);
        long readTime = System.currentTimeMillis() - startTime;
        if (result2 instanceof DataReady && ((DataReady)result2).getWriter() == null) {
            ProfileHistoryConfiguration.register$default(ProfileHistoryConfiguration.Companion.getInstance(this.getProject()), this.dumpFileWhenTargetProcessFinished, null, 2, null);
        }
        ProfilerUsageTriggerCollector.Companion.reportSnapshotGenerated(this.getProject(), dump.length(), readTime, this.getProfilerConfiguration().getConfigurationTypeId());
        return result2;
    }

    @NotNull
    protected abstract ProfilerState readPreparedDump(@NotNull File var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException;

    @NotNull
    protected final ProfilerState asProfilerState(@NotNull ProfilerDumpFileParsingResult $this$asProfilerState, @Nullable ProfilerDumpWriter writer) {
        ProfilerState profilerState;
        Intrinsics.checkNotNullParameter((Object)$this$asProfilerState, (String)"$this$asProfilerState");
        ProfilerDumpFileParsingResult profilerDumpFileParsingResult = $this$asProfilerState;
        if (profilerDumpFileParsingResult instanceof Success) {
            profilerState = new DataReady(((Success)$this$asProfilerState).getData(), writer);
        } else if (profilerDumpFileParsingResult instanceof Failure) {
            profilerState = new ProfilerError(((Failure)$this$asProfilerState).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return profilerState;
    }

    @NotNull
    protected final File getDumpFileWhenTargetProcessFinished() {
        return this.dumpFileWhenTargetProcessFinished;
    }

    public FileBasedProfilerProcess(@NotNull Project project, @NotNull TargetProcess targetProcess, @NotNull File dumpFileWhenTargetProcessFinished) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)dumpFileWhenTargetProcessFinished, (String)"dumpFileWhenTargetProcessFinished");
        super(project, targetProcess);
        this.dumpFileWhenTargetProcessFinished = dumpFileWhenTargetProcessFinished;
    }
}

