/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\u001a\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/LineByLineParser;", "", "()V", "<set-?>", "", "badLines", "getBadLines", "()I", "setBadLines", "(I)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "consumeLineTimeMs", "", "getConsumeLineTimeMs", "()J", "setConsumeLineTimeMs", "(J)V", "goodLines", "getGoodLines", "setGoodLines", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "consumeLine", "", "line", "", "consumeText", "text", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readFromStream", "inputStream", "Ljava/io/InputStream;", "readLargeFile", "file", "Ljava/io/File;", "Companion", "intellij.profiler.common"})
public abstract class LineByLineParser {
    private final StringBuilder buffer = new StringBuilder();
    private LineSeparator lineSeparator;
    private long consumeLineTimeMs;
    private int goodLines;
    private int badLines;
    @Deprecated
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Companion Companion;

    public final long getConsumeLineTimeMs() {
        return this.consumeLineTimeMs;
    }

    public final void setConsumeLineTimeMs(long l) {
        this.consumeLineTimeMs = l;
    }

    public final int getGoodLines() {
        return this.goodLines;
    }

    protected final void setGoodLines(int n) {
        this.goodLines = n;
    }

    public final int getBadLines() {
        return this.badLines;
    }

    protected final void setBadLines(int n) {
        this.badLines = n;
    }

    public final void readLargeFile(@NotNull File file2, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        File file3 = file2;
        boolean bl = false;
        this.readFromStream(new FileInputStream(file3), indicator2);
    }

    public final void readFromStream(@NotNull InputStream inputStream2, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        byte[] buf = new byte[0x200000];
        int bytesRead;
        while ((bytesRead = inputStream2.read(buf)) > 0) {
            int n = 0;
            boolean bl = false;
            this.consumeText(new String(buf, n, bytesRead, Charsets.UTF_8), indicator2);
        }
        return;
    }

    public final void consumeText(@NotNull String text2, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.buffer.append(text2);
        if (this.lineSeparator == null) {
            this.lineSeparator = StringUtil.detectSeparators((CharSequence)this.buffer);
            if (this.lineSeparator == null) {
                return;
            }
        }
        LineSeparator lineSeparator = this.lineSeparator;
        Intrinsics.checkNotNull((Object)lineSeparator);
        int index2 = this.buffer.lastIndexOf(lineSeparator.getSeparatorString());
        if (index2 == -1) {
            return;
        }
        int start2 = 0;
        while (true) {
            LineSeparator lineSeparator2 = this.lineSeparator;
            Intrinsics.checkNotNull((Object)lineSeparator2);
            index2 = this.buffer.indexOf(lineSeparator2.getSeparatorString(), start2);
            if (index2 == -1) break;
            boolean $i$f$measureTimeMillis = false;
            boolean bl = false;
            long start$iv = System.currentTimeMillis();
            long l = this.consumeLineTimeMs;
            boolean bl2 = false;
            try {
                ProgressIndicator progressIndicator = indicator2;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                String string = this.buffer.substring(start2, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.substring(start, index)");
                this.consumeLine(string);
            }
            catch (Exception e) {
                LOG.error("in LineByLineParser.consumeLine, line = '" + this.buffer.substring(start2, index2) + '\'', (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
            var11_10.consumeLineTimeMs = l + (System.currentTimeMillis() - start$iv);
            LineSeparator lineSeparator3 = this.lineSeparator;
            Intrinsics.checkNotNull((Object)lineSeparator3);
            start2 = index2 + lineSeparator3.getSeparatorString().length();
        }
        this.buffer.delete(0, start2);
    }

    public static /* synthetic */ void consumeText$default(LineByLineParser lineByLineParser, String string, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: consumeText");
        }
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        lineByLineParser.consumeText(string, progressIndicator);
    }

    public abstract void consumeLine(@NotNull String var1);

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LineByLineParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/LineByLineParser$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.common"})
    private static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

