/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.actions.ExportProfilerResultAction;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.Inactive;
import com.intellij.profiler.api.ParsingData;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.Terminated;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.api.configurations.ProfilerConfigurationStateKt;
import com.intellij.profiler.api.configurations.ProfilerConfigurationType;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\"#B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0012\u0010\u001e\u001a\u00020\u00192\b\b\u0001\u0010\u001f\u001a\u00020\u0005H\u0002J\u0012\u0010 \u001a\u00020\u00192\b\b\u0001\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/ProfilerProcessPanel;", "Lcom/intellij/profiler/AbstractProfilerToolWindowPanel;", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "tabName", "", "(Lcom/intellij/profiler/api/ProfilerProcess;Ljava/lang/String;)V", "content", "Lcom/intellij/ui/content/Content;", "Lorg/jetbrains/annotations/NotNull;", "getContent", "()Lcom/intellij/ui/content/Content;", "getProfilerProcess", "()Lcom/intellij/profiler/api/ProfilerProcess;", "smallLoadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "tabIcon", "Ljavax/swing/Icon;", "getTabName", "()Ljava/lang/String;", "time", "", "getTime", "()J", "dispose", "", "newUpdateUI", "state", "Lcom/intellij/profiler/api/ProfilerState;", "onPanelAdd", "setCenteredText", "text", "setReadingData", "stopLoading", "ActiveProfilingPlaceholder", "CloseListener", "intellij.profiler.common"})
public final class ProfilerProcessPanel
extends AbstractProfilerToolWindowPanel {
    private final long time;
    private final Icon tabIcon;
    @NotNull
    private final Content content;
    private final JBLoadingPanel smallLoadingPanel;
    @NotNull
    private final ProfilerProcess<?> profilerProcess;
    @NotNull
    private final String tabName;

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    @NotNull
    public Content getContent() {
        return this.content;
    }

    private final void newUpdateUI(ProfilerState state) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, state){
            final /* synthetic */ ProfilerProcessPanel this$0;
            final /* synthetic */ ProfilerState $state;

            public final void run() {
                block3: {
                    ProfilerState profilerState;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (Disposer.isDisposed((Disposable)this.this$0)) {
                                                return;
                                            }
                                            profilerState = this.$state;
                                            if (!(profilerState instanceof Inactive)) break block2;
                                            ProfilerProcessPanel.access$setCenteredText(this.this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.inactive", new Object[0]));
                                            break block3;
                                        }
                                        if (!(profilerState instanceof Attached)) break block4;
                                        this.this$0.setContent(new ActiveProfilingPlaceholder(this.this$0.getProfilerProcess(), this.this$0));
                                        break block3;
                                    }
                                    if (!(profilerState instanceof ReadingData)) break block5;
                                    ProfilerProcessPanel.access$setReadingData(this.this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.reading.data", new Object[0]));
                                    break block3;
                                }
                                if (!(profilerState instanceof ParsingData)) break block6;
                                ProfilerProcessPanel.access$setReadingData(this.this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.parsing.data", new Object[0]));
                                break block3;
                            }
                            if (!(profilerState instanceof DataReady)) break block7;
                            ProfilerProcessPanel.access$stopLoading(this.this$0);
                            ProfilerDumpWriter profilerDumpWriter = ((DataReady)this.$state).getWriter();
                            if (profilerDumpWriter != null) {
                                ProfilerDumpWriter profilerDumpWriter2 = profilerDumpWriter;
                                boolean bl = false;
                                boolean bl2 = false;
                                ProfilerDumpWriter it = profilerDumpWriter2;
                                boolean bl3 = false;
                                this.this$0.getMyToolbarActions().add((AnAction)new ExportProfilerResultAction(it));
                                this.this$0.updateToolbar();
                            }
                            this.this$0.setContent(((DataReady)this.$state).getData().createTopLevelComponent(this.this$0.getProfilerProcess().getProject(), this.this$0));
                            break block3;
                        }
                        if (!(profilerState instanceof ProfilerError)) break block8;
                        ProfilerProcessPanel.access$stopLoading(this.this$0);
                        ProfilerProcessPanel.access$setCenteredText(this.this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.error", ((ProfilerError)this.$state).getReason()));
                        break block3;
                    }
                    if (!(profilerState instanceof Terminated)) break block3;
                    ProfilerProcessPanel.access$stopLoading(this.this$0);
                    ProfilerProcessPanel.access$setCenteredText(this.this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.terminated", new Object[0]));
                }
            }
            {
                this.this$0 = profilerProcessPanel;
                this.$state = profilerState;
            }
        });
    }

    private final void setReadingData(@Nls String text2) {
        JComponent component2 = this.getContent();
        if (component2 == this.smallLoadingPanel) {
            this.smallLoadingPanel.setLoadingText(text2);
        } else {
            JComponent jComponent = component2;
            if (!(jComponent instanceof ActiveProfilingPlaceholder)) {
                jComponent = null;
            }
            ActiveProfilingPlaceholder activeProfilingPlaceholder = (ActiveProfilingPlaceholder)jComponent;
            if (activeProfilingPlaceholder != null) {
                activeProfilingPlaceholder.stop();
            }
            this.smallLoadingPanel.setLoadingText(text2);
            this.smallLoadingPanel.startLoading();
            this.setContent((JComponent)this.smallLoadingPanel);
        }
    }

    @Override
    public void onPanelAdd() {
        new CloseListener();
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.profilerProcess);
    }

    private final void stopLoading() {
        JComponent jComponent;
        JComponent jComponent2 = this.getComponent();
        if (!(jComponent2 instanceof ActiveProfilingPlaceholder)) {
            jComponent2 = null;
        }
        ActiveProfilingPlaceholder activeProfilingPlaceholder = (ActiveProfilingPlaceholder)jComponent2;
        if (activeProfilingPlaceholder != null) {
            activeProfilingPlaceholder.stop();
        }
        if (!((jComponent = this.getComponent()) instanceof JBLoadingPanel)) {
            jComponent = null;
        }
        JBLoadingPanel jBLoadingPanel = (JBLoadingPanel)jComponent;
        if (jBLoadingPanel != null) {
            jBLoadingPanel.stopLoading();
        }
        this.getContent().setIcon(this.tabIcon);
    }

    private final void setCenteredText(@NlsContexts.Label String text2) {
        String string = StringUtil.escapeXmlEntities((String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.escapeXmlEntities(text)");
        String body = StringsKt.replace$default((String)string, (String)"\n", (String)"<br>", (boolean)false, (int)4, null);
        String string2 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.div((String)"text-align: center").addRaw(body)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"HtmlBuilder().append(Htm\u2026WithHtmlBody().toString()");
        String html = string2;
        JBLabel jBLabel = new JBLabel(html);
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = jBLabel;
        boolean bl3 = false;
        $this$apply.setHorizontalAlignment(0);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        $this$apply.setBackground(editorColorsScheme.getDefaultBackground());
        JBLabel label2 = jBLabel;
        this.setContent((JComponent)new BorderLayoutPanel().addToCenter((Component)label2));
    }

    @NotNull
    public final ProfilerProcess<?> getProfilerProcess() {
        return this.profilerProcess;
    }

    @Override
    @NotNull
    public String getTabName() {
        return this.tabName;
    }

    public ProfilerProcessPanel(@NotNull ProfilerProcess<?> profilerProcess, @NlsContexts.TabTitle @NotNull String tabName) {
        Content $this$apply;
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        this.profilerProcess = profilerProcess;
        this.tabName = tabName;
        this.time = this.profilerProcess.getAttachedTimestamp();
        ProfilerConfigurationType<ProfilerConfigurationState> profilerConfigurationType = ProfilerConfigurationStateKt.getConfigurationType(this.profilerProcess.getProfilerConfiguration());
        if (profilerConfigurationType == null || (profilerConfigurationType = profilerConfigurationType.getIcon()) == null) {
            Icon icon2 = AllIcons.RunConfigurations.Application;
            profilerConfigurationType = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.RunConfigurations.Application");
        }
        this.tabIcon = profilerConfigurationType;
        Object object = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)this), this.getTabName(), true);
        boolean bl = false;
        boolean bl2 = false;
        Content content2 = object;
        ProfilerProcessPanel profilerProcessPanel = this;
        boolean bl3 = false;
        $this$apply.setCloseable(true);
        $this$apply.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        $this$apply.setIcon(this.profilerProcess.getState().isActive() ? ExecutionUtil.getLiveIndicator((Icon)this.tabIcon) : this.tabIcon);
        Unit unit = Unit.INSTANCE;
        Content content3 = object;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"ContentFactory.SERVICE.g\u2026tabIcon) else tabIcon\n  }");
        profilerProcessPanel.content = content3;
        object = new JBLoadingPanel((LayoutManager)new BorderLayout(), new Function(this){
            final /* synthetic */ ProfilerProcessPanel this$0;

            public final LoadingDecorator apply(JPanel panel2) {
                return new LoadingDecorator((JComponent)panel2, (Disposable)this.this$0, 0, true, new AsyncProcessIcon("ProfilerProcessLoading"));
            }
            {
                this.this$0 = profilerProcessPanel;
            }
        });
        bl = false;
        bl2 = false;
        $this$apply = object;
        profilerProcessPanel = this;
        boolean bl4 = false;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        $this$apply.setBackground(editorColorsScheme.getDefaultBackground());
        unit = Unit.INSTANCE;
        profilerProcessPanel.smallLoadingPanel = object;
        String string = this.profilerProcess.getHelpId();
        if (string != null) {
            object = string;
            bl = false;
            bl2 = false;
            Object it = object;
            boolean bl5 = false;
            this.getContent().setHelpId((String)it);
        }
        this.newUpdateUI(this.profilerProcess.getState());
        this.profilerProcess.addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new Function2<ProfilerState, ProfilerState, Unit>(){

            public final void invoke(@NotNull ProfilerState $noName_0, @NotNull ProfilerState newState2) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)newState2, (String)"newState");
                this.newUpdateUI(newState2);
            }
        }));
    }

    public static final /* synthetic */ void access$setCenteredText(ProfilerProcessPanel $this, String text2) {
        $this.setCenteredText(text2);
    }

    public static final /* synthetic */ void access$setReadingData(ProfilerProcessPanel $this, String text2) {
        $this.setReadingData(text2);
    }

    public static final /* synthetic */ void access$stopLoading(ProfilerProcessPanel $this) {
        $this.stopLoading();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ProfilerProcessPanel$CloseListener;", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "(Lcom/intellij/profiler/ProfilerProcessPanel;)V", "closeQuery", "", "content", "Lcom/intellij/ui/content/Content;", "modal", "disposeContent", "", "intellij.profiler.common"})
    private final class CloseListener
    extends BaseContentCloseListener {
        @Override
        protected void disposeContent(@NotNull Content content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (ProfilerProcessPanel.this.getProfilerProcess().getState().isActive()) {
                Disposer.dispose((Disposable)ProfilerProcessPanel.this);
            }
            content2.release();
        }

        @Override
        protected boolean closeQuery(@NotNull Content content2, boolean modal) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (!ProfilerProcessPanel.this.getProfilerProcess().getState().isActive()) {
                return true;
            }
            NopProcessHandler nopProcessHandler = new NopProcessHandler();
            boolean bl = false;
            boolean bl2 = false;
            NopProcessHandler $this$apply = nopProcessHandler;
            boolean bl3 = false;
            $this$apply.startNotify();
            NopProcessHandler proxy = nopProcessHandler;
            proxy.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
            ProfilerProcessPanel.this.getProfilerProcess().addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new Function2<ProfilerState, ProfilerState, Unit>(proxy){
                final /* synthetic */ NopProcessHandler $proxy;

                public final void invoke(@NotNull ProfilerState $noName_0, @NotNull ProfilerState newState2) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)newState2, (String)"newState");
                    if (!newState2.isActive()) {
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                            final /* synthetic */ closeQuery.1 this$0;

                            public final void run() {
                                Thread.sleep(200L);
                                this.this$0.$proxy.destroyProcess();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
                {
                    this.$proxy = nopProcessHandler;
                    super(2);
                }
            }));
            String sessionName = "Profiler for '" + ProfilerProcessPanel.this.getTabName() + '\'';
            if (TerminateRemoteProcessDialog.show(ProfilerProcessPanel.this.getProfilerProcess().getProject(), sessionName, (ProcessHandler)proxy) == null) {
                return false;
            }
            ProfilerProcessPanel.this.getProfilerProcess().terminate();
            return true;
        }

        public CloseListener() {
            super(ProfilerProcessPanel.this.getContent(), ProfilerProcessPanel.this.getProfilerProcess().getProject(), ProfilerProcessPanel.this);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ProfilerProcessPanel$ActiveProfilingPlaceholder;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "parent", "(Lcom/intellij/profiler/api/ProfilerProcess;Lcom/intellij/openapi/Disposable;)V", "duration", "Lcom/intellij/ui/SimpleColoredComponent;", "durationTimeComponent", "durationUpdater", "Ljava/util/concurrent/ScheduledFuture;", "processNameComponent", "profiling", "dispose", "", "stop", "updateProfilingDuration", "intellij.profiler.common"})
    private static final class ActiveProfilingPlaceholder
    extends JPanel
    implements Disposable {
        private final SimpleColoredComponent profiling;
        private final SimpleColoredComponent processNameComponent;
        private final SimpleColoredComponent duration;
        private final SimpleColoredComponent durationTimeComponent;
        private ScheduledFuture<?> durationUpdater;
        private final ProfilerProcess<?> profilerProcess;

        private final void updateProfilingDuration() {
            long durationInMs = System.currentTimeMillis() - this.profilerProcess.getAttachedTimestamp();
            String string = NlsMessages.formatDurationApproximate((long)durationInMs);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NlsMessages.formatDurati\u2026Approximate(durationInMs)");
            String string2 = string;
            this.durationTimeComponent.clear();
            this.durationTimeComponent.append(string2, StatusText.DEFAULT_ATTRIBUTES);
            this.revalidate();
            this.repaint();
        }

        public final void stop() {
            ScheduledFuture<?> scheduledFuture = this.durationUpdater;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            this.durationUpdater = null;
        }

        public void dispose() {
            this.stop();
        }

        public ActiveProfilingPlaceholder(@NotNull ProfilerProcess<?> profilerProcess, @NotNull Disposable parent) {
            boolean bl;
            SimpleColoredComponent $this$apply;
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(new GridBagLayout());
            this.profilerProcess = profilerProcess;
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            boolean bl2 = false;
            boolean bl3 = false;
            SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent;
            ActiveProfilingPlaceholder activeProfilingPlaceholder = this;
            boolean bl4 = false;
            $this$apply.append(CommonProfilerBundleKt.profilerMessage("profiler.placeholder.profiling", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
            Unit unit = Unit.INSTANCE;
            activeProfilingPlaceholder.profiling = simpleColoredComponent;
            simpleColoredComponent = new SimpleColoredComponent();
            bl2 = false;
            bl3 = false;
            $this$apply = simpleColoredComponent;
            activeProfilingPlaceholder = this;
            boolean bl5 = false;
            $this$apply.append(this.profilerProcess.getTargetProcess().getFullName() + "...", StatusText.DEFAULT_ATTRIBUTES);
            unit = Unit.INSTANCE;
            activeProfilingPlaceholder.processNameComponent = simpleColoredComponent;
            simpleColoredComponent = new SimpleColoredComponent();
            bl2 = false;
            bl3 = false;
            $this$apply = simpleColoredComponent;
            activeProfilingPlaceholder = this;
            boolean bl6 = false;
            $this$apply.append(CommonProfilerBundleKt.profilerMessage("profiler.placeholder.duration", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
            unit = Unit.INSTANCE;
            activeProfilingPlaceholder.duration = simpleColoredComponent;
            this.durationTimeComponent = new SimpleColoredComponent();
            simpleColoredComponent = (Function0)new Function0<Unit>(this){

                public final void invoke() {
                    ActiveProfilingPlaceholder.access$updateProfilingDuration((ActiveProfilingPlaceholder)this.receiver);
                }
            };
            this.durationUpdater = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(new Runnable((Function0)simpleColoredComponent){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            }, 0L, 1L, TimeUnit.SECONDS);
            Disposer.register((Disposable)parent, (Disposable)this);
            GridBag gridBag = new GridBag().setDefaultInsets(0, 0, 4, 10).setDefaultAnchor(17);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"GridBag()\n        .setDe\u2026(GridBagConstraints.WEST)");
            GridBag bag = gridBag;
            this.add((Component)this.profiling, bag.nextLine().next());
            this.add((Component)this.processNameComponent, bag.next().coverLine());
            this.add((Component)this.duration, bag.nextLine().next());
            this.add((Component)this.durationTimeComponent, bag.next().coverLine());
            this.add((Component)new SimpleColoredComponent(), bag.nextLine().next().coverLine());
            if (this.profilerProcess.canBeStopped()) {
                HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(CommonProfilerBundleKt.profilerMessage("run.profiler.stopAndShow", new Object[0]));
                boolean bl7 = false;
                bl = false;
                HyperlinkLabel $this$apply2 = hyperlinkLabel;
                boolean bl8 = false;
                $this$apply2.addHyperlinkListener(new HyperlinkListener(this){
                    final /* synthetic */ ActiveProfilingPlaceholder this$0;
                    {
                        this.this$0 = activeProfilingPlaceholder;
                    }

                    public final void hyperlinkUpdate(HyperlinkEvent it) {
                        ActiveProfilingPlaceholder.access$getProfilerProcess$p(this.this$0).stop();
                    }
                });
                HyperlinkLabel stopBtn = hyperlinkLabel;
                this.add((Component)stopBtn, bag.nextLine().next().coverLine().insetTop(4));
            } else {
                SimpleColoredComponent simpleColoredComponent3 = new SimpleColoredComponent();
                boolean bl9 = false;
                bl = false;
                SimpleColoredComponent $this$apply3 = simpleColoredComponent3;
                boolean bl10 = false;
                $this$apply3.append(CommonProfilerBundleKt.profilerMessage("profiler.link.stop.and.get", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
                SimpleColoredComponent stopTargetToGetResults = simpleColoredComponent3;
                this.add((Component)stopTargetToGetResults, bag.nextLine().next().coverLine());
            }
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
            this.setBackground(editorColorsScheme.getDefaultBackground());
        }

        public static final /* synthetic */ void access$updateProfilingDuration(ActiveProfilingPlaceholder $this) {
            $this.updateProfilingDuration();
        }

        public static final /* synthetic */ ProfilerProcess access$getProfilerProcess$p(ActiveProfilingPlaceholder $this) {
            return $this.profilerProcess;
        }
    }
}

