/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.configurations;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.profiler.api.configurations.ConfigurationWithAnotherGroupCreatedException;
import com.intellij.profiler.api.configurations.ExceptionDuringMigrateException;
import com.intellij.profiler.api.configurations.MigrationResult;
import com.intellij.profiler.api.configurations.ObsoleteConfigurationRemainedException;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.api.configurations.ProfilerConfigurationStateKt;
import com.intellij.profiler.api.configurations.ProfilerConfigurationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/api/configurations/ProfilerConfigurationsMigrator;", "", "indexNumber", "", "getIndexNumber", "()I", "languageSettingsGroup", "", "getLanguageSettingsGroup", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "obsoleteConfigurationTypeIds", "", "getObsoleteConfigurationTypeIds", "()Ljava/util/Set;", "migrate", "", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "configurations", "Companion", "intellij.profiler.common"})
@ApiStatus.Experimental
public interface ProfilerConfigurationsMigrator {
    @NotNull
    public static final Companion Companion = com.intellij.profiler.api.configurations.ProfilerConfigurationsMigrator$Companion.$$INSTANCE;

    @NotNull
    public String getName();

    @NotNull
    public String getLanguageSettingsGroup();

    @NotNull
    public Set<String> getObsoleteConfigurationTypeIds();

    public int getIndexNumber();

    @NotNull
    public List<ProfilerConfigurationState> migrate(@NotNull List<? extends ProfilerConfigurationState> var1);

    @NotNull
    public static ExtensionPointName<ProfilerConfigurationsMigrator> getEP_NAME() {
        return Companion.getEP_NAME();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0000\u00a2\u0006\u0002\b\u0014R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/api/configurations/ProfilerConfigurationsMigrator$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationsMigrator;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "allObsoleteConfigurationTypeIds", "", "", "allObsoleteConfigurationTypeIds$intellij_profiler_common", "configurationName", "configuration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "migrateAll", "Lcom/intellij/profiler/api/configurations/MigrationResult;", "configurations", "", "migrateAll$intellij_profiler_common", "intellij.profiler.common"})
    public static final class Companion {
        @NotNull
        private static final ExtensionPointName<ProfilerConfigurationsMigrator> EP_NAME;
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        public static /* synthetic */ void getEP_NAME$annotations() {
        }

        @NotNull
        public final ExtensionPointName<ProfilerConfigurationsMigrator> getEP_NAME() {
            return EP_NAME;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> allObsoleteConfigurationTypeIds$intellij_profiler_common() {
            void var2_3;
            void $this$flatMapTo$iv;
            List list2 = EP_NAME.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.extensionList");
            Iterable iterable = list2;
            boolean bl = false;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ProfilerConfigurationsMigrator it = (ProfilerConfigurationsMigrator)element$iv;
                boolean bl2 = false;
                Iterable list$iv = it.getObsoleteConfigurationTypeIds();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (Set)var2_3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MigrationResult migrateAll$intellij_profiler_common(@NotNull List<? extends ProfilerConfigurationState> configurations) {
            void $this$mapValuesTo$iv$iv;
            Map configurationsByLanguage;
            Object $this$getOrPut$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            void configurationsAbleToMigrate;
            Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
            List list2 = EP_NAME.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.extensionList");
            List extensions2 = list2;
            Iterable $this$partition$iv = configurations;
            boolean $i$f$partition = false;
            Iterable<Object> first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                ProfilerConfigurationState it = (ProfilerConfigurationState)element$iv;
                boolean bl = false;
                if (ProfilerConfigurationStateKt.getConfigurationType(it) != null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list3 = (List)pair.component1();
            List otherConfigurations = (List)pair.component2();
            Iterable $this$groupBy$iv = (Iterable)configurationsAbleToMigrate;
            boolean $i$f$groupBy = false;
            first$iv = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                ProfilerConfigurationState it = (ProfilerConfigurationState)element$iv$iv;
                boolean bl = false;
                ProfilerConfigurationType<ProfilerConfigurationState> profilerConfigurationType = ProfilerConfigurationStateKt.getConfigurationType(it);
                Intrinsics.checkNotNull(profilerConfigurationType);
                String key$iv$iv = profilerConfigurationType.getLanguageSettingsGroup();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$mapValues$iv = configurationsByLanguage = destination$iv$iv;
            boolean $i$f$mapValues = false;
            destination$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                MigrationResult.Status status;
                Map map2;
                Object k;
                block20: {
                    void $this$sortedBy$iv;
                    void $this$filterTo$iv$iv2;
                    void $dstr$languageSettingsGroup$suitableConfigurations;
                    void it$iv$iv;
                    $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv2;
                    boolean bl = false;
                    Object k2 = it$iv$iv.getKey();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    k = k2;
                    map2 = map3;
                    boolean bl3 = false;
                    void var22_33 = $dstr$languageSettingsGroup$suitableConfigurations;
                    boolean bl4 = false;
                    String string = (String)var22_33.getKey();
                    var22_33 = $dstr$languageSettingsGroup$suitableConfigurations;
                    bl4 = false;
                    List<ProfilerConfigurationState> suitableConfigurations = (List<ProfilerConfigurationState>)var22_33.getValue();
                    Iterable $this$filter$iv = extensions2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        void languageSettingsGroup;
                        ProfilerConfigurationsMigrator it = (ProfilerConfigurationsMigrator)element$iv$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getLanguageSettingsGroup(), (Object)languageSettingsGroup)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv3;
                    boolean $i$f$sortedBy = false;
                    boolean $this$filterTo$iv$iv2 = false;
                    List applicableMigrators = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            ProfilerConfigurationsMigrator it = (ProfilerConfigurationsMigrator)a;
                            boolean bl2 = false;
                            Comparable comparable = Integer.valueOf(it.getIndexNumber());
                            it = (ProfilerConfigurationsMigrator)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Integer n = it.getIndexNumber();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    });
                    List<ProfilerConfigurationState> configurationsAfterMigration = suitableConfigurations;
                    Iterable $this$forEachIndexed$iv = applicableMigrators;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        Object object;
                        void $this$filterTo$iv$iv3;
                        Object object2;
                        Object it;
                        Collection<String> collection;
                        Iterable destination$iv$iv4;
                        Iterable $this$map$iv;
                        String string2;
                        void migrator;
                        int n = index$iv++;
                        boolean bl6 = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ProfilerConfigurationsMigrator bl5 = (ProfilerConfigurationsMigrator)item$iv;
                        int index2 = n;
                        boolean bl7 = false;
                        try {
                            configurationsAfterMigration = migrator.migrate((List<? extends ProfilerConfigurationState>)configurationsAfterMigration);
                        }
                        catch (Throwable e) {
                            void $this$mapTo$iv$iv;
                            Iterable iterable2 = CollectionsKt.drop((Iterable)applicableMigrators, (int)(index2 + 1));
                            string2 = migrator.getName();
                            boolean $i$f$map = false;
                            void var40_62 = $this$map$iv;
                            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                ProfilerConfigurationsMigrator profilerConfigurationsMigrator = (ProfilerConfigurationsMigrator)item$iv$iv;
                                collection = destination$iv$iv4;
                                boolean bl8 = false;
                                object2 = it.getName();
                                collection.add((String)object2);
                            }
                            collection = (List)destination$iv$iv4;
                            Throwable throwable = e;
                            List list4 = collection;
                            String string3 = string2;
                            List<ProfilerConfigurationState> list5 = suitableConfigurations;
                            Exception exception = new ExceptionDuringMigrateException(string3, list4, throwable);
                            status = new MigrationResult.Failure(exception, list5);
                            break block20;
                        }
                        Iterable $this$filter$iv2 = configurationsAfterMigration;
                        boolean $i$f$filter2 = false;
                        Iterable $this$mapTo$iv$iv = $this$filter$iv2;
                        destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                            it = (ProfilerConfigurationState)element$iv$iv;
                            boolean bl9 = false;
                            if (!migrator.getObsoleteConfigurationTypeIds().contains(it.getConfigurationTypeId())) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        List remainingObsoleteConfigurations = (List)destination$iv$iv4;
                        $this$filter$iv2 = remainingObsoleteConfigurations;
                        $i$f$filter2 = false;
                        if (!$this$filter$iv2.isEmpty()) {
                            $this$filter$iv2 = CollectionsKt.drop((Iterable)applicableMigrators, (int)(index2 + 1));
                            string2 = migrator.getName();
                            boolean $i$f$map = false;
                            $this$filterTo$iv$iv3 = $this$map$iv;
                            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                it = (ProfilerConfigurationsMigrator)item$iv$iv;
                                collection = destination$iv$iv4;
                                boolean bl10 = false;
                                object2 = it.getName();
                                collection.add((String)object2);
                            }
                            collection = (List)destination$iv$iv4;
                            $this$map$iv = remainingObsoleteConfigurations;
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                it = (ProfilerConfigurationState)item$iv$iv;
                                object2 = destination$iv$iv4;
                                boolean bl11 = false;
                                object = this.configurationName((ProfilerConfigurationState)it);
                                object2.add(object);
                            }
                            Object object3 = object2 = (List)destination$iv$iv4;
                            Collection<String> collection2 = collection;
                            String string4 = string2;
                            List<ProfilerConfigurationState> list6 = suitableConfigurations;
                            Exception exception = new ObsoleteConfigurationRemainedException(string4, (List<String>)collection2, (List<String>)object3);
                            status = new MigrationResult.Failure(exception, list6);
                        } else {
                            Iterable $this$mapTo$iv$iv2;
                            Iterable $this$map$iv2;
                            void $this$filterTo$iv$iv4;
                            Iterable $this$filter$iv3 = configurationsAfterMigration;
                            boolean $i$f$filter3 = false;
                            destination$iv$iv4 = $this$filter$iv3;
                            Collection destination$iv$iv5 = new ArrayList();
                            boolean $i$f$filterTo3 = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv4) {
                                ProfilerConfigurationState it2 = (ProfilerConfigurationState)element$iv$iv;
                                boolean bl12 = false;
                                ProfilerConfigurationType<ProfilerConfigurationState> profilerConfigurationType = ProfilerConfigurationStateKt.getConfigurationType(it2);
                                if (!(Intrinsics.areEqual((Object)(profilerConfigurationType != null ? profilerConfigurationType.getLanguageSettingsGroup() : null), (Object)migrator.getLanguageSettingsGroup()) ^ true)) continue;
                                destination$iv$iv5.add(element$iv$iv);
                            }
                            List configurationsWithDifferentGroup = (List)destination$iv$iv5;
                            $this$filter$iv3 = configurationsWithDifferentGroup;
                            $i$f$filter3 = false;
                            if (!(!$this$filter$iv3.isEmpty())) continue;
                            $this$filter$iv3 = CollectionsKt.drop((Iterable)applicableMigrators, (int)(index2 + 1));
                            string2 = migrator.getName();
                            boolean $i$f$map = false;
                            $this$filterTo$iv$iv4 = $this$map$iv2;
                            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                ProfilerConfigurationsMigrator it2 = (ProfilerConfigurationsMigrator)item$iv$iv;
                                collection = destination$iv$iv5;
                                boolean bl13 = false;
                                object2 = it2.getName();
                                collection.add((String)object2);
                            }
                            collection = (List)destination$iv$iv5;
                            $this$map$iv2 = configurationsWithDifferentGroup;
                            object2 = migrator.getLanguageSettingsGroup();
                            $i$f$map = false;
                            $this$mapTo$iv$iv2 = $this$map$iv2;
                            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                ProfilerConfigurationState it3 = (ProfilerConfigurationState)item$iv$iv;
                                object = destination$iv$iv5;
                                boolean bl14 = false;
                                ProfilerConfigurationType<ProfilerConfigurationState> profilerConfigurationType = ProfilerConfigurationStateKt.getConfigurationType(it3);
                                Pair pair2 = TuplesKt.to((Object)this.configurationName(it3), (Object)(profilerConfigurationType != null ? profilerConfigurationType.getLanguageSettingsGroup() : null));
                                object.add(pair2);
                            }
                            Object object4 = object = (List)destination$iv$iv5;
                            Object object5 = object2;
                            Collection<String> collection3 = collection;
                            String string5 = string2;
                            List<ProfilerConfigurationState> list7 = suitableConfigurations;
                            Exception exception = new ConfigurationWithAnotherGroupCreatedException(string5, (List<String>)collection3, (String)object5, (List<Pair<String, String>>)object4);
                            status = new MigrationResult.Failure(exception, list7);
                        }
                        break block20;
                    }
                    status = new MigrationResult.Success((List<? extends ProfilerConfigurationState>)configurationsAfterMigration);
                }
                MigrationResult.Status status2 = status;
                map2.put(k, status2);
            }
            Map result2 = destination$iv$iv2;
            return new MigrationResult(CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)result2.values()), (Object)new MigrationResult.Success(otherConfigurations)));
        }

        private final String configurationName(ProfilerConfigurationState configuration2) {
            String string = configuration2.getDisplayName();
            if (string == null) {
                string = "<configuration with id " + configuration2.getConfigurationTypeId() + '>';
            }
            return string;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            EP_NAME = new ExtensionPointName("com.intellij.profiler.profilerConfigurationsMigrator");
        }
    }
}

