/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.charts;

import com.intellij.profiler.charts.CategoryLineChart;
import com.intellij.profiler.charts.CategoryLineDataset;
import com.intellij.profiler.charts.ChartWrapperKt;
import com.intellij.profiler.charts.Coordinates;
import com.intellij.profiler.charts.Dataset;
import com.intellij.profiler.charts.Grid;
import com.intellij.profiler.charts.GridChartWrapper;
import com.intellij.profiler.charts.LineChart$WhenMappings;
import com.intellij.profiler.charts.LineChartKt;
import com.intellij.profiler.charts.LineDataset;
import com.intellij.profiler.charts.LineStepped;
import com.intellij.profiler.charts.MinMax;
import com.intellij.profiler.charts.XYLineChart;
import com.intellij.profiler.charts.XYLineDataset;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 /*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0006:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0019J.\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010#J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010!H\u0016J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010&\u001a\u00020'H\u0087\u0002\u00a2\u0006\u0002\b(J\u000b\u0010(\u001a\u00028\u0002\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,H\u0016J-\u0010-\u001a\u00020\u0019*\u00028\u00022\u0006\u0010+\u001a\u00020,2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010!H\u0002\u00a2\u0006\u0002\u0010.R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lcom/intellij/profiler/charts/LineChart;", "X", "", "Y", "D", "Lcom/intellij/profiler/charts/LineDataset;", "Lcom/intellij/profiler/charts/GridChartWrapper;", "()V", "borderPainted", "", "getBorderPainted", "()Z", "setBorderPainted", "(Z)V", "datasets", "", "getDatasets", "()Ljava/util/List;", "setDatasets", "(Ljava/util/List;)V", "ranges", "Lcom/intellij/profiler/charts/Grid;", "getRanges", "()Lcom/intellij/profiler/charts/Grid;", "add", "", "x", "y", "(Ljava/lang/Number;Ljava/lang/Number;)V", "clear", "findLocation", "Ljava/awt/geom/Point2D$Double;", "xy", "Lcom/intellij/profiler/charts/MinMax;", "coordinates", "Lcom/intellij/profiler/charts/Coordinates;", "findMinMax", "get", "label", "", "getDataset", "()Lcom/intellij/profiler/charts/LineDataset;", "paintComponent", "g", "Ljava/awt/Graphics2D;", "paintDataset", "(Lcom/intellij/profiler/charts/LineDataset;Ljava/awt/Graphics2D;Lcom/intellij/profiler/charts/MinMax;)V", "Companion", "intellij.profiler.common"})
public abstract class LineChart<X extends Number, Y extends Number, D extends LineDataset<X, Y>>
extends GridChartWrapper<X, Y> {
    @NotNull
    private List<? extends D> datasets;
    private boolean borderPainted;
    @NotNull
    private final Grid<X, Y> ranges;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<D> getDatasets() {
        return this.datasets;
    }

    public final void setDatasets(@NotNull List<? extends D> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.datasets = list2;
    }

    public final boolean getBorderPainted() {
        return this.borderPainted;
    }

    public final void setBorderPainted(boolean bl) {
        this.borderPainted = bl;
    }

    @Override
    @NotNull
    public Grid<X, Y> getRanges() {
        return this.ranges;
    }

    @Override
    public void paintComponent(@NotNull Graphics2D g) {
        MinMax<X, Y> xy;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int gridWidth = this.getWidth() - (this.getMargins().left + this.getMargins().right);
        int gridHeight = this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
        if (this.borderPainted) {
            g.setColor(this.getGridColor());
            g.drawRect(this.getMargins().left, this.getMargins().top, gridWidth, gridHeight);
        }
        if ((xy = this.findMinMax()).isInitialized()) {
            Graphics graphics = g.create(this.getMargins().left, this.getMargins().top, gridWidth, gridHeight);
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D grid = (Graphics2D)graphics;
            this.paintGrid(grid, g, xy);
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LineDataset it = (LineDataset)element$iv;
                boolean bl = false;
                this.paintDataset(it, grid, xy);
            }
            grid.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MinMax<X, Y> findMinMax() {
        MinMax minMax;
        if (this.getRanges().isInitialized()) {
            minMax = this.getRanges();
        } else {
            MinMax minMax2 = this.getRanges().plus(new MinMax());
            boolean bl = false;
            boolean bl2 = false;
            MinMax minMax3 = minMax2;
            MinMax minMax4 = this.getRanges();
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$apply;
                LineDataset it = (LineDataset)element$iv;
                boolean bl4 = false;
                Iterable iterable = it.getData();
                void var13_14 = $this$apply;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Coordinates p1 = (Coordinates)element$iv2;
                    boolean bl5 = false;
                    var13_14.process(p1);
                }
            }
            Unit unit = Unit.INSTANCE;
            minMax = minMax4.times(minMax2);
        }
        return minMax;
    }

    /*
     * WARNING - void declaration
     */
    private final void paintDataset(D $this$paintDataset, Graphics2D g, MinMax<X, Y> xy) {
        boolean bl;
        Path2D.Double path2 = new Path2D.Double();
        Point2D first = null;
        Rectangle bounds2 = g.getClipBounds();
        g.setPaint(((Dataset)$this$paintDataset).getLineColor());
        g.setStroke(((LineDataset)$this$paintDataset).getStroke());
        boolean useSplines = ((LineDataset)$this$paintDataset).getSmooth() && ((LineDataset)$this$paintDataset).getStepped() == LineStepped.NONE;
        int n = 8;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            int n3 = n2;
            int n4 = n2++;
            double[] dArray2 = dArray;
            boolean bl2 = false;
            dArray2[n4] = d = Double.NaN;
        }
        double[] neighborhood = dArray;
        Object $this$forEachIndexed$iv = ((Dataset)$this$paintDataset).getData();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Object it = $this$forEachIndexed$iv.iterator();
        while (it.hasNext()) {
            void x;
            void $dstr$x$y;
            Object item$iv = it.next();
            int n5 = index$iv++;
            boolean bl3 = false;
            if (n5 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Coordinates coordinates = (Coordinates)item$iv;
            int i2 = n5;
            boolean bl4 = false;
            Object x2 = $dstr$x$y.component1();
            Object y = $dstr$x$y.component2();
            double px = this.findX(xy, x);
            double py = this.findY(xy, y);
            LineChartKt.access$shiftLeftByTwo(neighborhood, px, py);
            if (i2 == 0) {
                first = new Point2D.Double(px, py);
                path2.moveTo(px, py);
                continue;
            }
            if (!useSplines) {
                switch (LineChart$WhenMappings.$EnumSwitchMapping$0[((LineDataset)$this$paintDataset).getStepped().ordinal()]) {
                    case 1: {
                        path2.lineTo(neighborhood[4], py);
                        break;
                    }
                    case 2: {
                        path2.lineTo(px, neighborhood[5]);
                    }
                }
                path2.lineTo(px, py);
                continue;
            }
            if (i2 <= 1) continue;
            LineChartKt.access$curveTo(path2, neighborhood);
        }
        if (useSplines) {
            LineChartKt.access$shiftLeftByTwo(neighborhood, Double.NaN, Double.NaN);
            LineChartKt.access$curveTo(path2, neighborhood);
        }
        g.setPaint(((Dataset)$this$paintDataset).getLineColor());
        g.setStroke(((LineDataset)$this$paintDataset).getStroke());
        g.draw(path2);
        Point2D point2D = path2.getCurrentPoint();
        if (point2D != null) {
            $this$forEachIndexed$iv = point2D;
            bl = false;
            n2 = 0;
            Object last = $this$forEachIndexed$iv;
            boolean bl5 = false;
            path2.lineTo(((Point2D)last).getX(), (double)bounds2.height + 1.0);
            Point2D point2D2 = first;
            if (point2D2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"first");
            }
            path2.lineTo(point2D2.getX(), (double)bounds2.height + 1.0);
            path2.closePath();
        }
        Paint paint2 = ((Dataset)$this$paintDataset).getFillColor();
        if (paint2 != null) {
            $this$forEachIndexed$iv = paint2;
            bl = false;
            n2 = 0;
            it = $this$forEachIndexed$iv;
            boolean bl6 = false;
            g.setPaint((Paint)it);
            g.fill(path2);
        }
        if (((LineDataset)$this$paintDataset).getStacked()) {
            Area area = new Area(g.getClip());
            area.subtract(new Area(path2));
            g.setClip(area);
        }
    }

    @NotNull
    public final Point2D.Double findLocation(@NotNull MinMax<X, Y> xy, @NotNull Coordinates<X, Y> coordinates) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        return new Point2D.Double(this.findX(xy, coordinates.getX()) + (double)this.getMargins().left, this.findY(xy, coordinates.getY()) + (double)this.getMargins().top);
    }

    public void add(@NotNull X x, @NotNull Y y) {
        block0: {
            Intrinsics.checkNotNullParameter(x, (String)"x");
            Intrinsics.checkNotNullParameter(y, (String)"y");
            LineDataset lineDataset = (LineDataset)CollectionsKt.firstOrNull(this.datasets);
            if (lineDataset == null) break block0;
            lineDataset.add(ChartWrapperKt.to(x, y));
        }
    }

    @NotNull
    public final D getDataset() {
        return (D)((LineDataset)CollectionsKt.first(this.datasets));
    }

    @JvmName(name="getDataset")
    @NotNull
    public final LineDataset<X, Y> getDataset(@NotNull String label2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            Iterable iterable = this.datasets;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                LineDataset it = (LineDataset)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getLabel(), (Object)label2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        LineDataset lineDataset = v0;
        if (lineDataset == null) {
            throw (Throwable)new NoSuchElementException("Cannot find dataset with label " + this.datasets);
        }
        return lineDataset;
    }

    public final void clear() {
        Iterable $this$forEach$iv = this.datasets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineDataset it = (LineDataset)element$iv;
            boolean bl = false;
            Iterable iterable = it.getData();
            if (iterable == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.charts.Coordinates<X, Y>>");
            }
            TypeIntrinsics.asMutableList(iterable).clear();
        }
    }

    public LineChart() {
        boolean bl = false;
        this.datasets = new ArrayList();
        this.ranges = new Grid();
    }

    @JvmStatic
    @NotNull
    public static final <T extends Number, D extends CategoryLineDataset<T>> CategoryLineChart<T> of(D ... values2) {
        return Companion.of((CategoryLineDataset[])values2);
    }

    @JvmStatic
    @NotNull
    public static final <X extends Number, Y extends Number, D extends XYLineDataset<X, Y>> XYLineChart<X, Y> of(D ... values2) {
        return Companion.of((XYLineDataset[])values2);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Number> CategoryLineChart<T> of(T ... values2) {
        return Companion.of((Number[])values2);
    }

    @JvmStatic
    @NotNull
    public static final <X extends Number, Y extends Number> XYLineChart<X, Y> of(Coordinates<X, Y> ... points) {
        return Companion.of(points);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0003\u0010\u0005*\u00020\u0006\"\u000e\b\u0004\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00050\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\n\"\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\u000bJW\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\f\"\b\b\u0003\u0010\r*\u00020\u0006\"\b\b\u0004\u0010\u000e*\u00020\u0006\"\u0014\b\u0005\u0010\u0007*\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\n\"\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\u0010J1\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0003\u0010\u0005*\u00020\u00062\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\n\"\u0002H\u0005H\u0007\u00a2\u0006\u0002\u0010\u0011JY\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\f\"\b\b\u0003\u0010\r*\u00020\u0006\"\b\b\u0004\u0010\u000e*\u00020\u00062*\u0010\u0012\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00130\n\"\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/charts/LineChart$Companion;", "", "()V", "of", "Lcom/intellij/profiler/charts/CategoryLineChart;", "T", "", "D", "Lcom/intellij/profiler/charts/CategoryLineDataset;", "values", "", "([Lcom/intellij/profiler/charts/CategoryLineDataset;)Lcom/intellij/profiler/charts/CategoryLineChart;", "Lcom/intellij/profiler/charts/XYLineChart;", "X", "Y", "Lcom/intellij/profiler/charts/XYLineDataset;", "([Lcom/intellij/profiler/charts/XYLineDataset;)Lcom/intellij/profiler/charts/XYLineChart;", "([Ljava/lang/Number;)Lcom/intellij/profiler/charts/CategoryLineChart;", "points", "Lcom/intellij/profiler/charts/Coordinates;", "([Lcom/intellij/profiler/charts/Coordinates;)Lcom/intellij/profiler/charts/XYLineChart;", "intellij.profiler.common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T extends Number, D extends CategoryLineDataset<T>> CategoryLineChart<T> of(D ... values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            CategoryLineChart categoryLineChart = new CategoryLineChart();
            boolean bl = false;
            boolean bl2 = false;
            CategoryLineChart $this$apply = categoryLineChart;
            boolean bl3 = false;
            $this$apply.setDatasets(CollectionsKt.mutableListOf((Object[])((CategoryLineDataset[])Arrays.copyOf(values2, values2.length))));
            return categoryLineChart;
        }

        @JvmStatic
        @NotNull
        public final <X extends Number, Y extends Number, D extends XYLineDataset<X, Y>> XYLineChart<X, Y> of(D ... values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            XYLineChart xYLineChart = new XYLineChart();
            boolean bl = false;
            boolean bl2 = false;
            XYLineChart $this$apply = xYLineChart;
            boolean bl3 = false;
            $this$apply.setDatasets(CollectionsKt.mutableListOf((Object[])((XYLineDataset[])Arrays.copyOf(values2, values2.length))));
            return xYLineChart;
        }

        @JvmStatic
        @NotNull
        public final <T extends Number> CategoryLineChart<T> of(T ... values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            CategoryLineChart categoryLineChart = new CategoryLineChart();
            boolean bl = false;
            boolean bl2 = false;
            CategoryLineChart $this$apply = categoryLineChart;
            boolean bl3 = false;
            $this$apply.setDatasets(CollectionsKt.mutableListOf((Object[])new CategoryLineDataset[]{LineDataset.Companion.of((Number[])Arrays.copyOf(values2, values2.length))}));
            return categoryLineChart;
        }

        @JvmStatic
        @NotNull
        public final <X extends Number, Y extends Number> XYLineChart<X, Y> of(Coordinates<X, Y> ... points) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            XYLineChart xYLineChart = new XYLineChart();
            boolean bl = false;
            boolean bl2 = false;
            XYLineChart $this$apply = xYLineChart;
            boolean bl3 = false;
            $this$apply.setDatasets(CollectionsKt.mutableListOf((Object[])new XYLineDataset[]{LineDataset.Companion.of(Arrays.copyOf(points, points.length))}));
            return xYLineChart;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

