/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.model;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallStackElementKt;
import com.intellij.util.containers.Interner;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0006\u0010\u0004\u001a\u00020\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/model/NativeCall;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "library", "", "methodWithClassOrFunction", "(Ljava/lang/String;Ljava/lang/String;)V", "className", "methodOrFunction", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getLibrary", "getMethodOrFunction", "getType", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "fullName", "hashCode", "", "toString", "Companion", "intellij.profiler.common"})
public final class NativeCall
extends BaseCallStackElement {
    @NotNull
    private final String library;
    @NotNull
    private final String className;
    @NotNull
    private final String methodOrFunction;
    @NotNull
    private final String type;
    private static final String LIBRARY_DELIMITER = "`";
    private static final String CPP_CLASS_DELIMITER = "::";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String fullName() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        CharSequence charSequence = this.library;
        boolean bl6 = false;
        if (charSequence.length() > 0) {
            $this$buildString.append(this.library + LIBRARY_DELIMITER);
        }
        $this$buildString.append(this.methodWithClassOrFunction());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String methodWithClassOrFunction() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        CharSequence charSequence = this.className;
        boolean bl6 = false;
        if (charSequence.length() > 0) {
            $this$buildString.append(this.className + CPP_CLASS_DELIMITER);
        }
        $this$buildString.append(this.methodOrFunction);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String getLibrary() {
        return this.library;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getMethodOrFunction() {
        return this.methodOrFunction;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @JvmOverloads
    public NativeCall(@NotNull String library2, @NotNull String className, @NotNull String methodOrFunction, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodOrFunction, (String)"methodOrFunction");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.library = library2;
        this.className = className;
        this.methodOrFunction = methodOrFunction;
        this.type = type;
    }

    public /* synthetic */ NativeCall(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = "";
        }
        this(string, string2, string3, string4);
    }

    @JvmOverloads
    public NativeCall(@NotNull String library2, @NotNull String className, @NotNull String methodOrFunction) {
        this(library2, className, methodOrFunction, null, 8, null);
    }

    public NativeCall(@NotNull String library2, @NotNull String methodWithClassOrFunction) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)methodWithClassOrFunction, (String)"methodWithClassOrFunction");
        this(library2, "", methodWithClassOrFunction, null, 8, null);
    }

    @NotNull
    public final String component1() {
        return this.library;
    }

    @NotNull
    public final String component2() {
        return this.className;
    }

    @NotNull
    public final String component3() {
        return this.methodOrFunction;
    }

    @NotNull
    public final String component4() {
        return this.type;
    }

    @NotNull
    public final NativeCall copy(@NotNull String library2, @NotNull String className, @NotNull String methodOrFunction, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodOrFunction, (String)"methodOrFunction");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new NativeCall(library2, className, methodOrFunction, type);
    }

    public static /* synthetic */ NativeCall copy$default(NativeCall nativeCall, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = nativeCall.library;
        }
        if ((n & 2) != 0) {
            string2 = nativeCall.className;
        }
        if ((n & 4) != 0) {
            string3 = nativeCall.methodOrFunction;
        }
        if ((n & 8) != 0) {
            string4 = nativeCall.type;
        }
        return nativeCall.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "NativeCall(library=" + this.library + ", className=" + this.className + ", methodOrFunction=" + this.methodOrFunction + ", type=" + this.type + ")";
    }

    public int hashCode() {
        String string = this.library;
        String string2 = this.className;
        String string3 = this.methodOrFunction;
        String string4 = this.type;
        return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof NativeCall)) break block3;
                NativeCall nativeCall = (NativeCall)object;
                if (!Intrinsics.areEqual((Object)this.library, (Object)nativeCall.library) || !Intrinsics.areEqual((Object)this.className, (Object)nativeCall.className) || !Intrinsics.areEqual((Object)this.methodOrFunction, (Object)nativeCall.methodOrFunction) || !Intrinsics.areEqual((Object)this.type, (Object)nativeCall.type)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J.\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/model/NativeCall$Companion;", "", "()V", "CPP_CLASS_DELIMITER", "", "LIBRARY_DELIMITER", "isCPPCall", "", "call", "isObjCCall", "read", "Lcom/intellij/profiler/model/NativeCall;", "string", "interner", "Lcom/intellij/util/containers/Interner;", "type", "intellij.profiler.common"})
    public static final class Companion {
        @JvmOverloads
        @Nullable
        public final NativeCall read(@NotNull String string, @Nullable Interner<String> interner, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String library2 = StringsKt.substringBefore((String)string, (String)NativeCall.LIBRARY_DELIMITER, (String)"");
            String call = StringsKt.substringAfter$default((String)string, (String)NativeCall.LIBRARY_DELIMITER, null, (int)2, null);
            CharSequence charSequence = library2;
            boolean bl = false;
            if (charSequence.length() == 0 && !this.isCPPCall(call) && !this.isObjCCall(call)) {
                return null;
            }
            String className = StringsKt.substringBefore((String)call, (String)NativeCall.CPP_CLASS_DELIMITER, (String)"");
            String methodOrFunction = StringsKt.substringAfter$default((String)call, (String)NativeCall.CPP_CLASS_DELIMITER, null, (int)2, null);
            return new NativeCall(CallStackElementKt.access$tryIntern(library2, interner), CallStackElementKt.access$tryIntern(className, interner), CallStackElementKt.access$tryIntern(methodOrFunction, interner), type);
        }

        public static /* synthetic */ NativeCall read$default(Companion companion, String string, Interner interner, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                interner = null;
            }
            if ((n & 4) != 0) {
                string2 = "";
            }
            return companion.read(string, (Interner<String>)interner, string2);
        }

        @JvmOverloads
        @Nullable
        public final NativeCall read(@NotNull String string, @Nullable Interner<String> interner) {
            return com.intellij.profiler.model.NativeCall$Companion.read$default(this, string, interner, null, 4, null);
        }

        @JvmOverloads
        @Nullable
        public final NativeCall read(@NotNull String string) {
            return com.intellij.profiler.model.NativeCall$Companion.read$default(this, string, null, null, 6, null);
        }

        public final boolean isCPPCall(@NotNull String call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            return StringsKt.contains$default((CharSequence)call, (CharSequence)NativeCall.CPP_CLASS_DELIMITER, (boolean)false, (int)2, null);
        }

        public final boolean isObjCCall(@NotNull String call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            return StringsKt.contains$default((CharSequence)call, (CharSequence)"-[", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)call, (CharSequence)"+[", (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

