/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.statistics;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.api.ProfilerDumpParserProviderKt;
import com.intellij.profiler.api.configurations.ProfilerConfigurationType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector;", "", "()V", "Companion", "ProfilerConfigurationTypeValidator", "SnapshotTypeValidator", "intellij.profiler.common"})
public final class ProfilerUsageTriggerCollector {
    private static final String GROUP = "profiler.usage";
    private static final String CONFIGURATION_TYPE = "profiler_configuration_type";
    private static final String LOAD_TIME = "load_time";
    private static final String SIZE = "size";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void reportStart(@Nullable Project project, @NotNull String profilerConfigurationType, @NotNull String runConfigurationType) {
        Companion.reportStart(project, profilerConfigurationType, runConfigurationType);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$ProfilerConfigurationTypeValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "acceptRuleId", "", "ruleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.profiler.common"})
    public static final class ProfilerConfigurationTypeValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return Intrinsics.areEqual((Object)ProfilerUsageTriggerCollector.CONFIGURATION_TYPE, (Object)ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (Intrinsics.areEqual((Object)data2, (Object)"legacy.dtrace") || Intrinsics.areEqual((Object)data2, (Object)"legacy.perf")) {
                    return ValidationResultType.ACCEPTED;
                }
                Iterable iterable = ProfilerConfigurationType.Companion.availableEPs();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ProfilerConfigurationType it = (ProfilerConfigurationType)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)data2)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ProfilerConfigurationType profilerConfigurationType = v0;
            if (profilerConfigurationType == null) {
                return ValidationResultType.REJECTED;
            }
            ProfilerConfigurationType configurationType = profilerConfigurationType;
            return PluginInfoDetectorKt.getPluginInfo(configurationType.getClass()).isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotTypeValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "acceptRuleId", "", "ruleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.profiler.common"})
    public static final class SnapshotTypeValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return Intrinsics.areEqual((Object)"profiler_snapshot_type", (Object)ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (Intrinsics.areEqual((Object)data2, (Object)"hprof.readOnly") || Intrinsics.areEqual((Object)data2, (Object)"hprof.readWrite")) {
                    return ValidationResultType.ACCEPTED;
                }
                Iterable iterable = ProfilerDumpParserProviderKt.getProfilerDumpParserProviders();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ProfilerDumpParserProvider it = (ProfilerDumpParserProvider)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)data2)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ProfilerDumpParserProvider profilerDumpParserProvider = v0;
            if (profilerDumpParserProvider == null) {
                return ValidationResultType.REJECTED;
            }
            ProfilerDumpParserProvider configurationType = profilerDumpParserProvider;
            return PluginInfoDetectorKt.getPluginInfo(configurationType.getClass()).isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\"\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\tJ(\u0010\u0013\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0004J(\u0010\u0017\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\"\u0010\u0019\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J \u0010\u001b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$Companion;", "", "()V", "CONFIGURATION_TYPE", "", "GROUP", "LOAD_TIME", "SIZE", "report", "", "project", "Lcom/intellij/openapi/project/Project;", "eventId", "data", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "reportAttach", "profilerConfigurationType", "reportRecursionCheckbox", "reportRecursionCollapse", "reportSnapshotGenerated", "size", "", "loadTime", "reportSnapshotOpen", "type", "reportStart", "runConfigurationType", "reportTabOpen", "tabName", "relativeTime", "intellij.profiler.common"})
    public static final class Companion {
        @JvmStatic
        public final void reportStart(@Nullable Project project, @NotNull String profilerConfigurationType, @NotNull String runConfigurationType) {
            Intrinsics.checkNotNullParameter((Object)profilerConfigurationType, (String)"profilerConfigurationType");
            Intrinsics.checkNotNullParameter((Object)runConfigurationType, (String)"runConfigurationType");
            FeatureUsageData data2 = new FeatureUsageData().addData(ProfilerUsageTriggerCollector.CONFIGURATION_TYPE, profilerConfigurationType).addData("run_configuration_type", runConfigurationType);
            this.report(project, "start", data2);
        }

        public final void reportSnapshotGenerated(@Nullable Project project, long size2, long loadTime, @NotNull String profilerConfigurationType) {
            Intrinsics.checkNotNullParameter((Object)profilerConfigurationType, (String)"profilerConfigurationType");
            FeatureUsageData data2 = new FeatureUsageData().addData(ProfilerUsageTriggerCollector.SIZE, size2).addData(ProfilerUsageTriggerCollector.LOAD_TIME, loadTime).addData(ProfilerUsageTriggerCollector.CONFIGURATION_TYPE, profilerConfigurationType);
            this.report(project, "snapshot.generated", data2);
        }

        public final void reportAttach(@Nullable Project project, @NotNull String profilerConfigurationType) {
            Intrinsics.checkNotNullParameter((Object)profilerConfigurationType, (String)"profilerConfigurationType");
            this.report(project, "attach", new FeatureUsageData().addData(ProfilerUsageTriggerCollector.CONFIGURATION_TYPE, profilerConfigurationType));
        }

        public final void reportRecursionCollapse() {
            this.report(null, "tree.recursion.collapse");
        }

        public final void reportRecursionCheckbox(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.report(project, "tree.recursion.checkbox");
        }

        public final void reportSnapshotOpen(@Nullable Project project, @NotNull String type, long size2, long loadTime) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.report(project, "snapshot.open", new FeatureUsageData().addData(ProfilerUsageTriggerCollector.SIZE, size2).addData("type", type).addData(ProfilerUsageTriggerCollector.LOAD_TIME, loadTime));
        }

        public final void reportTabOpen(@Nullable Project project, @NotNull String tabName, long relativeTime) {
            Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
            this.report(project, "tab.open", new FeatureUsageData().addData("name", tabName).addData(ProfilerUsageTriggerCollector.LOAD_TIME, relativeTime));
        }

        private final void report(Project project, String eventId) {
            FUCounterUsageLogger.getInstance().logEvent(project, ProfilerUsageTriggerCollector.GROUP, eventId);
        }

        private final void report(Project project, String eventId, FeatureUsageData data2) {
            FUCounterUsageLogger.getInstance().logEvent(project, ProfilerUsageTriggerCollector.GROUP, eventId, data2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

