/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.ui.CascadeExpansion;
import com.intellij.profiler.ui.callusage.MainCallTreeUIModel;
import com.intellij.profiler.ui.treetable.TreeExpandedPaths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ui/callusage/UsageModelActions;", "", "()V", "fold", "", "tree", "Ljavax/swing/JTree;", "path", "Ljavax/swing/tree/TreePath;", "mergePaths", "head", "tail", "unfold", "intellij.profiler.common"})
public final class UsageModelActions {
    @NotNull
    public static final UsageModelActions INSTANCE;

    public final void fold(@NotNull JTree tree, @NotNull TreePath path2) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        TreeModel treeModel = tree.getModel();
        if (treeModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.callusage.MainCallTreeUIModel");
        }
        MainCallTreeUIModel model2 = (MainCallTreeUIModel)((Object)treeModel);
        Object object = path2.getLastPathComponent();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.callusage.CallUsageNode /* = com.intellij.profiler.model.CallTreeNode<com.intellij.profiler.api.BaseCallStackElement> */");
        }
        CallTreeNode<BaseCallStackElement> foldedNode = model2.getFoldedNode((CallTreeNode)object);
        TreeExpandedPaths treeExpandedPaths = TreeExpandedPaths.createOn(tree, path2);
        boolean bl = false;
        boolean bl2 = false;
        TreeExpandedPaths $this$apply = treeExpandedPaths;
        boolean bl3 = false;
        if (tree.isExpanded(path2)) {
            $this$apply.with(path2);
        }
        TreeExpandedPaths state = treeExpandedPaths;
        TreePath folded = model2.foldPath(path2, foldedNode);
        if (folded != path2) {
            TreeExpandedPaths treeExpandedPaths2 = state.updateAny(new TreeExpandedPaths.TreePathReplacer(folded){
                final /* synthetic */ TreePath $folded;

                public final TreePath replace(TreePath it) {
                    TreePath treePath = it;
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"it");
                    return UsageModelActions.access$mergePaths(UsageModelActions.INSTANCE, treePath, this.$folded);
                }
                {
                    this.$folded = treePath;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)treeExpandedPaths2, (String)"state.updateAny { mergePaths(it, folded) }");
            List<TreePath> paths2 = treeExpandedPaths2.getPaths();
            if (paths2.size() > 0) {
                List<TreePath> list2 = paths2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"paths");
                CascadeExpansion.Companion.expandPathsWithoutCascade(tree, (Collection<? extends TreePath>)list2);
            }
            tree.setSelectionPath(folded);
        }
    }

    public final void unfold(@NotNull JTree tree, @NotNull TreePath path2) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        TreeExpandedPaths treeExpandedPaths = TreeExpandedPaths.createOn(tree, path2);
        boolean bl = false;
        boolean bl2 = false;
        TreeExpandedPaths $this$apply = treeExpandedPaths;
        boolean bl3 = false;
        TreePath treePath = path2.getParentPath();
        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"path.parentPath");
        CascadeExpansion.Companion.expandPathWithoutCascade(tree, treePath);
        TreeExpandedPaths state = treeExpandedPaths;
        TreeModel treeModel = tree.getModel();
        if (treeModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.callusage.MainCallTreeUIModel");
        }
        TreePath unfolded = ((MainCallTreeUIModel)((Object)treeModel)).unfoldPath(path2);
        if (unfolded != path2) {
            TreeExpandedPaths treeExpandedPaths2 = state.updateAny(new TreeExpandedPaths.TreePathReplacer(unfolded){
                final /* synthetic */ TreePath $unfolded;

                public final TreePath replace(TreePath it) {
                    TreePath treePath = it;
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"it");
                    return UsageModelActions.access$mergePaths(UsageModelActions.INSTANCE, treePath, this.$unfolded);
                }
                {
                    this.$unfolded = treePath;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)treeExpandedPaths2, (String)"state.updateAny { mergePaths(it, unfolded) }");
            List<TreePath> paths2 = treeExpandedPaths2.getPaths();
            if (paths2.size() > 0) {
                List<TreePath> list2 = paths2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"paths");
                CascadeExpansion.Companion.expandPathsWithoutCascade(tree, (Collection<? extends TreePath>)list2);
            } else {
                TreePath treePath2 = unfolded.getParentPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"unfolded.parentPath");
                CascadeExpansion.Companion.expandPathWithoutCascade(tree, treePath2);
            }
            tree.setSelectionPath(unfolded);
        }
    }

    private final TreePath mergePaths(TreePath head, TreePath tail) {
        TreePath current2;
        LinkedList<Object> path2 = new LinkedList<Object>();
        for (current2 = head; current2 != null && Intrinsics.areEqual((Object)current2.getLastPathComponent(), (Object)tail.getLastPathComponent()) ^ true; current2 = current2.getParentPath()) {
            path2.add(0, current2.getLastPathComponent());
        }
        if (current2 == null) {
            path2.clear();
        }
        for (current2 = tail; current2 != null; current2 = current2.getParentPath()) {
            path2.add(0, current2.getLastPathComponent());
        }
        return new TreePath(path2.toArray());
    }

    private UsageModelActions() {
    }

    static {
        UsageModelActions usageModelActions;
        INSTANCE = usageModelActions = new UsageModelActions();
    }

    public static final /* synthetic */ TreePath access$mergePaths(UsageModelActions $this, TreePath head, TreePath tail) {
        return $this.mergePaths(head, tail);
    }
}

