/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.flamegraph.FlameGraphRenderer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.FontUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0004J$\u0010\u0014\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0014J&\u0010\u0017\u001a\u0004\u0018\u00010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0014J,\u0010\u0018\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J,\u0010\u0019\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0014J,\u0010\u001a\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphRenderer;", "T", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphRenderer;", "()V", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "setBackground", "(Ljava/awt/Color;)V", "beforePaint", "", "component", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "g", "Ljava/awt/Graphics2D;", "fillRect", "rect", "Ljava/awt/geom/RectangularShape;", "color", "getBackgroundColor", "bounds", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "getBorderColor", "paint", "paintRectangle", "paintText", "intellij.profiler.common"})
public class DefaultFlameGraphRenderer<T>
implements FlameGraphRenderer<T> {
    @NotNull
    private Color background;

    @NotNull
    protected final Color getBackground() {
        return this.background;
    }

    protected final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.background = color;
    }

    @Override
    public void beforePaint(@NotNull FlameGraphPanel<T> component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (SystemInfo.isMac) {
            g.setFont(FontUtil.disableKerning((Font)g.getFont()));
        }
    }

    @Override
    public void paint(@NotNull FlameGraphPanel<T> component2, @NotNull Graphics2D g, @NotNull FlameGraphNode<T> bounds2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        this.background = new Color(this.getBackgroundColor(component2, bounds2).getRGB());
        this.paintRectangle(component2, g, bounds2);
        this.paintText(component2, g, bounds2);
    }

    protected void paintRectangle(@NotNull FlameGraphPanel<T> component2, @NotNull Graphics2D g, @NotNull FlameGraphNode<T> bounds2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        AffineTransform transform = g.getTransform();
        double d = 1.0;
        AffineTransform affineTransform = transform;
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"transform");
        double scaleX = d / affineTransform.getScaleX();
        double scaleY = 1.0 / transform.getScaleY();
        Rectangle rectangle = g.getClipBounds();
        boolean bl = false;
        boolean bl2 = false;
        Rectangle $this$with = rectangle;
        boolean bl3 = false;
        Rectangle2D.Double outerRect = new Rectangle2D.Double((double)$this$with.x - scaleX, $this$with.y, (double)$this$with.width + scaleX, (double)$this$with.height + scaleY);
        Rectangle2D.Double innerRect = new Rectangle2D.Double(outerRect.x + scaleX, outerRect.y + scaleY, outerRect.width - scaleX * (double)2, outerRect.height - scaleY * (double)2);
        g.setClip(outerRect);
        Color color = this.getBorderColor(component2, bounds2);
        if (color == null) {
            Color color2 = ColorUtil.mix((Color)this.background, (Color)Color.BLACK, (double)(0.1 / scaleX));
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"ColorUtil.mix(background\u2026olor.BLACK, 0.1 / scaleX)");
            color = new Color(color2.getRGB());
        }
        Color border = color;
        this.fillRect(g, outerRect, border);
        this.fillRect(g, innerRect, this.background);
    }

    protected final void fillRect(@NotNull Graphics2D g, @NotNull RectangularShape rect, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        g.setColor(color);
        g.fill(rect);
    }

    protected void paintText(@NotNull FlameGraphPanel<T> component2, @NotNull Graphics2D g, @NotNull FlameGraphNode<T> bounds2) {
        block0: {
            Intrinsics.checkNotNullParameter(component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
            g.setColor(g.getColor().darker());
            String string = this.getDisplayableText(component2.getModel(), bounds2.getContent());
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            FontMetrics fm = g.getFontMetrics(g.getFont());
            int n = component2.getRowHeight() / 2;
            FontMetrics fontMetrics = fm;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
            int y = n + fontMetrics.getAscent() * 2 / 5;
            g.drawString(it, 0, y);
        }
    }

    @NotNull
    protected Color getBackgroundColor(@NotNull FlameGraphPanel<T> component2, @NotNull FlameGraphNode<T> bounds2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        JBColor jBColor = JBColor.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.DARK_GRAY");
        return (Color)jBColor;
    }

    @Nullable
    protected Color getBorderColor(@NotNull FlameGraphPanel<T> component2, @NotNull FlameGraphNode<T> bounds2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        return null;
    }

    public DefaultFlameGraphRenderer() {
        Color color = JBColor.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBColor.background()");
        this.background = color;
    }

    @Override
    @Nls
    @Nullable
    public String getDisplayableText(@NotNull FlameGraphModel<T> model2, T node2) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        return FlameGraphRenderer.DefaultImpls.getDisplayableText(this, model2, node2);
    }

    @Override
    @Nullable
    public String getTooltipText(@NotNull FlameGraphModel<T> model2, T node2) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        return FlameGraphRenderer.DefaultImpls.getTooltipText(this, model2, node2);
    }
}

