/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoIndex
extends FileBasedIndexExtension<TodoIndexEntry, Integer> {
    @NonNls
    public static final ID<TodoIndexEntry, Integer> NAME = ID.create((String)"TodoIndex");
    private final KeyDescriptor<TodoIndexEntry> myKeyDescriptor = new KeyDescriptor<TodoIndexEntry>(){

        public int getHashCode(TodoIndexEntry value2) {
            return value2.hashCode();
        }

        public boolean isEqual(TodoIndexEntry val1, TodoIndexEntry val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, TodoIndexEntry value2) throws IOException {
            if (out == null) {
                2.$$$reportNull$$$0(0);
            }
            out.writeUTF(value2.pattern);
            out.writeBoolean(value2.caseSensitive);
        }

        public TodoIndexEntry read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                2.$$$reportNull$$$0(1);
            }
            String pattern = in.readUTF();
            boolean caseSensitive = in.readBoolean();
            return new TodoIndexEntry(pattern, caseSensitive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DataExternalizer<Integer> myValueExternalizer = new IntInlineKeyDescriptor(){

        protected boolean isCompactFormat() {
            return true;
        }
    };
    private final DataIndexer<TodoIndexEntry, Integer, FileContent> myIndexer = new CompositeDataIndexer<TodoIndexEntry, Integer, DataIndexer<TodoIndexEntry, Integer, FileContent>, String>(){

        @Nullable
        public DataIndexer<TodoIndexEntry, Integer, FileContent> calculateSubIndexer(@NotNull IndexedFile file2) {
            if (file2 == null) {
                4.$$$reportNull$$$0(0);
            }
            return PlatformIdTableBuilding.getTodoIndexer(file2.getFileType());
        }

        @NotNull
        public String getSubIndexerVersion(@NotNull DataIndexer<TodoIndexEntry, Integer, FileContent> indexer) {
            if (indexer == null) {
                4.$$$reportNull$$$0(1);
            }
            int version2 = indexer instanceof VersionedTodoIndexer ? ((VersionedTodoIndexer)indexer).getVersion() : 255;
            String string = indexer.getClass().getName() + ":" + version2;
            if (string == null) {
                4.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
            EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
            if (enumeratorStringDescriptor == null) {
                4.$$$reportNull$$$0(3);
            }
            return enumeratorStringDescriptor;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData, @NotNull DataIndexer<TodoIndexEntry, Integer, FileContent> indexer) {
            Map map2;
            if (inputData == null) {
                4.$$$reportNull$$$0(4);
            }
            if (indexer == null) {
                4.$$$reportNull$$$0(5);
            }
            try {
                map2 = indexer.map((Object)inputData);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw new MapReduceIndexMappingException((Throwable)e, indexer.getClass());
            }
            if (map2 == null) {
                4.$$$reportNull$$$0(6);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexer";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex$4";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex$4";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubIndexerVersion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubIndexerVersionDescriptor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calculateSubIndexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubIndexerVersion";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public TodoIndex() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(IndexPatternProvider.INDEX_PATTERNS_CHANGED, (Object)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileBasedIndex.getInstance().requestRebuild(NAME);
            }
        });
    }

    public int getVersion() {
        return 11;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<TodoIndexEntry, Integer> getName() {
        ID<TodoIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            TodoIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<TodoIndexEntry, Integer, FileContent> getIndexer() {
        DataIndexer<TodoIndexEntry, Integer, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            TodoIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<TodoIndexEntry> getKeyDescriptor() {
        KeyDescriptor<TodoIndexEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            TodoIndex.$$$reportNull$$$0(2);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        DataExternalizer<Integer> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            TodoIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.ProjectSpecificInputFilter(){

            public boolean acceptInput(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!TodoIndexers.needsTodoIndex(file2)) {
                    return false;
                }
                FileType fileType = file2.getFileType();
                if (fileType instanceof LanguageFileType) {
                    return LanguageParserDefinitions.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage()) != null;
                }
                return PlatformIdTableBuilding.isTodoIndexerRegistered(fileType) || fileType instanceof CustomSyntaxTableFileType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/todo/TodoIndex$5", "acceptInput"));
            }
        };
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

