/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorFacade;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ChangedRangesUtil;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerRunnable;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedIndentAdjuster;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.MathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleManagerImpl
extends CodeStyleManager
implements FormattingModeAwareIndentAdjuster {
    private static final Logger LOG = Logger.getInstance(CodeStyleManagerImpl.class);
    private final ThreadLocal<FormattingMode> myCurrentFormattingMode = ThreadLocal.withInitial(() -> FormattingMode.REFORMAT);
    private final Project myProject;

    public CodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(0);
        }
        return project;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = this.reformat(element2, false);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element2, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(3);
        }
        CheckUtil.checkWritable(element2);
        if (!SourceTreeToPsiMap.hasTreeElement(element2)) {
            PsiElement psiElement = element2;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiFile file2 = element2.getContainingFile();
        if (file2 == null) {
            PsiElement psiElement = element2;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement psiElement = FormattingServiceUtil.formatElement(element2, canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public PsiElement reformatRange(@NotNull PsiElement element2, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(7);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element2, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element2, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(8);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element2, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file2) {
        ((TreeElement)file2).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    public void reformatText(@NotNull PsiFile file2, int startOffset, int endOffset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(9);
        }
        this.reformatText(file2, Collections.singleton(new TextRange(startOffset, endOffset)));
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(10);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(11);
        }
        this.reformatText(file2, ranges, null);
    }

    public void reformatTextWithContext(@NotNull PsiFile file2, @NotNull ChangedRangesInfo info2) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(12);
        }
        if (info2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(13);
        }
        this.ensureDocumentCommitted(file2);
        FormatTextRanges formatRanges = new FormatTextRanges(info2, ChangedRangesUtil.processChangedRanges(file2, info2));
        formatRanges.setExtendToContext(true);
        this.reformatText(file2, formatRanges, null);
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges, @Nullable Editor editor) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(14);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(15);
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges.forEach(range2 -> formatRanges.add((TextRange)range2, true));
        this.reformatText(file2, formatRanges, editor);
    }

    private void reformatText(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @Nullable Editor editor) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(16);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(17);
        }
        if (ranges.isEmpty()) {
            return;
        }
        this.ensureDocumentCommitted(file2);
        CheckUtil.checkWritable((PsiElement)file2);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        LOG.assertTrue(file2.isValid(), (Object)("File name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName()));
        if (editor == null) {
            editor = PsiEditorUtil.findEditor((PsiElement)file2);
        }
        CaretPositionKeeper caretKeeper = null;
        if (editor != null) {
            caretKeeper = new CaretPositionKeeper(editor, CodeStyleManagerImpl.getSettings(file2), file2.getLanguage());
        }
        if (FormatterUtil.isFormatterCalledExplicitly()) {
            CodeStyleManagerImpl.removeEndingWhiteSpaceFromEachRange(file2, ranges);
        }
        FormattingServiceUtil.formatRanges(file2, ranges, false);
        if (caretKeeper != null) {
            caretKeeper.restoreCaretPosition();
        }
    }

    private void ensureDocumentCommitted(@NotNull PsiFile file2) {
        PsiDocumentManager documentManager;
        Document document;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(18);
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)this.myProject)).getDocument(file2)) != null) {
            documentManager.commitDocument(document);
        }
    }

    private static void removeEndingWhiteSpaceFromEachRange(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(19);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(20);
        }
        for (FormatTextRange formatRange : ranges.getRanges()) {
            PsiElement prev2;
            TextRange range2 = formatRange.getTextRange();
            int rangeStart = range2.getStartOffset();
            int rangeEnd = range2.getEndOffset();
            PsiElement lastElementInRange = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file2, rangeEnd);
            if (!(lastElementInRange instanceof PsiWhiteSpace) || rangeStart >= lastElementInRange.getTextRange().getStartOffset() || (prev2 = lastElementInRange.getPrevSibling()) == null) continue;
            int newEnd = prev2.getTextRange().getEndOffset();
            formatRange.setTextRange(new TextRange(rangeStart, newEnd));
        }
    }

    private static PsiElement reformatRangeImpl(@NotNull PsiElement element2, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(element2.isValid());
        CheckUtil.checkWritable(element2);
        if (!SourceTreeToPsiMap.hasTreeElement(element2)) {
            return element2;
        }
        return FormattingServiceUtil.formatElement(element2, TextRange.create((int)startOffset, (int)endOffset), canChangeWhiteSpacesOnly);
    }

    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder2;
        if (parent == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(22);
        }
        if (addedElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(addedElement.getTreeParent() == parent, (Object)"addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        assert (containingFile != null);
        TextRange textRange = addedElement.getTextRange();
        Document document = fileViewProvider.getDocument();
        if (document instanceof DocumentWindow) {
            containingFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
            textRange = ((DocumentWindow)document).injectedToHost(textRange);
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)containingFile)) != null) {
            FormattingModel model2 = CoreFormatterUtil.buildModel(builder2, (PsiElement)containingFile, CodeStyleManagerImpl.getSettings(containingFile), FormattingMode.REFORMAT);
            FormatterEx.getInstanceEx().formatAroundRange(model2, CodeStyleManagerImpl.getSettings(containingFile), containingFile, textRange);
        }
        this.adjustLineIndent(containingFile, textRange);
    }

    public int adjustLineIndent(@NotNull PsiFile file2, int offset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(24);
        }
        return (Integer)PostprocessReformattingAspect.getInstance(file2.getProject()).disablePostprocessFormattingInside(() -> this.doAdjustLineIndentByOffset(file2, offset, FormattingMode.ADJUST_INDENT));
    }

    public int adjustLineIndent(@NotNull Document document, int offset, FormattingMode mode) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(25);
        }
        return (Integer)PostprocessReformattingAspect.getInstance(this.getProject()).disablePostprocessFormattingInside(() -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null) {
                return offset;
            }
            return this.doAdjustLineIndentByOffset(file2, offset, mode);
        });
    }

    public int adjustLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(26);
        }
        return this.adjustLineIndent(document, offset, FormattingMode.ADJUST_INDENT);
    }

    private int doAdjustLineIndentByOffset(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        Integer result2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(27);
        }
        return (result2 = (Integer)new CodeStyleManagerRunnable<Integer>(this, mode){

            @Override
            protected Integer doPerform(int offset, TextRange range2) {
                return FormatterEx.getInstanceEx().adjustLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }

            @Override
            protected Integer computeValueInsidePlainComment(PsiFile file2, int offset, Integer defaultValue) {
                return CharArrayUtil.shiftForward((CharSequence)file2.getViewProvider().getContents(), (int)offset, (String)" \t");
            }

            @Override
            protected Integer adjustResultForInjected(Integer result2, DocumentWindow documentWindow) {
                return result2 != null ? Integer.valueOf(documentWindow.hostToInjected(result2.intValue())) : null;
            }
        }.perform(file2, offset, null, null)) != null ? result2 : offset;
    }

    public void adjustLineIndent(@NotNull PsiFile file2, TextRange rangeToAdjust) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(28);
        }
        new CodeStyleManagerRunnable<Object>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Object doPerform(int offset, TextRange range2) {
                FormatterEx.getInstanceEx().adjustLineIndentsForRange(this.myModel, this.mySettings, this.myIndentOptions, range2);
                return null;
            }
        }.perform(file2, -1, rangeToAdjust, null);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(29);
        }
        return this.getLineIndent(file2, offset, FormattingMode.ADJUST_INDENT);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(30);
        }
        return new CodeStyleManagerRunnable<String>(this, mode){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected String doPerform(int offset, TextRange range2) {
                return FormatterEx.getInstanceEx().getLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }
        }.perform(file2, offset, null, null);
    }

    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        PsiFile file2;
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(31);
        }
        if ((file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document)) == null) {
            return "";
        }
        return this.getLineIndent(file2, offset);
    }

    @Deprecated
    public boolean isLineToBeIndented(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(32);
        }
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return false;
        }
        CharSequence chars = file2.getViewProvider().getContents();
        int start2 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (start2 > 0 && chars.charAt(start2) != '\n' && chars.charAt(start2) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element2 = SourceTreeToPsiMap.psiElementToTree(CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file2, end));
        if (element2 == null) {
            return false;
        }
        if (element2.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element2.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !CodeStyleManagerImpl.getSettings((PsiFile)file2).getCommonSettings((Language)file2.getLanguage()).KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element2) || IndentHelper.getInstance().getIndent(this.myProject, file2.getFileType(), element2, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element2) {
        Language language = element2.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element2.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element2.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    public Indent getIndent(String text2, FileType fileType) {
        int indent = IndentHelperImpl.getIndent(CodeStyle.getSettings((Project)this.myProject).getIndentOptions(fileType), text2, true);
        int indentLevel = indent / 10000;
        int spaceCount = indent - indentLevel * 10000;
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), indentLevel, spaceCount, fileType);
    }

    public String fillIndent(Indent indent, FileType fileType) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        CodeStyleSettings settings2 = CodeStyle.getSettings((Project)this.myProject);
        if (indentLevel < 0) {
            spaceCount += indentLevel * settings2.getIndentSize(fileType);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + settings2.getIndentSize(fileType) - 1) / settings2.getIndentSize(fileType);
            spaceCount += v * settings2.getIndentSize(fileType);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return IndentHelperImpl.fillIndent(this.myProject, fileType, indentLevel * 10000 + spaceCount);
    }

    public Indent zeroIndent() {
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), 0, 0, null);
    }

    @NotNull
    private static CodeStyleSettings getSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(33);
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file2);
        if (codeStyleSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(34);
        }
        return codeStyleSettings;
    }

    public boolean isSequentialProcessingAllowed() {
        return CoreCodeStyleUtil.isSequentialProcessingAllowed();
    }

    @Deprecated
    public static void setSequentialProcessingAllowed(boolean allowed) {
        CoreCodeStyleUtil.setSequentialProcessingAllowed(allowed);
    }

    public void performActionWithFormatterDisabled(Runnable r) {
        this.performActionWithFormatterDisabled(() -> {
            r.run();
            return null;
        });
    }

    public <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> r) throws T {
        Throwable[] throwable = new Throwable[1];
        this.performActionWithFormatterDisabled(() -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            return null;
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance(this.getProject());
        return component2.disablePostprocessFormattingInside(r);
    }

    public FormattingMode getCurrentFormattingMode() {
        return this.myCurrentFormattingMode.get();
    }

    void setCurrentFormattingMode(@NotNull FormattingMode mode) {
        if (mode == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(35);
        }
        this.myCurrentFormattingMode.set(mode);
    }

    public int getSpacing(@NotNull PsiFile file2, int offset) {
        FormattingModel model2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(36);
        }
        return (model2 = CodeStyleManagerImpl.createFormattingModel(file2, offset)) == null ? -1 : FormatterEx.getInstance().getSpacingForBlockAtOffset(model2, offset);
    }

    public int getMinLineFeeds(@NotNull PsiFile file2, int offset) {
        FormattingModel model2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(37);
        }
        return (model2 = CodeStyleManagerImpl.createFormattingModel(file2, offset)) == null ? -1 : FormatterEx.getInstance().getMinLineFeedsBeforeBlockAtOffset(model2, offset);
    }

    @Nullable
    private static FormattingModel createFormattingModel(@NotNull PsiFile file2, int offset) {
        FormattingModelBuilder builder2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(38);
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)file2)) == null) {
            return null;
        }
        CodeStyleSettings settings2 = CodeStyle.getSettings((PsiFile)file2);
        return builder2.createModel(FormattingContext.create((PsiElement)file2, (TextRange)TextRange.create((int)offset, (int)offset), (CodeStyleSettings)settings2, (FormattingMode)FormattingMode.REFORMAT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(39);
        }
        if (runnable2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(40);
        }
        DocCommentSettings docSettings = this.getDocCommentSettings(file2);
        boolean currDocFormattingEnabled = docSettings.isDocFormattingEnabled();
        docSettings.setDocFormattingEnabled(false);
        try {
            runnable2.run();
        }
        finally {
            docSettings.setDocFormattingEnabled(currDocFormattingEnabled);
        }
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file2) {
        Language language;
        LanguageCodeStyleProvider settingsProvider;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(41);
        }
        if ((settingsProvider = CodeStyleSettingsService.getLanguageCodeStyleProvider((Language)(language = file2.getLanguage()))) != null) {
            DocCommentSettings docCommentSettings = settingsProvider.getDocCommentSettings(CodeStyle.getSettings((PsiFile)file2));
            if (docCommentSettings == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(42);
            }
            return docCommentSettings;
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(43);
        }
        return docCommentSettings;
    }

    public void scheduleIndentAdjustment(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(44);
        }
        FormatterBasedIndentAdjuster.scheduleIndentAdjustment(this.myProject, document, offset);
    }

    public void scheduleReformatWhenSettingsComputed(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(45);
        }
        if (ModelBranch.getPsiBranch((PsiElement)file2) != null) {
            this.commitAndFormat(file2);
            return;
        }
        Runnable commandRunnable = () -> WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)CodeStyleBundle.message((String)"command.name.reformat", (Object[])new Object[0]), null, () -> this.commitAndFormat(file2), (PsiFile[])new PsiFile[]{file2});
        CodeStyleCachingService.getInstance((Project)this.myProject).scheduleWhenSettingsComputed(file2, () -> {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                commandRunnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(commandRunnable);
            }
        });
    }

    private void commitAndFormat(@NotNull PsiFile file2) {
        PsiDocumentManager documentManager;
        Document document;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(46);
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)this.myProject)).getDocument(file2)) != null) {
            documentManager.commitDocument(document);
        }
        PostprocessReformattingAspect.getInstance(this.myProject).disablePostprocessFormattingInside(() -> this.reformat((PsiElement)this.ensureValid(file2)));
    }

    @NotNull
    private PsiFile ensureValid(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(47);
        }
        if (!file2.isValid()) {
            PsiFile psiFile = PsiUtilCore.getPsiFile((Project)this.myProject, (VirtualFile)file2.getViewProvider().getVirtualFile());
            if (psiFile == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(48);
            }
            return psiFile;
        }
        PsiFile psiFile = file2;
        if (psiFile == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(49);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElement";
                break;
            }
            case 25: 
            case 26: 
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureValid";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reformatText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reformatTextWithContext";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "ensureDocumentCommitted";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeEndingWhiteSpaceFromEachRange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reformatRangeImpl";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reformatNewlyAddedElement";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineIndent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doAdjustLineIndentByOffset";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isLineToBeIndented";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentFormattingMode";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingModel";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndentAdjustment";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReformatWhenSettingsComputed";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "commitAndFormat";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CaretPositionKeeper {
        Editor myEditor;
        Document myDocument;
        CaretModel myCaretModel;
        RangeMarker myBeforeCaretRangeMarker;
        String myCaretIndentToRestore;
        int myVisualColumnToRestore;
        boolean myBlankLineIndentPreserved;

        CaretPositionKeeper(@NotNull Editor editor, @NotNull CodeStyleSettings settings2, @NotNull Language language) {
            if (editor == null) {
                CaretPositionKeeper.$$$reportNull$$$0(0);
            }
            if (settings2 == null) {
                CaretPositionKeeper.$$$reportNull$$$0(1);
            }
            if (language == null) {
                CaretPositionKeeper.$$$reportNull$$$0(2);
            }
            this.myVisualColumnToRestore = -1;
            this.myEditor = editor;
            this.myCaretModel = editor.getCaretModel();
            this.myDocument = editor.getDocument();
            this.myBlankLineIndentPreserved = CaretPositionKeeper.isBlankLineIndentPreserved(settings2, language);
            int caretOffset = this.getCaretOffset();
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            int lineEndOffset = this.getLineEndOffsetByTotalOffset(caretOffset);
            boolean shouldFixCaretPosition = CharArrayUtil.isEmptyOrSpaces((CharSequence)this.myDocument.getCharsSequence(), (int)lineStartOffset, (int)lineEndOffset);
            if (shouldFixCaretPosition) {
                this.initRestoreInfo(caretOffset);
            }
        }

        private static boolean isBlankLineIndentPreserved(@NotNull CodeStyleSettings settings2, @NotNull Language language) {
            CommonCodeStyleSettings langSettings;
            CommonCodeStyleSettings.IndentOptions indentOptions;
            if (settings2 == null) {
                CaretPositionKeeper.$$$reportNull$$$0(3);
            }
            if (language == null) {
                CaretPositionKeeper.$$$reportNull$$$0(4);
            }
            return (indentOptions = (langSettings = settings2.getCommonSettings(language)).getIndentOptions()) != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
        }

        private void initRestoreInfo(int caretOffset) {
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            this.myVisualColumnToRestore = this.myCaretModel.getVisualPosition().column;
            this.myCaretIndentToRestore = this.myDocument.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
            this.myBeforeCaretRangeMarker = this.myDocument.createRangeMarker(0, lineStartOffset);
        }

        public void restoreCaretPosition() {
            if (this.isVirtualSpaceEnabled()) {
                this.restoreVisualPosition();
            } else {
                this.restorePositionByIndentInsertion();
            }
        }

        private void restorePositionByIndentInsertion() {
            if (this.myBeforeCaretRangeMarker == null || !this.myBeforeCaretRangeMarker.isValid() || this.myCaretIndentToRestore == null || this.myBlankLineIndentPreserved) {
                return;
            }
            int newCaretLineStartOffset = this.myBeforeCaretRangeMarker.getEndOffset();
            this.myBeforeCaretRangeMarker.dispose();
            if (this.myCaretModel.getVisualPosition().column == this.myVisualColumnToRestore) {
                return;
            }
            Project project = this.myEditor.getProject();
            if (project == null || PsiDocumentManager.getInstance((Project)project).isDocumentBlockedByPsi(this.myDocument)) {
                return;
            }
            this.insertWhiteSpaceIndentIfNeeded(newCaretLineStartOffset);
        }

        private void restoreVisualPosition() {
            if (this.myVisualColumnToRestore < 0) {
                EditorFacade.getInstance().runWithAnimationDisabled(this.myEditor, () -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE));
                return;
            }
            VisualPosition position = this.myCaretModel.getVisualPosition();
            if (this.myVisualColumnToRestore != position.column) {
                this.myCaretModel.moveToVisualPosition(new VisualPosition(position.line, this.myVisualColumnToRestore));
            }
        }

        private void insertWhiteSpaceIndentIfNeeded(int caretLineOffset) {
            int lineToInsertIndent = this.myDocument.getLineNumber(caretLineOffset);
            if (!this.lineContainsWhiteSpaceSymbolsOnly(lineToInsertIndent)) {
                return;
            }
            int lineToInsertStartOffset = this.myDocument.getLineStartOffset(lineToInsertIndent);
            if (lineToInsertIndent != this.getCurrentCaretLine()) {
                this.myCaretModel.moveToOffset(lineToInsertStartOffset);
            }
            this.myDocument.replaceString(lineToInsertStartOffset, caretLineOffset, (CharSequence)this.myCaretIndentToRestore);
        }

        private boolean isVirtualSpaceEnabled() {
            return this.myEditor.getSettings().isVirtualSpace();
        }

        private int getLineStartOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineStartOffset(line);
        }

        private int getLineEndOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineEndOffset(line);
        }

        private int getCaretOffset() {
            int caretOffset = this.myCaretModel.getOffset();
            int upperBound = Math.max(this.myDocument.getTextLength() - 1, 0);
            caretOffset = MathUtil.clamp((int)caretOffset, (int)0, (int)upperBound);
            return caretOffset;
        }

        private boolean lineContainsWhiteSpaceSymbolsOnly(int lineNumber) {
            int startOffset = this.myDocument.getLineStartOffset(lineNumber);
            int endOffset = this.myDocument.getLineEndOffset(lineNumber);
            return CharArrayUtil.isEmptyOrSpaces((CharSequence)this.myDocument.getCharsSequence(), (int)startOffset, (int)endOffset);
        }

        private int getCurrentCaretLine() {
            return this.myDocument.getLineNumber(this.myCaretModel.getOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBlankLineIndentPreserved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

