/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTokenType;

public class XmlConditionalSectionImpl
extends XmlElementImpl
implements XmlConditionalSection {
    public XmlConditionalSectionImpl() {
        super(XmlElementType.XML_CONDITIONAL_SECTION);
    }

    public boolean isIncluded(PsiFile targetFile) {
        ASTNode child2 = this.findChildByType(XmlTokenType.XML_CONDITIONAL_SECTION_START);
        if (child2 != null) {
            if ((child2 = child2.getTreeNext()) != null && child2.getElementType() == TokenType.WHITE_SPACE) {
                child2 = child2.getTreeNext();
            }
            if (child2 != null) {
                IElementType elementType = child2.getElementType();
                if (elementType == XmlTokenType.XML_CONDITIONAL_INCLUDE) {
                    return true;
                }
                if (elementType == XmlTokenType.XML_CONDITIONAL_IGNORE) {
                    return false;
                }
                if (elementType == XmlElementType.XML_ENTITY_REF) {
                    XmlEntityDecl decl;
                    XmlEntityDecl psiElement;
                    XmlEntityRef xmlEntityRef = (XmlEntityRef)child2.getPsi();
                    String text2 = xmlEntityRef.getText();
                    String name = text2.substring(1, text2.length() - 1);
                    XmlEntityDecl xmlEntityDecl = psiElement = targetFile != null ? XmlEntityCache.getCachedEntity(targetFile, name) : null;
                    if (psiElement instanceof XmlEntityDecl && (decl = psiElement).isInternalReference()) {
                        for (ASTNode e = decl.getNode().getFirstChildNode(); e != null; e = e.getTreeNext()) {
                            if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                            boolean b = StringUtil.stripQuotesAroundValue((String)e.getText()).equals("INCLUDE");
                            return b;
                        }
                    }
                }
            }
        }
        return false;
    }

    public PsiElement getBodyStart() {
        ASTNode child2 = this.findChildByType(XmlTokenType.XML_MARKUP_START);
        if (child2 != null) {
            child2 = child2.getTreeNext();
        }
        if (child2 != null) {
            return child2.getPsi();
        }
        return null;
    }
}

