/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FileLocalStringEnumerator
implements AbstractStringEnumerator {
    private final Object2IntMap<String> myEnumerates;
    private final ArrayList<String> myStrings = new ArrayList();

    FileLocalStringEnumerator(boolean forSavingStub) {
        this.myEnumerates = forSavingStub ? new Object2IntOpenHashMap() : null;
    }

    public int enumerate(@Nullable String value2) {
        if (value2 == null) {
            return 0;
        }
        assert (this.myEnumerates != null);
        int i2 = this.myEnumerates.getInt((Object)value2);
        if (i2 == 0) {
            i2 = this.myStrings.size() + 1;
            this.myEnumerates.put((Object)value2, i2);
            this.myStrings.add(value2);
        }
        return i2;
    }

    public String valueOf(int idx) {
        if (idx == 0) {
            return null;
        }
        return this.myStrings.get(idx - 1);
    }

    void write(@NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            FileLocalStringEnumerator.$$$reportNull$$$0(0);
        }
        assert (this.myEnumerates != null);
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myStrings.size());
        for (String s : this.myStrings) {
            IOUtil.writeUTF((DataOutput)stream, (String)s);
        }
    }

    public void markCorrupted() {
    }

    public void close() throws IOException {
    }

    public boolean isDirty() {
        return false;
    }

    public void force() {
    }

    void read(@NotNull DataInput stream, @NotNull UnaryOperator<String> mapping2) throws IOException {
        if (stream == null) {
            FileLocalStringEnumerator.$$$reportNull$$$0(1);
        }
        if (mapping2 == null) {
            FileLocalStringEnumerator.$$$reportNull$$$0(2);
        }
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)stream);
        this.myStrings.ensureCapacity(this.myStrings.size() + numberOfStrings);
        for (int i2 = 0; i2 < numberOfStrings; ++i2) {
            this.myStrings.add((String)mapping2.apply(IOUtil.readUTF((DataInput)stream)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/FileLocalStringEnumerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

